#!/usr/bin/perl
## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Description:       The simplest form of auto generated register/documentation
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################

use Cwd;

$REG_READ = 0;
$REG_WRITE = 1;
$REG_TIMER = 2;
$REG_CLKMON = 3;
$REG_CDCSYNC = 4;

sub setdooku {

    local(@args) = @_;
}
dooku;

sub width2mask {

    local($d) = @_;

    $d = (2**$d) - 1;

    return(hex2str($d));
}
dooku;

sub hex2str {

    local($d) = @_;
    local($s);

    $s = sprintf("0x%04x", $d);

    return($s);
}
dooku;

sub s2h_32 {

    local($s, $i) = @_;

    $s = $s.(" " x 32);
    $s = substr($s, ($i*4), 4);
    $s =~ s/(.)/sprintf("%x",ord($1))/eg;
    $s = "0x".$s;
    return($s);
}
dooku;

sub i2str {

    local($n, $m, $i) = @_;
    local($s);

    if ($m <= 1) {return($n);}

    if ($m > 100) {
        $s = sprintf("%03d", $i);
    } elsif ($m > 10)  {
        $s = sprintf("%02d", $i);
    } else {
        $s = sprintf("%d", $i);
    }

    return("${n}_${s}");
}
dooku;

sub define {

    local($name, $value, $desc) = @_;

    $no_of_defines = $no_of_defines + 1;
    $define_names[$no_of_defines] = uc("${module_name}_${name}");
    $define_values[$no_of_defines] = sprintf("0x%x", $value);
}
dooku;

sub add_field {

    local($pos, $width, $type, $default, $name, $looptype, $loopcnt) = @_;
    local($ro);

    $ro = 0;
    if ($type eq "RO") {
        $ro = 1;
    }

    $no_of_fields = $no_of_fields + 1;
    $field_pos[$no_of_fields] = $pos;
    $field_mask[$no_of_fields] = width2mask($width);
    $field_type[$no_of_fields] = $ro;
    $field_name[$no_of_fields] = uc($name);
    $field_addr[$no_of_fields] = $register_addr[$no_of_registers];

    if ($looptype eq "LOOP:FIELD") {
        $field_offset[$no_of_fields] = $field_offset;
        $field_loopcnt[$no_of_fields] = $loopcnt;
    } else {
        $field_offset[$no_of_fields] = 0x0;
        $field_loopcnt[$no_of_fields] = 1;
    }

    if ($looptype eq "LOOP:ADDR") {
        $field_addr_offset[$no_of_fields] = hex2str($register_offset);
        $field_addr_loop[$no_of_fields] = 2;
    } else {
        $field_addr_offset[$no_of_fields] = hex2str(0x0);
        $field_addr_loop[$no_of_fields] = 1;
    }

    if ($register_type[$no_of_registers] < 0) {
        $register_type[$no_of_registers] = $ro;
    } elsif ($register_type[$no_of_registers] != $ro) {
        $register_type[$no_of_registers] = 0;
    }

    if (($register_single[$no_of_registers] < 0) &&
        ($looptype ne "LOOP:FIELD")) {
        $register_single[$no_of_registers] = 1;
    } else {
        $register_single[$no_of_registers] = 0;
    }
}
dooku;

sub field {

    local($pos, $width, $type, $default, $name, $desc) = @_;
    add_field($pos, $width, $type, $default, $name, "LOOP:NONE", 0);
}
dooku;

sub field_loop {

    local($name, $desc) = @_;
    local($spos, $width, $type, $default);

    $spos = $field_base + ($field_index * $field_offset);
    $width = $field_width;
    $type = $field_type;
    $default = $field_default;

    if ($field_index == 0) {
        $name =~ s/_%\d*d//ig;
        $name =~ s/_0x%\d*x//ig;
        add_field($spos, $width, $type, $default, $name, "LOOP:FIELD", $field_count);
    }
}
dooku;

sub register_loop_field {

    local($spos, $width, $type, $default, $name, $desc) = @_;

    if ($register_index == 0) {
        $name =~ s/_%\d*d//ig;
        $name =~ s/_0x%\d*x//ig;
        add_field($spos, $width, $type, $default, $name, "LOOP:ADDR", 0);
    }
}
dooku;

sub add_register {

    local($addr, $name, $loopcnt) = @_;

    $no_of_registers = $no_of_registers + 1;
    $register_addr[$no_of_registers] = hex2str($addr);
    $register_name[$no_of_registers] = uc($name);
    $register_type[$no_of_registers] = -1;
    $register_single[$no_of_registers] = -1;
    $register_loopcnt[$no_of_registers] = $loopcnt;
    if ($loopcnt == 0) {
        $register_offset[$no_of_registers] = hex2str(0x0);
    } else {
        $register_offset[$no_of_registers] = hex2str($register_offset);
    }
}
dooku;

sub register {

    local($addr, $name) = @_;
    add_register($addr, $name, 1);
}
dooku;

sub register_loop {

    local($name) = @_;
    local($raddr);

    if ($register_index == 0) {
        $raddr = $register_base + ($register_index * $register_offset);
        $name =~ s/_%\d*d//ig;
        $name =~ s/_0x%\d*x//ig;
        add_register($raddr, $name, $register_count);
    }
}
dooku;

sub module {

    local($addr, $name) = @_;
    local($w);

    $module_name = uc($name);
    $no_of_registers = -1;
    $no_of_fields = -1;
    $no_of_defines = -1;

    $submodule = 0;
    if ($addr_width != $addr_width_used) {
        $submodule = 1;
    }
}
dooku;

sub endmodule {

}
dooku;

sub endregisters {

    local($i, $d, $r, $f, $l, $m, $lname, $uname, $rname);
    local($addr, $raddr, $iaddr, $iname, $fname, $pos);

    $lname = lc($module_name);
    open(ofile, ">${lname}.regs");
    pheader();

    for ($i = 0; $i < $no_of_instances; $i++) {
        $iaddr = $instance_base_addr + ($i * $instance_offset_addr);
        $iname = i2str($module_name, $no_of_instances, $i);
        for ($r = 0; $r <= $no_of_registers; $r++) {
            $raddr = $iaddr + hex($register_addr[$r]);
            for ($l = 0; $l < $register_loopcnt[$r]; $l++) {
                $rname = i2str($register_name[$r], $register_loopcnt[$r], $l);
                $lname = sprintf("0x%08x", $raddr);
                $uname = uc("${iname}_$rname");
                print ofile "${lname}:reg:${uname}:0:0xffffffff\n";
                for ($f = 0; $f <= $no_of_fields; $f++) {
                    if ($register_addr[$r] eq $field_addr[$f]) {
                        $pos = $field_pos[$f];
                        for ($m = 0; $m < $field_loopcnt[$f]; $m++) {
                            $fname = i2str($field_name[$f], $field_loopcnt[$f], $m);
                            $fname = uc("${iname}_$fname");
                            print ofile "${lname}:fld:${fname}:$pos:$field_mask[$f]\n";
                            $pos = $pos + $field_offset[$f];
                        }
                    }
                }
                $raddr = $raddr + hex($register_offset[$r]);
            }
        }
        print ofile "\n";
    }

    print ofile "\n";
    pfooter();
    close(ofile);

    $lname = lc($module_name);
    open(ofile, ">${lname}_regs.h");
    pheader();

    print ofile "#ifndef ${module_name}_REGS_H\n";
    print ofile "#define ${module_name}_REGS_H\n";

    print ofile "\n";
    for ($d = 0; $d <= $no_of_defines; $d++) {
        print ofile "#define $define_names[$d] $define_values[$d]\n";
    }

    print ofile "\n";
    for ($r = 0; $r <= $no_of_registers; $r++) {
        $lname = "${module_name}_$register_name[$r]";
        print ofile "#define ${lname}_ADDR $register_addr[$r]\n";
        if ($register_loopcnt[$r] > 1) {
            print ofile "#define ${lname}_ADDR_OFFSET $register_offset[$r]\n";
        }
        for ($f = 0; $f <= $no_of_fields; $f++) {
            if ($register_addr[$r] eq $field_addr[$f]) {
                $lname = "${module_name}_$field_name[$f]";
                print ofile "#define ${lname}_ADDR $field_addr[$f]\n";
                if ($field_addr_loop[$f] > 1) {
                    print ofile "#define ${lname}_ADDR_OFFSET $field_addr_offset[$f]\n";
                }
                print ofile "#define ${lname}_POS $field_pos[$f]\n";
                print ofile "#define ${lname}_MASK $field_mask[$f]\n";
                if ($field_loopcnt[$f] > 1) {
                    print ofile "#define ${lname}_POS_OFFSET $field_offset[$f]\n";
                }
            }
        }
        print ofile "\n";
    }

    print ofile "\n";
    print ofile "#endif\n";
    print ofile "\n";

    pfooter();
    close(ofile);

    $header = 0;
    $lname = lc($module_name);
    open(ofile, ">${lname}.c");
    pheader();

    print ofile "\n";
    print ofile "#include \"${lname}_regs.h\"\n";
    print ofile "#include \"${lname}.h\"\n";
    print ofile "\n";

    for ($r = 0; $r <= $no_of_registers; $r++) {
        if ($register_single[$r] == 0) {
            prdwr(0, $REG_READ, $r, $r);
            if ($register_type[$r] == 0) {prdwr(0, $REG_WRITE, $r, $r);}
        }
        for ($f = 0; $f <= $no_of_fields; $f++) {
            if ($register_addr[$r] eq $field_addr[$f]) {
                prdwr(1, $REG_READ, $r, $f);
                if ($field_type[$f] == 0) {prdwr(1, $REG_WRITE, $r, $f);}
                if ($field_name[$f] =~ /TIMER/) {prdwr(1, $REG_TIMER, $r, $f);}
                if ($field_name[$f] =~ /CLK_MON/) {prdwr(1, $REG_CLKMON, $r, $f);}
                if ($field_name[$f] =~ /CDC_STATE/) {prdwr(1, $REG_CDCSYNC, $r, $f);}
            }
        }
    }

    pfooter();
    close(ofile);

    $header = 1;
    $lname = lc($module_name);
    open(ofile, ">${lname}.h");
    pheader();

    print ofile "#ifndef ${module_name}_H\n";
    print ofile "#define ${module_name}_H\n";
    print ofile "\n";

    print ofile "\n";
    print ofile "#include \"axi_common.h\"\n";
    print ofile "#include \"axi_utils.h\"\n";
    print ofile "#include \"${lname}_regs.h\"\n";
    print ofile "\n";
    
    print ofile "\n";
    print ofile "#ifdef __cplusplus\n";
    print ofile "extern \"C\" {\n";
    print ofile "#endif\n";
    print ofile "\n";

    for ($r = 0; $r <= $no_of_registers; $r++) {
        if ($register_single[$r] == 0) {
            prdwr(0, $REG_READ, $r, $r);
            if ($register_type[$r] == 0) {prdwr(0, $REG_WRITE, $r, $r);}
        }
        for ($f = 0; $f <= $no_of_fields; $f++) {
            if ($register_addr[$r] eq $field_addr[$f]) {
                prdwr(1, $REG_READ, $r, $f);
                if ($field_type[$f] == 0) {prdwr(1, $REG_WRITE, $r, $f);}
                if ($field_name[$f] =~ /TIMER/) {prdwr(1, $REG_TIMER, $r, $f);}
                if ($field_name[$f] =~ /CLK_MON/) {prdwr(1, $REG_CLKMON, $r, $f);}
                if ($field_name[$f] =~ /CDC_STATE/) {prdwr(1, $REG_CDCSYNC, $r, $f);}
            }
        }
    }

    print ofile "\n";
    print ofile "#ifdef __cplusplus\n";
    print ofile "}\n";
    print ofile "#endif\n";
    print ofile "\n";

    print ofile "\n";
    print ofile "#endif\n";
    print ofile "\n";

    pfooter();
    close(ofile);
}
dooku;

sub generate {

}
dooku;

sub pheader {

    print ofile "// **********************************************************************************\n";
    print ofile "// **********************************************************************************\n";
    print ofile "// ----------------------------------------------------------------------------------\n";
    print ofile "// ################\n";
    print ofile "// ##   ###########   Analog Devices Inc.\n";
    print ofile "// ##      ########\n";
    print ofile "// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.\n";
    print ofile "// ##            ##   This file is the confidential and proprietary property of ADI.\n";
    print ofile "// ##         #####   Possession or use of this file requires a written license.\n";
    print ofile "// ##      ########   The licensing information may be found at: www.analog.com\n";
    print ofile "// ##   ###########\n";
    print ofile "// ################\n";
    print ofile "// ----------------------------------------------------------------------------------\n";
    print ofile "// Description:       AXI $module_name Driver\n";
    print ofile "// ----------------------------------------------------------------------------------\n";
    print ofile "// **********************************************************************************\n";
    print ofile "// **********************************************************************************\n";
    print ofile "\n";

}
dooku;

sub pfooter {

    print ofile "// **********************************************************************************\n";
    print ofile "// **********************************************************************************\n";
    print ofile "\n";

}
dooku;

sub prdwr {

    local($is_field, $rftype, $rindex, $findex) = @_;
    local($rfname, $is_single, $lname, $uname, $rloopcnt, $floopcnt);

    $is_single = $register_single[$rindex];
    if ($is_field == 1) {
        $floopcnt = $field_loopcnt[$findex];
        $rloopcnt = $field_addr_loop[$findex];
        $rfname = $field_name[$findex];
    } else {
        $floopcnt = 1;
        $rloopcnt = $register_loopcnt[$rindex]; 
        $rfname = $register_name[$rindex];
    }


    $lname = lc("${module_name}_${rfname}");
    $uname = uc($lname);

    print ofile "\n";
    if ($header == 1) {
        print ofile "/**\n";
        print ofile " * \\brief ";
    } else {
        print ofile "/* ";
    }
    if ($rftype == $REG_CDCSYNC) {
        print ofile "clock domain transfer sync ";
    } elsif ($rftype == $REG_CLKMON) {
        print ofile "count frequency (Hz) ";
    } elsif ($rftype == $REG_TIMER) {
        print ofile "timer delay (us) ";
    } else {
        print ofile " register ";
        if ($is_field == 1) {
            print ofile "field ";
        }
        if ($rftype == $REG_WRITE) {
            print ofile "write, ";
        } else {
            print ofile "read, ";
        }
    }
    print ofile "${lname} ";
    if ($header == 0) {
        print ofile "*/\n";
    }
    print ofile "\n";
    if ($header == 1) {
        print ofile " *\n";
        print ofile " * \\param[in] a_device context variable - pointer to axi bus master device\n";
        print ofile " * \\param[in] peripheral_id of this instance\n";
        if ($submodule == 1) {
            print ofile " * \\param[in] module_id of this instance\n";
        }
        if (($rloopcnt > 1) || ($floopcnt > 1)) {
            print ofile " * \\param[in] index_id of this instance\n";
        }
        if (($rftype == $REG_READ) || ($rftype == $REG_CLKMON)) {
            print ofile " * \\param[out] data current value\n";
        } elsif ($rftype != $REG_CDCSYNC) {
            print ofile " * \\param[in] data desired value\n";
        }
        print ofile " * \\returns non zero value to indicate bus errors from axi bus master\n";
        print ofile " */\n";
        print ofile "\n";
    }

    print ofile "int32_t ${lname}_";
    if ($rftype == $REG_CDCSYNC) {
        print ofile "sync";
    } elsif ($rftype == $REG_CLKMON) {
        print ofile "freq_hz";
    } elsif ($rftype == $REG_TIMER) {
        print ofile "delay_us";
    } elsif ($rftype == $REG_WRITE) {
        print ofile "set";
    } else {
        print ofile "get";
    }
    print ofile "(AXI_DEVICE_T *a_device, uint32_t peripheral_id";
    if ($submodule == 1) {
        print ofile ", uint32_t module_id";
    }
    if (($rloopcnt > 1) || ($floopcnt > 1)) {
        print ofile ", uint32_t index_id";
    }
    if (($rftype == $REG_READ) || ($rftype == $REG_CLKMON)) {
        print ofile ", uint32_t *data";
    } elsif ($rftype != $REG_CDCSYNC) {
        print ofile ", uint32_t data";
    }
    print ofile ")";
    if ($header == 1) {
        print ofile ";\n";
    } else {
        print ofile " {\n";
    }
    print ofile "\n";

    if ($header == 1) {
        return;
    }

    print ofile "    uint32_t addr_offset;\n";
    if ($floopcnt > 1) {
        print ofile "    uint32_t pos_offset;\n";
    }
    print ofile "\n";

    print ofile "    addr_offset = 0x0;\n";
    if ($rloopcnt > 1) {
        print ofile "    addr_offset = (index_id * ${uname}_ADDR_OFFSET);\n";
    }
    if ($submodule == 1) {
        print ofile "    addr_offset = addr_offset + module_id;\n";
    }
    print ofile "\n";

    if ($floopcnt > 1) {
        print ofile "    pos_offset = (index_id * ${uname}_POS_OFFSET);\n";
        print ofile "\n";
    }

    print ofile "    return(";
    if ($rftype == $REG_CDCSYNC) {
        print ofile "axi_utils_cdc_sync";
    } elsif ($rftype == $REG_CLKMON) {
        print ofile "axi_utils_count_freq_hz";
    } elsif ($rftype == $REG_TIMER) {
        print ofile "axi_utils_timer_delay_us";
    } elsif ($rftype == $REG_WRITE) {
        if (($is_field == 0) || ($is_single == 1)) {
            print ofile "AXI_REG_WRITE";
        } else {
            print ofile "axi_utils_field_write";
        }
    } else {
        if (($is_field == 0) || ($is_single == 1)) {
            print ofile "AXI_REG_READ";
        } else {
            print ofile "axi_utils_field_read";
        }
    }
    print ofile "(a_device, peripheral_id";
    print ofile ", (${uname}_ADDR + addr_offset)";
    if ($rftype == $REG_CDCSYNC) {
        $uname =~ s/CDC_STATE/TIMER/;
        print ofile ", (${uname}_ADDR + addr_offset)";
    } elsif ((($rftype == $REG_WRITE) || ($rftype == $REG_READ)) &&
        ($is_field == 1) && ($is_single == 0)) {
        if ($floopcnt > 1) {
            print ofile ", (${uname}_POS + pos_offset)";
        } else {
            print ofile ", ${uname}_POS";
        }
        print ofile ", ${uname}_MASK";
        print ofile ", data";
    } else {
        print ofile ", data";
    }
    print ofile "));\n";
    print ofile "}\n";
    print ofile "\n";
}
dooku;

## ##################################################################################
## ##################################################################################
