// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Description:       Up-Size
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module upsize #(
    
    parameter   IW = 8,
    parameter   OW = 16) (

    // interface

    input   wire                    resetn,
    input   wire                    clk,
    input   wire                    start,
    input   wire                    valid_in,
    input   wire    [ (IW-1):0]     data_in,
    output  wire                    valid_out,
    output  wire    [ (OW-1):0]     data_out);

    // local constants

    localparam  X1W = IW*1;
    localparam  X2W = IW*2;
    localparam  X4W = IW*4;
    localparam  X8W = IW*8;

    // registers

    reg                             valid_x2 = 'd0;
    reg                             toggle_x2 = 'd0;
    reg             [(X2W-1):0]     data_x2 = 'd0;
    reg                             valid_x4 = 'd0;
    reg                             toggle_x4 = 'd0;
    reg             [(X4W-1):0]     data_x4 = 'd0;
    reg                             valid_x8 = 'd0;
    reg                             toggle_x8 = 'd0;
    reg             [(X8W-1):0]     data_x8 = 'd0;

    // signals

    wire                            valid_x1;
    wire            [(X1W-1):0]     data_x1;

    // simple doubler

    assign valid_x1 = valid_in;
    assign data_x1 = data_in;

    generate

    if (OW == IW) begin

    assign valid_out = valid_x1 & start;
    assign data_out = data_x1;

    end else if (OW == (IW*2)) begin

    assign valid_out = valid_x2;
    assign data_out = data_x2;

    end else if (OW == (IW*4)) begin

    assign valid_out = valid_x4;
    assign data_out = data_x4;

    end else if (OW == (IW*8)) begin

    assign valid_out = valid_x8;
    assign data_out = data_x8;

    end

    if (OW >= (IW*2)) begin

    always @(negedge resetn or posedge clk) begin
        if (resetn == 1'b0) begin
            valid_x2 <= 'd0;
            toggle_x2 <= 'd0;
            data_x2 <= 'd0;
        end else begin
            if (start == 1'b0) begin
                valid_x2 <= 'd0;
                toggle_x2 <= 'd0;
                data_x2 <= 'd0;
            end else begin
                valid_x2 <= valid_x1 & toggle_x2;
                if (valid_x1 == 1'b1) begin
                    toggle_x2 <= ~toggle_x2;
                    data_x2[((X1W*2)-1):(X1W*1)] <= data_x1;
                    data_x2[((X1W*1)-1):(X1W*0)] <= data_x2[((X1W*2)-1):(X1W*1)];
                end
            end
        end
    end

    end

    if (OW >= (IW*4)) begin

    always @(negedge resetn or posedge clk) begin
        if (resetn == 1'b0) begin
            valid_x4 <= 'd0;
            toggle_x4 <= 'd0;
            data_x4 <= 'd0;
        end else begin
            if (start == 1'b0) begin
                valid_x4 <= 'd0;
                toggle_x4 <= 'd0;
                data_x4 <= 'd0;
            end else begin
                valid_x4 <= valid_x2 & toggle_x4;
                if (valid_x2 == 1'b1) begin
                    toggle_x4 <= ~toggle_x4;
                    data_x4[((X2W*2)-1):(X2W*1)] <= data_x2;
                    data_x4[((X2W*1)-1):(X2W*0)] <= data_x4[((X2W*2)-1):(X2W*1)];
                end
            end
        end
    end

    end

    if (OW >= (IW*8)) begin

    always @(negedge resetn or posedge clk) begin
        if (resetn == 1'b0) begin
            valid_x8 <= 'd0;
            toggle_x8 <= 'd0;
            data_x8 <= 'd0;
        end else begin
            if (start == 1'b0) begin
                valid_x8 <= 'd0;
                toggle_x8 <= 'd0;
                data_x8 <= 'd0;
            end else begin
                valid_x8 <= valid_x4 & toggle_x8;
                if (valid_x4 == 1'b1) begin
                    toggle_x8 <= ~toggle_x8;
                    data_x8[((X4W*2)-1):(X4W*1)] <= data_x4;
                    data_x8[((X4W*1)-1):(X4W*0)] <= data_x8[((X4W*2)-1):(X4W*1)];
                end
            end
        end
    end

    end

    endgenerate

endmodule

// **********************************************************************************
// **********************************************************************************
