// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Description:       TDD enable
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module tdd_enable (

    // source

    input   wire            tdd_resetn,
    input   wire            tdd_clk,
    input   wire            tdd_genb,
    input   wire            tdd_state,
    input   wire            tdd_last,
    input   wire  [ 31:0]   tdd_clk_cnt,
    input   wire  [ 31:0]   tdd_frm_cnt,
    output  reg             tdd_enable = 'd0,

    // axilite

    input   wire            axilite_clk,
    input   wire            axilite_resetn,
    input   wire  [ 31:0]   axilite_pri_assert,
    input   wire  [ 31:0]   axilite_pri_deassert,
    input   wire  [ 31:0]   axilite_sec_assert,
    input   wire  [ 31:0]   axilite_sec_deassert,
    input   wire  [ 31:0]   axilite_pri_frame_assert,
    input   wire  [ 31:0]   axilite_pri_frame_deassert,
    input   wire  [ 31:0]   axilite_sec_frame_assert,
    input   wire  [ 31:0]   axilite_sec_frame_deassert,
    input   wire  [  1:0]   axilite_mode);

    // internal registers

    reg                     tdd_pri_enable = 'd0;
    reg                     tdd_sec_enable = 'd0;

    // internal signals

    wire          [ 31:0]   tdd_pri_assert;
    wire          [ 31:0]   tdd_pri_deassert;
    wire          [ 31:0]   tdd_sec_assert;
    wire          [ 31:0]   tdd_sec_deassert;
    wire          [ 31:0]   tdd_pri_frame_assert;
    wire          [ 31:0]   tdd_pri_frame_deassert;
    wire          [ 31:0]   tdd_sec_frame_assert;
    wire          [ 31:0]   tdd_sec_frame_deassert;
    wire          [  1:0]   tdd_mode;
    wire                    tdd_int_resetn;

    // tdd enable

    always @(negedge tdd_int_resetn or posedge tdd_clk) begin
        if (tdd_int_resetn == 1'b0) begin
            tdd_enable <= 1'd0;
            tdd_pri_enable <= 1'd0;
            tdd_sec_enable <= 1'd0;
        end else begin
            if (tdd_mode[1] == 1'd0) begin
                tdd_enable <= tdd_mode[0] & tdd_genb;
            end else begin
                tdd_enable <= tdd_pri_enable | tdd_sec_enable;
            end
            if (((tdd_frm_cnt >= tdd_pri_frame_assert) &&
                (tdd_frm_cnt <= tdd_pri_frame_deassert)) ||
                ((tdd_frm_cnt >= tdd_sec_frame_assert) &&
                (tdd_frm_cnt <= tdd_sec_frame_deassert))) begin
                if (tdd_clk_cnt == tdd_pri_deassert) begin
                    tdd_pri_enable <= 1'd0;
                end else if (tdd_clk_cnt == tdd_pri_assert) begin
                    tdd_pri_enable <= tdd_state & ~tdd_last;
                end
                if (tdd_clk_cnt == tdd_sec_deassert) begin
                    tdd_sec_enable <= 1'd0;
                end else if (tdd_clk_cnt == tdd_sec_assert) begin
                    tdd_sec_enable <= tdd_state & ~tdd_last;
                end
            end
        end
    end

    // instantiations

    cdc_resetp i_cdc_resetp (
        .src_clk          (tdd_clk),
        .src_resetn       (tdd_resetn),
        .dest_clk         (tdd_clk),
        .dest_resetp      (tdd_int_resetn));

    cdc_cntrl #(.DATA_WIDTH(258)) i_tdd_cdc_cntrl (
        .src_resetn       (axilite_resetn),
        .src_clk          (axilite_clk),
        .src_data         ({axilite_pri_assert,
                            axilite_pri_deassert,
                            axilite_sec_assert,
                            axilite_sec_deassert,
                            axilite_pri_frame_assert,
                            axilite_pri_frame_deassert,
                            axilite_sec_frame_assert,
                            axilite_sec_frame_deassert,
                            axilite_mode}),
        .dest_resetn      (tdd_int_resetn),
        .dest_clk         (tdd_clk),
        .dest_data        ({tdd_pri_assert,
                            tdd_pri_deassert,
                            tdd_sec_assert,
                            tdd_sec_deassert,
                            tdd_pri_frame_assert,
                            tdd_pri_frame_deassert,
                            tdd_sec_frame_assert,
                            tdd_sec_frame_deassert,
                            tdd_mode}));

endmodule

// **********************************************************************************
// **********************************************************************************
