// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Description:       Pipe 1 (for global reset, and not to infer ram/shift-lut)
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module pipe_1 #(parameter WIDTH = 8) (

    // interface

    input   wire                    resetn,
    input   wire                    clk,
    input   wire  [(WIDTH-1):0]     data_in,
    output  reg                     resetn_out = 'd0,
    output  reg   [(WIDTH-1):0]     data_out = 'd0);

    // simple register

    always @(negedge resetn or posedge clk) begin
        if (resetn == 1'b0) begin
            resetn_out <= 'd0;
            data_out <= 'd0;
        end else begin
            resetn_out <= 'd1;
            data_out <= data_in;
        end
    end

endmodule

// **********************************************************************************
// **********************************************************************************
