// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Description:       Pipe
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module pipe #(
    
    parameter   WIDTH = 8,
    parameter   LENGTH = 0) (

    // interface

    input   wire                    resetn,
    input   wire                    clk,
    input   wire  [(WIDTH-1):0]     data_in,
    output  wire                    resetn_out,
    output  wire  [(WIDTH-1):0]     data_out);

    // signals

    wire                            presetn[0:LENGTH];
    wire          [(WIDTH-1):0]     pdata[0:LENGTH];

    // simple pipe-line


    genvar n;
    generate

    if (LENGTH == 0) begin

    assign pdata[0] = 'd0;
    assign presetn[0] = 'd0;
    assign resetn_out = resetn;
    assign data_out = data_in;

    end else begin

    assign presetn[0] = resetn;
    assign pdata[0] = data_in;
    assign resetn_out = presetn[LENGTH];
    assign data_out = pdata[LENGTH];

    for (n = 0; n < LENGTH; n = n + 1) begin: g_pipe_1
    pipe_1 #(.WIDTH(WIDTH)) i_pipe_1 (
        .resetn         (presetn[n]),
        .clk            (clk),
        .data_in        (pdata[n]),
        .resetn_out     (presetn[(n+1)]),
        .data_out       (pdata[(n+1)]));
    end

    end
    endgenerate

endmodule

// **********************************************************************************
// **********************************************************************************
