// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Description:       FIFO, zero delay read
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module mem_zrd #(

    parameter   DATA_WIDTH = 16) (

    input   wire                        rd_clk,
    input   wire                        rd_resetn,
    input   wire                        rd_read,
    output  wire                        rd_valid,
    output  wire  [(DATA_WIDTH-1):0]    rd_data,
    output  wire                        rd_empty,
    output  reg                         rd_mem_read = 'd0,
    input   wire                        rd_mem_valid,
    input   wire  [(DATA_WIDTH-1):0]    rd_mem_data,
    input   wire                        rd_mem_empty);

    // internal registers
 
    reg           [ 3:0]                rd_mem_cnt = 'd0;
    reg           [ 2:0]                rd_wrcnt = 'd0;
    reg           [ 2:0]                rd_rdcnt = 'd0;
    reg                                 rd_valid_0 = 'd0;
    reg           [(DATA_WIDTH-1):0]    rd_data_0 = 'd0;
    reg                                 rd_valid_1 = 'd0;
    reg           [(DATA_WIDTH-1):0]    rd_data_1 = 'd0;
    reg                                 rd_valid_2 = 'd0;
    reg           [(DATA_WIDTH-1):0]    rd_data_2 = 'd0;
    reg                                 rd_valid_3 = 'd0;
    reg           [(DATA_WIDTH-1):0]    rd_data_3 = 'd0;
    reg                                 rd_valid_4 = 'd0;
    reg           [(DATA_WIDTH-1):0]    rd_data_4 = 'd0;
    reg                                 rd_valid_5 = 'd0;
    reg           [(DATA_WIDTH-1):0]    rd_data_5 = 'd0;
    reg                                 rd_valid_6 = 'd0;
    reg           [(DATA_WIDTH-1):0]    rd_data_6 = 'd0;
    reg                                 rd_valid_7 = 'd0;
    reg           [(DATA_WIDTH-1):0]    rd_data_7 = 'd0;

    // internal signals

    wire                                rd_read_valid;

    // status update requires at least one clock cycle

    always @(negedge rd_resetn or posedge rd_clk) begin
        if (rd_resetn == 1'd0) begin
            rd_mem_cnt <= 4'd0;
            rd_mem_read <= 'd0;
        end else begin
            if ((rd_mem_valid == 1'b1) && (rd_read_valid == 1'b0)) begin
                rd_mem_cnt <= rd_mem_cnt + 1'd1;
            end else if ((rd_mem_valid == 1'b0) && (rd_read_valid == 1'b1)) begin
                rd_mem_cnt <= rd_mem_cnt - 1'd1;
            end
            rd_mem_read <= (rd_mem_cnt > 4'd4) ? rd_read : 1'b1;
        end
    end

    // data handler

    assign rd_read_valid = rd_read & rd_valid;

    always @(negedge rd_resetn or posedge rd_clk) begin
        if (rd_resetn == 1'd0) begin
            rd_wrcnt <= 3'd0;
            rd_rdcnt <= 3'd0;
        end else begin
            if (rd_mem_valid == 1'b1) begin
                rd_wrcnt <= rd_wrcnt + 1'b1;
            end
            if (rd_read_valid == 1'b1) begin
                rd_rdcnt <= rd_rdcnt + 1'b1;
            end
        end
    end

    // pipeline data

    assign rd_empty = ~rd_valid;
    assign rd_valid = (rd_rdcnt == 3'd0) ? rd_valid_0 :
        ((rd_rdcnt == 3'd1) ? rd_valid_1 :
        ((rd_rdcnt == 3'd2) ? rd_valid_2 :
        ((rd_rdcnt == 3'd3) ? rd_valid_3 :
        ((rd_rdcnt == 3'd4) ? rd_valid_4 :
        ((rd_rdcnt == 3'd5) ? rd_valid_5 :
        ((rd_rdcnt == 3'd6) ? rd_valid_6 :
        rd_valid_7))))));
    assign rd_data = (rd_rdcnt == 3'd0) ? rd_data_0 :
        ((rd_rdcnt == 3'd1) ? rd_data_1 :
        ((rd_rdcnt == 3'd2) ? rd_data_2 :
        ((rd_rdcnt == 3'd3) ? rd_data_3 :
        ((rd_rdcnt == 3'd4) ? rd_data_4 :
        ((rd_rdcnt == 3'd5) ? rd_data_5 :
        ((rd_rdcnt == 3'd6) ? rd_data_6 :
        rd_data_7))))));

    always @(negedge rd_resetn or posedge rd_clk) begin
        if (rd_resetn == 1'd0) begin
            rd_valid_0 <= 'd0;
            rd_data_0 <= 'd0;
            rd_valid_1 <= 'd0;
            rd_data_1 <= 'd0;
            rd_valid_2 <= 'd0;
            rd_data_2 <= 'd0;
            rd_valid_3 <= 'd0;
            rd_data_3 <= 'd0;
            rd_valid_4 <= 'd0;
            rd_data_4 <= 'd0;
            rd_valid_5 <= 'd0;
            rd_data_5 <= 'd0;
            rd_valid_6 <= 'd0;
            rd_data_6 <= 'd0;
            rd_valid_7 <= 'd0;
            rd_data_7 <= 'd0;
        end else begin
            if ((rd_wrcnt == 3'd0) && (rd_mem_valid == 1'b1)) begin
                rd_valid_0 <= 1'b1;
                rd_data_0 <= rd_mem_data;
            end else if ((rd_rdcnt == 3'd0) && (rd_read_valid == 1'b1)) begin
                rd_valid_0 <= 1'b0;
                rd_data_0 <= 'd0;
            end
            if ((rd_wrcnt == 3'd1) && (rd_mem_valid == 1'b1)) begin
                rd_valid_1 <= 1'b1;
                rd_data_1 <= rd_mem_data;
            end else if ((rd_rdcnt == 3'd1) && (rd_read_valid == 1'b1)) begin
                rd_valid_1 <= 1'b0;
                rd_data_1 <= 'd0;
            end
            if ((rd_wrcnt == 3'd2) && (rd_mem_valid == 1'b1)) begin
                rd_valid_2 <= 1'b1;
                rd_data_2 <= rd_mem_data;
            end else if ((rd_rdcnt == 3'd2) && (rd_read_valid == 1'b1)) begin
                rd_valid_2 <= 1'b0;
                rd_data_2 <= 'd0;
            end
            if ((rd_wrcnt == 3'd3) && (rd_mem_valid == 1'b1)) begin
                rd_valid_3 <= 1'b1;
                rd_data_3 <= rd_mem_data;
            end else if ((rd_rdcnt == 3'd3) && (rd_read_valid == 1'b1)) begin
                rd_valid_3 <= 1'b0;
                rd_data_3 <= 'd0;
            end
            if ((rd_wrcnt == 3'd4) && (rd_mem_valid == 1'b1)) begin
                rd_valid_4 <= 1'b1;
                rd_data_4 <= rd_mem_data;
            end else if ((rd_rdcnt == 3'd4) && (rd_read_valid == 1'b1)) begin
                rd_valid_4 <= 1'b0;
                rd_data_4 <= 'd0;
            end
            if ((rd_wrcnt == 3'd5) && (rd_mem_valid == 1'b1)) begin
                rd_valid_5 <= 1'b1;
                rd_data_5 <= rd_mem_data;
            end else if ((rd_rdcnt == 3'd5) && (rd_read_valid == 1'b1)) begin
                rd_valid_5 <= 1'b0;
                rd_data_5 <= 'd0;
            end
            if ((rd_wrcnt == 3'd6) && (rd_mem_valid == 1'b1)) begin
                rd_valid_6 <= 1'b1;
                rd_data_6 <= rd_mem_data;
            end else if ((rd_rdcnt == 3'd6) && (rd_read_valid == 1'b1)) begin
                rd_valid_6 <= 1'b0;
                rd_data_6 <= 'd0;
            end
            if ((rd_wrcnt == 3'd7) && (rd_mem_valid == 1'b1)) begin
                rd_valid_7 <= 1'b1;
                rd_data_7 <= rd_mem_data;
            end else if ((rd_rdcnt == 3'd7) && (rd_read_valid == 1'b1)) begin
                rd_valid_7 <= 1'b0;
                rd_data_7 <= 'd0;
            end
        end
    end

endmodule

// **********************************************************************************
// **********************************************************************************
