// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Description:       Zero delay FIFO, simple dual port
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module mem_zdfifo #(

    parameter   WRITE_LIMIT = 14,
    parameter   ADDRESS_WIDTH = 4,
    parameter   DATA_WIDTH = 16) (

    input   wire                        wr_clk,
    input   wire                        wr_resetn,
    input   wire                        wr_valid,
    input   wire  [(DATA_WIDTH-1):0]    wr_data,
    output  wire                        wr_limit,

    input   wire                        rd_clk,
    input   wire                        rd_resetn,
    input   wire                        rd_read,
    output  wire                        rd_valid,
    output  wire  [(DATA_WIDTH-1):0]    rd_data,
    output  wire                        rd_empty);

    // internal signals
 
    wire                                rd_mem_read;
    wire                                rd_mem_valid;
    wire          [(DATA_WIDTH-1):0]    rd_mem_data;
    wire                                rd_mem_empty;

    // instantiations
 
    mem_fifo #(
        .WRITE_LIMIT    (WRITE_LIMIT),
        .ADDRESS_WIDTH  (ADDRESS_WIDTH),
        .DATA_WIDTH     (DATA_WIDTH))
    i_fifo (
        .wr_clk         (wr_clk),
        .wr_resetn      (wr_resetn),
        .wr_valid       (wr_valid),
        .wr_data        (wr_data),
        .wr_limit       (wr_limit),
        .rd_clk         (rd_clk),
        .rd_resetn      (rd_resetn),
        .rd_read        (rd_mem_read),
        .rd_valid       (rd_mem_valid),
        .rd_data        (rd_mem_data),
        .rd_empty       (rd_mem_empty));

    mem_zrd #(
        .DATA_WIDTH     (DATA_WIDTH))
    i_zrd (
        .rd_clk         (rd_clk),
        .rd_resetn      (rd_resetn),
        .rd_read        (rd_read),
        .rd_valid       (rd_valid),
        .rd_data        (rd_data),
        .rd_empty       (rd_empty),
        .rd_mem_read    (rd_mem_read),
        .rd_mem_valid   (rd_mem_valid),
        .rd_mem_data    (rd_mem_data),
        .rd_mem_empty   (rd_mem_empty));

endmodule

// **********************************************************************************
// **********************************************************************************
