// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Description:       Simple CDC reset (parameterized level, and edge)
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module cdc_resetp #(

    parameter ACTIVE_HIGH1_LOW0 = 0,
    parameter ACTIVE_RISE1_FALL0 = 0) (

    // source

    input   wire    src_clk,
    input   wire    src_resetn,

    // destination

    input   wire    dest_clk,
    output  reg     dest_resetp = ACTIVE_HIGH1_LOW0);

    // internal registers

    reg             src_async_resetn = ACTIVE_HIGH1_LOW0;
    reg             dest_sync_resetp_1 = ACTIVE_HIGH1_LOW0;
    reg             dest_sync_resetp_2 = ACTIVE_HIGH1_LOW0;

    // simple reset

    always @(posedge src_clk) begin
        src_async_resetn <= src_resetn;
    end

    generate
    if (ACTIVE_RISE1_FALL0 == 0) begin

    always @(negedge src_async_resetn or negedge dest_clk) begin
        if (src_async_resetn == 1'b0) begin
            dest_sync_resetp_1 <= ACTIVE_HIGH1_LOW0;
            dest_sync_resetp_2 <= ACTIVE_HIGH1_LOW0;
            dest_resetp <= ACTIVE_HIGH1_LOW0;
        end else begin
            dest_sync_resetp_1 <= ~ACTIVE_HIGH1_LOW0;
            dest_sync_resetp_2 <= dest_sync_resetp_1;
            dest_resetp <= dest_sync_resetp_2;
        end
    end

    end else begin

    always @(negedge src_async_resetn or posedge dest_clk) begin
        if (src_async_resetn == 1'b0) begin
            dest_sync_resetp_1 <= ACTIVE_HIGH1_LOW0;
            dest_sync_resetp_2 <= ACTIVE_HIGH1_LOW0;
            dest_resetp <= ACTIVE_HIGH1_LOW0;
        end else begin
            dest_sync_resetp_1 <= ~ACTIVE_HIGH1_LOW0;
            dest_sync_resetp_2 <= dest_sync_resetp_1;
            dest_resetp <= dest_sync_resetp_2;
        end
    end

    end
    endgenerate

endmodule

// **********************************************************************************
// **********************************************************************************
