// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Description:       CDC Phase (clocks must be frequency locked)
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module cdc_phase #(parameter DATA_WIDTH = 8) (

    // source

    input   wire                      src_clk,
    input   wire  [(DATA_WIDTH-1):0]  src_data,

    // destination

    input   wire                      dest_clk,
    output  wire  [(DATA_WIDTH-1):0]  dest_data,
    input   wire                      dest_resetn,
    output  reg                       dest_ovf,
    output  reg                       dest_unf);

    // internal registers

    reg                               dest_enable = 'd0;
    reg                               dest_ovf_m1 = 'd0;
    reg                               dest_unf_m1 = 'd0;
    reg                               src_enable = 'd0;
    reg                               src_reset_m1 = 'd0;
    reg                               src_reset = 'd0;

    // internal signals

    wire                              dest_disable;
    wire                              src_disable;

    // source write interface

    always @(posedge dest_clk) begin
        dest_enable <= ~dest_disable;
    end

    always @(posedge dest_clk) begin
        dest_ovf_m1 <= fifo_full;
        dest_ovf <= dest_ovf_m1;
        dest_unf_m1 <= fifo_empty;
        dest_unf <= dest_unf_m1;
    end

    always @(posedge src_clk) begin
        src_enable <= ~src_disable;
    end

    always @(posedge src_clk) begin
        src_reset_m1 <= ~dest_resetn;
        src_reset <= src_reset_m1;
    end

    xpm_fifo_async #(
        .CDC_SYNC_STAGES                (2),
        .DOUT_RESET_VALUE               ("0"),
        .ECC_MODE                       ("no_ecc"),
        .FIFO_MEMORY_TYPE               ("auto"),
        .FIFO_READ_LATENCY              (1),
        .FIFO_WRITE_DEPTH               (16),
        .FULL_RESET_VALUE               (0),
        .PROG_EMPTY_THRESH              (2),
        .PROG_FULL_THRESH               (14),
        .RD_DATA_COUNT_WIDTH            (1),
        .READ_DATA_WIDTH                (DATA_WIDTH),
        .READ_MODE                      ("std"),
        .RELATED_CLOCKS                 (0),
        .USE_ADV_FEATURES               ("0000"),
        .WAKEUP_TIME                    (0),
        .WRITE_DATA_WIDTH               (DATA_WIDTH),
        .WR_DATA_COUNT_WIDTH            (1))
    i_fifo (
        .almost_empty                   (),
        .almost_full                    (),
        .data_valid                     (),
        .dbiterr                        (),
        .dout                           (dest_data),
        .empty                          (fifo_empty),
        .full                           (fifo_full),
        .overflow                       (),
        .prog_empty                     (),
        .prog_full                      (),
        .rd_data_count                  (),
        .rd_rst_busy                    (dest_disable),
        .sbiterr                        (),
        .underflow                      (),
        .wr_ack                         (),
        .wr_data_count                  (),
        .wr_rst_busy                    (src_disable),
        .din                            (src_data),
        .injectdbiterr                  (1'd0),
        .injectsbiterr                  (1'd0),
        .rd_clk                         (dest_clk),
        .rd_en                          (dest_enable),
        .rst                            (src_reset),
        .sleep                          (1'd0),
        .wr_clk                         (src_clk),
        .wr_en                          (src_enable));

endmodule

// **********************************************************************************
// **********************************************************************************
