// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Description:       Simple CDC (no source clock or reset)
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module cdc #(parameter DATA_WIDTH = 8) (

    // source

    input   wire  [(DATA_WIDTH-1):0]          src_data,

    // destination

    input   wire                              dest_resetn,
    input   wire                              dest_clk,
    output  reg   [(DATA_WIDTH-1):0]          dest_data = 'd0);

    // internal registers

    reg           [(DATA_WIDTH-1):0]          dest_data_m1 = 'd0;

    // simple xfer

    always @(negedge dest_resetn or posedge dest_clk) begin
        if (dest_resetn == 1'b0) begin
            dest_data_m1 <= 'd0;
            dest_data <= 'd0;
        end else begin
            dest_data_m1 <= src_data;
            dest_data <= dest_data_m1;
        end
    end

endmodule

// **********************************************************************************
// **********************************************************************************
