// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Description:       AXILite blocks bus handler
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module axilite_block_if #(parameter NUM_OF_BLOCKS = 8) (

    // axilite interface
 
    input   wire                              axilite_clk,
    input   wire                              axilite_resetn,
    output  reg                               axilite_intr = 'd0,
    output  reg                               axilite_wrack = 'd0,
    output  reg                               axilite_rdack = 'd0,
    output  reg   [   31:0]                   axilite_rddata = 'd0,

    // block interface
 
    input   wire  [(NUM_OF_BLOCKS-1):0]       axilite_block_intr,
    input   wire  [(NUM_OF_BLOCKS-1):0]       axilite_block_wrack,
    input   wire  [(NUM_OF_BLOCKS-1):0]       axilite_block_rdack,
    input   wire  [((NUM_OF_BLOCKS*32)-1):0]  axilite_block_rddata);

    // internal signals

    wire                                      axilite_split_intr[0:(NUM_OF_BLOCKS-1)];
    wire                                      axilite_split_wrack[0:(NUM_OF_BLOCKS-1)];
    wire                                      axilite_split_rdack[0:(NUM_OF_BLOCKS-1)];
    wire          [   31:0]                   axilite_split_rddata[0:(NUM_OF_BLOCKS-1)];
    reg                                       axilite_int_intr = 'd0;
    reg                                       axilite_int_wrack = 'd0;
    reg                                       axilite_int_rdack = 'd0;
    reg           [   31:0]                   axilite_int_rddata = 'd0;


    // axi blocks

    genvar n;
    generate
    for (n = 0; n < NUM_OF_BLOCKS; n = n + 1) begin: g_split
    assign axilite_split_intr[n] = axilite_block_intr[n];
    assign axilite_split_wrack[n] = axilite_block_wrack[n];
    assign axilite_split_rdack[n] = axilite_block_rdack[n];
    assign axilite_split_rddata[n] = axilite_block_rddata[((n*32)+31):(n*32)];
    end
    endgenerate

    integer i;
    always @(*) begin
        axilite_int_intr = 1'd0;
        axilite_int_wrack = 1'd0;
        axilite_int_rdack = 1'd0;
        axilite_int_rddata = 32'd0;
        for (i = 0; i < NUM_OF_BLOCKS; i = i + 1) begin
            axilite_int_intr = axilite_int_intr | axilite_split_intr[i];
            axilite_int_wrack = axilite_int_wrack | axilite_split_wrack[i];
            axilite_int_rdack = axilite_int_rdack | axilite_split_rdack[i];
            axilite_int_rddata = axilite_int_rddata | axilite_split_rddata[i];
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 0) begin
            axilite_intr <= 1'd0;
            axilite_wrack <= 1'd0;
            axilite_rdack <= 1'd0;
            axilite_rddata <= 32'd0;
        end else begin
            axilite_intr <= axilite_int_intr;
            axilite_wrack <= axilite_int_wrack;
            axilite_rdack <= axilite_int_rdack;
            axilite_rddata <= axilite_int_rddata;
        end
    end

endmodule

// **********************************************************************************
// **********************************************************************************
