# AXI Transmit DMA

## Contents

* [Introduction](#introduction)
* [Functional Description](#functional-description)
* [Parameters](#parameters)
* [Ports](#ports)
* [Register Map](#register-map)

## <a name="introduction"></a>Introduction

The AXI transmit DMA transfers samples from the AXI memory slave (usually DDR).

## <a name="functional-description"></a>Functional Description

This is an AXI memory mapped core (write only). At the device side, it has an AXI stream interface. There is no back pressure, the AXIMM interface must be capable of meeting the bandwidth requirements of the interface core. If not, an overflow and underflow is the certain result.

Since DMA is a well known concept, this document highlights only the control flow around the data transfer. In its default configuration, samples are transferred as received as soon as the start bit (see register description) is set. The exception to this, as outlined below, makes the core more interesting. In literacy terms, it adds valleys and peaks to an otherwise barren desert land.

### Trigger souces ###

The trigger sources, if enabled, control when a DMA starts transferring samples.

There are four common trigger ports in DMA (this depends on the project, see the corresponding documentation for details). These trigger ports can be individually setup to start the transfer at the rising edge, falling edge or either edge. They can also be masked individually to generate a multiple trigger controlled capture.

Since software is asynchronous in nature, in default configuration, the DMA starts immediately when the start bit is set. There may be scenarios where this is not desired.

If there are multiple DMA cores that need to start at the same time, each DMA can be configured to use one of the trigger sources, common to all cores as the trigger event. The trigger allows DMA to start capture at a specified time.

### TDD Trigger souce ###

The DMA also supports a dedicated TDD trigger source, though its function is the same as the other trigger signals, this is special because it is dedicated and is generated by TDD. This allows a programmable capture delay between two DMA cores, but still synchronous to each other.

### Synchronous Enable ###

The trigger sources mentioned above controls how the DMA starts capture and subsequent captures follow the assertion of the valid signal at the interface. This can be controlled with a synchronous enable option, if set, this allows DMA to align capture with the enable signal. In order to understand this better, let's see how DMA transfers samples under the following scenario.

Let's assume that the enable is a periodic signal, asserted high for 50 samples and DMA is set to capture 100 samples.

If software set the start bit in the middle of an enable asserted high time (say at the 25th sample). The transfer finishes with 25 remaining samples in the current period, 50 samples from the second period and another 25 samples from the third period. This results in a partial buffer (if enables were delineators of data buffers).

On the other hand, if synchronous enable is set in the same scenario above, transfer ignores the first partial frame completely. Instead it waits and collects 50 samples from the second period and 50 samples from the third period and finishes the transfer with two complete buffers (no partial buffers).

### Master Trigger Enable ###

In a multi-core environment, the DMA cores are primarily independent even with the common trigger sources. That is, a signal may still have a clock uncertainity between cores due to their asynchronous nature. If this uncertainity is not acceptable, one must setup the DMA in a master slave configuration, and a master trigger is used by all cores to achieve synchronization.

## <a name="parameters"></a>Parameters

---
| Parameter         | Type    | Default | Description |
| ----------------- | ------- | ------- | ----------- |
| INSTANCE\_ID      | Integer | 0       | The instance ID of this core. |
| AXIS\_DATA\_WIDTH | Integer | 32      | The AXIS data width 32 or 8 only. |
|||||
---

## <a name="ports"></a>Ports

---
| Port                  | Direction/Size           | Description |
| --------------------- | ------------------------ | ----------- |
| tx\_clk               | Input                    | Transmit clock. |
| tx\_resetn            | Input                    | Transmit reset (active low). |
| tx\_senb              | Input                    | Transmit data enable. |
| tx\_strig             | Input                    | Transmit TDD trigger input. |
| tx\_srd               | Input                    | Transmit data read. |
| tx\_sav               | Output                   | Transmit data available. |
| tx\_svld              | Output                   | Transmit data valid. |
| tx\_sd                | Output[32]               | Transmit data. |
| trig                  | Input[4]                 | Trigger inputs. |
| tx\_mtrig\_out        | Output                   | Master trigger output. |
| tx\_mtrig\_in         | Input                    | Master trigger input. |
| aximm\_clk            | Input                    | MM interface clock. |
| aximm\_resetn         | Input                    | MM interface reset (active low). |
| aximm\_araddr         | Output[40]               | MM read address channel, address. |
| aximm\_arlen          | Output[8]                | MM read address channel, length. |
| aximm\_arsize         | Output[3]                | MM read address channel, size. |
| aximm\_arburst        | Output[2]                | MM read address channel, burst. |
| aximm\_arprot         | Output[3]                | MM read address channel, protect. |
| aximm\_arcache        | Output[4]                | MM read address channel, cache. |
| aximm\_aruser         | Output[4]                | MM read address channel, user. |
| aximm\_arvalid        | Output                   | MM read address channel, valid. |
| aximm\_arready        | Input                    | MM read address channel, ready. |
| aximm\_rdata          | Input[512]               | MM read channel, data. |
| aximm\_rresp          | Input[2]                 | MM read channel, response. |
| aximm\_rlast          | Input                    | MM read channel, last. |
| aximm\_rvalid         | Input                    | MM read channel, valid. |
| aximm\_rready         | Output                   | MM read channel, ready. |
| axilite\_clk          | Input                    | Processor clock. |
| axilite\_resetn       | Input                    | Processor reset (active low). |
| axilite\_awvalid      | Input                    | Write address channel, valid. |
| axilite\_awaddr       | Input[16]                | Write address channel, address. |
| axilite\_awready      | Output                   | Write address channel, ready. |
| axilite\_wvalid       | Input                    | Write channel, valid. |
| axilite\_wdata        | Input[32]                | Write channel, data. | 
| axilite\_wready       | Output                   | Write channel, ready. |
| axilite\_bvalid       | Output                   | Write response channel, valid. |
| axilite\_bresp        | Output[2]                | Write response channel, data (response). |
| axilite\_bready       | Input                    | Write response channel, ready. |
| axilite\_arvalid      | Input                    | Read address channel, valid. |
| axilite\_araddr       | Input[16]                | Read address channel, address. |
| axilite\_arready      | Output                   | Read address channel, ready. |
| axilite\_rvalid       | Output                   | Read data channel, valid. |
| axilite\_rresp        | Output[2]                | Read data channel, response. |
| axilite\_rdata        | Output[32]               | Read data channel, data. |
| axilite\_rready       | Input                    | Read data channel, ready. |
| interrupt             | Output                   | Processor interrupt (active high). |
||||
---

## <a name="register-map"></a>Register Map

### [Register Map](hdl/axi_txdma_regs.md)
