// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Description:       Auto generated, local modifications are discouraged.
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module axi_sysid_top_regs (

    input   wire  [31:0]    axilite_version,
    input   wire  [31:0]    axilite_instance_id,
    output  reg   [31:0]    axilite_scratch = 'd0,
    output  reg   [31:0]    axilite_timer = 'd0,
    input   wire  [31:0]    axilite_board_id,
    input   wire  [ 7:0]    axilite_gpio_in,
    output  reg   [ 7:0]    axilite_gpio_out = 'd0,
    input   wire  [ 7:0]    axilite_status_state,
    output  reg   [ 7:0]    axilite_control_state = 'd0,
    output  reg   [ 7:0]    axilite_intr_gpio_in_enable = 'd0,
    output  reg   [ 7:0]    axilite_intr_status_state_enable = 'd0,
    input   wire  [31:0]    axilite_sys_version,
    input   wire  [31:0]    axilite_sys_params_0,
    input   wire  [31:0]    axilite_sys_params_1,
    input   wire  [31:0]    axilite_sys_build_0,
    input   wire  [31:0]    axilite_sys_build_1,
    input   wire  [31:0]    axilite_sys_info_0_0,
    input   wire  [31:0]    axilite_sys_info_0_1,
    input   wire  [31:0]    axilite_sys_info_0_2,
    input   wire  [31:0]    axilite_sys_info_0_3,
    input   wire  [31:0]    axilite_sys_info_0_4,
    input   wire  [31:0]    axilite_sys_info_0_5,
    input   wire  [31:0]    axilite_sys_info_0_6,
    input   wire  [31:0]    axilite_sys_info_0_7,
    input   wire  [31:0]    axilite_sys_info_1_0,
    input   wire  [31:0]    axilite_sys_info_1_1,
    input   wire  [31:0]    axilite_sys_info_1_2,
    input   wire  [31:0]    axilite_sys_info_1_3,
    input   wire  [31:0]    axilite_sys_info_1_4,
    input   wire  [31:0]    axilite_sys_info_1_5,
    input   wire  [31:0]    axilite_sys_info_1_6,
    input   wire  [31:0]    axilite_sys_info_1_7,
    output  reg   [31:0]    axilite_pwm_prescale_count = 'd0,
    output  reg   [ 7:0]    axilite_pwm_enable = 'd0,
    output  reg   [ 7:0]    axilite_pwm_out = 'd0,
    output  reg   [15:0]    axilite_pwm_delay_count_0 = 'd0,
    output  reg   [15:0]    axilite_pwm_high_count_0 = 'd0,
    output  reg   [15:0]    axilite_pwm_low_count_0 = 'd0,
    output  reg   [15:0]    axilite_pwm_delay_count_1 = 'd0,
    output  reg   [15:0]    axilite_pwm_high_count_1 = 'd0,
    output  reg   [15:0]    axilite_pwm_low_count_1 = 'd0,
    output  reg   [15:0]    axilite_pwm_delay_count_2 = 'd0,
    output  reg   [15:0]    axilite_pwm_high_count_2 = 'd0,
    output  reg   [15:0]    axilite_pwm_low_count_2 = 'd0,
    output  reg   [15:0]    axilite_pwm_delay_count_3 = 'd0,
    output  reg   [15:0]    axilite_pwm_high_count_3 = 'd0,
    output  reg   [15:0]    axilite_pwm_low_count_3 = 'd0,
    output  reg   [15:0]    axilite_pwm_delay_count_4 = 'd0,
    output  reg   [15:0]    axilite_pwm_high_count_4 = 'd0,
    output  reg   [15:0]    axilite_pwm_low_count_4 = 'd0,
    output  reg   [15:0]    axilite_pwm_delay_count_5 = 'd0,
    output  reg   [15:0]    axilite_pwm_high_count_5 = 'd0,
    output  reg   [15:0]    axilite_pwm_low_count_5 = 'd0,
    output  reg   [15:0]    axilite_pwm_delay_count_6 = 'd0,
    output  reg   [15:0]    axilite_pwm_high_count_6 = 'd0,
    output  reg   [15:0]    axilite_pwm_low_count_6 = 'd0,
    output  reg   [15:0]    axilite_pwm_delay_count_7 = 'd0,
    output  reg   [15:0]    axilite_pwm_high_count_7 = 'd0,
    output  reg   [15:0]    axilite_pwm_low_count_7 = 'd0,
    input   wire            axilite_sys_intr_status,
    input   wire  [31:0]    axilite_sys_intr_0_status,
    output  reg   [31:0]    axilite_sys_intr_0_enable = 'd0,
    input   wire  [31:0]    axilite_mem_id,
    input   wire  [11:0]    axilite_mem_pg,
    output  reg   [11:0]    axilite_mem_pg_sel = 'd0,

    input   wire            axilite_clk,
    input   wire            axilite_resetn,
    input   wire            axilite_wrreq,
    input   wire  [11:0]    axilite_wraddr,
    input   wire  [31:0]    axilite_wrdata,
    output  reg             axilite_wrack = 'd0,
    input   wire            axilite_rdreq,
    input   wire  [11:0]    axilite_rdaddr,
    output  reg   [31:0]    axilite_rddata = 'd0,
    output  reg             axilite_rdack = 'd0);


    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_wrack <= 'd0;
            axilite_rdack <= 'd0;
        end else begin
            axilite_wrack <= axilite_wrreq;
            axilite_rdack <= axilite_rdreq;
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_scratch <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h8)) begin
                axilite_scratch <= axilite_wrdata;
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_timer <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'hc)) begin
                axilite_timer <= axilite_wrdata;
            end else if (axilite_timer > 0) begin
                axilite_timer <= axilite_timer - 1'b1;
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_gpio_out <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h44)) begin
                axilite_gpio_out <= axilite_wrdata[7:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_control_state <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h84)) begin
                axilite_control_state <= axilite_wrdata[7:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_intr_gpio_in_enable <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'hc4)) begin
                axilite_intr_gpio_in_enable <= axilite_wrdata[7:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_intr_status_state_enable <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'hc4)) begin
                axilite_intr_status_state_enable <= axilite_wrdata[15:8];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_pwm_prescale_count <= 'h186a0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h400)) begin
                axilite_pwm_prescale_count <= axilite_wrdata;
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_pwm_enable <= 'hff;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h404)) begin
                axilite_pwm_enable <= axilite_wrdata[7:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_pwm_out <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h408)) begin
                axilite_pwm_out <= axilite_wrdata[7:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_pwm_delay_count_0 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h410)) begin
                axilite_pwm_delay_count_0 <= axilite_wrdata[15:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_pwm_high_count_0 <= 'h64;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h414)) begin
                axilite_pwm_high_count_0 <= axilite_wrdata[15:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_pwm_low_count_0 <= 'h2bc;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h418)) begin
                axilite_pwm_low_count_0 <= axilite_wrdata[15:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_pwm_delay_count_1 <= 'h64;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h420)) begin
                axilite_pwm_delay_count_1 <= axilite_wrdata[15:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_pwm_high_count_1 <= 'h64;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h424)) begin
                axilite_pwm_high_count_1 <= axilite_wrdata[15:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_pwm_low_count_1 <= 'h2bc;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h428)) begin
                axilite_pwm_low_count_1 <= axilite_wrdata[15:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_pwm_delay_count_2 <= 'hc8;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h430)) begin
                axilite_pwm_delay_count_2 <= axilite_wrdata[15:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_pwm_high_count_2 <= 'h64;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h434)) begin
                axilite_pwm_high_count_2 <= axilite_wrdata[15:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_pwm_low_count_2 <= 'h2bc;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h438)) begin
                axilite_pwm_low_count_2 <= axilite_wrdata[15:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_pwm_delay_count_3 <= 'h12c;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h440)) begin
                axilite_pwm_delay_count_3 <= axilite_wrdata[15:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_pwm_high_count_3 <= 'h64;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h444)) begin
                axilite_pwm_high_count_3 <= axilite_wrdata[15:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_pwm_low_count_3 <= 'h2bc;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h448)) begin
                axilite_pwm_low_count_3 <= axilite_wrdata[15:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_pwm_delay_count_4 <= 'h190;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h450)) begin
                axilite_pwm_delay_count_4 <= axilite_wrdata[15:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_pwm_high_count_4 <= 'h64;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h454)) begin
                axilite_pwm_high_count_4 <= axilite_wrdata[15:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_pwm_low_count_4 <= 'h2bc;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h458)) begin
                axilite_pwm_low_count_4 <= axilite_wrdata[15:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_pwm_delay_count_5 <= 'h1f4;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h460)) begin
                axilite_pwm_delay_count_5 <= axilite_wrdata[15:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_pwm_high_count_5 <= 'h64;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h464)) begin
                axilite_pwm_high_count_5 <= axilite_wrdata[15:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_pwm_low_count_5 <= 'h2bc;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h468)) begin
                axilite_pwm_low_count_5 <= axilite_wrdata[15:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_pwm_delay_count_6 <= 'h258;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h470)) begin
                axilite_pwm_delay_count_6 <= axilite_wrdata[15:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_pwm_high_count_6 <= 'h64;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h474)) begin
                axilite_pwm_high_count_6 <= axilite_wrdata[15:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_pwm_low_count_6 <= 'h2bc;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h478)) begin
                axilite_pwm_low_count_6 <= axilite_wrdata[15:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_pwm_delay_count_7 <= 'h2bc;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h480)) begin
                axilite_pwm_delay_count_7 <= axilite_wrdata[15:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_pwm_high_count_7 <= 'h64;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h484)) begin
                axilite_pwm_high_count_7 <= axilite_wrdata[15:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_pwm_low_count_7 <= 'h2bc;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h488)) begin
                axilite_pwm_low_count_7 <= axilite_wrdata[15:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_sys_intr_0_enable <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h514)) begin
                axilite_sys_intr_0_enable <= axilite_wrdata;
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_mem_pg_sel <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h608)) begin
                axilite_mem_pg_sel <= axilite_wrdata[11:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_rddata <= 'd0;
        end else begin
            if (axilite_rdreq == 1'b1) begin
                case (axilite_rdaddr[11:0])
                    'h0: begin
                        axilite_rddata <= axilite_version;
                    end
                    'h4: begin
                        axilite_rddata <= axilite_instance_id;
                    end
                    'h8: begin
                        axilite_rddata <= axilite_scratch;
                    end
                    'hc: begin
                        axilite_rddata <= axilite_timer;
                    end
                    'h10: begin
                        axilite_rddata <= axilite_board_id;
                    end
                    'h40: begin
                        axilite_rddata[7:0] <= axilite_gpio_in;
                        axilite_rddata[31:8] <= 'd0;
                    end
                    'h44: begin
                        axilite_rddata[7:0] <= axilite_gpio_out;
                        axilite_rddata[31:8] <= 'd0;
                    end
                    'h80: begin
                        axilite_rddata[7:0] <= axilite_status_state;
                        axilite_rddata[31:8] <= 'd0;
                    end
                    'h84: begin
                        axilite_rddata[7:0] <= axilite_control_state;
                        axilite_rddata[31:8] <= 'd0;
                    end
                    'hc4: begin
                        axilite_rddata[7:0] <= axilite_intr_gpio_in_enable;
                        axilite_rddata[15:8] <= axilite_intr_status_state_enable;
                        axilite_rddata[31:16] <= 'd0;
                    end
                    'h100: begin
                        axilite_rddata <= axilite_sys_version;
                    end
                    'h104: begin
                        axilite_rddata <= axilite_sys_params_0;
                    end
                    'h108: begin
                        axilite_rddata <= axilite_sys_params_1;
                    end
                    'h140: begin
                        axilite_rddata <= axilite_sys_build_0;
                    end
                    'h144: begin
                        axilite_rddata <= axilite_sys_build_1;
                    end
                    'h200: begin
                        axilite_rddata <= axilite_sys_info_0_0;
                    end
                    'h204: begin
                        axilite_rddata <= axilite_sys_info_0_1;
                    end
                    'h208: begin
                        axilite_rddata <= axilite_sys_info_0_2;
                    end
                    'h20c: begin
                        axilite_rddata <= axilite_sys_info_0_3;
                    end
                    'h210: begin
                        axilite_rddata <= axilite_sys_info_0_4;
                    end
                    'h214: begin
                        axilite_rddata <= axilite_sys_info_0_5;
                    end
                    'h218: begin
                        axilite_rddata <= axilite_sys_info_0_6;
                    end
                    'h21c: begin
                        axilite_rddata <= axilite_sys_info_0_7;
                    end
                    'h300: begin
                        axilite_rddata <= axilite_sys_info_1_0;
                    end
                    'h304: begin
                        axilite_rddata <= axilite_sys_info_1_1;
                    end
                    'h308: begin
                        axilite_rddata <= axilite_sys_info_1_2;
                    end
                    'h30c: begin
                        axilite_rddata <= axilite_sys_info_1_3;
                    end
                    'h310: begin
                        axilite_rddata <= axilite_sys_info_1_4;
                    end
                    'h314: begin
                        axilite_rddata <= axilite_sys_info_1_5;
                    end
                    'h318: begin
                        axilite_rddata <= axilite_sys_info_1_6;
                    end
                    'h31c: begin
                        axilite_rddata <= axilite_sys_info_1_7;
                    end
                    'h400: begin
                        axilite_rddata <= axilite_pwm_prescale_count;
                    end
                    'h404: begin
                        axilite_rddata[7:0] <= axilite_pwm_enable;
                        axilite_rddata[31:8] <= 'd0;
                    end
                    'h408: begin
                        axilite_rddata[7:0] <= axilite_pwm_out;
                        axilite_rddata[31:8] <= 'd0;
                    end
                    'h410: begin
                        axilite_rddata[15:0] <= axilite_pwm_delay_count_0;
                        axilite_rddata[31:16] <= 'd0;
                    end
                    'h414: begin
                        axilite_rddata[15:0] <= axilite_pwm_high_count_0;
                        axilite_rddata[31:16] <= 'd0;
                    end
                    'h418: begin
                        axilite_rddata[15:0] <= axilite_pwm_low_count_0;
                        axilite_rddata[31:16] <= 'd0;
                    end
                    'h420: begin
                        axilite_rddata[15:0] <= axilite_pwm_delay_count_1;
                        axilite_rddata[31:16] <= 'd0;
                    end
                    'h424: begin
                        axilite_rddata[15:0] <= axilite_pwm_high_count_1;
                        axilite_rddata[31:16] <= 'd0;
                    end
                    'h428: begin
                        axilite_rddata[15:0] <= axilite_pwm_low_count_1;
                        axilite_rddata[31:16] <= 'd0;
                    end
                    'h430: begin
                        axilite_rddata[15:0] <= axilite_pwm_delay_count_2;
                        axilite_rddata[31:16] <= 'd0;
                    end
                    'h434: begin
                        axilite_rddata[15:0] <= axilite_pwm_high_count_2;
                        axilite_rddata[31:16] <= 'd0;
                    end
                    'h438: begin
                        axilite_rddata[15:0] <= axilite_pwm_low_count_2;
                        axilite_rddata[31:16] <= 'd0;
                    end
                    'h440: begin
                        axilite_rddata[15:0] <= axilite_pwm_delay_count_3;
                        axilite_rddata[31:16] <= 'd0;
                    end
                    'h444: begin
                        axilite_rddata[15:0] <= axilite_pwm_high_count_3;
                        axilite_rddata[31:16] <= 'd0;
                    end
                    'h448: begin
                        axilite_rddata[15:0] <= axilite_pwm_low_count_3;
                        axilite_rddata[31:16] <= 'd0;
                    end
                    'h450: begin
                        axilite_rddata[15:0] <= axilite_pwm_delay_count_4;
                        axilite_rddata[31:16] <= 'd0;
                    end
                    'h454: begin
                        axilite_rddata[15:0] <= axilite_pwm_high_count_4;
                        axilite_rddata[31:16] <= 'd0;
                    end
                    'h458: begin
                        axilite_rddata[15:0] <= axilite_pwm_low_count_4;
                        axilite_rddata[31:16] <= 'd0;
                    end
                    'h460: begin
                        axilite_rddata[15:0] <= axilite_pwm_delay_count_5;
                        axilite_rddata[31:16] <= 'd0;
                    end
                    'h464: begin
                        axilite_rddata[15:0] <= axilite_pwm_high_count_5;
                        axilite_rddata[31:16] <= 'd0;
                    end
                    'h468: begin
                        axilite_rddata[15:0] <= axilite_pwm_low_count_5;
                        axilite_rddata[31:16] <= 'd0;
                    end
                    'h470: begin
                        axilite_rddata[15:0] <= axilite_pwm_delay_count_6;
                        axilite_rddata[31:16] <= 'd0;
                    end
                    'h474: begin
                        axilite_rddata[15:0] <= axilite_pwm_high_count_6;
                        axilite_rddata[31:16] <= 'd0;
                    end
                    'h478: begin
                        axilite_rddata[15:0] <= axilite_pwm_low_count_6;
                        axilite_rddata[31:16] <= 'd0;
                    end
                    'h480: begin
                        axilite_rddata[15:0] <= axilite_pwm_delay_count_7;
                        axilite_rddata[31:16] <= 'd0;
                    end
                    'h484: begin
                        axilite_rddata[15:0] <= axilite_pwm_high_count_7;
                        axilite_rddata[31:16] <= 'd0;
                    end
                    'h488: begin
                        axilite_rddata[15:0] <= axilite_pwm_low_count_7;
                        axilite_rddata[31:16] <= 'd0;
                    end
                    'h500: begin
                        axilite_rddata[0] <= axilite_sys_intr_status;
                        axilite_rddata[31:1] <= 'd0;
                    end
                    'h510: begin
                        axilite_rddata <= axilite_sys_intr_0_status;
                    end
                    'h514: begin
                        axilite_rddata <= axilite_sys_intr_0_enable;
                    end
                    'h600: begin
                        axilite_rddata <= axilite_mem_id;
                    end
                    'h604: begin
                        axilite_rddata[11:0] <= axilite_mem_pg;
                        axilite_rddata[31:12] <= 'd0;
                    end
                    'h608: begin
                        axilite_rddata[11:0] <= axilite_mem_pg_sel;
                        axilite_rddata[31:12] <= 'd0;
                    end
                    default: begin
                        axilite_rddata <= 32'd0;
                    end
                endcase
            end else begin
                axilite_rddata <= 32'd0;
            end
        end
    end

endmodule

// **********************************************************************************
// **********************************************************************************
