#!/usr/bin/perl
## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Description:       System Id
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################

use autodie;
require 'dooku.pl';

$addr_width = 12;
$addr_width_used = 12;

$no_of_instances = 1;
$instance_base_addr = 0x0;
$instance_offset_addr = 0x0;

setdooku(@ARGV);
module(0x0, 'axi_sysid_top');

register(0x000, 'REG_VERSION');
field(0, 32, RO, 0x00060000, 'VERSION', 'This is read as the current version of this IP core.');

register(0x004, 'REG_INSTANCE_ID');
field(0, 32, RO, 0x0, 'INSTANCE_ID', 'These bits Indicate the instance ID, in any multiple
    instances system, instance id 0x0 is the master core.');

register(0x008, 'REG_SCRATCH');
field(0, 32, RW, 0x0, 'SCRATCH', 'The general purpose scratch register');

register(0x00c, 'REG_TIMER');
field(0, 32, RW, 0x0, 'TIMER', 'The general purpose timer register');

## ##################################################################################
## ##################################################################################
## Board/Hardware Id

register(0x010, 'REG_BOARD_ID');
field(0, 32, RO, 0x0, 'BOARD_ID', 'Board/Hardware identifier, system specific.');

## ##################################################################################
## ##################################################################################
## System GPIO

register(0x040, 'REG_GPIO_IN');
field(0, 8, RO, 0x0, 'GPIO_IN', 'GPIO inputs.');

register(0x044, 'REG_GPIO_OUT');
field(0, 8, RW, 0x0, 'GPIO_OUT', 'GPIO outputs.');

## ##################################################################################
## ##################################################################################
## System status & information (raw & persistent)

register(0x080, 'REG_STATUS_STATE');
field(0, 8, RO, 0x0, 'STATUS_STATE', 'Platform status states');

register(0x084, 'REG_CONTROL_STATE');
field(0, 8, RW, 0x0, 'CONTROL_STATE', 'Platform control states');

## ##################################################################################
## ##################################################################################
## Interrupts

register(0x0c4, 'REG_INTR_ENABLE');
field(0, 8, RW, 0x0, 'INTR_GPIO_IN_ENABLE', 'Interrupt enable for INTR_GPIO_IN.');
field(8, 8, RW, 0x0, 'INTR_STATUS_STATE_ENABLE', 'Interrupt enable for INTR_STATUS_STATE.');

## ##################################################################################
## ##################################################################################
## Platform Version (not the IP core version)

register(0x100, 'REG_SYS_VERSION');
field(0, 32, RO, 0x00060000, 'SYS_VERSION', 'This is read as the current version
    of the system and is independent of the IP core version.');

register(0x104, 'REG_SYS_PARAMS_0');
field(0, 32, RO, 0x0, 'SYS_PARAMS_0', 'This is read as system parameters
    set by the project (dependent on the platform)');

register(0x108, 'REG_SYS_PARAMS_1');
field(0, 32, RO, 0x0, 'SYS_PARAMS_1', 'This is read as system parameters
    set by the project (dependent on the platform)');

define('SYS_PARAMS_SIZE', 0x2, 'System parameters size');

register(0x140, 'REG_SYS_BUILD_0');
field(0, 32, RO, 0x0, 'SYS_BUILD_0', 'This is read as the build version
    of the system as MMDDYYYY.');

register(0x144, 'REG_SYS_BUILD_1');
field(0, 32, RO, 0x0, 'SYS_BUILD_1', 'This is read as the build version
    of the system as 00HHMMSS.');

define('SYS_BUILD_SIZE', 0x2, 'System build size');

## ##################################################################################
## ##################################################################################
## The 32 character system identifier.

$SID = "BOOT";
for ($n = 0; $n < 8; $n++) {
    register((0x200 + ($n*4)), "REG_SYS_INFO_0_${n}");
    field(0, 32, RO, s2h_32($SID, $n), "SYS_INFO_0_${n}", "System Id string $n");
}

define('SYS_INFO_0_SIZE', 0x8, 'System info (0) size');

## ##################################################################################
## ##################################################################################
## The 32 character system build identifier.

$BID = "201909191621";
for ($n = 0; $n < 8; $n++) {
    register((0x300 + ($n*4)), "REG_SYS_INFO_1_${n}");
    field(0, 32, RO, s2h_32($BID, $n), "SYS_INFO_1_${n}", "Build Id string $n");
}

define('SYS_INFO_1_SIZE', 0x8, 'System info (1) size');

## ##################################################################################
## ##################################################################################
## The timer controls

register(0x400, 'REG_PWM_PRESCALE_COUNT');
field(0, 32, RW, 100000, 'PWM_PRESCALE_COUNT', 'PWM prescale, base is 10ns');

register(0x404, 'REG_PWM_ENABLE');
field(0, 8, RW, 0xff, 'PWM_ENABLE', 'PWM enable, hardware mode.');

register(0x408, 'REG_PWM_OUT');
field(0, 8, RW, 0x00, 'PWM_OUT', 'PWM output, software mode.');

$register_offset = 0x10;
$register_count = 8;
$register_index = 0;

for ($register_index = 0; $register_index < $register_count; $register_index++) {

    $register_base = 0x410;
    register_loop("REG_PWM_DELAY_COUNT_%d");
    register_loop_field(0, 16, RW, ($register_index * 100), "PWM_DELAY_COUNT_%d", "PWM delay count.");

    $register_base = 0x414;
    register_loop("REG_PWM_HIGH_COUNT_%d");
    register_loop_field(0, 16, RW, 100, "PWM_HIGH_COUNT_%d", "PWM high count.");

    $register_base = 0x418;
    register_loop("REG_PWM_LOW_COUNT_%d");
    register_loop_field(0, 16, RW, 700, "PWM_LOW_COUNT_%d", "PWM low count.");
}

## ##################################################################################
## ##################################################################################
## Interrupts

$num_of_intrs = 1;
register(0x500, 'REG_SYS_INTR_STATUS');
field(0, $num_of_intrs, RO, 0x0, 'SYS_INTR_STATUS', 'Interrupt status,
    simplified tree (no mask or clear).');

for ($n = 0; $n < $num_of_intrs; $n++) {
    register((0x510 + ($n*0x10)), "REG_SYS_INTR_${n}_STATUS");
    field(0, 32, RO, 0x0, "SYS_INTR_${n}_STATUS", "Interrupts $n status.");
    register((0x514 + ($n*0x10)), "REG_SYS_INTR_${n}_ENABLE");
    field(0, 32, RW, 0x0, "SYS_INTR_${n}_ENABLE", "Interrupts $n enable, traditionally mask,
        to avoid ambiguity, renamed to enable, if set interrupt is enabled.");
}

## ##################################################################################
## ##################################################################################
## Memory Page

register(0x600, 'REG_MEM_ID');
field(0, 32, RO, 0x0, 'MEM_ID', 'Memory identifier, system specific.');

register(0x604, 'REG_MEM_PG');
field(0, 12, RO, 0x0, 'MEM_PG', 'Memory current page, system specific.');

register(0x608, 'REG_MEM_PG_SEL');
field(0, 12, RW, 0x0, 'MEM_PG_SEL', 'Memory page select, system specific.');

## ##################################################################################
## ##################################################################################

endregisters();
endmodule();
generate();

## ##################################################################################
## ##################################################################################
