### AXI\_SYSID\_TOP Register Map
The addresses shown are relative to the peripheral base address.

---
| Address | Bits | Field | Type | Default | Description |
| ------- | ---- | ----- | ---- | ------- | ----------- |
| 0x0 | [31:0] | version[31:0] | RO | 0x60000 | This is read as the current version of this IP core. |
| | | | | | |
| 0x4 | [31:0] | instance\_id[31:0] | RO | 0x0 | These bits Indicate the instance ID, in any multiple instances system, instance id 0x0 is the master core. |
| | | | | | |
| 0x8 | [31:0] | scratch[31:0] | RW | 0x0 | The general purpose scratch register |
| | | | | | |
| 0xc | [31:0] | timer[31:0] | RW | 0x0 | The general purpose timer register |
| | | | | | |
| 0x10 | [31:0] | board\_id[31:0] | RO | 0x0 | Board/Hardware identifier, system specific. |
| | | | | | |
| 0x40 | [7:0] | gpio\_in[7:0] | RO | 0x0 | GPIO inputs. |
| | | | | | |
| 0x44 | [7:0] | gpio\_out[7:0] | RW | 0x0 | GPIO outputs. |
| | | | | | |
| 0x80 | [7:0] | status\_state[7:0] | RO | 0x0 | Platform status states |
| | | | | | |
| 0x84 | [7:0] | control\_state[7:0] | RW | 0x0 | Platform control states |
| | | | | | |
| 0xc4 | [7:0] | intr\_gpio\_in\_enable[7:0] | RW | 0x0 | Interrupt enable for INTR\_GPIO\_IN. |
| 0xc4 | [15:8] | intr\_status\_state\_enable[7:0] | RW | 0x0 | Interrupt enable for INTR\_STATUS\_STATE. |
| | | | | | |
| 0x100 | [31:0] | sys\_version[31:0] | RO | 0x60000 | This is read as the current version of the system and is independent of the IP core version. |
| | | | | | |
| 0x104 | [31:0] | sys\_params\_0[31:0] | RO | 0x0 | This is read as system parameters set by the project (dependent on the platform) |
| | | | | | |
| 0x108 | [31:0] | sys\_params\_1[31:0] | RO | 0x0 | This is read as system parameters set by the project (dependent on the platform) |
| | | | | | |
| 0x140 | [31:0] | sys\_build\_0[31:0] | RO | 0x0 | This is read as the build version of the system as MMDDYYYY. |
| | | | | | |
| 0x144 | [31:0] | sys\_build\_1[31:0] | RO | 0x0 | This is read as the build version of the system as 00HHMMSS. |
| | | | | | |
| 0x200 | [31:0] | sys\_info\_0\_0[31:0] | RO | 0x424f4f54 | System Id string 0 |
| | | | | | |
| 0x204 | [31:0] | sys\_info\_0\_1[31:0] | RO | 0x20202020 | System Id string 1 |
| | | | | | |
| 0x208 | [31:0] | sys\_info\_0\_2[31:0] | RO | 0x20202020 | System Id string 2 |
| | | | | | |
| 0x20c | [31:0] | sys\_info\_0\_3[31:0] | RO | 0x20202020 | System Id string 3 |
| | | | | | |
| 0x210 | [31:0] | sys\_info\_0\_4[31:0] | RO | 0x20202020 | System Id string 4 |
| | | | | | |
| 0x214 | [31:0] | sys\_info\_0\_5[31:0] | RO | 0x20202020 | System Id string 5 |
| | | | | | |
| 0x218 | [31:0] | sys\_info\_0\_6[31:0] | RO | 0x20202020 | System Id string 6 |
| | | | | | |
| 0x21c | [31:0] | sys\_info\_0\_7[31:0] | RO | 0x20202020 | System Id string 7 |
| | | | | | |
| 0x300 | [31:0] | sys\_info\_1\_0[31:0] | RO | 0x32303139 | Build Id string 0 |
| | | | | | |
| 0x304 | [31:0] | sys\_info\_1\_1[31:0] | RO | 0x30393139 | Build Id string 1 |
| | | | | | |
| 0x308 | [31:0] | sys\_info\_1\_2[31:0] | RO | 0x31363231 | Build Id string 2 |
| | | | | | |
| 0x30c | [31:0] | sys\_info\_1\_3[31:0] | RO | 0x20202020 | Build Id string 3 |
| | | | | | |
| 0x310 | [31:0] | sys\_info\_1\_4[31:0] | RO | 0x20202020 | Build Id string 4 |
| | | | | | |
| 0x314 | [31:0] | sys\_info\_1\_5[31:0] | RO | 0x20202020 | Build Id string 5 |
| | | | | | |
| 0x318 | [31:0] | sys\_info\_1\_6[31:0] | RO | 0x20202020 | Build Id string 6 |
| | | | | | |
| 0x31c | [31:0] | sys\_info\_1\_7[31:0] | RO | 0x20202020 | Build Id string 7 |
| | | | | | |
| 0x400 | [31:0] | pwm\_prescale\_count[31:0] | RW | 0x186a0 | PWM prescale, base is 10ns |
| | | | | | |
| 0x404 | [7:0] | pwm\_enable[7:0] | RW | 0xff | PWM enable, hardware mode. |
| | | | | | |
| 0x408 | [7:0] | pwm\_out[7:0] | RW | 0x0 | PWM output, software mode. |
| | | | | | |
| 0x410 | [15:0] | pwm\_delay\_count\_0[15:0] | RW | 0x0 | PWM delay count. |
| | | | | | |
| 0x414 | [15:0] | pwm\_high\_count\_0[15:0] | RW | 0x64 | PWM high count. |
| | | | | | |
| 0x418 | [15:0] | pwm\_low\_count\_0[15:0] | RW | 0x2bc | PWM low count. |
| | | | | | |
| 0x420 | [15:0] | pwm\_delay\_count\_1[15:0] | RW | 0x64 | PWM delay count. |
| | | | | | |
| 0x424 | [15:0] | pwm\_high\_count\_1[15:0] | RW | 0x64 | PWM high count. |
| | | | | | |
| 0x428 | [15:0] | pwm\_low\_count\_1[15:0] | RW | 0x2bc | PWM low count. |
| | | | | | |
| 0x430 | [15:0] | pwm\_delay\_count\_2[15:0] | RW | 0xc8 | PWM delay count. |
| | | | | | |
| 0x434 | [15:0] | pwm\_high\_count\_2[15:0] | RW | 0x64 | PWM high count. |
| | | | | | |
| 0x438 | [15:0] | pwm\_low\_count\_2[15:0] | RW | 0x2bc | PWM low count. |
| | | | | | |
| 0x440 | [15:0] | pwm\_delay\_count\_3[15:0] | RW | 0x12c | PWM delay count. |
| | | | | | |
| 0x444 | [15:0] | pwm\_high\_count\_3[15:0] | RW | 0x64 | PWM high count. |
| | | | | | |
| 0x448 | [15:0] | pwm\_low\_count\_3[15:0] | RW | 0x2bc | PWM low count. |
| | | | | | |
| 0x450 | [15:0] | pwm\_delay\_count\_4[15:0] | RW | 0x190 | PWM delay count. |
| | | | | | |
| 0x454 | [15:0] | pwm\_high\_count\_4[15:0] | RW | 0x64 | PWM high count. |
| | | | | | |
| 0x458 | [15:0] | pwm\_low\_count\_4[15:0] | RW | 0x2bc | PWM low count. |
| | | | | | |
| 0x460 | [15:0] | pwm\_delay\_count\_5[15:0] | RW | 0x1f4 | PWM delay count. |
| | | | | | |
| 0x464 | [15:0] | pwm\_high\_count\_5[15:0] | RW | 0x64 | PWM high count. |
| | | | | | |
| 0x468 | [15:0] | pwm\_low\_count\_5[15:0] | RW | 0x2bc | PWM low count. |
| | | | | | |
| 0x470 | [15:0] | pwm\_delay\_count\_6[15:0] | RW | 0x258 | PWM delay count. |
| | | | | | |
| 0x474 | [15:0] | pwm\_high\_count\_6[15:0] | RW | 0x64 | PWM high count. |
| | | | | | |
| 0x478 | [15:0] | pwm\_low\_count\_6[15:0] | RW | 0x2bc | PWM low count. |
| | | | | | |
| 0x480 | [15:0] | pwm\_delay\_count\_7[15:0] | RW | 0x2bc | PWM delay count. |
| | | | | | |
| 0x484 | [15:0] | pwm\_high\_count\_7[15:0] | RW | 0x64 | PWM high count. |
| | | | | | |
| 0x488 | [15:0] | pwm\_low\_count\_7[15:0] | RW | 0x2bc | PWM low count. |
| | | | | | |
| 0x500 | [0:0] | sys\_intr\_status | RO | 0x0 | Interrupt status, simplified tree (no mask or clear). |
| | | | | | |
| 0x510 | [31:0] | sys\_intr\_0\_status[31:0] | RO | 0x0 | Interrupts 0 status. |
| | | | | | |
| 0x514 | [31:0] | sys\_intr\_0\_enable[31:0] | RW | 0x0 | Interrupts 0 enable, traditionally mask, to avoid ambiguity, renamed to enable, if set interrupt is enabled. |
| | | | | | |
| 0x600 | [31:0] | mem\_id[31:0] | RO | 0x0 | Memory identifier, system specific. |
| | | | | | |
| 0x604 | [11:0] | mem\_pg[11:0] | RO | 0x0 | Memory current page, system specific. |
| | | | | | |
| 0x608 | [11:0] | mem\_pg\_sel[11:0] | RW | 0x0 | Memory page select, system specific. |
| | | | | | |
---
