## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Description:       DMA Xilinx Cores
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################

source ../../../bin/vivado_include.tcl

pkg_interface rxs_io
add_interface_ports rsenb out 1
add_interface_ports rstrig out 1
add_interface_ports rsdsync out 1
add_interface_ports rsvld out 1
add_interface_ports rsd out -1
ipx::save_abstraction_definition [ipx::current_busabs]
ipx::save_bus_definition [ipx::current_busdef]

create_project axi_rxdma . -part xc7z045ffg900-2 -force
msg_settings none
set_property ip_repo_paths . [current_fileset]
update_ip_catalog

set ip_source_list {}
lappend ip_source_list ../../common/hdl/cdc.v
lappend ip_source_list ../../common/hdl/cdc_constr.xdc
lappend ip_source_list ../../common/hdl/cdc_resetp.v
lappend ip_source_list ../../common/hdl/cdc_resetp_constr.xdc
lappend ip_source_list ../../common/hdl/cdc_cntrl.v
lappend ip_source_list ../../common/hdl/cdc_cntrl_constr.xdc
lappend ip_source_list ../../common/hdl/cdc_event.v
lappend ip_source_list ../../common/hdl/cdc_event_constr.xdc
lappend ip_source_list ../../common/hdl/clk_mon.v
lappend ip_source_list ../../common/hdl/clk_mon_constr.xdc
lappend ip_source_list ../../common/hdl/mem_sdp.v
lappend ip_source_list ../../common/hdl/mem_zrd.v
lappend ip_source_list ../../common/hdl/mem_fifo.v
lappend ip_source_list ../../common/hdl/mem_zdfifo.v
lappend ip_source_list ../../common/hdl/upsize.v
lappend ip_source_list ../../common/hdl/axilite_slave_if.v
lappend ip_source_list ../../axi_dma/hdl/axi_dma_top_regs.v
lappend ip_source_list axi_rxdma_core.v
lappend ip_source_list axi_rxdma.v
set ip_file_list $ip_source_list
add_files -norecurse -fileset [get_filesets sources_1] $ip_file_list
set_property source_set sources_1 [get_filesets sim_1]
set_property top axi_rxdma [get_filesets sources_1]
set_property top axi_rxdma [get_filesets sim_1]

pkg_ip_core axi_rxdma
add_ip_files $ip_file_list synthesis
add_ip_files $ip_file_list simulation
ipx::save_core

set ip_file_set [ipx::get_file_groups -filter {name =~ *synthesis*}]
set_property SCOPED_TO_REF cdc_event [ipx::get_files *cdc_event_constr.xdc -of_objects $ip_file_set]
set_property SCOPED_TO_REF cdc_resetp [ipx::get_files *cdc_resetp_constr.xdc -of_objects $ip_file_set]
set_property SCOPED_TO_REF cdc_cntrl [ipx::get_files *cdc_cntrl_constr.xdc -of_objects $ip_file_set]
set_property SCOPED_TO_REF cdc [ipx::get_files *cdc_constr.xdc -of_objects $ip_file_set]
set_property SCOPED_TO_REF clk_mon [ipx::get_files *clk_mon_constr.xdc -of_objects $ip_file_set]
ipx::save_core

## ##################################################################################
## ##################################################################################

set ip_file_list {}
lappend ip_file_list axi_datamover
add_ip_cores $ip_file_list synthesis
add_ip_cores $ip_file_list simulation
ipx::save_core

## ##################################################################################
## ##################################################################################

