// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Description:       Receive DMA Core
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module axi_rxdma #(

    parameter integer INSTANCE_ID = 0,
    parameter integer RSD_DW = 64,
    parameter integer AXIS_DW = 64,
    parameter integer AXIMM_SF = 1,
    parameter integer AXIMM_DW = 512,
    parameter integer AXIMM_SW = 64) (

    // ssi interface

    input   wire                            rx_clk,
    input   wire                            rx_resetn,
    input   wire                            rx_rsenb,
    input   wire                            rx_rstrig,
    input   wire                            rx_rsdsync,
    input   wire                            rx_rsvld,
    input   wire  [(RSD_DW-1):0]            rx_rsd,

    // asynchronous events

    input   wire  [  3:0]                   trig,
    output  wire                            rx_mtrig_out,
    input   wire                            rx_mtrig_in,

    // axi master interface

    input   wire                            aximm_clk,
    input   wire                            aximm_resetn,
    output  wire                            aximm_intc_cntrl,
    output  wire  [ 39:0]                   aximm_awaddr,
    output  wire  [  7:0]                   aximm_awlen,
    output  wire  [  2:0]                   aximm_awsize,
    output  wire  [  1:0]                   aximm_awburst,
    output  wire  [  2:0]                   aximm_awprot,
    output  wire  [  3:0]                   aximm_awcache,
    output  wire                            aximm_awvalid,
    input   wire                            aximm_awready,
    output  wire  [(AXIMM_DW-1):0]          aximm_wdata,
    output  wire  [(AXIMM_SW-1):0]          aximm_wstrb,
    output  wire                            aximm_wlast,
    output  wire                            aximm_wvalid,
    input   wire                            aximm_wready,
    input   wire  [  1:0]                   aximm_bresp,
    input   wire                            aximm_bvalid,
    output  wire                            aximm_bready,

    // axilite interface

    input   wire                            axilite_clk,
    input   wire                            axilite_resetn,
    input   wire                            axilite_awvalid,
    input   wire  [ 15:0]                   axilite_awaddr,
    output  wire                            axilite_awready,
    input   wire                            axilite_wvalid,
    input   wire  [ 31:0]                   axilite_wdata,
    output  wire                            axilite_wready,
    output  wire                            axilite_bvalid,
    output  wire  [  1:0]                   axilite_bresp,
    input   wire                            axilite_bready,
    input   wire                            axilite_arvalid,
    input   wire  [ 15:0]                   axilite_araddr,
    output  wire                            axilite_arready,
    output  wire                            axilite_rvalid,
    output  wire  [  1:0]                   axilite_rresp,
    output  wire  [ 31:0]                   axilite_rdata,
    input   wire                            axilite_rready,
    output  wire                            axilite_intr);

    // internal signals

    wire                                    axilite_wrreq;
    wire          [ 15:0]                   axilite_wraddr;
    wire          [ 31:0]                   axilite_wrdata;
    wire                                    axilite_wrack;
    wire                                    axilite_rdreq;
    wire          [ 15:0]                   axilite_rdaddr;
    wire          [ 31:0]                   axilite_rddata;
    wire                                    axilite_rdack;

    // instantiations

    axi_rxdma_core #(
        .MODULE_ID                          (0),
        .INSTANCE_ID                        (INSTANCE_ID),
        .RSD_DW                             (RSD_DW),
        .AXIS_DW                            (AXIS_DW),
        .AXIMM_SF                           (AXIMM_SF),
        .AXIMM_DW                           (AXIMM_DW),
        .AXIMM_SW                           (AXIMM_SW))
    i_core_if (
        .rx_clk                             (rx_clk),
        .rx_resetn                          (rx_resetn),
        .rx_rsenb                           (rx_rsenb),
        .rx_rstrig                          (rx_rstrig),
        .rx_rsdsync                         (rx_rsdsync),
        .rx_rsvld                           (rx_rsvld),
        .rx_rsd                             (rx_rsd),
        .trig                               (trig),
        .rx_mtrig_out                       (rx_mtrig_out),
        .rx_mtrig_in                        (rx_mtrig_in),
        .aximm_clk                          (aximm_clk),
        .aximm_resetn                       (aximm_resetn),
        .aximm_intc_cntrl                   (aximm_intc_cntrl),
        .aximm_awaddr                       (aximm_awaddr),
        .aximm_awlen                        (aximm_awlen),
        .aximm_awsize                       (aximm_awsize),
        .aximm_awburst                      (aximm_awburst),
        .aximm_awprot                       (aximm_awprot),
        .aximm_awcache                      (aximm_awcache),
        .aximm_awvalid                      (aximm_awvalid),
        .aximm_awready                      (aximm_awready),
        .aximm_wdata                        (aximm_wdata),
        .aximm_wstrb                        (aximm_wstrb),
        .aximm_wlast                        (aximm_wlast),
        .aximm_wvalid                       (aximm_wvalid),
        .aximm_wready                       (aximm_wready),
        .aximm_bresp                        (aximm_bresp),
        .aximm_bvalid                       (aximm_bvalid),
        .aximm_bready                       (aximm_bready),
        .axilite_clk                        (axilite_clk),
        .axilite_resetn                     (axilite_resetn),
        .axilite_wrreq                      (axilite_wrreq),
        .axilite_wraddr                     (axilite_wraddr),
        .axilite_wrdata                     (axilite_wrdata),
        .axilite_wrack                      (axilite_wrack),
        .axilite_rdreq                      (axilite_rdreq),
        .axilite_rdaddr                     (axilite_rdaddr),
        .axilite_rddata                     (axilite_rddata),
        .axilite_rdack                      (axilite_rdack),
        .axilite_intr                       (axilite_intr));

    axilite_slave_if #(
        .AXI_ADDRESS_WIDTH                  (16))
    i_axilite_if (
        .axilite_clk                        (axilite_clk),
        .axilite_resetn                     (axilite_resetn),
        .axilite_awvalid                    (axilite_awvalid),
        .axilite_awaddr                     (axilite_awaddr),
        .axilite_awready                    (axilite_awready),
        .axilite_wvalid                     (axilite_wvalid),
        .axilite_wdata                      (axilite_wdata),
        .axilite_wready                     (axilite_wready),
        .axilite_bvalid                     (axilite_bvalid),
        .axilite_bresp                      (axilite_bresp),
        .axilite_bready                     (axilite_bready),
        .axilite_arvalid                    (axilite_arvalid),
        .axilite_araddr                     (axilite_araddr),
        .axilite_arready                    (axilite_arready),
        .axilite_rvalid                     (axilite_rvalid),
        .axilite_rresp                      (axilite_rresp),
        .axilite_rdata                      (axilite_rdata),
        .axilite_rready                     (axilite_rready),
        .axilite_wrreq                      (axilite_wrreq),
        .axilite_wraddr                     (axilite_wraddr),
        .axilite_wrdata                     (axilite_wrdata),
        .axilite_wrack                      (axilite_wrack),
        .axilite_rdreq                      (axilite_rdreq),
        .axilite_rdaddr                     (axilite_rdaddr),
        .axilite_rddata                     (axilite_rddata),
        .axilite_rdack                      (axilite_rdack));

endmodule

// **********************************************************************************
// **********************************************************************************
