# AXI Receive DMA

## Contents

* [Introduction](#introduction)
* [Functional Description](#functional-description)
* [Parameters](#parameters)
* [Ports](#ports)
* [Register Map](#register-map)

## <a name="introduction"></a>Introduction

The AXI receive DMA transfers samples to the AXI memory slave (usually DDR).

## <a name="functional-description"></a>Functional Description

This is an AXI memory mapped core (write only). At the device side, it has an AXI stream interface. There is no back pressure, the AXIMM interface must be capable of meeting the bandwidth requirements of the interface core. If not, an overflow and underflow is the certain result.

Since DMA is a well known concept, this document highlights only the control flow around the data transfer. In its default configuration, samples are transferred as received as soon as the start bit (see register description) is set. The exception to this, as outlined below, makes the core more interesting. In literacy terms, it adds valleys and peaks to an otherwise barren desert land.

### Trigger souces ###

The trigger sources, if enabled, control when a DMA starts transferring samples.

There are four common trigger ports in DMA (this depends on the project, see the corresponding documentation for details). These trigger ports can be individually setup to start the transfer at the rising edge, falling edge or either edge. They can also be masked individually to generate a multiple trigger controlled capture.

Since software is asynchronous in nature, in default configuration, the DMA starts immediately when the start bit is set. There may be scenarios where this is not desired.

If there are multiple DMA cores that need to start at the same time, each DMA can be configured to use one of the trigger sources, common to all cores as the trigger event. The trigger allows DMA to start capture at a specified time.

### TDD Trigger souce ###

The DMA also supports a dedicated TDD trigger source, though its function is the same as the other trigger signals, this is special because it is dedicated and is generated by TDD. This allows a programmable capture delay between two DMA cores, but still synchronous to each other.

### Synchronous Enable ###

The trigger sources mentioned above controls how the DMA starts capture and subsequent captures follow the assertion of the valid signal at the interface. This can be controlled with a synchronous enable option, if set, this allows DMA to align capture with the enable signal. In order to understand this better, let's see how DMA transfers samples under the following scenario.

Let's assume that the enable is a periodic signal, asserted high for 25 samples and DMA is set to handle (transmit or receive) 32 samples. Here is a scenario that illustrates the behavior in possible combinations.

![AXI\_DMA Synchronization Controls](docs/axi_dma_sync.png)

Software set the start bit in the middle of an enable asserted high (at T1 in the above picture).

* If start-sync = 0, cyclic-sync = 0, dma transfers samples immediately.
* If start-sync = 1, cyclic-sync = 0, dma waits for the start of the enable signal.
* If start-sync = 1, cyclic-sync = 1, dma waits for the start of the enable signal.

If the current dma cycle finishes within an enable window (at T2 in the above picture).

* If start-sync = 0, cyclic-sync = 0, dma continously transferring samples.
* If start-sync = 1, cyclic-sync = 0, dma continously transferring samples.
* If start-sync = 1, cyclic-sync = 1, dma pauses, finish the current window and waits for the start of the enable signal.

In otherwords, the synchronization is around the enable signal as to when a transfer starts and when the transfer repeats. In either direction, samples shown above are either read from a buffer and transmitted or received and written into a buffer.

### Master Trigger Enable ###

In a multi-core environment, the DMA cores are primarily independent even with the common trigger sources. That is, a signal may still have a clock uncertainity between cores due to their asynchronous nature. If this uncertainity is not acceptable, one must setup the DMA in a master slave configuration, and a master trigger is used by all cores to achieve synchronization.

## <a name="parameters"></a>Parameters

---
| Parameter         | Type    | Default | Description |
| ----------------- | ------- | ------- | ----------- |
| INSTANCE\_ID      | Integer | 0       | The instance ID of this core. |
| AXIS\_DATA\_WIDTH | Integer | 32      | The AXIS data width 32 or 8 only. |
|||||
---

## <a name="ports"></a>Ports

---
| Port                  | Direction/Size           | Description |
| --------------------- | ------------------------ | ----------- |
| rx\_clk               | Input                    | Receive clock. |
| rx\_resetn            | Input                    | Receive reset (active low). |
| rx\_senb              | Input                    | Receive data enable. |
| rx\_strig             | Input                    | Receive TDD trigger source. |
| rx\_svld              | Input                    | Receive data valid. |
| rx\_sd                | Input[AXIS\_DATA\_WIDTH] | Receive data. |
| trig                  | Input[4]                 | Trigger sources, for data transfer. |
| rx\_mtrig\_out        | Output                   | Master trigger output. |
| rx\_mtrig\_in         | Input                    | Master trigger input. |
| aximm\_clk            | Input                    | MM interface clock. |
| aximm\_resetn         | Input                    | MM interface reset (active low). |
| aximm\_awaddr         | Output[40]               | MM write address channel, address. |
| aximm\_awlen          | Output[8]                | MM write address channel, length. |
| aximm\_awsize         | Output[3]                | MM write address channel, size. |
| aximm\_awburst        | Output[2]                | MM write address channel, burst. |
| aximm\_awprot         | Output[3]                | MM write address channel, protect. |
| aximm\_awcache        | Output[4]                | MM write address channel, cache. |
| aximm\_awvalid        | Output                   | MM write address channel, valid. |
| aximm\_awready        | Input                    | MM write address channel, ready. |
| aximm\_wdata          | Output[512]              | MM write channel, data. |
| aximm\_wstrb          | Output[64]               | MM write channel, strobe. |
| aximm\_wlast          | Output                   | MM write channel, last. |
| aximm\_wvalid         | Output                   | MM write channel, valid. |
| aximm\_wready         | Input                    | MM write channel, ready. |
| aximm\_bresp          | Input[2]                 | MM write response channel, data (response). |
| aximm\_bvalid         | Input                    | MM write response channel, valid. |
| aximm\_bready         | Output                   | MM write response channel, ready. |
| axilite\_clk          | Input                    | Processor clock. |
| axilite\_resetn       | Input                    | Processor reset (active low). |
| axilite\_awvalid      | Input                    | Write address channel, valid. |
| axilite\_awaddr       | Input[16]                | Write address channel, address. |
| axilite\_awready      | Output                   | Write address channel, ready. |
| axilite\_wvalid       | Input                    | Write channel, valid. |
| axilite\_wdata        | Input[32]                | Write channel, data. | 
| axilite\_wready       | Output                   | Write channel, ready. |
| axilite\_bvalid       | Output                   | Write response channel, valid. |
| axilite\_bresp        | Output[2]                | Write response channel, data (response). |
| axilite\_bready       | Input                    | Write response channel, ready. |
| axilite\_arvalid      | Input                    | Read address channel, valid. |
| axilite\_araddr       | Input[16]                | Read address channel, address. |
| axilite\_arready      | Output                   | Read address channel, ready. |
| axilite\_rvalid       | Output                   | Read data channel, valid. |
| axilite\_rresp        | Output[2]                | Read data channel, response. |
| axilite\_rdata        | Output[32]               | Read data channel, data. |
| axilite\_rready       | Input                    | Read data channel, ready. |
| interrupt             | Output                   | Processor interrupt (active high). |
||||
---

## <a name="register-map"></a>Register Map

### [Register Map](hdl/axi_rxdma_regs.md)
