## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Description:       DMA Xilinx Cores
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################

source ../../../bin/vivado_include.tcl

create_project axi_mspi . -part xc7z045ffg900-2 -force
msg_settings none
set_property ip_repo_paths {../..} [current_fileset]
update_ip_catalog

set ip_core_list {}
lappend ip_core_list ../../../library/axi_rxdma
lappend ip_core_list ../../../library/axi_txdma

set ip_source_list {}
lappend ip_source_list ../../../library/common/hdl/axilite_slave_if.v
lappend ip_source_list ../../../library/common/hdl/mem_fifo.v
lappend ip_source_list ../../../library/common/hdl/mem_sdp.v
lappend ip_source_list ../../../library/common/hdl/cdc.v
lappend ip_source_list ../../../library/common/hdl/cdc_constr.xdc
lappend ip_source_list ../../../library/common/hdl/cdc_cntrl.v
lappend ip_source_list ../../../library/common/hdl/cdc_cntrl_constr.xdc
lappend ip_source_list ../../../library/common/hdl/cdc_resetp.v
lappend ip_source_list ../../../library/common/hdl/cdc_resetp_constr.xdc
lappend ip_source_list axi_mspi_constr.xdc
lappend ip_source_list axi_mspi_top_regs.v
lappend ip_source_list axi_mspi.v
set ip_file_list $ip_source_list
add_files -norecurse -fileset [get_filesets sources_1] $ip_file_list
set_property source_set sources_1 [get_filesets sim_1]
set_property top axi_mspi [get_filesets sources_1]
set_property top axi_mspi [get_filesets sim_1]

pkg_ip_core axi_mspi
add_ip_files $ip_file_list synthesis
add_ip_files $ip_file_list simulation
ipx::save_core

set ip_file_set [ipx::get_file_groups -filter {NAME =~ *synthesis*}]
set_property SCOPED_TO_REF axi_mspi [ipx::get_files *axi_mspi_constr.xdc -of_objects $ip_file_set]
set_property SCOPED_TO_REF cdc_resetp [ipx::get_files *cdc_resetp_constr.xdc -of_objects $ip_file_set]
set_property SCOPED_TO_REF cdc_cntrl [ipx::get_files *cdc_cntrl_constr.xdc -of_objects $ip_file_set]
set_property SCOPED_TO_REF cdc [ipx::get_files *cdc_constr.xdc -of_objects $ip_file_set]
ipx::save_core

ipx::associate_bus_interfaces -clock spi_clk -reset spi_mosi_resetn [ipx::current_core]
ipx::associate_bus_interfaces -clock spi_clk -reset spi_miso_resetn [ipx::current_core]
ipx::save_core

set_property driver_value 0 [ipx::get_ports *spi_mosi_tsvld* -of_objects [ipx::current_core]]
set_property driver_value 0 [ipx::get_ports *spi_mosi_tsav* -of_objects [ipx::current_core]]
set_property driver_value 0 [ipx::get_ports *spi_mosi_tsd* -of_objects [ipx::current_core]]
set_property driver_value 0 [ipx::get_ports *spi_trig* -of_objects [ipx::current_core]]
ipx::save_core

## ##################################################################################
## ##################################################################################
