// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Description:       Auto generated, local modifications are discouraged.
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module axi_mspi_top_regs (

    input   wire  [31:0]    axilite_version,
    input   wire  [31:0]    axilite_instance_id,
    output  reg   [31:0]    axilite_scratch = 'd0,
    output  reg   [31:0]    axilite_timer = 'd0,
    output  reg   [ 7:0]    axilite_slave_select_n = 'd0,
    output  reg             axilite_enable = 'd0,
    output  reg             axilite_auto = 'd0,
    input   wire            axilite_busy,
    output  reg   [19:0]    axilite_num_of_bytes = 'd0,
    output  reg   [19:0]    axilite_num_of_frames = 'd0,
    output  reg   [15:0]    axilite_sclk_period = 'd0,
    output  reg             axilite_sclk_init = 'd0,
    output  reg             axilite_mosi_bidir_mode = 'd0,
    output  reg   [ 3:0]    axilite_mosi_bidir_offset = 'd0,
    output  reg             axilite_miso_fall1_rise0 = 'd0,
    output  reg   [ 7:0]    axilite_miso_select = 'd0,
    output  reg             axilite_miso_enable = 'd0,
    output  reg   [ 1:0]    axilite_trigger_mode_0 = 'd0,
    output  reg   [ 1:0]    axilite_trigger_mode_1 = 'd0,
    output  reg   [ 1:0]    axilite_trigger_mode_2 = 'd0,
    output  reg   [ 1:0]    axilite_trigger_mode_3 = 'd0,
    output  reg   [ 1:0]    axilite_trigger_mode_4 = 'd0,
    output  reg             axilite_dma1_fifo0 = 'd0,
    output  reg             axilite_swreset = 'd0,
    input   wire            axilite_swreset_clr,
    output  reg             axilite_mosi_data_wr = 'd0,
    output  reg   [ 7:0]    axilite_mosi_data_data = 'd0,
    output  reg             axilite_miso_data_rd = 'd0,
    input   wire  [ 7:0]    axilite_miso_data_data,
    input   wire            axilite_mosi_full,
    input   wire            axilite_mosi_empty,
    input   wire            axilite_miso_full,
    input   wire            axilite_miso_empty,
    input   wire  [22:0]    axilite_byte_count,
    input   wire            axilite_ssn_state,
    input   wire  [31:0]    axilite_ssn_sclk_count,
    input   wire            axilite_dma_status,
    output  reg             axilite_intr_mosi_full_enable = 'd0,
    output  reg             axilite_intr_mosi_empty_enable = 'd0,
    output  reg             axilite_intr_miso_full_enable = 'd0,
    output  reg             axilite_intr_miso_empty_enable = 'd0,
    output  reg             axilite_intr_dma_done_enable = 'd0,
    output  reg             axilite_intr_xfer_done_enable = 'd0,
    output  reg   [ 7:0]    axilite_ssn_disable = 'd0,
    output  reg   [ 7:0]    axilite_sclk_disable = 'd0,
    output  reg   [ 7:0]    axilite_mosi_disable = 'd0,

    input   wire            axilite_clk,
    input   wire            axilite_resetn,
    input   wire            axilite_wrreq,
    input   wire  [11:0]    axilite_wraddr,
    input   wire  [31:0]    axilite_wrdata,
    output  reg             axilite_wrack = 'd0,
    input   wire            axilite_rdreq,
    input   wire  [11:0]    axilite_rdaddr,
    output  reg   [31:0]    axilite_rddata = 'd0,
    output  reg             axilite_rdack = 'd0);

    reg                     axilite_swreset_clr_d = 'd0;

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_wrack <= 'd0;
            axilite_rdack <= 'd0;
        end else begin
            axilite_wrack <= axilite_wrreq;
            axilite_rdack <= axilite_rdreq;
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_scratch <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h8)) begin
                axilite_scratch <= axilite_wrdata;
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_timer <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'hc)) begin
                axilite_timer <= axilite_wrdata;
            end else if (axilite_timer > 0) begin
                axilite_timer <= axilite_timer - 1'b1;
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_slave_select_n <= 'hff;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h10)) begin
                axilite_slave_select_n <= axilite_wrdata[7:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_enable <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h20)) begin
                axilite_enable <= axilite_wrdata[0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_auto <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h20)) begin
                axilite_auto <= axilite_wrdata[1];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_num_of_bytes <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h30)) begin
                axilite_num_of_bytes <= axilite_wrdata[19:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_num_of_frames <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h34)) begin
                axilite_num_of_frames <= axilite_wrdata[19:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_sclk_period <= 'h1;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h40)) begin
                axilite_sclk_period <= axilite_wrdata[15:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_sclk_init <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h50)) begin
                axilite_sclk_init <= axilite_wrdata[0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_mosi_bidir_mode <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h60)) begin
                axilite_mosi_bidir_mode <= axilite_wrdata[0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_mosi_bidir_offset <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h64)) begin
                axilite_mosi_bidir_offset <= axilite_wrdata[3:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_miso_fall1_rise0 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h70)) begin
                axilite_miso_fall1_rise0 <= axilite_wrdata[0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_miso_select <= 'h1;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h74)) begin
                axilite_miso_select <= axilite_wrdata[7:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_miso_enable <= 'h1;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h78)) begin
                axilite_miso_enable <= axilite_wrdata[0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_trigger_mode_0 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h80)) begin
                axilite_trigger_mode_0 <= axilite_wrdata[1:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_trigger_mode_1 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h80)) begin
                axilite_trigger_mode_1 <= axilite_wrdata[3:2];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_trigger_mode_2 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h80)) begin
                axilite_trigger_mode_2 <= axilite_wrdata[5:4];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_trigger_mode_3 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h80)) begin
                axilite_trigger_mode_3 <= axilite_wrdata[7:6];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_trigger_mode_4 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h80)) begin
                axilite_trigger_mode_4 <= axilite_wrdata[9:8];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_dma1_fifo0 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h90)) begin
                axilite_dma1_fifo0 <= axilite_wrdata[0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_swreset_clr_d <= 'd0;
            axilite_swreset <= 'h0;
        end else begin
            axilite_swreset_clr_d <= axilite_swreset_clr;
            if ((axilite_swreset_clr_d == 1'b0) && (axilite_swreset_clr == 1'b1)) begin
                axilite_swreset <= 1'b0;
            end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'ha0)) begin
                axilite_swreset <= axilite_swreset | axilite_wrdata[0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_mosi_data_wr <= 'd0;
            axilite_mosi_data_data <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h100)) begin
                axilite_mosi_data_wr <= 1'd1;
                axilite_mosi_data_data <= axilite_wrdata[7:0];
            end else begin
                axilite_mosi_data_wr <= 1'd0;
                axilite_mosi_data_data <= axilite_mosi_data_data;
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_miso_data_rd <= 'd0;
        end else begin
            if ((axilite_rdreq == 1'b1) && (axilite_rdaddr[11:0] == 'h104)) begin
                axilite_miso_data_rd <= 1'd1;
            end else begin
                axilite_miso_data_rd <= 1'd0;
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_intr_mosi_full_enable <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h204)) begin
                axilite_intr_mosi_full_enable <= axilite_wrdata[0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_intr_mosi_empty_enable <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h204)) begin
                axilite_intr_mosi_empty_enable <= axilite_wrdata[1];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_intr_miso_full_enable <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h204)) begin
                axilite_intr_miso_full_enable <= axilite_wrdata[2];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_intr_miso_empty_enable <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h204)) begin
                axilite_intr_miso_empty_enable <= axilite_wrdata[3];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_intr_dma_done_enable <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h204)) begin
                axilite_intr_dma_done_enable <= axilite_wrdata[4];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_intr_xfer_done_enable <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h204)) begin
                axilite_intr_xfer_done_enable <= axilite_wrdata[5];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_ssn_disable <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h280)) begin
                axilite_ssn_disable <= axilite_wrdata[7:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_sclk_disable <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h284)) begin
                axilite_sclk_disable <= axilite_wrdata[7:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_mosi_disable <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h288)) begin
                axilite_mosi_disable <= axilite_wrdata[7:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_rddata <= 'd0;
        end else begin
            if (axilite_rdreq == 1'b1) begin
                case (axilite_rdaddr[11:0])
                    'h0: begin
                        axilite_rddata <= axilite_version;
                    end
                    'h4: begin
                        axilite_rddata <= axilite_instance_id;
                    end
                    'h8: begin
                        axilite_rddata <= axilite_scratch;
                    end
                    'hc: begin
                        axilite_rddata <= axilite_timer;
                    end
                    'h10: begin
                        axilite_rddata[7:0] <= axilite_slave_select_n;
                        axilite_rddata[31:8] <= 'd0;
                    end
                    'h20: begin
                        axilite_rddata[0] <= axilite_enable;
                        axilite_rddata[1] <= axilite_auto;
                        axilite_rddata[31:2] <= 'd0;
                    end
                    'h24: begin
                        axilite_rddata[0] <= axilite_busy;
                        axilite_rddata[31:1] <= 'd0;
                    end
                    'h30: begin
                        axilite_rddata[19:0] <= axilite_num_of_bytes;
                        axilite_rddata[31:20] <= 'd0;
                    end
                    'h34: begin
                        axilite_rddata[19:0] <= axilite_num_of_frames;
                        axilite_rddata[31:20] <= 'd0;
                    end
                    'h40: begin
                        axilite_rddata[15:0] <= axilite_sclk_period;
                        axilite_rddata[31:16] <= 'd0;
                    end
                    'h50: begin
                        axilite_rddata[0] <= axilite_sclk_init;
                        axilite_rddata[31:1] <= 'd0;
                    end
                    'h60: begin
                        axilite_rddata[0] <= axilite_mosi_bidir_mode;
                        axilite_rddata[31:1] <= 'd0;
                    end
                    'h64: begin
                        axilite_rddata[3:0] <= axilite_mosi_bidir_offset;
                        axilite_rddata[31:4] <= 'd0;
                    end
                    'h70: begin
                        axilite_rddata[0] <= axilite_miso_fall1_rise0;
                        axilite_rddata[31:1] <= 'd0;
                    end
                    'h74: begin
                        axilite_rddata[7:0] <= axilite_miso_select;
                        axilite_rddata[31:8] <= 'd0;
                    end
                    'h78: begin
                        axilite_rddata[0] <= axilite_miso_enable;
                        axilite_rddata[31:1] <= 'd0;
                    end
                    'h80: begin
                        axilite_rddata[1:0] <= axilite_trigger_mode_0;
                        axilite_rddata[3:2] <= axilite_trigger_mode_1;
                        axilite_rddata[5:4] <= axilite_trigger_mode_2;
                        axilite_rddata[7:6] <= axilite_trigger_mode_3;
                        axilite_rddata[9:8] <= axilite_trigger_mode_4;
                        axilite_rddata[31:10] <= 'd0;
                    end
                    'h90: begin
                        axilite_rddata[0] <= axilite_dma1_fifo0;
                        axilite_rddata[31:1] <= 'd0;
                    end
                    'ha0: begin
                        axilite_rddata[0] <= axilite_swreset;
                        axilite_rddata[31:1] <= 'd0;
                    end
                    'h100: begin
                        axilite_rddata[7:0] <= axilite_mosi_data_data;
                        axilite_rddata[31:8] <= 'd0;
                    end
                    'h104: begin
                        axilite_rddata[7:0] <= axilite_miso_data_data;
                        axilite_rddata[31:8] <= 'd0;
                    end
                    'h110: begin
                        axilite_rddata[0] <= axilite_mosi_full;
                        axilite_rddata[1] <= axilite_mosi_empty;
                        axilite_rddata[2] <= axilite_miso_full;
                        axilite_rddata[3] <= axilite_miso_empty;
                        axilite_rddata[31:4] <= 'd0;
                    end
                    'h114: begin
                        axilite_rddata[22:0] <= axilite_byte_count;
                        axilite_rddata[31:23] <= 'd0;
                    end
                    'h140: begin
                        axilite_rddata[0] <= axilite_ssn_state;
                        axilite_rddata[31:1] <= 'd0;
                    end
                    'h144: begin
                        axilite_rddata <= axilite_ssn_sclk_count;
                    end
                    'h148: begin
                        axilite_rddata[0] <= axilite_dma_status;
                        axilite_rddata[31:1] <= 'd0;
                    end
                    'h204: begin
                        axilite_rddata[0] <= axilite_intr_mosi_full_enable;
                        axilite_rddata[1] <= axilite_intr_mosi_empty_enable;
                        axilite_rddata[2] <= axilite_intr_miso_full_enable;
                        axilite_rddata[3] <= axilite_intr_miso_empty_enable;
                        axilite_rddata[4] <= axilite_intr_dma_done_enable;
                        axilite_rddata[5] <= axilite_intr_xfer_done_enable;
                        axilite_rddata[31:6] <= 'd0;
                    end
                    'h280: begin
                        axilite_rddata[7:0] <= axilite_ssn_disable;
                        axilite_rddata[31:8] <= 'd0;
                    end
                    'h284: begin
                        axilite_rddata[7:0] <= axilite_sclk_disable;
                        axilite_rddata[31:8] <= 'd0;
                    end
                    'h288: begin
                        axilite_rddata[7:0] <= axilite_mosi_disable;
                        axilite_rddata[31:8] <= 'd0;
                    end
                    default: begin
                        axilite_rddata <= 32'd0;
                    end
                endcase
            end else begin
                axilite_rddata <= 32'd0;
            end
        end
    end

endmodule

// **********************************************************************************
// **********************************************************************************
