#!/usr/bin/perl
## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Description:       SPI Master registers
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################

use autodie;
require 'dooku.pl';

$addr_width = 12;
$addr_width_used = 12;

$no_of_instances = 1;
$instance_base_addr = 0x0;
$instance_offset_addr = 0x0;

setdooku(@ARGV);
module(0x0, 'axi_mspi_top');

register(0x000, 'REG_VERSION');
field(0, 32, RO, 0x00060000, 'VERSION', 'This is the current
    version of this IP core.');

register(0x004, 'REG_INSTANCE_ID');
field(0, 32, RO, 0x0, 'INSTANCE_ID', 'These bits Indicate the instance ID,
    in a multiple instances system, instance id 0x0 is the master core.');

register(0x008, 'REG_SCRATCH');
field(0, 32, RW, 0x0, 'SCRATCH', 'The general purpose scratch register');

register(0x00c, 'REG_TIMER');
field(0, 32, RW, 0x0, 'TIMER', 'The general purpose timer register');

register(0x010, 'REG_SLAVE_SELECT_N');
field(0, 8, RW, 0xff, 'SLAVE_SELECT_N', 'Slave select (active low).');

register(0x020, 'REG_ENABLE');
field(0, 1, RW, 0x0, 'ENABLE', 'If set to 0x1, transfer begins at the interface
    provided the mosi fifo is not empty and miso fifo is not full.');
field(1, 1, RW, 0x0, 'AUTO', 'If set to 0x1, slave select is controlled by
    hardware, in DMA mode, this must be set to 0x1.');

define('DISABLE', 0x0, 'Disabled, no transfers');
define('FIFO_ENABLE', 0x1, 'FIFO mode, using internal FIFO');
define('DMA_ENABLE', 0x3, 'DMA mode, streaming.');

register(0x024, 'REG_BUSY');
field(0, 1, RO, 0x0, 'BUSY', 'If set, indicates a spi transfer in progress,
    software must make sure this bit is 0x0 before changing slave select.');

register(0x030, 'REG_NUM_OF_BYTES');
field(0, 20, RW, 0x0, 'NUM_OF_BYTES', 'The number of bytes to transfer for each
    frame (for a single slave select transfer).');

register(0x034, 'REG_NUM_OF_FRAMES');
field(0, 20, RW, 0x0, 'NUM_OF_FRAMES', 'The number of frames to transfer for each
    transfer (optionally synchronized to the trigger sources).');

register(0x040, 'REG_SCLK_PERIOD');
field(0, 16, RW, 0x1, 'SCLK_PERIOD', 'The number of clock cycles defining the
    SCLK period, in which MOSI data is asserted, and in which MISO data is
    sampled. The period of SCLK is (50/(PERIOD+1)) MHz.');

register(0x050, 'REG_SCLK_INIT');
field(0, 1, RW, 0x0, 'SCLK_INIT', 'The init value of SCLK,
    in conventional terms, this is equivalent to clock-polarity.');

register(0x060, 'REG_MOSI_BIDIR_MODE');
field(0, 1, RW, 0x0, 'MOSI_BIDIR_MODE', 'If set indicates MOSI port is shared
    for MOSI and MISO data. The MOSI port is tri-stated after BIDIR_OFFSET
    transfers from CS assertion, at BIDIR_COUNT clock cycle.');

register(0x064, 'REG_MOSI_BIDIR_OFFSET');
field(0, 4, RW, 0x0, 'MOSI_BIDIR_OFFSET', 'If BIDIR_MODE is set, this field sets
    the number of transfers after which the MOSI data line is tri-stated
    and is sampled for MISO data.');

register(0x070, 'REG_MISO_CONTROL');
field(0, 1, RW, 0x0, 'MISO_FALL1_RISE0', 'This selects the active clock edge to
    sample MISO relative to the SPI clock, in conventional terms this is
    equivalent to clock-phase');

register(0x074, 'REG_MISO_SELECT');
field(0, 8, RW, 0x01, 'MISO_SELECT', 'Input MISO select.');

register(0x078, 'REG_MISO_ENABLE');
field(0, 1, RW, 0x01, 'MISO_ENABLE', 'Enable MISO (fast transfer mode).');

$field_base = 0;
$field_offset = 2;
$field_width = 2;
$field_type = "RW";
$field_default = 0x0;
$field_count = 5;
$field_index = 0;

register(0x080, 'REG_TRIGGERS');
for ($field_index = 0; $field_index < $field_count; $field_index++) {
    field_loop("TRIGGER_MODE_%d", "The core may optionally be controlled through
        the cores trigger inputs. There are four programmable trigger inputs, these bits
        control each one of the triggers independently. The data transfer is controlled
        as an AND function of all the trigger modes. In all modes, the duration of data
        transfer is controlled by the length.");
}

define('TRIGGER_DISABLE', 0x000, 'The source is ignored.');
define('TRIGGER_RISING_EDGE', 0x001, 'Trigger begins at the rising edge of this input');
define('TRIGGER_FALLING_EDGE', 0x002, 'Trigger begins at the falling edge of this input');
define('TRIGGER_EDGE', 0x003, 'Trigger begins at either edge of this input');

register(0x090, 'REG_DMA1_FIFO0');
field(0, 1, RW, 0x0, 'DMA1_FIFO0', 'If set, data is driven from DMA,
    this is a AXI-MM interface.');

register(0x0a0, 'REG_SWRESET');
field(0, 1, RW1HC, 0x0, 'SWRESET', 'If set, core is reset, hardware cleared.');

register(0x100, 'REG_MOSI_DATA');
field(0, 8, MW, 0x0, 'MOSI_DATA', 'The mosi data output.');

register(0x104, 'REG_MISO_DATA');
field(0, 8, MR, 0x0, 'MISO_DATA', 'The miso data input.');

register(0x110, 'REG_STATUS');
field(0, 1, RO, 0x0, 'MOSI_FULL', 'The mosi data fifo is full.');
field(1, 1, RO, 0x0, 'MOSI_EMPTY', 'The mosi data fifo is empty.');
field(2, 1, RO, 0x0, 'MISO_FULL', 'The miso data fifo is full.');
field(3, 1, RO, 0x0, 'MISO_EMPTY', 'The miso data fifo is empty.');

define('XFER_EMPTY', 0xa, 'Indicates idle state');
define('XFER_MOSI_MASK', 0x3, 'Mask for MOSI');
define('XFER_MOSI_EMPTY', 0x2, 'MOSI empty');
define('XFER_MOSI_FULL', 0x1, 'MOSI full');
define('XFER_MISO_MASK', 0xc, 'Mask for MOSI');
define('XFER_MISO_EMPTY', 0x8, 'MOSI empty');
define('XFER_MISO_FULL', 0x4, 'MOSI full');

register(0x114, 'REG_BYTE_COUNT');
field(0, 23, RO, 0x0, 'BYTE_COUNT', 'The number of bytes transferred per enable.');

register(0x140, 'REG_SSN_STATE');
field(0, 1, RO, 0x0, 'SSN_STATE', 'The current state of SSN (consolidated).');

register(0x144, 'REG_SSN_SCLK_COUNT');
field(0, 32, RO, 0x0, 'SSN_SCLK_COUNT', 'The number of sclk cycles in active slave select.');

register(0x148, 'REG_DMA_STATUS');
field(0, 1, RO, 0x0, 'DMA_STATUS', 'If set, indicates pending DMA transfers');

register(0x204, 'REG_INTR_ENABLE');
field(0, 1, RW, 0x0, 'INTR_MOSI_FULL_ENABLE', 'Interrupt enable for INTR_MOSI_FULL_ENABLE.');
field(1, 1, RW, 0x0, 'INTR_MOSI_EMPTY_ENABLE', 'Interrupt enable for INTR_MOSI_EMPTY_ENABLE.');
field(2, 1, RW, 0x0, 'INTR_MISO_FULL_ENABLE', 'Interrupt enable for INTR_MISO_FULL_ENABLE.');
field(3, 1, RW, 0x0, 'INTR_MISO_EMPTY_ENABLE', 'Interrupt enable for INTR_MISO_EMPTY_ENABLE.');
field(4, 1, RW, 0x0, 'INTR_DMA_DONE_ENABLE', 'Interrupt enable for INTR_DMA_DONE_ENABLE.');
field(5, 1, RW, 0x0, 'INTR_XFER_DONE_ENABLE', 'Interrupt enable for INTR_XFER_DONE_ENABLE.');

register(0x280, 'REG_SSN_DISABLE');
field(0, 8, RW, 0x0, 'SSN_DISABLE', 'If set, disables the corresponding SSN (tri-stated).');

register(0x284, 'REG_SCLK_DISABLE');
field(0, 8, RW, 0x0, 'SCLK_DISABLE', 'If set, disables the corresponding SCLK (tri-stated).');

register(0x288, 'REG_MOSI_DISABLE');
field(0, 8, RW, 0x0, 'MOSI_DISABLE', 'If set, disables the corresponding MOSI (tri-stated).');

endregisters();
endmodule();
generate();

## ##################################################################################
## ##################################################################################
