### AXI\_MSPI\_TOP Register Map
The addresses shown are relative to the peripheral base address.

---
| Address | Bits | Field | Type | Default | Description |
| ------- | ---- | ----- | ---- | ------- | ----------- |
| 0x0 | [31:0] | version[31:0] | RO | 0x60000 | This is the current version of this IP core. |
| | | | | | |
| 0x4 | [31:0] | instance\_id[31:0] | RO | 0x0 | These bits Indicate the instance ID, in a multiple instances system, instance id 0x0 is the master core. |
| | | | | | |
| 0x8 | [31:0] | scratch[31:0] | RW | 0x0 | The general purpose scratch register |
| | | | | | |
| 0xc | [31:0] | timer[31:0] | RW | 0x0 | The general purpose timer register |
| | | | | | |
| 0x10 | [7:0] | slave\_select\_n[7:0] | RW | 0xff | Slave select (active low). |
| | | | | | |
| 0x20 | [0:0] | enable | RW | 0x0 | If set to 0x1, transfer begins at the interface provided the mosi fifo is not empty and miso fifo is not full. |
| 0x20 | [1:1] | auto | RW | 0x0 | If set to 0x1, slave select is controlled by hardware, in DMA mode, this must be set to 0x1. |
| | | | | | |
| 0x24 | [0:0] | busy | RO | 0x0 | If set, indicates a spi transfer in progress, software must make sure this bit is 0x0 before changing slave select. |
| | | | | | |
| 0x30 | [19:0] | num\_of\_bytes[19:0] | RW | 0x0 | The number of bytes to transfer for each frame (for a single slave select transfer). |
| | | | | | |
| 0x34 | [19:0] | num\_of\_frames[19:0] | RW | 0x0 | The number of frames to transfer for each transfer (optionally synchronized to the trigger sources). |
| | | | | | |
| 0x40 | [15:0] | sclk\_period[15:0] | RW | 0x1 | The number of clock cycles defining the SCLK period, in which MOSI data is asserted, and in which MISO data is sampled. The period of SCLK is (50/(PERIOD+1)) MHz. |
| | | | | | |
| 0x50 | [0:0] | sclk\_init | RW | 0x0 | The init value of SCLK, in conventional terms, this is equivalent to clock-polarity. |
| | | | | | |
| 0x60 | [0:0] | mosi\_bidir\_mode | RW | 0x0 | If set indicates MOSI port is shared for MOSI and MISO data. The MOSI port is tri-stated after BIDIR\_OFFSET transfers from CS assertion, at BIDIR\_COUNT clock cycle. |
| | | | | | |
| 0x64 | [3:0] | mosi\_bidir\_offset[3:0] | RW | 0x0 | If BIDIR\_MODE is set, this field sets the number of transfers after which the MOSI data line is tri-stated and is sampled for MISO data. |
| | | | | | |
| 0x70 | [0:0] | miso\_fall1\_rise0 | RW | 0x0 | This selects the active clock edge to sample MISO relative to the SPI clock, in conventional terms this is equivalent to clock-phase |
| | | | | | |
| 0x74 | [7:0] | miso\_select[7:0] | RW | 0x1 | Input MISO select. |
| | | | | | |
| 0x78 | [0:0] | miso\_enable | RW | 0x1 | Enable MISO (fast transfer mode). |
| | | | | | |
| 0x80 | [1:0] | trigger\_mode\_0[1:0] | RW | 0x0 | The core may optionally be controlled through the cores trigger inputs. There are four programmable trigger inputs, these bits control each one of the triggers independently. The data transfer is controlled as an AND function of all the trigger modes. In all modes, the duration of data transfer is controlled by the length. |
| 0x80 | [3:2] | trigger\_mode\_1[1:0] | RW | 0x0 | The core may optionally be controlled through the cores trigger inputs. There are four programmable trigger inputs, these bits control each one of the triggers independently. The data transfer is controlled as an AND function of all the trigger modes. In all modes, the duration of data transfer is controlled by the length. |
| 0x80 | [5:4] | trigger\_mode\_2[1:0] | RW | 0x0 | The core may optionally be controlled through the cores trigger inputs. There are four programmable trigger inputs, these bits control each one of the triggers independently. The data transfer is controlled as an AND function of all the trigger modes. In all modes, the duration of data transfer is controlled by the length. |
| 0x80 | [7:6] | trigger\_mode\_3[1:0] | RW | 0x0 | The core may optionally be controlled through the cores trigger inputs. There are four programmable trigger inputs, these bits control each one of the triggers independently. The data transfer is controlled as an AND function of all the trigger modes. In all modes, the duration of data transfer is controlled by the length. |
| 0x80 | [9:8] | trigger\_mode\_4[1:0] | RW | 0x0 | The core may optionally be controlled through the cores trigger inputs. There are four programmable trigger inputs, these bits control each one of the triggers independently. The data transfer is controlled as an AND function of all the trigger modes. In all modes, the duration of data transfer is controlled by the length. |
| | | | | | |
| 0x90 | [0:0] | dma1\_fifo0 | RW | 0x0 | If set, data is driven from DMA, this is a AXI-MM interface. |
| | | | | | |
| 0xa0 | [0:0] | swreset | RW1HC | 0x0 | If set, core is reset, hardware cleared. |
| | | | | | |
| 0x100 | [7:0] | mosi\_data[7:0] | MW | 0x0 | The mosi data output. |
| | | | | | |
| 0x104 | [7:0] | miso\_data[7:0] | MR | 0x0 | The miso data input. |
| | | | | | |
| 0x110 | [0:0] | mosi\_full | RO | 0x0 | The mosi data fifo is full. |
| 0x110 | [1:1] | mosi\_empty | RO | 0x0 | The mosi data fifo is empty. |
| 0x110 | [2:2] | miso\_full | RO | 0x0 | The miso data fifo is full. |
| 0x110 | [3:3] | miso\_empty | RO | 0x0 | The miso data fifo is empty. |
| | | | | | |
| 0x114 | [22:0] | byte\_count[22:0] | RO | 0x0 | The number of bytes transferred per enable. |
| | | | | | |
| 0x140 | [0:0] | ssn\_state | RO | 0x0 | The current state of SSN (consolidated). |
| | | | | | |
| 0x144 | [31:0] | ssn\_sclk\_count[31:0] | RO | 0x0 | The number of sclk cycles in active slave select. |
| | | | | | |
| 0x148 | [0:0] | dma\_status | RO | 0x0 | If set, indicates pending DMA transfers |
| | | | | | |
| 0x204 | [0:0] | intr\_mosi\_full\_enable | RW | 0x0 | Interrupt enable for INTR\_MOSI\_FULL\_ENABLE. |
| 0x204 | [1:1] | intr\_mosi\_empty\_enable | RW | 0x0 | Interrupt enable for INTR\_MOSI\_EMPTY\_ENABLE. |
| 0x204 | [2:2] | intr\_miso\_full\_enable | RW | 0x0 | Interrupt enable for INTR\_MISO\_FULL\_ENABLE. |
| 0x204 | [3:3] | intr\_miso\_empty\_enable | RW | 0x0 | Interrupt enable for INTR\_MISO\_EMPTY\_ENABLE. |
| 0x204 | [4:4] | intr\_dma\_done\_enable | RW | 0x0 | Interrupt enable for INTR\_DMA\_DONE\_ENABLE. |
| 0x204 | [5:5] | intr\_xfer\_done\_enable | RW | 0x0 | Interrupt enable for INTR\_XFER\_DONE\_ENABLE. |
| | | | | | |
| 0x280 | [7:0] | ssn\_disable[7:0] | RW | 0x0 | If set, disables the corresponding SSN (tri-stated). |
| | | | | | |
| 0x284 | [7:0] | sclk\_disable[7:0] | RW | 0x0 | If set, disables the corresponding SCLK (tri-stated). |
| | | | | | |
| 0x288 | [7:0] | mosi\_disable[7:0] | RW | 0x0 | If set, disables the corresponding MOSI (tri-stated). |
| | | | | | |
---
