# AXI Master SPI

## Contents

* [Introduction](#introduction)
* [Functional Description](#functional-description)
* [Parameters](#parameters)
* [Ports](#ports)
* [Register Map](#register-map)

## <a name="introduction"></a>Introduction

The AXI SPI master core manages spi transactions to one more slave devices.

## <a name="functional-description"></a>Functional Description

The core supports two modes, FIFO (AXI-Lite) and DMA (AXI-MM), in both modes a transaction may be split across multiple slave selects. The DMA transfer requires external DMA cores. The transfer may optionally be synchronized with any one of the trigger sources. A simple block diagram is shown below.

## <a name="parameters"></a>Parameters

---
| Parameter         | Type    | Default | Description |
| ----------------- | ------- | ------- | ----------- |
| INSTANCE\_ID      | Integer | 0       | The instance ID of this core. |
| NUM\_OF\_SLAVES   | Integer | 8       | The number of slaves in the system. |
| SCLK\_WIDTH       | Integer | 1       | The number of clock lines in the system. |
|||||
---

## <a name="ports"></a>Ports

---
| Port                  | Direction/Size           | Description |
| --------------------- | ------------------------ | ----------- |
| spi\_ssn              | Output[NUM\_OF\_SLAVES]  | Slave select (active low). |
| spi\_sclk             | Output[SCLK\_WIDTH]      | Serial clock. |
| spi\_mosi             | InOut[NUM\_OF\_SLAVES]   | Master data output (or input). |
| spi\_miso             | Input[NUM\_OF\_SLAVES]   | Master data input. |
| trig                  | Input[4]                 | Trigger inputs, for data transfer. |
| spi\_trig             | Input                    | Trigger input, for data transfer. |
| axilite\_miso\_resetn | Output                   | MISO DMA, resetn (active low). |
| axilite\_miso\_senb   | Output                   | MISO DMA, data enable. |
| axilite\_miso\_strig  | Output                   | MISO DMA, data trigger. |
| axilite\_miso\_svld   | Output                   | MISO DMA, data valid. |
| axilite\_miso\_sd     | Output[8]                | MISO DMA, data. |
| axilite\_mosi\_resetn | Output                   | MOSI DMA, resetn (active low). |
| axilite\_mosi\_senb   | Output                   | MOSI DMA, data enable. |
| axilite\_mosi\_strig  | Output                   | MOSI DMA, data trigger. |
| axilite\_mosi\_srd    | Output                   | MOSI DMA, data read. |
| axilite\_mosi\_sav    | Input                    | MOSI DMA, data available. |
| axilite\_mosi\_svld   | Input                    | MOSI DMA, data valid. |
| axilite\_mosi\_sd     | Input[8]                 | MOSI DMA, data. |
| axilite\_clk          | Input                    | Processor clock. |
| axilite\_resetn       | Input                    | Processor reset (active low). |
| axilite\_awvalid      | Input                    | Write address channel, valid. |
| axilite\_awaddr       | Input[16]                | Write address channel, address. |
| axilite\_awready      | Output                   | Write address channel, ready. |
| axilite\_wvalid       | Input                    | Write channel, valid. |
| axilite\_wdata        | Input[32]                | Write channel, data. | 
| axilite\_wready       | Output                   | Write channel, ready. |
| axilite\_bvalid       | Output                   | Write response channel, valid. |
| axilite\_bresp        | Output[2]                | Write response channel, data (response). |
| axilite\_bready       | Input                    | Write response channel, ready. |
| axilite\_arvalid      | Input                    | Read address channel, valid. |
| axilite\_araddr       | Input[16]                | Read address channel, address. |
| axilite\_arready      | Output                   | Read address channel, ready. |
| axilite\_rvalid       | Output                   | Read data channel, valid. |
| axilite\_rresp        | Output[2]                | Read data channel, response. |
| axilite\_rdata        | Output[32]               | Read data channel, data. |
| axilite\_rready       | Input                    | Read data channel, ready. |
| interrupt             | Output                   | Processor interrupt (active high). |
||||
---

## <a name="register-map"></a>Register Map

### [Register Map](hdl/axi_mspi_regs.md)
