## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Description:       Memory Page
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################

source ../../../bin/vivado_include.tcl

create_project axi_m1page . -part xc7z045ffg900-2 -force
msg_settings none

set ip_source_list {}
lappend ip_source_list ../../common/hdl/cdc_cntrl.v
lappend ip_source_list ../../common/hdl/cdc_cntrl_constr.xdc
lappend ip_source_list axi_m1page.v
set ip_file_list $ip_source_list
add_files -norecurse -fileset [get_filesets sources_1] $ip_file_list
set_property source_set sources_1 [get_filesets sim_1]
set_property top axi_m1page [get_filesets sources_1]
set_property top axi_m1page [get_filesets sim_1]

pkg_ip_core axi_m1page
add_ip_files $ip_file_list synthesis
add_ip_files $ip_file_list simulation
ipx::save_core

set ip_file_set [ipx::get_file_groups -filter {name =~ *synthesis*}]
set_property SCOPED_TO_REF cdc_cntrl [ipx::get_files *cdc_cntrl_constr.xdc -of_objects $ip_file_set]
ipx::save_core

ipx::associate_bus_interfaces -busif aximm_pg -clock clk -remove [ipx::current_core]
ipx::associate_bus_interfaces -busif aximm_pg -clock aximm_clk [ipx::current_core]
ipx::associate_bus_interfaces -busif aximm -clock aximm_clk [ipx::current_core]
ipx::save_core

## ##################################################################################
## ##################################################################################

