// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Description:       Memory Page
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module axi_m1page (

    input   wire            aximm_clk,
    input   wire            aximm_resetn,

    input   wire  [ 27:0]   aximm_pg_awaddr,
    input   wire  [  7:0]   aximm_pg_awlen,
    input   wire  [  2:0]   aximm_pg_awsize,
    input   wire  [  1:0]   aximm_pg_awburst,
    input   wire  [  2:0]   aximm_pg_awprot,
    input   wire  [  3:0]   aximm_pg_awcache,
    input   wire            aximm_pg_awvalid,
    output  wire            aximm_pg_awready,
    input   wire  [511:0]   aximm_pg_wdata,
    input   wire  [ 63:0]   aximm_pg_wstrb,
    input   wire            aximm_pg_wlast,
    input   wire            aximm_pg_wvalid,
    output  wire            aximm_pg_wready,
    output  wire  [  1:0]   aximm_pg_bresp,
    output  wire            aximm_pg_bvalid,
    input   wire            aximm_pg_bready,
    input   wire  [ 27:0]   aximm_pg_araddr,
    input   wire  [  7:0]   aximm_pg_arlen,
    input   wire  [  2:0]   aximm_pg_arsize,
    input   wire  [  1:0]   aximm_pg_arburst,
    input   wire  [  2:0]   aximm_pg_arprot,
    input   wire  [  3:0]   aximm_pg_arcache,
    input   wire  [  3:0]   aximm_pg_aruser,
    input   wire            aximm_pg_arvalid,
    output  wire            aximm_pg_arready,
    output  wire  [511:0]   aximm_pg_rdata,
    output  wire  [  1:0]   aximm_pg_rresp,
    output  wire            aximm_pg_rlast,
    output  wire            aximm_pg_rvalid,
    input   wire            aximm_pg_rready,

    output  wire  [ 39:0]   aximm_awaddr,
    output  wire  [  7:0]   aximm_awlen,
    output  wire  [  2:0]   aximm_awsize,
    output  wire  [  1:0]   aximm_awburst,
    output  wire  [  2:0]   aximm_awprot,
    output  wire  [  3:0]   aximm_awcache,
    output  wire            aximm_awvalid,
    input   wire            aximm_awready,
    output  wire  [511:0]   aximm_wdata,
    output  wire  [ 63:0]   aximm_wstrb,
    output  wire            aximm_wlast,
    output  wire            aximm_wvalid,
    input   wire            aximm_wready,
    input   wire  [  1:0]   aximm_bresp,
    input   wire            aximm_bvalid,
    output  wire            aximm_bready,
    output  wire  [ 39:0]   aximm_araddr,
    output  wire  [  7:0]   aximm_arlen,
    output  wire  [  2:0]   aximm_arsize,
    output  wire  [  1:0]   aximm_arburst,
    output  wire  [  2:0]   aximm_arprot,
    output  wire  [  3:0]   aximm_arcache,
    output  wire  [  3:0]   aximm_aruser,
    output  wire            aximm_arvalid,
    input   wire            aximm_arready,
    input   wire  [511:0]   aximm_rdata,
    input   wire  [  1:0]   aximm_rresp,
    input   wire            aximm_rlast,
    input   wire            aximm_rvalid,
    output  wire            aximm_rready,

    input   wire            clk,
    input   wire            resetn,
    input   wire  [ 11:0]   pg_in,
    output  wire  [ 11:0]   pg_out);

    // internal signals

    wire          [ 11:0]   aximm_pg;

    // simple paging

    assign aximm_awaddr = {aximm_pg, aximm_pg_awaddr};
    assign aximm_awlen = aximm_pg_awlen;
    assign aximm_awsize = aximm_pg_awsize;
    assign aximm_awburst = aximm_pg_awburst;
    assign aximm_awprot = aximm_pg_awprot;
    assign aximm_awcache = aximm_pg_awcache;
    assign aximm_awvalid = aximm_pg_awvalid;
    assign aximm_pg_awready = aximm_awready;
    assign aximm_wdata = aximm_pg_wdata;
    assign aximm_wstrb = aximm_pg_wstrb;
    assign aximm_wlast = aximm_pg_wlast;
    assign aximm_wvalid = aximm_pg_wvalid;
    assign aximm_pg_wready = aximm_wready;
    assign aximm_pg_bresp = aximm_bresp;
    assign aximm_pg_bvalid = aximm_bvalid;
    assign aximm_bready = aximm_pg_bready;
    assign aximm_araddr = {aximm_pg, aximm_pg_araddr};
    assign aximm_arlen = aximm_pg_arlen;
    assign aximm_arsize = aximm_pg_arsize;
    assign aximm_arburst = aximm_pg_arburst;
    assign aximm_arprot = aximm_pg_arprot;
    assign aximm_arcache = aximm_pg_arcache;
    assign aximm_aruser = aximm_pg_aruser;
    assign aximm_arvalid = aximm_pg_arvalid;
    assign aximm_pg_arready = aximm_arready;
    assign aximm_pg_rdata = aximm_rdata;
    assign aximm_pg_rresp = aximm_rresp;
    assign aximm_pg_rlast = aximm_rlast;
    assign aximm_pg_rvalid = aximm_rvalid;
    assign aximm_rready = aximm_pg_rready;

    // instantiations
 
    cdc_cntrl #(.DATA_WIDTH(12)) i_cdc_cntrl_aximm (
        .src_resetn   (resetn),
        .src_clk      (clk),
        .src_data     (pg_in),
        .dest_resetn  (aximm_resetn),
        .dest_clk     (aximm_clk),
        .dest_data    (aximm_pg));

    cdc_cntrl #(.DATA_WIDTH(12)) i_cdc_cntrl (
        .src_resetn   (aximm_resetn),
        .src_clk      (aximm_clk),
        .src_data     (aximm_pg),
        .dest_resetn  (resetn),
        .dest_clk     (clk),
        .dest_data    (pg_out));

endmodule

// **********************************************************************************
// **********************************************************************************
