// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Description:       AXI AXI_DMA_TOP Driver
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

#ifndef AXI_DMA_TOP_REGS_H
#define AXI_DMA_TOP_REGS_H

#define AXI_DMA_TOP_OFFSET 0x0
#define AXI_DMA_TOP_XFER_STATUS 0x1
#define AXI_DMA_TOP_XFER_OVF_UNF 0x2
#define AXI_DMA_TOP_XFER_LENGTH_ERROR 0x4
#define AXI_DMA_TOP_XFER_TLAST_ERROR 0x8
#define AXI_DMA_TOP_XFER_ADDRDEC_ERROR 0x10
#define AXI_DMA_TOP_XFER_SLAVE_ERROR 0x20
#define AXI_DMA_TOP_TRIGGER_DISABLE 0x0
#define AXI_DMA_TOP_TRIGGER_RISING_EDGE 0x1
#define AXI_DMA_TOP_TRIGGER_FALLING_EDGE 0x2
#define AXI_DMA_TOP_TRIGGER_EDGE 0x3

#define AXI_DMA_TOP_REG_VERSION_ADDR 0x0000
#define AXI_DMA_TOP_VERSION_ADDR 0x0000
#define AXI_DMA_TOP_VERSION_POS 0
#define AXI_DMA_TOP_VERSION_MASK 0xffffffff

#define AXI_DMA_TOP_REG_INSTANCE_ID_ADDR 0x0004
#define AXI_DMA_TOP_INSTANCE_ID_ADDR 0x0004
#define AXI_DMA_TOP_INSTANCE_ID_POS 0
#define AXI_DMA_TOP_INSTANCE_ID_MASK 0xffffffff

#define AXI_DMA_TOP_REG_SCRATCH_ADDR 0x0008
#define AXI_DMA_TOP_SCRATCH_ADDR 0x0008
#define AXI_DMA_TOP_SCRATCH_POS 0
#define AXI_DMA_TOP_SCRATCH_MASK 0xffffffff

#define AXI_DMA_TOP_REG_TIMER_ADDR 0x000c
#define AXI_DMA_TOP_TIMER_ADDR 0x000c
#define AXI_DMA_TOP_TIMER_POS 0
#define AXI_DMA_TOP_TIMER_MASK 0xffffffff

#define AXI_DMA_TOP_REG_AXIMM_WIDTH_ADDR 0x0010
#define AXI_DMA_TOP_AXIMM_WIDTH_ADDR 0x0010
#define AXI_DMA_TOP_AXIMM_WIDTH_POS 0
#define AXI_DMA_TOP_AXIMM_WIDTH_MASK 0xffffffff

#define AXI_DMA_TOP_REG_AXIS_WIDTH_ADDR 0x0014
#define AXI_DMA_TOP_AXIS_WIDTH_ADDR 0x0014
#define AXI_DMA_TOP_AXIS_WIDTH_POS 0
#define AXI_DMA_TOP_AXIS_WIDTH_MASK 0xffffffff

#define AXI_DMA_TOP_REG_DMA_TYPE_ADDR 0x0018
#define AXI_DMA_TOP_DMA_TX1_RX0_ADDR 0x0018
#define AXI_DMA_TOP_DMA_TX1_RX0_POS 0
#define AXI_DMA_TOP_DMA_TX1_RX0_MASK 0x0001

#define AXI_DMA_TOP_REG_SWRESET_ADDR 0x0020
#define AXI_DMA_TOP_SWRESET_ADDR 0x0020
#define AXI_DMA_TOP_SWRESET_POS 0
#define AXI_DMA_TOP_SWRESET_MASK 0x0001

#define AXI_DMA_TOP_REG_CONTROL_ADDR 0x0024
#define AXI_DMA_TOP_START_ADDR 0x0024
#define AXI_DMA_TOP_START_POS 0
#define AXI_DMA_TOP_START_MASK 0x0001
#define AXI_DMA_TOP_STOP_ADDR 0x0024
#define AXI_DMA_TOP_STOP_POS 1
#define AXI_DMA_TOP_STOP_MASK 0x0001
#define AXI_DMA_TOP_CYCLIC_ADDR 0x0024
#define AXI_DMA_TOP_CYCLIC_POS 2
#define AXI_DMA_TOP_CYCLIC_MASK 0x0001
#define AXI_DMA_TOP_QTHRESHOLD_ADDR 0x0024
#define AXI_DMA_TOP_QTHRESHOLD_POS 4
#define AXI_DMA_TOP_QTHRESHOLD_MASK 0x000f

#define AXI_DMA_TOP_REG_BUSY_ADDR 0x0028
#define AXI_DMA_TOP_BUSY_ADDR 0x0028
#define AXI_DMA_TOP_BUSY_POS 0
#define AXI_DMA_TOP_BUSY_MASK 0x0001

#define AXI_DMA_TOP_REG_STATUS_ADDR 0x002c
#define AXI_DMA_TOP_STATUS_ADDR 0x002c
#define AXI_DMA_TOP_STATUS_POS 0
#define AXI_DMA_TOP_STATUS_MASK 0x0001
#define AXI_DMA_TOP_OVF_UNF_ADDR 0x002c
#define AXI_DMA_TOP_OVF_UNF_POS 1
#define AXI_DMA_TOP_OVF_UNF_MASK 0x0001
#define AXI_DMA_TOP_LENGTH_ERROR_ADDR 0x002c
#define AXI_DMA_TOP_LENGTH_ERROR_POS 2
#define AXI_DMA_TOP_LENGTH_ERROR_MASK 0x0001
#define AXI_DMA_TOP_TLAST_ERROR_ADDR 0x002c
#define AXI_DMA_TOP_TLAST_ERROR_POS 3
#define AXI_DMA_TOP_TLAST_ERROR_MASK 0x0001
#define AXI_DMA_TOP_ADDRDEC_ERROR_ADDR 0x002c
#define AXI_DMA_TOP_ADDRDEC_ERROR_POS 4
#define AXI_DMA_TOP_ADDRDEC_ERROR_MASK 0x0001
#define AXI_DMA_TOP_SLAVE_ERROR_ADDR 0x002c
#define AXI_DMA_TOP_SLAVE_ERROR_POS 5
#define AXI_DMA_TOP_SLAVE_ERROR_MASK 0x0001

#define AXI_DMA_TOP_REG_REQ_BUF_NUM_ADDR 0x0030
#define AXI_DMA_TOP_REQ_BUF_NUM_ADDR 0x0030
#define AXI_DMA_TOP_REQ_BUF_NUM_POS 0
#define AXI_DMA_TOP_REQ_BUF_NUM_MASK 0x0fff

#define AXI_DMA_TOP_REG_ACK_BUF_NUM_ADDR 0x0034
#define AXI_DMA_TOP_ACK_BUF_NUM_ADDR 0x0034
#define AXI_DMA_TOP_ACK_BUF_NUM_POS 0
#define AXI_DMA_TOP_ACK_BUF_NUM_MASK 0x0fff

#define AXI_DMA_TOP_REG_START_ADDR_LOW_ADDR 0x0080
#define AXI_DMA_TOP_START_ADDR_LOW_ADDR 0x0080
#define AXI_DMA_TOP_START_ADDR_LOW_POS 0
#define AXI_DMA_TOP_START_ADDR_LOW_MASK 0xffffffff

#define AXI_DMA_TOP_REG_START_ADDR_HIGH_ADDR 0x0084
#define AXI_DMA_TOP_START_ADDR_HIGH_ADDR 0x0084
#define AXI_DMA_TOP_START_ADDR_HIGH_POS 0
#define AXI_DMA_TOP_START_ADDR_HIGH_MASK 0x00ff

#define AXI_DMA_TOP_REG_BASE_ADDR_LOW_ADDR 0x0088
#define AXI_DMA_TOP_BASE_ADDR_LOW_ADDR 0x0088
#define AXI_DMA_TOP_BASE_ADDR_LOW_POS 0
#define AXI_DMA_TOP_BASE_ADDR_LOW_MASK 0xffffffff

#define AXI_DMA_TOP_REG_BASE_ADDR_HIGH_ADDR 0x008c
#define AXI_DMA_TOP_BASE_ADDR_HIGH_ADDR 0x008c
#define AXI_DMA_TOP_BASE_ADDR_HIGH_POS 0
#define AXI_DMA_TOP_BASE_ADDR_HIGH_MASK 0x00ff

#define AXI_DMA_TOP_REG_LENGTH_ADDR 0x00a0
#define AXI_DMA_TOP_LENGTH_ADDR 0x00a0
#define AXI_DMA_TOP_LENGTH_POS 0
#define AXI_DMA_TOP_LENGTH_MASK 0x7fffff

#define AXI_DMA_TOP_REG_NUM_OF_BUFERS_ADDR 0x00a4
#define AXI_DMA_TOP_NUM_OF_BUFFERS_ADDR 0x00a4
#define AXI_DMA_TOP_NUM_OF_BUFFERS_POS 0
#define AXI_DMA_TOP_NUM_OF_BUFFERS_MASK 0x0fff

#define AXI_DMA_TOP_REG_TRIGGERS_ADDR 0x00c0
#define AXI_DMA_TOP_TRIGGER_MODE_ADDR 0x00c0
#define AXI_DMA_TOP_TRIGGER_MODE_POS 0
#define AXI_DMA_TOP_TRIGGER_MODE_MASK 0x0003
#define AXI_DMA_TOP_TRIGGER_MODE_POS_OFFSET 2

#define AXI_DMA_TOP_REG_FLAGS_ADDR 0x00c4
#define AXI_DMA_TOP_START_SYNC_ADDR 0x00c4
#define AXI_DMA_TOP_START_SYNC_POS 0
#define AXI_DMA_TOP_START_SYNC_MASK 0x0001
#define AXI_DMA_TOP_CYCLIC_SYNC_ADDR 0x00c4
#define AXI_DMA_TOP_CYCLIC_SYNC_POS 1
#define AXI_DMA_TOP_CYCLIC_SYNC_MASK 0x0001

#define AXI_DMA_TOP_REG_CDC_STATE_ADDR 0x0100
#define AXI_DMA_TOP_CDC_STATE_ADDR 0x0100
#define AXI_DMA_TOP_CDC_STATE_POS 0
#define AXI_DMA_TOP_CDC_STATE_MASK 0x0001

#define AXI_DMA_TOP_REG_MASTER_TRIGGER_ADDR 0x0140
#define AXI_DMA_TOP_MASTER_TRIGGER_ADDR 0x0140
#define AXI_DMA_TOP_MASTER_TRIGGER_POS 0
#define AXI_DMA_TOP_MASTER_TRIGGER_MASK 0x0001

#define AXI_DMA_TOP_REG_MMQ_TLIMIT_ADDR 0x0160
#define AXI_DMA_TOP_MMQ_TLIMIT_ADDR 0x0160
#define AXI_DMA_TOP_MMQ_TLIMIT_POS 0
#define AXI_DMA_TOP_MMQ_TLIMIT_MASK 0xffffffff

#define AXI_DMA_TOP_REG_MMQ_STATUS_ADDR 0x0164
#define AXI_DMA_TOP_MMQ_STATUS_ADDR 0x0164
#define AXI_DMA_TOP_MMQ_STATUS_POS 0
#define AXI_DMA_TOP_MMQ_STATUS_MASK 0xffffffff

#define AXI_DMA_TOP_REG_MMQ_COUNT_ADDR 0x0168
#define AXI_DMA_TOP_MMQ_COUNT_ADDR 0x0168
#define AXI_DMA_TOP_MMQ_COUNT_POS 0
#define AXI_DMA_TOP_MMQ_COUNT_MASK 0x000f

#define AXI_DMA_TOP_REG_INTR_ENABLE_ADDR 0x0204
#define AXI_DMA_TOP_INTR_DONE_ENABLE_ADDR 0x0204
#define AXI_DMA_TOP_INTR_DONE_ENABLE_POS 0
#define AXI_DMA_TOP_INTR_DONE_ENABLE_MASK 0x0001
#define AXI_DMA_TOP_INTR_OVF_UNF_ENABLE_ADDR 0x0204
#define AXI_DMA_TOP_INTR_OVF_UNF_ENABLE_POS 1
#define AXI_DMA_TOP_INTR_OVF_UNF_ENABLE_MASK 0x0001
#define AXI_DMA_TOP_INTR_LENGTH_ERROR_ENABLE_ADDR 0x0204
#define AXI_DMA_TOP_INTR_LENGTH_ERROR_ENABLE_POS 2
#define AXI_DMA_TOP_INTR_LENGTH_ERROR_ENABLE_MASK 0x0001
#define AXI_DMA_TOP_INTR_TLAST_ERROR_ENABLE_ADDR 0x0204
#define AXI_DMA_TOP_INTR_TLAST_ERROR_ENABLE_POS 3
#define AXI_DMA_TOP_INTR_TLAST_ERROR_ENABLE_MASK 0x0001
#define AXI_DMA_TOP_INTR_ADDRDEC_ERROR_ENABLE_ADDR 0x0204
#define AXI_DMA_TOP_INTR_ADDRDEC_ERROR_ENABLE_POS 4
#define AXI_DMA_TOP_INTR_ADDRDEC_ERROR_ENABLE_MASK 0x0001
#define AXI_DMA_TOP_INTR_SLAVE_ERROR_ENABLE_ADDR 0x0204
#define AXI_DMA_TOP_INTR_SLAVE_ERROR_ENABLE_POS 5
#define AXI_DMA_TOP_INTR_SLAVE_ERROR_ENABLE_MASK 0x0001

#define AXI_DMA_TOP_REG_CLK_MON_COUNT_ADDR 0x0300
#define AXI_DMA_TOP_CLK_MON_COUNT_ADDR 0x0300
#define AXI_DMA_TOP_CLK_MON_COUNT_POS 0
#define AXI_DMA_TOP_CLK_MON_COUNT_MASK 0xffffffff

#define AXI_DMA_TOP_REG_DATA_XFER_COUNT_ADDR 0x0304
#define AXI_DMA_TOP_DATA_XFER_COUNT_ADDR 0x0304
#define AXI_DMA_TOP_DATA_XFER_COUNT_POS 0
#define AXI_DMA_TOP_DATA_XFER_COUNT_MASK 0xffffffff

#define AXI_DMA_TOP_REG_INTC_CNTRL_ADDR 0x0340
#define AXI_DMA_TOP_INTC_CNTRL_ADDR 0x0340
#define AXI_DMA_TOP_INTC_CNTRL_POS 0
#define AXI_DMA_TOP_INTC_CNTRL_MASK 0x0001


#endif

// **********************************************************************************
// **********************************************************************************

