// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Description:       Auto generated, local modifications are discouraged.
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module axi_dma_top_regs  #(parameter [3:0] ID = 0) (

    input   wire  [31:0]    axilite_version,
    input   wire  [31:0]    axilite_instance_id,
    output  reg   [31:0]    axilite_scratch = 'd0,
    output  reg   [31:0]    axilite_timer = 'd0,
    input   wire  [31:0]    axilite_aximm_width,
    input   wire  [31:0]    axilite_axis_width,
    input   wire            axilite_dma_tx1_rx0,
    output  reg             axilite_swreset = 'd0,
    input   wire            axilite_swreset_clr,
    output  reg             axilite_start = 'd0,
    input   wire            axilite_start_clr,
    output  reg             axilite_stop = 'd0,
    input   wire            axilite_stop_clr,
    output  reg             axilite_cyclic = 'd0,
    output  reg   [ 3:0]    axilite_qthreshold = 'd0,
    input   wire            axilite_busy,
    input   wire            axilite_status,
    input   wire            axilite_ovf_unf,
    output  wire            axilite_intr_ovf_unf,
    input   wire            axilite_length_error,
    output  wire            axilite_intr_length_error,
    input   wire            axilite_tlast_error,
    output  wire            axilite_intr_tlast_error,
    input   wire            axilite_addrdec_error,
    output  wire            axilite_intr_addrdec_error,
    input   wire            axilite_slave_error,
    output  wire            axilite_intr_slave_error,
    input   wire  [11:0]    axilite_req_buf_num,
    input   wire  [11:0]    axilite_ack_buf_num,
    output  reg   [31:0]    axilite_start_addr_low = 'd0,
    output  reg   [ 7:0]    axilite_start_addr_high = 'd0,
    output  reg   [31:0]    axilite_base_addr_low = 'd0,
    output  reg   [ 7:0]    axilite_base_addr_high = 'd0,
    output  reg   [22:0]    axilite_length = 'd0,
    output  reg   [11:0]    axilite_num_of_buffers = 'd0,
    output  reg   [ 1:0]    axilite_trigger_mode_0 = 'd0,
    output  reg   [ 1:0]    axilite_trigger_mode_1 = 'd0,
    output  reg   [ 1:0]    axilite_trigger_mode_2 = 'd0,
    output  reg   [ 1:0]    axilite_trigger_mode_3 = 'd0,
    output  reg   [ 1:0]    axilite_trigger_mode_4 = 'd0,
    output  reg   [ 1:0]    axilite_trigger_mode_5 = 'd0,
    output  reg             axilite_start_sync = 'd0,
    output  reg             axilite_cyclic_sync = 'd0,
    output  reg             axilite_cdc_state = 'd0,
    input   wire            axilite_cdc_state_clr,
    output  reg             axilite_master_trigger = 'd0,
    output  reg             axilite_mmq_tlimit_wr = 'd0,
    output  reg   [31:0]    axilite_mmq_tlimit_data = 'd0,
    input   wire  [31:0]    axilite_mmq_status,
    input   wire  [ 3:0]    axilite_mmq_count,
    output  reg             axilite_intr_done_enable = 'd0,
    output  reg             axilite_intr_ovf_unf_enable = 'd0,
    output  reg             axilite_intr_length_error_enable = 'd0,
    output  reg             axilite_intr_tlast_error_enable = 'd0,
    output  reg             axilite_intr_addrdec_error_enable = 'd0,
    output  reg             axilite_intr_slave_error_enable = 'd0,
    input   wire  [31:0]    axilite_clk_mon_count,
    input   wire  [31:0]    axilite_data_xfer_count,
    output  reg             axilite_intc_cntrl = 'd0,

    input   wire            axilite_clk,
    input   wire            axilite_resetn,
    input   wire            axilite_wrreq,
    input   wire  [15:0]    axilite_wraddr,
    input   wire  [31:0]    axilite_wrdata,
    output  reg             axilite_wrack = 'd0,
    input   wire            axilite_rdreq,
    input   wire  [15:0]    axilite_rdaddr,
    output  reg   [31:0]    axilite_rddata = 'd0,
    output  reg             axilite_rdack = 'd0);

    reg                     axilite_swreset_clr_d = 'd0;
    reg                     axilite_start_clr_d = 'd0;
    reg                     axilite_stop_clr_d = 'd0;
    reg                     axilite_ovf_unf_w1c = 'd0;
    reg                     axilite_length_error_w1c = 'd0;
    reg                     axilite_tlast_error_w1c = 'd0;
    reg                     axilite_addrdec_error_w1c = 'd0;
    reg                     axilite_slave_error_w1c = 'd0;
    reg                     axilite_cdc_state_clr_d = 'd0;

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_wrack <= 'd0;
            axilite_rdack <= 'd0;
        end else begin
            if (axilite_wraddr[15:12] == ID) begin
                axilite_wrack <= axilite_wrreq;
            end else begin
                axilite_wrack <= 1'd0;
            end
            if (axilite_rdaddr[15:12] == ID) begin
                axilite_rdack <= axilite_rdreq;
            end else begin
                axilite_rdack <= 1'd0;
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_scratch <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h8)) begin
                axilite_scratch <= axilite_wrdata;
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_timer <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hc)) begin
                axilite_timer <= axilite_wrdata;
            end else if (axilite_timer > 0) begin
                axilite_timer <= axilite_timer - 1'b1;
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_swreset_clr_d <= 'd0;
            axilite_swreset <= 'h0;
        end else begin
            axilite_swreset_clr_d <= axilite_swreset_clr;
            if ((axilite_swreset_clr_d == 1'b0) && (axilite_swreset_clr == 1'b1)) begin
                axilite_swreset <= 1'b0;
            end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h20)) begin
                axilite_swreset <= axilite_swreset | axilite_wrdata[0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_start_clr_d <= 'd0;
            axilite_start <= 'h0;
        end else begin
            axilite_start_clr_d <= axilite_start_clr;
            if ((axilite_start_clr_d == 1'b0) && (axilite_start_clr == 1'b1)) begin
                axilite_start <= 1'b0;
            end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h24)) begin
                axilite_start <= axilite_start | axilite_wrdata[0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_stop_clr_d <= 'd0;
            axilite_stop <= 'h0;
        end else begin
            axilite_stop_clr_d <= axilite_stop_clr;
            if ((axilite_stop_clr_d == 1'b0) && (axilite_stop_clr == 1'b1)) begin
                axilite_stop <= 1'b0;
            end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h24)) begin
                axilite_stop <= axilite_stop | axilite_wrdata[1];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_cyclic <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h24)) begin
                axilite_cyclic <= axilite_wrdata[2];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_qthreshold <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h24)) begin
                axilite_qthreshold <= axilite_wrdata[7:4];
            end
        end
    end

    assign axilite_intr_ovf_unf = axilite_ovf_unf_w1c;

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_ovf_unf_w1c <= 'h0;
        end else begin
            if (axilite_ovf_unf == 1'b1) begin
                axilite_ovf_unf_w1c <= 1'b1;
            end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h2c)) begin
                axilite_ovf_unf_w1c <= axilite_ovf_unf_w1c & ~axilite_wrdata[1];
            end
        end
    end

    assign axilite_intr_length_error = axilite_length_error_w1c;

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_length_error_w1c <= 'h0;
        end else begin
            if (axilite_length_error == 1'b1) begin
                axilite_length_error_w1c <= 1'b1;
            end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h2c)) begin
                axilite_length_error_w1c <= axilite_length_error_w1c & ~axilite_wrdata[2];
            end
        end
    end

    assign axilite_intr_tlast_error = axilite_tlast_error_w1c;

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_tlast_error_w1c <= 'h0;
        end else begin
            if (axilite_tlast_error == 1'b1) begin
                axilite_tlast_error_w1c <= 1'b1;
            end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h2c)) begin
                axilite_tlast_error_w1c <= axilite_tlast_error_w1c & ~axilite_wrdata[3];
            end
        end
    end

    assign axilite_intr_addrdec_error = axilite_addrdec_error_w1c;

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_addrdec_error_w1c <= 'h0;
        end else begin
            if (axilite_addrdec_error == 1'b1) begin
                axilite_addrdec_error_w1c <= 1'b1;
            end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h2c)) begin
                axilite_addrdec_error_w1c <= axilite_addrdec_error_w1c & ~axilite_wrdata[4];
            end
        end
    end

    assign axilite_intr_slave_error = axilite_slave_error_w1c;

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_slave_error_w1c <= 'h0;
        end else begin
            if (axilite_slave_error == 1'b1) begin
                axilite_slave_error_w1c <= 1'b1;
            end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h2c)) begin
                axilite_slave_error_w1c <= axilite_slave_error_w1c & ~axilite_wrdata[5];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_start_addr_low <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h80)) begin
                axilite_start_addr_low <= axilite_wrdata;
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_start_addr_high <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h84)) begin
                axilite_start_addr_high <= axilite_wrdata[7:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_base_addr_low <= 'h80000000;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h88)) begin
                axilite_base_addr_low <= axilite_wrdata;
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_base_addr_high <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h8c)) begin
                axilite_base_addr_high <= axilite_wrdata[7:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_length <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'ha0)) begin
                axilite_length <= axilite_wrdata[22:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_num_of_buffers <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'ha4)) begin
                axilite_num_of_buffers <= axilite_wrdata[11:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_trigger_mode_0 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hc0)) begin
                axilite_trigger_mode_0 <= axilite_wrdata[1:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_trigger_mode_1 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hc0)) begin
                axilite_trigger_mode_1 <= axilite_wrdata[3:2];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_trigger_mode_2 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hc0)) begin
                axilite_trigger_mode_2 <= axilite_wrdata[5:4];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_trigger_mode_3 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hc0)) begin
                axilite_trigger_mode_3 <= axilite_wrdata[7:6];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_trigger_mode_4 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hc0)) begin
                axilite_trigger_mode_4 <= axilite_wrdata[9:8];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_trigger_mode_5 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hc0)) begin
                axilite_trigger_mode_5 <= axilite_wrdata[11:10];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_start_sync <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hc4)) begin
                axilite_start_sync <= axilite_wrdata[0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_cyclic_sync <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hc4)) begin
                axilite_cyclic_sync <= axilite_wrdata[1];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_cdc_state_clr_d <= 'd0;
            axilite_cdc_state <= 'h0;
        end else begin
            axilite_cdc_state_clr_d <= axilite_cdc_state_clr;
            if ((axilite_cdc_state_clr_d == 1'b0) && (axilite_cdc_state_clr == 1'b1)) begin
                axilite_cdc_state <= 1'b0;
            end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h100)) begin
                axilite_cdc_state <= axilite_cdc_state | axilite_wrdata[0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_master_trigger <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h140)) begin
                axilite_master_trigger <= axilite_wrdata[0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_mmq_tlimit_wr <= 'd0;
            axilite_mmq_tlimit_data <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h160)) begin
                axilite_mmq_tlimit_wr <= 1'd1;
                axilite_mmq_tlimit_data <= axilite_wrdata;
            end else begin
                axilite_mmq_tlimit_wr <= 1'd0;
                axilite_mmq_tlimit_data <= axilite_mmq_tlimit_data;
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_intr_done_enable <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h204)) begin
                axilite_intr_done_enable <= axilite_wrdata[0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_intr_ovf_unf_enable <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h204)) begin
                axilite_intr_ovf_unf_enable <= axilite_wrdata[1];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_intr_length_error_enable <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h204)) begin
                axilite_intr_length_error_enable <= axilite_wrdata[2];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_intr_tlast_error_enable <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h204)) begin
                axilite_intr_tlast_error_enable <= axilite_wrdata[3];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_intr_addrdec_error_enable <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h204)) begin
                axilite_intr_addrdec_error_enable <= axilite_wrdata[4];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_intr_slave_error_enable <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h204)) begin
                axilite_intr_slave_error_enable <= axilite_wrdata[5];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_intc_cntrl <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h340)) begin
                axilite_intc_cntrl <= axilite_wrdata[0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_rddata <= 'd0;
        end else begin
            if ((axilite_rdreq == 1'b1) && (axilite_rdaddr[15:12] == ID)) begin
                case (axilite_rdaddr[11:0])
                    'h0: begin
                        axilite_rddata <= axilite_version;
                    end
                    'h4: begin
                        axilite_rddata <= axilite_instance_id;
                    end
                    'h8: begin
                        axilite_rddata <= axilite_scratch;
                    end
                    'hc: begin
                        axilite_rddata <= axilite_timer;
                    end
                    'h10: begin
                        axilite_rddata <= axilite_aximm_width;
                    end
                    'h14: begin
                        axilite_rddata <= axilite_axis_width;
                    end
                    'h18: begin
                        axilite_rddata[0] <= axilite_dma_tx1_rx0;
                        axilite_rddata[31:1] <= 'd0;
                    end
                    'h20: begin
                        axilite_rddata[0] <= axilite_swreset;
                        axilite_rddata[31:1] <= 'd0;
                    end
                    'h24: begin
                        axilite_rddata[0] <= axilite_start;
                        axilite_rddata[1] <= axilite_stop;
                        axilite_rddata[2] <= axilite_cyclic;
                        axilite_rddata[3] <= 'd0;
                        axilite_rddata[7:4] <= axilite_qthreshold;
                        axilite_rddata[31:8] <= 'd0;
                    end
                    'h28: begin
                        axilite_rddata[0] <= axilite_busy;
                        axilite_rddata[31:1] <= 'd0;
                    end
                    'h2c: begin
                        axilite_rddata[0] <= axilite_status;
                        axilite_rddata[1] <= axilite_ovf_unf_w1c;
                        axilite_rddata[2] <= axilite_length_error_w1c;
                        axilite_rddata[3] <= axilite_tlast_error_w1c;
                        axilite_rddata[4] <= axilite_addrdec_error_w1c;
                        axilite_rddata[5] <= axilite_slave_error_w1c;
                        axilite_rddata[31:6] <= 'd0;
                    end
                    'h30: begin
                        axilite_rddata[11:0] <= axilite_req_buf_num;
                        axilite_rddata[31:12] <= 'd0;
                    end
                    'h34: begin
                        axilite_rddata[11:0] <= axilite_ack_buf_num;
                        axilite_rddata[31:12] <= 'd0;
                    end
                    'h80: begin
                        axilite_rddata <= axilite_start_addr_low;
                    end
                    'h84: begin
                        axilite_rddata[7:0] <= axilite_start_addr_high;
                        axilite_rddata[31:8] <= 'd0;
                    end
                    'h88: begin
                        axilite_rddata <= axilite_base_addr_low;
                    end
                    'h8c: begin
                        axilite_rddata[7:0] <= axilite_base_addr_high;
                        axilite_rddata[31:8] <= 'd0;
                    end
                    'ha0: begin
                        axilite_rddata[22:0] <= axilite_length;
                        axilite_rddata[31:23] <= 'd0;
                    end
                    'ha4: begin
                        axilite_rddata[11:0] <= axilite_num_of_buffers;
                        axilite_rddata[31:12] <= 'd0;
                    end
                    'hc0: begin
                        axilite_rddata[1:0] <= axilite_trigger_mode_0;
                        axilite_rddata[3:2] <= axilite_trigger_mode_1;
                        axilite_rddata[5:4] <= axilite_trigger_mode_2;
                        axilite_rddata[7:6] <= axilite_trigger_mode_3;
                        axilite_rddata[9:8] <= axilite_trigger_mode_4;
                        axilite_rddata[11:10] <= axilite_trigger_mode_5;
                        axilite_rddata[31:12] <= 'd0;
                    end
                    'hc4: begin
                        axilite_rddata[0] <= axilite_start_sync;
                        axilite_rddata[1] <= axilite_cyclic_sync;
                        axilite_rddata[31:2] <= 'd0;
                    end
                    'h100: begin
                        axilite_rddata[0] <= axilite_cdc_state;
                        axilite_rddata[31:1] <= 'd0;
                    end
                    'h140: begin
                        axilite_rddata[0] <= axilite_master_trigger;
                        axilite_rddata[31:1] <= 'd0;
                    end
                    'h160: begin
                        axilite_rddata <= axilite_mmq_tlimit_data;
                    end
                    'h164: begin
                        axilite_rddata <= axilite_mmq_status;
                    end
                    'h168: begin
                        axilite_rddata[3:0] <= axilite_mmq_count;
                        axilite_rddata[31:4] <= 'd0;
                    end
                    'h204: begin
                        axilite_rddata[0] <= axilite_intr_done_enable;
                        axilite_rddata[1] <= axilite_intr_ovf_unf_enable;
                        axilite_rddata[2] <= axilite_intr_length_error_enable;
                        axilite_rddata[3] <= axilite_intr_tlast_error_enable;
                        axilite_rddata[4] <= axilite_intr_addrdec_error_enable;
                        axilite_rddata[5] <= axilite_intr_slave_error_enable;
                        axilite_rddata[31:6] <= 'd0;
                    end
                    'h300: begin
                        axilite_rddata <= axilite_clk_mon_count;
                    end
                    'h304: begin
                        axilite_rddata <= axilite_data_xfer_count;
                    end
                    'h340: begin
                        axilite_rddata[0] <= axilite_intc_cntrl;
                        axilite_rddata[31:1] <= 'd0;
                    end
                    default: begin
                        axilite_rddata <= 32'd0;
                    end
                endcase
            end else begin
                axilite_rddata <= 32'd0;
            end
        end
    end

endmodule

// **********************************************************************************
// **********************************************************************************
