### AXI\_DMA\_TOP Register Map
The addresses shown are relative to the peripheral base address.

---
| Address | Bits | Field | Type | Default | Description |
| ------- | ---- | ----- | ---- | ------- | ----------- |
| 0x0 | [31:0] | version[31:0] | RO | 0x60000 | This is read as the current version of this IP core. |
| | | | | | |
| 0x4 | [31:0] | instance\_id[31:0] | RO | 0x0 | These bits Indicate the instance ID, in any multiple instances system, instance id 0x0 is the master core. |
| | | | | | |
| 0x8 | [31:0] | scratch[31:0] | RW | 0x0 | The general purpose scratch register |
| | | | | | |
| 0xc | [31:0] | timer[31:0] | RW | 0x0 | The general purpose timer register |
| | | | | | |
| 0x10 | [31:0] | aximm\_width[31:0] | RO | 0x200 | These bits Indicate AXIMM data width, ideally it is best to set the length to an integer multiple of this width in bytes. This allows minimal realignment and byte enables. |
| | | | | | |
| 0x14 | [31:0] | axis\_width[31:0] | RO | 0x8 | These bits Indicate AXIS data width, the dma length must be an integer multiple of this width. |
| | | | | | |
| 0x18 | [0:0] | dma\_tx1\_rx0 | RO | 0x0 | These bits indicate dma type. |
| | | | | | |
| 0x20 | [0:0] | swreset | RW1HC | 0x0 | If set, the core is reset at the AXIMM interface. In all hardware error cases, a software reset is required to resume normal operation. Hardware clears this bit once the internal reset is completed. |
| | | | | | |
| 0x24 | [0:0] | start | RW1HC | 0x0 | If set interpreted as a request to start the data transfer. All DMA related registers must be set properly before asserting this bit. |
| 0x24 | [1:1] | stop | RW1HC | 0x0 | If set, while the DMA BUSY bit is set, interpreted as a request to stop the data transfer. This may take a while depending on the queue threshold programmed and cyclic mode. All pending bursts is cleared. |
| 0x24 | [2:2] | cyclic | RW | 0x0 | This bit may be asserted to indicate a cyclic data transfer, software may split up contigous memory as segments to provide a seamless capture, however it must be capable of finishing read or write before data transfer repeats. |
| 0x24 | [7:4] | qthreshold[3:0] | RW | 0x0 | The transaction queue threshold, this limits the maximum number of posted transactions within the current data transfer. |
| | | | | | |
| 0x28 | [0:0] | busy | RO | 0x0 | If asserted indicates that dma is running or has stopped because of an error as indicated by the STATUS fields below. This bit is asserted low to indicate a successful completion of DMA, provided there are no overflow or underflow. |
| | | | | | |
| 0x2c | [0:0] | status | RO | 0x0 | If asserted indicates that the AXI bus transaction has completed successfully, this is not an indication of the entire transfer. This bit is accumulative |
| 0x2c | [1:1] | ovf\_unf | RW1C | 0x0 | If asserted indicates an overflow or underflow, data transfer may complete, but most likely data is corrupted. |
| 0x2c | [2:2] | length\_error | RW1C | 0x0 | If asserted indicates an invalid transfer length, recovery requires a soft-reset. |
| 0x2c | [3:3] | tlast\_error | RW1C | 0x0 | If asserted indicates an internal LAST flag error, recovery requires a soft-reset. |
| 0x2c | [4:4] | addrdec\_error | RW1C | 0x0 | If asserted indicates an address decode error, likely that the slave is not addressable, recovery requires a soft-reset. |
| 0x2c | [5:5] | slave\_error | RW1C | 0x0 | If asserted indicates a slave error, this is the AXI-RESPONSE received from the slave, recovery requires a soft-reset. |
| | | | | | |
| 0x30 | [11:0] | req\_buf\_num[11:0] | RO | 0x0 | The current requested buffer number. |
| | | | | | |
| 0x34 | [11:0] | ack\_buf\_num[11:0] | RO | 0x0 | The current completed buffer number. |
| | | | | | |
| 0x80 | [31:0] | start\_addr\_low[31:0] | RW | 0x0 | start address low order bits |
| | | | | | |
| 0x84 | [7:0] | start\_addr\_high[7:0] | RW | 0x0 | start address high order bits |
| | | | | | |
| 0x88 | [31:0] | base\_addr\_low[31:0] | RW | 0x80000000 | base address low order bits |
| | | | | | |
| 0x8c | [7:0] | base\_addr\_high[7:0] | RW | 0x0 | base address high order bits |
| | | | | | |
| 0xa0 | [22:0] | length[22:0] | RW | 0x0 | indicates length in bytes |
| | | | | | |
| 0xa4 | [11:0] | num\_of\_buffers[11:0] | RW | 0x0 | indicates number of buffers. |
| | | | | | |
| 0xc0 | [1:0] | trigger\_mode\_0[1:0] | RW | 0x0 | The DMA may optionally be controlled through the cores trigger inputs. There are four programmable trigger inputs, these bits control each one of the triggers independently. The data transfer is controlled as an AND function of all the trigger modes. In all modes, the duration of data transfer is controlled by the length. |
| 0xc0 | [3:2] | trigger\_mode\_1[1:0] | RW | 0x0 | The DMA may optionally be controlled through the cores trigger inputs. There are four programmable trigger inputs, these bits control each one of the triggers independently. The data transfer is controlled as an AND function of all the trigger modes. In all modes, the duration of data transfer is controlled by the length. |
| 0xc0 | [5:4] | trigger\_mode\_2[1:0] | RW | 0x0 | The DMA may optionally be controlled through the cores trigger inputs. There are four programmable trigger inputs, these bits control each one of the triggers independently. The data transfer is controlled as an AND function of all the trigger modes. In all modes, the duration of data transfer is controlled by the length. |
| 0xc0 | [7:6] | trigger\_mode\_3[1:0] | RW | 0x0 | The DMA may optionally be controlled through the cores trigger inputs. There are four programmable trigger inputs, these bits control each one of the triggers independently. The data transfer is controlled as an AND function of all the trigger modes. In all modes, the duration of data transfer is controlled by the length. |
| 0xc0 | [9:8] | trigger\_mode\_4[1:0] | RW | 0x0 | The DMA may optionally be controlled through the cores trigger inputs. There are four programmable trigger inputs, these bits control each one of the triggers independently. The data transfer is controlled as an AND function of all the trigger modes. In all modes, the duration of data transfer is controlled by the length. |
| 0xc0 | [11:10] | trigger\_mode\_5[1:0] | RW | 0x0 | The DMA may optionally be controlled through the cores trigger inputs. There are four programmable trigger inputs, these bits control each one of the triggers independently. The data transfer is controlled as an AND function of all the trigger modes. In all modes, the duration of data transfer is controlled by the length. |
| | | | | | |
| 0xc4 | [0:0] | start\_sync | RW | 0x0 | The DMA also allows samples transferred in relation with enable signals. These modes allow per enable transfer control. If this bit is set, data transfer begins at the next rising edge of enable. If set to 0x0, data transfer begins as soon as possible. |
| 0xc4 | [1:1] | cyclic\_sync | RW | 0x0 | If set to 0x1, data transfer at each cycle begins only with the rising edge of enable. This could cause data hit, depending on the DMA length and enable duration (transmit only). |
| | | | | | |
| 0x100 | [0:0] | cdc\_state | RW1HC | 0x0 | If set, cleared when CDC transfer is complete. |
| | | | | | |
| 0x140 | [0:0] | master\_trigger | RW | 0x0 | If set to 0x1, interface uses master trigger, this signal is based on board configuration and must be sourced from another instance of the same core. |
| | | | | | |
| 0x160 | [31:0] | mmq\_tlimit[31:0] | MW | 0x0 | The MMQ timer limit. |
| | | | | | |
| 0x164 | [31:0] | mmq\_status[31:0] | RO | 0x0 | The MMQ status data. |
| | | | | | |
| 0x168 | [3:0] | mmq\_count[3:0] | RO | 0x0 | The MMQ count (level). |
| | | | | | |
| 0x204 | [0:0] | intr\_done\_enable | RW | 0x0 | Interrupt enable for INTR\_DONE. |
| 0x204 | [1:1] | intr\_ovf\_unf\_enable | RW | 0x0 | Interrupt enable for INTR\_OVF\_UNF. |
| 0x204 | [2:2] | intr\_length\_error\_enable | RW | 0x0 | Interrupt enable for INTR\_LENGTH\_ERROR. |
| 0x204 | [3:3] | intr\_tlast\_error\_enable | RW | 0x0 | Interrupt enable for INTR\_TLAST\_ERROR. |
| 0x204 | [4:4] | intr\_addrdec\_error\_enable | RW | 0x0 | Interrupt enable for INTR\_ADDRDEC\_ERROR. |
| 0x204 | [5:5] | intr\_slave\_error\_enable | RW | 0x0 | Interrupt enable for INTR\_SLAVE\_ERROR. |
| | | | | | |
| 0x300 | [31:0] | clk\_mon\_count[31:0] | RO | 0x0 | Clock monitor frequency count. If read 0x0, indicates a loss of clock. The format is 16.16 x 100MHz |
| | | | | | |
| 0x304 | [31:0] | data\_xfer\_count[31:0] | RO | 0x0 | Data transfer count. Indicates time taken to complete the transfer. The format is 32.0 x 10ns. |
| | | | | | |
| 0x340 | [0:0] | intc\_cntrl | RW | 0x0 | Interconnect control, internal use only. |
| | | | | | |
---
