// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Description:       AXI AXI_ADRV9001_TDD Driver
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

#ifndef AXI_ADRV9001_TDD_REGS_H
#define AXI_ADRV9001_TDD_REGS_H

#define AXI_ADRV9001_TDD_OFFSET 0x8000
#define AXI_ADRV9001_TDD_TRIGGER_DISABLED 0x0
#define AXI_ADRV9001_TDD_TRIGGER_RISING_EDGE 0x1
#define AXI_ADRV9001_TDD_TRIGGER_FALLING_EDGE 0x2
#define AXI_ADRV9001_TDD_TRIGGER_EDGE 0x3
#define AXI_ADRV9001_TDD_ENABLE_AUTO 0x2
#define AXI_ADRV9001_TDD_ENABLE_HIGH 0x1
#define AXI_ADRV9001_TDD_ENABLE_LOW 0x0
#define AXI_ADRV9001_TDD_TRIG_START_INDEX 0x0
#define AXI_ADRV9001_TDD_RX0_DMA_TRIG 0x0
#define AXI_ADRV9001_TDD_TX0_DMA_TRIG 0x1
#define AXI_ADRV9001_TDD_RX1_DMA_TRIG 0x2
#define AXI_ADRV9001_TDD_TX1_DMA_TRIG 0x3
#define AXI_ADRV9001_TDD_ORX0_DMA_TRIG 0x4
#define AXI_ADRV9001_TDD_ORX1_DMA_TRIG 0x5
#define AXI_ADRV9001_TDD_EXT0_TRIG 0x6
#define AXI_ADRV9001_TDD_EXT1_TRIG 0x7
#define AXI_ADRV9001_TDD_SPI_TRIG 0x8
#define AXI_ADRV9001_TDD_GPIO_TRIG 0x9
#define AXI_ADRV9001_TDD_DEV_START_INDEX 0xa
#define AXI_ADRV9001_TDD_RX0_DEVICE 0xa
#define AXI_ADRV9001_TDD_TX0_DEVICE 0xb
#define AXI_ADRV9001_TDD_RX1_DEVICE 0xc
#define AXI_ADRV9001_TDD_TX1_DEVICE 0xd
#define AXI_ADRV9001_TDD_ORX0_GPIO 0xe
#define AXI_ADRV9001_TDD_ORX1_GPIO 0xf
#define AXI_ADRV9001_TDD_TX0_GPIO 0x10
#define AXI_ADRV9001_TDD_TX1_GPIO 0x11
#define AXI_ADRV9001_TDD_IFRM0CTL0_GPIO 0x12
#define AXI_ADRV9001_TDD_IFRM0CTL1_GPIO 0x13
#define AXI_ADRV9001_TDD_IFRM1CTL0_GPIO 0x14
#define AXI_ADRV9001_TDD_IFRM1CTL1_GPIO 0x15
#define AXI_ADRV9001_TDD_DMA_START_INDEX 0x16
#define AXI_ADRV9001_TDD_RX0_DMA_DATA 0x16
#define AXI_ADRV9001_TDD_TX0_DMA_DATA 0x17
#define AXI_ADRV9001_TDD_RX1_DMA_DATA 0x18
#define AXI_ADRV9001_TDD_TX1_DMA_DATA 0x19
#define AXI_ADRV9001_TDD_ORX0_DMA_DATA 0x1a
#define AXI_ADRV9001_TDD_ORX1_DMA_DATA 0x1b

#define AXI_ADRV9001_TDD_REG_FRAME_PERIOD_ADDR 0x0000
#define AXI_ADRV9001_TDD_FRAME_PERIOD_ADDR 0x0000
#define AXI_ADRV9001_TDD_FRAME_PERIOD_POS 0
#define AXI_ADRV9001_TDD_FRAME_PERIOD_MASK 0xffffffff

#define AXI_ADRV9001_TDD_REG_NUM_OF_FRAMES_ADDR 0x0004
#define AXI_ADRV9001_TDD_NUM_OF_FRAMES_ADDR 0x0004
#define AXI_ADRV9001_TDD_NUM_OF_FRAMES_POS 0
#define AXI_ADRV9001_TDD_NUM_OF_FRAMES_MASK 0xffffffff

#define AXI_ADRV9001_TDD_REG_FRAME_SWITCH_PERIOD_ADDR 0x0008
#define AXI_ADRV9001_TDD_FRAME_SWITCH_PERIOD_ADDR 0x0008
#define AXI_ADRV9001_TDD_FRAME_SWITCH_PERIOD_POS 0
#define AXI_ADRV9001_TDD_FRAME_SWITCH_PERIOD_MASK 0xffffffff

#define AXI_ADRV9001_TDD_REG_FRAME_SWITCH_NUMBER_ADDR 0x000c
#define AXI_ADRV9001_TDD_FRAME_SWITCH_NUMBER_ADDR 0x000c
#define AXI_ADRV9001_TDD_FRAME_SWITCH_NUMBER_POS 0
#define AXI_ADRV9001_TDD_FRAME_SWITCH_NUMBER_MASK 0xffffffff

#define AXI_ADRV9001_TDD_REG_TRIGGERS_ADDR 0x0010
#define AXI_ADRV9001_TDD_TRIGGER_MODE_ADDR 0x0010
#define AXI_ADRV9001_TDD_TRIGGER_MODE_POS 0
#define AXI_ADRV9001_TDD_TRIGGER_MODE_MASK 0x0003
#define AXI_ADRV9001_TDD_TRIGGER_MODE_POS_OFFSET 2

#define AXI_ADRV9001_TDD_REG_SEQUENCE_CONTROL_ADDR 0x0020
#define AXI_ADRV9001_TDD_START_ADDR 0x0020
#define AXI_ADRV9001_TDD_START_POS 0
#define AXI_ADRV9001_TDD_START_MASK 0x0001
#define AXI_ADRV9001_TDD_STOP_ADDR 0x0020
#define AXI_ADRV9001_TDD_STOP_POS 1
#define AXI_ADRV9001_TDD_STOP_MASK 0x0001
#define AXI_ADRV9001_TDD_SEQUENCE_REPEAT_ADDR 0x0020
#define AXI_ADRV9001_TDD_SEQUENCE_REPEAT_POS 2
#define AXI_ADRV9001_TDD_SEQUENCE_REPEAT_MASK 0x0001
#define AXI_ADRV9001_TDD_FRAME_SWITCH_ENABLE_ADDR 0x0020
#define AXI_ADRV9001_TDD_FRAME_SWITCH_ENABLE_POS 3
#define AXI_ADRV9001_TDD_FRAME_SWITCH_ENABLE_MASK 0x0001

#define AXI_ADRV9001_TDD_REG_SWRESET_ADDR 0x0024
#define AXI_ADRV9001_TDD_SWRESET_ADDR 0x0024
#define AXI_ADRV9001_TDD_SWRESET_POS 0
#define AXI_ADRV9001_TDD_SWRESET_MASK 0x0001

#define AXI_ADRV9001_TDD_REG_TIMER_ADDR 0x0028
#define AXI_ADRV9001_TDD_TIMER_ADDR 0x0028
#define AXI_ADRV9001_TDD_TIMER_POS 0
#define AXI_ADRV9001_TDD_TIMER_MASK 0xffffffff

#define AXI_ADRV9001_TDD_REG_CLK_MON_ADDR 0x0030
#define AXI_ADRV9001_TDD_CLK_MON_COUNT_ADDR 0x0030
#define AXI_ADRV9001_TDD_CLK_MON_COUNT_POS 0
#define AXI_ADRV9001_TDD_CLK_MON_COUNT_MASK 0xffffffff

#define AXI_ADRV9001_TDD_REG_GLOBAL_ENB_ADDR 0x0040
#define AXI_ADRV9001_TDD_GLOBAL_ENB_ADDR 0x0040
#define AXI_ADRV9001_TDD_GLOBAL_ENB_POS 0
#define AXI_ADRV9001_TDD_GLOBAL_ENB_MASK 0x0001

#define AXI_ADRV9001_TDD_REG_CDC_STATE_ADDR 0x0050
#define AXI_ADRV9001_TDD_CDC_STATE_ADDR 0x0050
#define AXI_ADRV9001_TDD_CDC_STATE_POS 0
#define AXI_ADRV9001_TDD_CDC_STATE_MASK 0x0001

#define AXI_ADRV9001_TDD_REG_PRIMARY_ASSERT_ADDR 0x0100
#define AXI_ADRV9001_TDD_REG_PRIMARY_ASSERT_ADDR_OFFSET 0x0040
#define AXI_ADRV9001_TDD_PRIMARY_ASSERT_ADDR 0x0100
#define AXI_ADRV9001_TDD_PRIMARY_ASSERT_ADDR_OFFSET 0x0040
#define AXI_ADRV9001_TDD_PRIMARY_ASSERT_POS 0
#define AXI_ADRV9001_TDD_PRIMARY_ASSERT_MASK 0xffffffff

#define AXI_ADRV9001_TDD_REG_PRIMARY_DEASSERT_ADDR 0x0104
#define AXI_ADRV9001_TDD_REG_PRIMARY_DEASSERT_ADDR_OFFSET 0x0040
#define AXI_ADRV9001_TDD_PRIMARY_DEASSERT_ADDR 0x0104
#define AXI_ADRV9001_TDD_PRIMARY_DEASSERT_ADDR_OFFSET 0x0040
#define AXI_ADRV9001_TDD_PRIMARY_DEASSERT_POS 0
#define AXI_ADRV9001_TDD_PRIMARY_DEASSERT_MASK 0xffffffff

#define AXI_ADRV9001_TDD_REG_SECONDARY_ASSERT_ADDR 0x0108
#define AXI_ADRV9001_TDD_REG_SECONDARY_ASSERT_ADDR_OFFSET 0x0040
#define AXI_ADRV9001_TDD_SECONDARY_ASSERT_ADDR 0x0108
#define AXI_ADRV9001_TDD_SECONDARY_ASSERT_ADDR_OFFSET 0x0040
#define AXI_ADRV9001_TDD_SECONDARY_ASSERT_POS 0
#define AXI_ADRV9001_TDD_SECONDARY_ASSERT_MASK 0xffffffff

#define AXI_ADRV9001_TDD_REG_SECONDARY_DEASSERT_ADDR 0x010c
#define AXI_ADRV9001_TDD_REG_SECONDARY_DEASSERT_ADDR_OFFSET 0x0040
#define AXI_ADRV9001_TDD_SECONDARY_DEASSERT_ADDR 0x010c
#define AXI_ADRV9001_TDD_SECONDARY_DEASSERT_ADDR_OFFSET 0x0040
#define AXI_ADRV9001_TDD_SECONDARY_DEASSERT_POS 0
#define AXI_ADRV9001_TDD_SECONDARY_DEASSERT_MASK 0xffffffff

#define AXI_ADRV9001_TDD_REG_PRIMARY_FRAME_ASSERT_ADDR 0x0110
#define AXI_ADRV9001_TDD_REG_PRIMARY_FRAME_ASSERT_ADDR_OFFSET 0x0040
#define AXI_ADRV9001_TDD_PRIMARY_FRAME_ASSERT_ADDR 0x0110
#define AXI_ADRV9001_TDD_PRIMARY_FRAME_ASSERT_ADDR_OFFSET 0x0040
#define AXI_ADRV9001_TDD_PRIMARY_FRAME_ASSERT_POS 0
#define AXI_ADRV9001_TDD_PRIMARY_FRAME_ASSERT_MASK 0xffffffff

#define AXI_ADRV9001_TDD_REG_PRIMARY_FRAME_DEASSERT_ADDR 0x0114
#define AXI_ADRV9001_TDD_REG_PRIMARY_FRAME_DEASSERT_ADDR_OFFSET 0x0040
#define AXI_ADRV9001_TDD_PRIMARY_FRAME_DEASSERT_ADDR 0x0114
#define AXI_ADRV9001_TDD_PRIMARY_FRAME_DEASSERT_ADDR_OFFSET 0x0040
#define AXI_ADRV9001_TDD_PRIMARY_FRAME_DEASSERT_POS 0
#define AXI_ADRV9001_TDD_PRIMARY_FRAME_DEASSERT_MASK 0xffffffff

#define AXI_ADRV9001_TDD_REG_SECONDARY_FRAME_ASSERT_ADDR 0x0118
#define AXI_ADRV9001_TDD_REG_SECONDARY_FRAME_ASSERT_ADDR_OFFSET 0x0040
#define AXI_ADRV9001_TDD_SECONDARY_FRAME_ASSERT_ADDR 0x0118
#define AXI_ADRV9001_TDD_SECONDARY_FRAME_ASSERT_ADDR_OFFSET 0x0040
#define AXI_ADRV9001_TDD_SECONDARY_FRAME_ASSERT_POS 0
#define AXI_ADRV9001_TDD_SECONDARY_FRAME_ASSERT_MASK 0xffffffff

#define AXI_ADRV9001_TDD_REG_SECONDARY_FRAME_DEASSERT_ADDR 0x011c
#define AXI_ADRV9001_TDD_REG_SECONDARY_FRAME_DEASSERT_ADDR_OFFSET 0x0040
#define AXI_ADRV9001_TDD_SECONDARY_FRAME_DEASSERT_ADDR 0x011c
#define AXI_ADRV9001_TDD_SECONDARY_FRAME_DEASSERT_ADDR_OFFSET 0x0040
#define AXI_ADRV9001_TDD_SECONDARY_FRAME_DEASSERT_POS 0
#define AXI_ADRV9001_TDD_SECONDARY_FRAME_DEASSERT_MASK 0xffffffff

#define AXI_ADRV9001_TDD_REG_MODE_ADDR 0x0120
#define AXI_ADRV9001_TDD_REG_MODE_ADDR_OFFSET 0x0040
#define AXI_ADRV9001_TDD_MODE_ADDR 0x0120
#define AXI_ADRV9001_TDD_MODE_ADDR_OFFSET 0x0040
#define AXI_ADRV9001_TDD_MODE_POS 0
#define AXI_ADRV9001_TDD_MODE_MASK 0x0003

#define AXI_ADRV9001_TDD_REG_SYNC_ADDR 0x0124
#define AXI_ADRV9001_TDD_REG_SYNC_ADDR_OFFSET 0x0040
#define AXI_ADRV9001_TDD_SYNC_ADDR 0x0124
#define AXI_ADRV9001_TDD_SYNC_ADDR_OFFSET 0x0040
#define AXI_ADRV9001_TDD_SYNC_POS 0
#define AXI_ADRV9001_TDD_SYNC_MASK 0x0001

#define AXI_ADRV9001_TDD_REG_CLK_RATIO_ADDR 0x0128
#define AXI_ADRV9001_TDD_REG_CLK_RATIO_ADDR_OFFSET 0x0040
#define AXI_ADRV9001_TDD_CLK_RATIO_ADDR 0x0128
#define AXI_ADRV9001_TDD_CLK_RATIO_ADDR_OFFSET 0x0040
#define AXI_ADRV9001_TDD_CLK_RATIO_POS 0
#define AXI_ADRV9001_TDD_CLK_RATIO_MASK 0x0fff


#endif

// **********************************************************************************
// **********************************************************************************

