// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Description:       AXI AXI_ADRV9001_GPIO Driver
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

#ifndef AXI_ADRV9001_GPIO_REGS_H
#define AXI_ADRV9001_GPIO_REGS_H

#define AXI_ADRV9001_GPIO_OFFSET 0x1000
#define AXI_ADRV9001_GPIO_MODE_SW_REG 0x0
#define AXI_ADRV9001_GPIO_MODE_SW_BUF 0x2
#define AXI_ADRV9001_GPIO_MODE_HW_TDD 0x1
#define AXI_ADRV9001_GPIO_HW_TX0_TDD_SEL 0x0
#define AXI_ADRV9001_GPIO_HW_RX0_TDD_SEL 0x1
#define AXI_ADRV9001_GPIO_HW_ORX0_TDD_SEL 0x2
#define AXI_ADRV9001_GPIO_HW_AUX0_TDD_SEL 0x3
#define AXI_ADRV9001_GPIO_HW_TX1_TDD_SEL 0x4
#define AXI_ADRV9001_GPIO_HW_RX1_TDD_SEL 0x5
#define AXI_ADRV9001_GPIO_HW_ORX1_TDD_SEL 0x6
#define AXI_ADRV9001_GPIO_HW_AUX1_TDD_SEL 0x7
#define AXI_ADRV9001_GPIO_HW_CTL0_TDD_SEL 0x8
#define AXI_ADRV9001_GPIO_HW_CTL1_TDD_SEL 0x9
#define AXI_ADRV9001_GPIO_HW_CTL2_TDD_SEL 0xa
#define AXI_ADRV9001_GPIO_HW_CTL3_TDD_SEL 0xb
#define AXI_ADRV9001_GPIO_BUF_TRIGGER_DISABLE 0x0
#define AXI_ADRV9001_GPIO_BUF_TRIGGER_RISING_EDGE 0x1
#define AXI_ADRV9001_GPIO_BUF_TRIGGER_FALLING_EDGE 0x2
#define AXI_ADRV9001_GPIO_BUF_TRIGGER_EDGE 0x3
#define AXI_ADRV9001_GPIO_IO_GROUP_DGPIO 0x0
#define AXI_ADRV9001_GPIO_IO_GROUP_RXSSI0 0x1
#define AXI_ADRV9001_GPIO_IO_GROUP_RXSSI1 0x2
#define AXI_ADRV9001_GPIO_IO_GROUP_TXSSI0 0x3
#define AXI_ADRV9001_GPIO_IO_GROUP_TXSSI1 0x4

#define AXI_ADRV9001_GPIO_REG_TIMER_ADDR 0x0000
#define AXI_ADRV9001_GPIO_TIMER_ADDR 0x0000
#define AXI_ADRV9001_GPIO_TIMER_POS 0
#define AXI_ADRV9001_GPIO_TIMER_MASK 0xffffffff

#define AXI_ADRV9001_GPIO_REG_DGPIO_PIO_DATA_ADDR 0x0100
#define AXI_ADRV9001_GPIO_DGPIO_PIO_DATA_ADDR 0x0100
#define AXI_ADRV9001_GPIO_DGPIO_PIO_DATA_POS 0
#define AXI_ADRV9001_GPIO_DGPIO_PIO_DATA_MASK 0x0fff

#define AXI_ADRV9001_GPIO_REG_DGPIO_PIO_DATA_OUT_ADDR 0x0104
#define AXI_ADRV9001_GPIO_DGPIO_PIO_DATA_OUT_ADDR 0x0104
#define AXI_ADRV9001_GPIO_DGPIO_PIO_DATA_OUT_POS 0
#define AXI_ADRV9001_GPIO_DGPIO_PIO_DATA_OUT_MASK 0x0fff

#define AXI_ADRV9001_GPIO_REG_DGPIO_PIO_DATA_OUT_ENB_ADDR 0x0108
#define AXI_ADRV9001_GPIO_DGPIO_PIO_DATA_OUT_ENB_ADDR 0x0108
#define AXI_ADRV9001_GPIO_DGPIO_PIO_DATA_OUT_ENB_POS 0
#define AXI_ADRV9001_GPIO_DGPIO_PIO_DATA_OUT_ENB_MASK 0x0fff

#define AXI_ADRV9001_GPIO_REG_DGPIO_PIO_DATA_MODE_ADDR 0x010c
#define AXI_ADRV9001_GPIO_DGPIO_PIO_DATA_MODE_ADDR 0x010c
#define AXI_ADRV9001_GPIO_DGPIO_PIO_DATA_MODE_POS 0
#define AXI_ADRV9001_GPIO_DGPIO_PIO_DATA_MODE_MASK 0x0fff

#define AXI_ADRV9001_GPIO_REG_DGPIO_PIO_SEL_ADDR 0x0110
#define AXI_ADRV9001_GPIO_REG_DGPIO_PIO_SEL_ADDR_OFFSET 0x0004
#define AXI_ADRV9001_GPIO_DGPIO_PIO_SEL_ADDR 0x0110
#define AXI_ADRV9001_GPIO_DGPIO_PIO_SEL_ADDR_OFFSET 0x0004
#define AXI_ADRV9001_GPIO_DGPIO_PIO_SEL_POS 0
#define AXI_ADRV9001_GPIO_DGPIO_PIO_SEL_MASK 0x000f

#define AXI_ADRV9001_GPIO_REG_DGPIO_PIO_BUF_ENABLE_ADDR 0x0180
#define AXI_ADRV9001_GPIO_DGPIO_PIO_BUF_ENABLE_ADDR 0x0180
#define AXI_ADRV9001_GPIO_DGPIO_PIO_BUF_ENABLE_POS 0
#define AXI_ADRV9001_GPIO_DGPIO_PIO_BUF_ENABLE_MASK 0x0001

#define AXI_ADRV9001_GPIO_REG_DGPIO_PIO_BUF_DATA_ADDR 0x0184
#define AXI_ADRV9001_GPIO_DGPIO_PIO_BUF_DATA_ADDR 0x0184
#define AXI_ADRV9001_GPIO_DGPIO_PIO_BUF_DATA_POS 0
#define AXI_ADRV9001_GPIO_DGPIO_PIO_BUF_DATA_MASK 0x0fff

#define AXI_ADRV9001_GPIO_REG_DGPIO_PIO_BUF_MODE_ADDR 0x018c
#define AXI_ADRV9001_GPIO_DGPIO_PIO_BUF_MODE_ADDR 0x018c
#define AXI_ADRV9001_GPIO_DGPIO_PIO_BUF_MODE_POS 0
#define AXI_ADRV9001_GPIO_DGPIO_PIO_BUF_MODE_MASK 0x0fff

#define AXI_ADRV9001_GPIO_REG_DGPIO_PIO_BUF_STATUS_ADDR 0x01a0
#define AXI_ADRV9001_GPIO_DGPIO_PIO_BUF_FULL_ADDR 0x01a0
#define AXI_ADRV9001_GPIO_DGPIO_PIO_BUF_FULL_POS 0
#define AXI_ADRV9001_GPIO_DGPIO_PIO_BUF_FULL_MASK 0x0001
#define AXI_ADRV9001_GPIO_DGPIO_PIO_BUF_EMPTY_ADDR 0x01a0
#define AXI_ADRV9001_GPIO_DGPIO_PIO_BUF_EMPTY_POS 1
#define AXI_ADRV9001_GPIO_DGPIO_PIO_BUF_EMPTY_MASK 0x0001

#define AXI_ADRV9001_GPIO_REG_DGPIO_PIO_BUF_TRIGGERS_ADDR 0x01c0
#define AXI_ADRV9001_GPIO_DGPIO_PIO_BUF_TRIGGER_MODE_ADDR 0x01c0
#define AXI_ADRV9001_GPIO_DGPIO_PIO_BUF_TRIGGER_MODE_POS 0
#define AXI_ADRV9001_GPIO_DGPIO_PIO_BUF_TRIGGER_MODE_MASK 0x0003
#define AXI_ADRV9001_GPIO_DGPIO_PIO_BUF_TRIGGER_MODE_POS_OFFSET 2

#define AXI_ADRV9001_GPIO_REG_RX0_PIO_DATA_ADDR 0x0200
#define AXI_ADRV9001_GPIO_RX0_PIO_DATA_ADDR 0x0200
#define AXI_ADRV9001_GPIO_RX0_PIO_DATA_POS 0
#define AXI_ADRV9001_GPIO_RX0_PIO_DATA_MASK 0x00ff

#define AXI_ADRV9001_GPIO_REG_RX0_PIO_DATA_OUT_ADDR 0x0204
#define AXI_ADRV9001_GPIO_RX0_PIO_DATA_OUT_ADDR 0x0204
#define AXI_ADRV9001_GPIO_RX0_PIO_DATA_OUT_POS 0
#define AXI_ADRV9001_GPIO_RX0_PIO_DATA_OUT_MASK 0x00ff

#define AXI_ADRV9001_GPIO_REG_RX0_PIO_DATA_OUT_ENB_ADDR 0x0208
#define AXI_ADRV9001_GPIO_RX0_PIO_DATA_OUT_ENB_ADDR 0x0208
#define AXI_ADRV9001_GPIO_RX0_PIO_DATA_OUT_ENB_POS 0
#define AXI_ADRV9001_GPIO_RX0_PIO_DATA_OUT_ENB_MASK 0x00ff

#define AXI_ADRV9001_GPIO_REG_RX1_PIO_DATA_ADDR 0x0300
#define AXI_ADRV9001_GPIO_RX1_PIO_DATA_ADDR 0x0300
#define AXI_ADRV9001_GPIO_RX1_PIO_DATA_POS 0
#define AXI_ADRV9001_GPIO_RX1_PIO_DATA_MASK 0x00ff

#define AXI_ADRV9001_GPIO_REG_RX1_PIO_DATA_OUT_ADDR 0x0304
#define AXI_ADRV9001_GPIO_RX1_PIO_DATA_OUT_ADDR 0x0304
#define AXI_ADRV9001_GPIO_RX1_PIO_DATA_OUT_POS 0
#define AXI_ADRV9001_GPIO_RX1_PIO_DATA_OUT_MASK 0x00ff

#define AXI_ADRV9001_GPIO_REG_RX1_PIO_DATA_OUT_ENB_ADDR 0x0308
#define AXI_ADRV9001_GPIO_RX1_PIO_DATA_OUT_ENB_ADDR 0x0308
#define AXI_ADRV9001_GPIO_RX1_PIO_DATA_OUT_ENB_POS 0
#define AXI_ADRV9001_GPIO_RX1_PIO_DATA_OUT_ENB_MASK 0x00ff

#define AXI_ADRV9001_GPIO_REG_TX0_PIO_DATA_ADDR 0x0400
#define AXI_ADRV9001_GPIO_TX0_PIO_DATA_ADDR 0x0400
#define AXI_ADRV9001_GPIO_TX0_PIO_DATA_POS 0
#define AXI_ADRV9001_GPIO_TX0_PIO_DATA_MASK 0x03ff

#define AXI_ADRV9001_GPIO_REG_TX0_PIO_DATA_OUT_ADDR 0x0404
#define AXI_ADRV9001_GPIO_TX0_PIO_DATA_OUT_ADDR 0x0404
#define AXI_ADRV9001_GPIO_TX0_PIO_DATA_OUT_POS 0
#define AXI_ADRV9001_GPIO_TX0_PIO_DATA_OUT_MASK 0x03ff

#define AXI_ADRV9001_GPIO_REG_TX0_PIO_DATA_OUT_ENB_ADDR 0x0408
#define AXI_ADRV9001_GPIO_TX0_PIO_DATA_OUT_ENB_ADDR 0x0408
#define AXI_ADRV9001_GPIO_TX0_PIO_DATA_OUT_ENB_POS 0
#define AXI_ADRV9001_GPIO_TX0_PIO_DATA_OUT_ENB_MASK 0x03ff

#define AXI_ADRV9001_GPIO_REG_TX1_PIO_DATA_ADDR 0x0500
#define AXI_ADRV9001_GPIO_TX1_PIO_DATA_ADDR 0x0500
#define AXI_ADRV9001_GPIO_TX1_PIO_DATA_POS 0
#define AXI_ADRV9001_GPIO_TX1_PIO_DATA_MASK 0x03ff

#define AXI_ADRV9001_GPIO_REG_TX1_PIO_DATA_OUT_ADDR 0x0504
#define AXI_ADRV9001_GPIO_TX1_PIO_DATA_OUT_ADDR 0x0504
#define AXI_ADRV9001_GPIO_TX1_PIO_DATA_OUT_POS 0
#define AXI_ADRV9001_GPIO_TX1_PIO_DATA_OUT_MASK 0x03ff

#define AXI_ADRV9001_GPIO_REG_TX1_PIO_DATA_OUT_ENB_ADDR 0x0508
#define AXI_ADRV9001_GPIO_TX1_PIO_DATA_OUT_ENB_ADDR 0x0508
#define AXI_ADRV9001_GPIO_TX1_PIO_DATA_OUT_ENB_POS 0
#define AXI_ADRV9001_GPIO_TX1_PIO_DATA_OUT_ENB_MASK 0x03ff

#define AXI_ADRV9001_GPIO_REG_TRIG_SRC_GROUP_ADDR 0x0600
#define AXI_ADRV9001_GPIO_TRIG_SRC_GROUP_ADDR 0x0600
#define AXI_ADRV9001_GPIO_TRIG_SRC_GROUP_POS 0
#define AXI_ADRV9001_GPIO_TRIG_SRC_GROUP_MASK 0x0007

#define AXI_ADRV9001_GPIO_REG_TRIG_SRC_PIN_ADDR 0x0604
#define AXI_ADRV9001_GPIO_TRIG_SRC_PIN_ADDR 0x0604
#define AXI_ADRV9001_GPIO_TRIG_SRC_PIN_POS 0
#define AXI_ADRV9001_GPIO_TRIG_SRC_PIN_MASK 0x000f

#define AXI_ADRV9001_GPIO_REG_GAININDEX_SRC_GROUP_ADDR 0x0700
#define AXI_ADRV9001_GPIO_GAININDEX_SRC_GROUP_ADDR 0x0700
#define AXI_ADRV9001_GPIO_GAININDEX_SRC_GROUP_POS 0
#define AXI_ADRV9001_GPIO_GAININDEX_SRC_GROUP_MASK 0x0007

#define AXI_ADRV9001_GPIO_REG_GAININDEX_SRC_PIN_ADDR 0x0704
#define AXI_ADRV9001_GPIO_REG_GAININDEX_SRC_PIN_ADDR_OFFSET 0x0004
#define AXI_ADRV9001_GPIO_GAININDEX_SRC_PIN_ADDR 0x0704
#define AXI_ADRV9001_GPIO_GAININDEX_SRC_PIN_ADDR_OFFSET 0x0004
#define AXI_ADRV9001_GPIO_GAININDEX_SRC_PIN_POS 0
#define AXI_ADRV9001_GPIO_GAININDEX_SRC_PIN_MASK 0x000f

#define AXI_ADRV9001_GPIO_REG_CLK_MON_ADDR 0x0800
#define AXI_ADRV9001_GPIO_CLK_MON_COUNT_ADDR 0x0800
#define AXI_ADRV9001_GPIO_CLK_MON_COUNT_POS 0
#define AXI_ADRV9001_GPIO_CLK_MON_COUNT_MASK 0xffffffff

#define AXI_ADRV9001_GPIO_REG_SSPI_SELECT_ADDR 0x0900
#define AXI_ADRV9001_GPIO_SSPI_SSN0_SEL_ADDR 0x0900
#define AXI_ADRV9001_GPIO_SSPI_SSN0_SEL_POS 0
#define AXI_ADRV9001_GPIO_SSPI_SSN0_SEL_MASK 0x000f
#define AXI_ADRV9001_GPIO_SSPI_SSN1_SEL_ADDR 0x0900
#define AXI_ADRV9001_GPIO_SSPI_SSN1_SEL_POS 4
#define AXI_ADRV9001_GPIO_SSPI_SSN1_SEL_MASK 0x000f
#define AXI_ADRV9001_GPIO_SSPI_SSN2_SEL_ADDR 0x0900
#define AXI_ADRV9001_GPIO_SSPI_SSN2_SEL_POS 8
#define AXI_ADRV9001_GPIO_SSPI_SSN2_SEL_MASK 0x000f
#define AXI_ADRV9001_GPIO_SSPI_SSN3_SEL_ADDR 0x0900
#define AXI_ADRV9001_GPIO_SSPI_SSN3_SEL_POS 12
#define AXI_ADRV9001_GPIO_SSPI_SSN3_SEL_MASK 0x000f

#define AXI_ADRV9001_GPIO_REG_SSPI_CONTROL_ADDR 0x0904
#define AXI_ADRV9001_GPIO_SSPI_BIDIR_COUNT_ADDR 0x0904
#define AXI_ADRV9001_GPIO_SSPI_BIDIR_COUNT_POS 0
#define AXI_ADRV9001_GPIO_SSPI_BIDIR_COUNT_MASK 0x000f
#define AXI_ADRV9001_GPIO_SSPI_BIDIR_ENABLE_ADDR 0x0904
#define AXI_ADRV9001_GPIO_SSPI_BIDIR_ENABLE_POS 4
#define AXI_ADRV9001_GPIO_SSPI_BIDIR_ENABLE_MASK 0x0001
#define AXI_ADRV9001_GPIO_SSPI_MISO_EDGE_SEL_ADDR 0x0904
#define AXI_ADRV9001_GPIO_SSPI_MISO_EDGE_SEL_POS 5
#define AXI_ADRV9001_GPIO_SSPI_MISO_EDGE_SEL_MASK 0x0001
#define AXI_ADRV9001_GPIO_SSPI_MOSI_EDGE_SEL_ADDR 0x0904
#define AXI_ADRV9001_GPIO_SSPI_MOSI_EDGE_SEL_POS 6
#define AXI_ADRV9001_GPIO_SSPI_MOSI_EDGE_SEL_MASK 0x0001

#define AXI_ADRV9001_GPIO_REG_SSPI_STATUS_ADDR 0x0908
#define AXI_ADRV9001_GPIO_SSPI_MOSI_FULL_ADDR 0x0908
#define AXI_ADRV9001_GPIO_SSPI_MOSI_FULL_POS 0
#define AXI_ADRV9001_GPIO_SSPI_MOSI_FULL_MASK 0x0001
#define AXI_ADRV9001_GPIO_SSPI_MOSI_EMPTY_ADDR 0x0908
#define AXI_ADRV9001_GPIO_SSPI_MOSI_EMPTY_POS 1
#define AXI_ADRV9001_GPIO_SSPI_MOSI_EMPTY_MASK 0x0001
#define AXI_ADRV9001_GPIO_SSPI_MISO_FULL_ADDR 0x0908
#define AXI_ADRV9001_GPIO_SSPI_MISO_FULL_POS 2
#define AXI_ADRV9001_GPIO_SSPI_MISO_FULL_MASK 0x0001
#define AXI_ADRV9001_GPIO_SSPI_MISO_EMPTY_ADDR 0x0908
#define AXI_ADRV9001_GPIO_SSPI_MISO_EMPTY_POS 3
#define AXI_ADRV9001_GPIO_SSPI_MISO_EMPTY_MASK 0x0001

#define AXI_ADRV9001_GPIO_REG_SSPI_SS_ADDR 0x090c
#define AXI_ADRV9001_GPIO_SSPI_SS_ADDR 0x090c
#define AXI_ADRV9001_GPIO_SSPI_SS_POS 0
#define AXI_ADRV9001_GPIO_SSPI_SS_MASK 0x000f

#define AXI_ADRV9001_GPIO_REG_SSPI_MOSI_DATA_ADDR 0x0910
#define AXI_ADRV9001_GPIO_SSPI_MOSI_DATA_ADDR 0x0910
#define AXI_ADRV9001_GPIO_SSPI_MOSI_DATA_POS 0
#define AXI_ADRV9001_GPIO_SSPI_MOSI_DATA_MASK 0x00ff

#define AXI_ADRV9001_GPIO_REG_SSPI_MISO_DATA_ADDR 0x0914
#define AXI_ADRV9001_GPIO_SSPI_MISO_DATA_ADDR 0x0914
#define AXI_ADRV9001_GPIO_SSPI_MISO_DATA_POS 0
#define AXI_ADRV9001_GPIO_SSPI_MISO_DATA_MASK 0x00ff

#define AXI_ADRV9001_GPIO_REG_SSPI_SWRESET_ADDR 0x0920
#define AXI_ADRV9001_GPIO_SSPI_SWRESET_ADDR 0x0920
#define AXI_ADRV9001_GPIO_SSPI_SWRESET_POS 0
#define AXI_ADRV9001_GPIO_SSPI_SWRESET_MASK 0x0001

#define AXI_ADRV9001_GPIO_REG_SSPI_ENABLE_ADDR 0x0924
#define AXI_ADRV9001_GPIO_SSPI_ENABLE_ADDR 0x0924
#define AXI_ADRV9001_GPIO_SSPI_ENABLE_POS 0
#define AXI_ADRV9001_GPIO_SSPI_ENABLE_MASK 0x0001


#endif

// **********************************************************************************
// **********************************************************************************

