## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Description:       AXI_ADRV9001 Interface Core
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################
## Interface

source ../../../bin/vivado_include.tcl

create_project axi_adrv9001 . -part xczu9eg-ffvb1156-2-e -force
msg_settings none
set_property ip_repo_paths {../..} [current_fileset]
update_ip_catalog

set ip_core_list {}
lappend ip_core_list ../../../library/axi_rxdma
lappend ip_core_list ../../../library/axi_txdma

set ip_source_list {}
lappend ip_source_list ../../common/hdl/pipe_1.v
lappend ip_source_list ../../common/hdl/pipe.v
lappend ip_source_list ../../common/hdl/cdc.v
lappend ip_source_list ../../common/hdl/cdc_constr.xdc
lappend ip_source_list ../../common/hdl/cdc_resetp.v
lappend ip_source_list ../../common/hdl/cdc_resetp_constr.xdc
lappend ip_source_list ../../common/hdl/cdc_cntrl.v
lappend ip_source_list ../../common/hdl/cdc_cntrl_constr.xdc
lappend ip_source_list ../../common/hdl/cdc_event.v
lappend ip_source_list ../../common/hdl/cdc_event_constr.xdc
lappend ip_source_list ../../common/hdl/clk_mon.v
lappend ip_source_list ../../common/hdl/clk_mon_constr.xdc
lappend ip_source_list ../../common/hdl/mem_sdp.v
lappend ip_source_list ../../common/hdl/mem_fifo.v
lappend ip_source_list ../../common/hdl/mem_buf.v
lappend ip_source_list ../../common/hdl/tdd_frame.v
lappend ip_source_list ../../common/hdl/tdd_enable.v
lappend ip_source_list ../../common/hdl/tdd_dma_enable.v
lappend ip_source_list ../../common/hdl/axilite_slave_if.v
lappend ip_source_list ../../common/hdl/axilite_block_if.v
lappend ip_source_list axi_adrv9001_gpio_sspi_constr.xdc
lappend ip_source_list axi_adrv9001_constr.xdc
lappend ip_source_list axi_adrv9001_rst_cntrl.v
lappend ip_source_list axi_adrv9001_rx_if.v
lappend ip_source_list axi_adrv9001_rx_dmon.v
lappend ip_source_list axi_adrv9001_rx_ss.v
lappend ip_source_list axi_adrv9001_rx.v
lappend ip_source_list axi_adrv9001_tx_if.v
lappend ip_source_list axi_adrv9001_tx_clk.v
lappend ip_source_list axi_adrv9001_tx_ss.v
lappend ip_source_list axi_adrv9001_tx_dgen.v
lappend ip_source_list axi_adrv9001_tx_dmgr.v
lappend ip_source_list axi_adrv9001_tx_fifo.v
lappend ip_source_list axi_adrv9001_tx.v
lappend ip_source_list axi_adrv9001_tdd.v
lappend ip_source_list axi_adrv9001_mcs.v
lappend ip_source_list axi_adrv9001_clkgen.v
lappend ip_source_list axi_adrv9001_gpio.v
lappend ip_source_list axi_adrv9001_gpio_sspi.v
lappend ip_source_list axi_adrv9001_ssi_regs.v
lappend ip_source_list axi_adrv9001_tdd_regs.v
lappend ip_source_list axi_adrv9001_top_regs.v
lappend ip_source_list axi_adrv9001_gpio_regs.v
lappend ip_source_list axi_adrv9001.v
set ip_file_list $ip_source_list
add_files -norecurse -fileset [get_filesets sources_1] $ip_file_list
set_property source_set sources_1 [get_filesets sim_1]
set_property top axi_adrv9001 [get_filesets sources_1]
set_property top axi_adrv9001 [get_filesets sim_1]

pkg_ip_core axi_adrv9001
add_ip_files $ip_file_list synthesis
add_ip_files $ip_file_list simulation
ipx::save_core

set ip_file_set [ipx::get_file_groups -filter {NAME =~ *synthesis*}]
set_property SCOPED_TO_REF axi_adrv9001 [ipx::get_files *axi_adrv9001_constr.xdc -of_objects $ip_file_set]
set_property SCOPED_TO_REF axi_adrv9001 [ipx::get_files *axi_adrv9001_gpio_sspi_constr.xdc -of_objects $ip_file_set]
set_property SCOPED_TO_REF cdc_event [ipx::get_files *cdc_event_constr.xdc -of_objects $ip_file_set]
set_property SCOPED_TO_REF cdc_cntrl [ipx::get_files *cdc_cntrl_constr.xdc -of_objects $ip_file_set]
set_property SCOPED_TO_REF cdc_resetp [ipx::get_files *cdc_resetp_constr.xdc -of_objects $ip_file_set]
set_property SCOPED_TO_REF cdc [ipx::get_files *cdc_constr.xdc -of_objects $ip_file_set]
ipx::save_core

set_property driver_value 0 [ipx::get_ports *trig* -of_objects [ipx::current_core]]
set_property driver_value 0 [ipx::get_ports *usr_gpio_in* -of_objects [ipx::current_core]]
ipx::save_core

## ##################################################################################
## ##################################################################################
