// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Description:       AXI_ADRV9001, transmit super sampling (interpolation)
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module axi_adrv9001_tx_ss (

    // transmit interface

    input   wire            tx_clk,
    input   wire            tx_resetn,
    input   wire            tx_ss_enable,
    input   wire            tx_ss_read,
    output  reg             tx_ss_valid = 'd0,
    output  reg   [ 63:0]   tx_ss_data = 'd0,
    input   wire  [  2:0]   tx_ss_ratio,
    input   wire  [  2:0]   tx_num_of_bits,
    output  reg             tx_sync = 'd0,
    output  reg             tx_read = 'd0,
    input   wire            tx_valid,
    input   wire  [ 63:0]   tx_data);

    // internal registers
 
    reg           [ 63:0]   tx_data_08 = 'd0;
    reg           [ 63:0]   tx_data_16 = 'd0;
    reg           [ 63:0]   tx_data_32 = 'd0;
    reg           [ 63:0]   tx_data_64 = 'd0;
    reg           [ 63:0]   tx_data_hold = 'd0;
    reg           [ 63:0]   tx_data_int = 'd0;
    reg                     tx_read_int_d = 'd0;
    reg           [  4:0]   tx_ss_cnt = 'd0;
    reg           [  4:0]   tx_ss_max = 'd0;

    // internal signals

    wire                    tx_read_int;
    wire          [  7:0]   tx_ss_sel;

    // super sampling (interpolation with repetition)

    always @(posedge tx_clk) begin
        if (tx_read_int == 1'd1) begin
            case (tx_ss_sel)
                8'b00000000: begin
                    tx_data_08 <= tx_data_int;
                end
                8'b00100000: begin
                    tx_data_08[63:56] <= tx_data_int[31:24];
                    tx_data_08[55:48] <= tx_data_int[31:24];
                    tx_data_08[47:40] <= tx_data_int[23:16];
                    tx_data_08[39:32] <= tx_data_int[23:16];
                    tx_data_08[31:24] <= tx_data_int[15: 8];
                    tx_data_08[23:16] <= tx_data_int[15: 8];
                    tx_data_08[15: 8] <= tx_data_int[ 7: 0];
                    tx_data_08[ 7: 0] <= tx_data_int[ 7: 0];
                end
                8'b00100001: begin
                    tx_data_08[63:56] <= tx_data_int[63:56];
                    tx_data_08[55:48] <= tx_data_int[63:56];
                    tx_data_08[47:40] <= tx_data_int[55:48];
                    tx_data_08[39:32] <= tx_data_int[55:48];
                    tx_data_08[31:24] <= tx_data_int[47:40];
                    tx_data_08[23:16] <= tx_data_int[47:40];
                    tx_data_08[15: 8] <= tx_data_int[39:32];
                    tx_data_08[ 7: 0] <= tx_data_int[39:32];
                end
                8'b01000000: begin
                    tx_data_08[63:56] <= tx_data_int[15:8];
                    tx_data_08[55:48] <= tx_data_int[15:8];
                    tx_data_08[47:40] <= tx_data_int[15:8];
                    tx_data_08[39:32] <= tx_data_int[15:8];
                    tx_data_08[31:24] <= tx_data_int[ 7:0];
                    tx_data_08[23:16] <= tx_data_int[ 7:0];
                    tx_data_08[15: 8] <= tx_data_int[ 7:0];
                    tx_data_08[ 7: 0] <= tx_data_int[ 7:0];
                end
                8'b01000001: begin
                    tx_data_08[63:56] <= tx_data_int[31:24];
                    tx_data_08[55:48] <= tx_data_int[31:24];
                    tx_data_08[47:40] <= tx_data_int[31:24];
                    tx_data_08[39:32] <= tx_data_int[31:24];
                    tx_data_08[31:24] <= tx_data_int[23:16];
                    tx_data_08[23:16] <= tx_data_int[23:16];
                    tx_data_08[15: 8] <= tx_data_int[23:16];
                    tx_data_08[ 7: 0] <= tx_data_int[23:16];
                end
                8'b01000010: begin
                    tx_data_08[63:56] <= tx_data_int[47:40];
                    tx_data_08[55:48] <= tx_data_int[47:40];
                    tx_data_08[47:40] <= tx_data_int[47:40];
                    tx_data_08[39:32] <= tx_data_int[47:40];
                    tx_data_08[31:24] <= tx_data_int[39:32];
                    tx_data_08[23:16] <= tx_data_int[39:32];
                    tx_data_08[15: 8] <= tx_data_int[39:32];
                    tx_data_08[ 7: 0] <= tx_data_int[39:32];
                end
                8'b01000011: begin
                    tx_data_08[63:56] <= tx_data_int[63:56];
                    tx_data_08[55:48] <= tx_data_int[63:56];
                    tx_data_08[47:40] <= tx_data_int[63:56];
                    tx_data_08[39:32] <= tx_data_int[63:56];
                    tx_data_08[31:24] <= tx_data_int[55:48];
                    tx_data_08[23:16] <= tx_data_int[55:48];
                    tx_data_08[15: 8] <= tx_data_int[55:48];
                    tx_data_08[ 7: 0] <= tx_data_int[55:48];
                end
                8'b01100000, 8'b10000000, 8'b10100000: begin
                    tx_data_08[63:56] <= tx_data_int[7:0];
                    tx_data_08[55:48] <= tx_data_int[7:0];
                    tx_data_08[47:40] <= tx_data_int[7:0];
                    tx_data_08[39:32] <= tx_data_int[7:0];
                    tx_data_08[31:24] <= tx_data_int[7:0];
                    tx_data_08[23:16] <= tx_data_int[7:0];
                    tx_data_08[15: 8] <= tx_data_int[7:0];
                    tx_data_08[ 7: 0] <= tx_data_int[7:0];
                end
                8'b01100001, 8'b10000010, 8'b10100100: begin
                    tx_data_08[63:56] <= tx_data_int[15:8];
                    tx_data_08[55:48] <= tx_data_int[15:8];
                    tx_data_08[47:40] <= tx_data_int[15:8];
                    tx_data_08[39:32] <= tx_data_int[15:8];
                    tx_data_08[31:24] <= tx_data_int[15:8];
                    tx_data_08[23:16] <= tx_data_int[15:8];
                    tx_data_08[15: 8] <= tx_data_int[15:8];
                    tx_data_08[ 7: 0] <= tx_data_int[15:8];
                end
                8'b01100010, 8'b10000100, 8'b10101000: begin
                    tx_data_08[63:56] <= tx_data_int[23:16];
                    tx_data_08[55:48] <= tx_data_int[23:16];
                    tx_data_08[47:40] <= tx_data_int[23:16];
                    tx_data_08[39:32] <= tx_data_int[23:16];
                    tx_data_08[31:24] <= tx_data_int[23:16];
                    tx_data_08[23:16] <= tx_data_int[23:16];
                    tx_data_08[15: 8] <= tx_data_int[23:16];
                    tx_data_08[ 7: 0] <= tx_data_int[23:16];
                end
                8'b01100011, 8'b10000110, 8'b10101100: begin
                    tx_data_08[63:56] <= tx_data_int[31:24];
                    tx_data_08[55:48] <= tx_data_int[31:24];
                    tx_data_08[47:40] <= tx_data_int[31:24];
                    tx_data_08[39:32] <= tx_data_int[31:24];
                    tx_data_08[31:24] <= tx_data_int[31:24];
                    tx_data_08[23:16] <= tx_data_int[31:24];
                    tx_data_08[15: 8] <= tx_data_int[31:24];
                    tx_data_08[ 7: 0] <= tx_data_int[31:24];
                end
                8'b01100100, 8'b10001000, 8'b10110000: begin
                    tx_data_08[63:56] <= tx_data_int[39:32];
                    tx_data_08[55:48] <= tx_data_int[39:32];
                    tx_data_08[47:40] <= tx_data_int[39:32];
                    tx_data_08[39:32] <= tx_data_int[39:32];
                    tx_data_08[31:24] <= tx_data_int[39:32];
                    tx_data_08[23:16] <= tx_data_int[39:32];
                    tx_data_08[15: 8] <= tx_data_int[39:32];
                    tx_data_08[ 7: 0] <= tx_data_int[39:32];
                end
                8'b01100101, 8'b10001010, 8'b10110100: begin
                    tx_data_08[63:56] <= tx_data_int[47:40];
                    tx_data_08[55:48] <= tx_data_int[47:40];
                    tx_data_08[47:40] <= tx_data_int[47:40];
                    tx_data_08[39:32] <= tx_data_int[47:40];
                    tx_data_08[31:24] <= tx_data_int[47:40];
                    tx_data_08[23:16] <= tx_data_int[47:40];
                    tx_data_08[15: 8] <= tx_data_int[47:40];
                    tx_data_08[ 7: 0] <= tx_data_int[47:40];
                end
                8'b01100110, 8'b10001100, 8'b10111000: begin
                    tx_data_08[63:56] <= tx_data_int[55:48];
                    tx_data_08[55:48] <= tx_data_int[55:48];
                    tx_data_08[47:40] <= tx_data_int[55:48];
                    tx_data_08[39:32] <= tx_data_int[55:48];
                    tx_data_08[31:24] <= tx_data_int[55:48];
                    tx_data_08[23:16] <= tx_data_int[55:48];
                    tx_data_08[15: 8] <= tx_data_int[55:48];
                    tx_data_08[ 7: 0] <= tx_data_int[55:48];
                end
                8'b01100111, 8'b10001110, 8'b10111100: begin
                    tx_data_08[63:56] <= tx_data_int[63:56];
                    tx_data_08[55:48] <= tx_data_int[63:56];
                    tx_data_08[47:40] <= tx_data_int[63:56];
                    tx_data_08[39:32] <= tx_data_int[63:56];
                    tx_data_08[31:24] <= tx_data_int[63:56];
                    tx_data_08[23:16] <= tx_data_int[63:56];
                    tx_data_08[15: 8] <= tx_data_int[63:56];
                    tx_data_08[ 7: 0] <= tx_data_int[63:56];
                end
                default: begin
                    tx_data_08 <= tx_data_08;
                end
            endcase
        end
    end

    always @(posedge tx_clk) begin
        if (tx_read_int == 1'd1) begin
            case (tx_ss_sel)
                8'b00000000: begin
                    tx_data_16 <= tx_data_int;
                end
                8'b00100000: begin
                    tx_data_16[63:48] <= tx_data_int[31:16];
                    tx_data_16[47:32] <= tx_data_int[31:16];
                    tx_data_16[31:16] <= tx_data_int[15: 0];
                    tx_data_16[15: 0] <= tx_data_int[15: 0];
                end
                8'b00100001: begin
                    tx_data_16[63:48] <= tx_data_int[63:48];
                    tx_data_16[47:32] <= tx_data_int[63:48];
                    tx_data_16[31:16] <= tx_data_int[47:32];
                    tx_data_16[15: 0] <= tx_data_int[47:32];
                end
                8'b01000000, 8'b01100000, 8'b10000000,
                8'b10100000: begin
                    tx_data_16[63:48] <= tx_data_int[15:0];
                    tx_data_16[47:32] <= tx_data_int[15:0];
                    tx_data_16[31:16] <= tx_data_int[15:0];
                    tx_data_16[15: 0] <= tx_data_int[15:0];
                end
                8'b01000001, 8'b01100010, 8'b10000100,
                8'b10101000: begin
                    tx_data_16[63:48] <= tx_data_int[31:16];
                    tx_data_16[47:32] <= tx_data_int[31:16];
                    tx_data_16[31:16] <= tx_data_int[31:16];
                    tx_data_16[15: 0] <= tx_data_int[31:16];
                end
                8'b01000010, 8'b01100100, 8'b10001000,
                8'b10110000: begin
                    tx_data_16[63:48] <= tx_data_int[47:32];
                    tx_data_16[47:32] <= tx_data_int[47:32];
                    tx_data_16[31:16] <= tx_data_int[47:32];
                    tx_data_16[15: 0] <= tx_data_int[47:32];
                end
                8'b01000011, 8'b01100110, 8'b10001100,
                8'b10111000: begin
                    tx_data_16[63:48] <= tx_data_int[63:48];
                    tx_data_16[47:32] <= tx_data_int[63:48];
                    tx_data_16[31:16] <= tx_data_int[63:48];
                    tx_data_16[15: 0] <= tx_data_int[63:48];
                end
                default: begin
                    tx_data_16 <= tx_data_16;
                end
            endcase
        end
    end

    always @(posedge tx_clk) begin
        if (tx_read_int == 1'd1) begin
            case (tx_ss_sel)
                8'b00000000: begin
                    tx_data_32 <= tx_data_int;
                end
                8'b00100000, 8'b01000000, 8'b01100000,
                8'b10000000, 8'b10100000: begin
                    tx_data_32[63:32] <= tx_data_int[31:0];
                    tx_data_32[31: 0] <= tx_data_int[31:0];
                end
                8'b00100001, 8'b01000010, 8'b01100100,
                8'b10001000, 8'b10110000: begin
                    tx_data_32[63:32] <= tx_data_int[63:32];
                    tx_data_32[31: 0] <= tx_data_int[63:32];
                end
                default: begin
                    tx_data_32 <= tx_data_32;
                end
            endcase
        end
    end

    always @(posedge tx_clk) begin
        if ((tx_read_int == 1'd1) && (tx_ss_cnt == 5'd0)) begin
            tx_data_64 <= tx_data_int;
        end
    end

    assign tx_read_int = tx_ss_read & tx_ss_enable;

    always @(negedge tx_resetn or posedge tx_clk) begin
        if (tx_resetn == 1'b0) begin
            tx_data_hold <= 64'd0;
            tx_data_int <= 64'd0;
            tx_read_int_d <= 1'd0;
        end else begin
            if (tx_valid == 1'd1) begin
                tx_data_hold <= tx_data;
            end
            if ((tx_read_int == 1'd1) && (tx_ss_cnt >= tx_ss_max)) begin
                tx_data_int <= tx_data_hold;
            end
            tx_read_int_d <= tx_read_int;
        end
    end

    always @(negedge tx_resetn or posedge tx_clk) begin
        if (tx_resetn == 1'b0) begin
            tx_sync <= 1'd0;
            tx_read <= 1'd0;
            tx_ss_valid <= 1'd0;
            tx_ss_data <= 64'd0;
        end else begin
            tx_sync <= tx_ss_read;
            if (tx_ss_cnt >= tx_ss_max) begin
                tx_read <= tx_read_int;
            end else begin
                tx_read <= 1'd0;
            end
            tx_ss_valid <= tx_read_int_d;
            case (tx_num_of_bits)
                3'b101: tx_ss_data <= tx_data_64;
                3'b100: tx_ss_data <= tx_data_32;
                3'b011: tx_ss_data <= tx_data_32;
                3'b010: tx_ss_data <= tx_data_16;
                3'b001: tx_ss_data <= tx_data_08;
                3'b000: tx_ss_data <= tx_data_08;
                default: tx_ss_data <= 64'd0;
            endcase
        end
    end

    assign tx_ss_sel = {tx_ss_ratio, tx_ss_cnt};

    always @(negedge tx_resetn or posedge tx_clk) begin
        if (tx_resetn == 1'b0) begin
            tx_ss_cnt <= 5'd0;
        end else if (tx_read_int == 1'b1) begin
            if (tx_ss_cnt >= tx_ss_max) begin
                tx_ss_cnt <= 5'd0;
            end else begin
                tx_ss_cnt <= tx_ss_cnt + 1'b1;
            end
        end
    end

    always @(negedge tx_resetn or posedge tx_clk) begin
        if (tx_resetn == 1'b0) begin
            tx_ss_max <= 5'h00;
        end else begin
            case (tx_ss_ratio)
                3'd5: tx_ss_max <= 5'h1f;
                3'd4: tx_ss_max <= 5'h0f;
                3'd3: tx_ss_max <= 5'h07;
                3'd2: tx_ss_max <= 5'h03;
                3'd1: tx_ss_max <= 5'h01;
                default: tx_ss_max <= 5'h00;
            endcase
        end
    end

endmodule

// **********************************************************************************
// **********************************************************************************
