// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Description:       AXI_ADRV9001, transmit loop back fifo
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module axi_adrv9001_tx_fifo (

    // receive interface

    input   wire            rx_clk,
    input   wire            rx_resetn,
    input   wire            rx_valid,
    input   wire  [ 63:0]   rx_data,

    // transmit interface

    input   wire            tx_clk,
    input   wire            tx_resetn,
    input   wire            tx_read,
    output  wire            tx_valid,
    output  reg   [ 63:0]   tx_data = 'd0,

    // axilite interface

    input   wire            axilite_clk,
    input   wire            axilite_resetn,
    output  wire            axilite_ovf,
    output  wire            axilite_unf);

    // internal signals
 
    wire                    rx_full;
    wire                    rx_ovf;
    wire          [ 63:0]   tx_rddata;
    wire                    tx_empty;
    wire                    tx_unf;

    // overflow and underflow

    assign rx_ovf = rx_valid & rx_full;
    assign tx_unf = tx_read & tx_empty;

    always @(negedge tx_resetn or posedge tx_clk) begin
        if (tx_resetn == 1'd0) begin
            tx_data <= 64'd0;
        end else begin
            if (tx_valid == 1'd1) begin
                tx_data <= tx_rddata;
            end
        end
    end

    // instantiations
 
    cdc_event #(.DATA_WIDTH(1)) i_rx_cdc (
        .src_resetn           (rx_resetn),
        .src_clk              (rx_clk),
        .src_data             (rx_ovf),
        .dest_resetn          (axilite_resetn),
        .dest_clk             (axilite_clk),
        .dest_data            (axilite_ovf));

    cdc_event #(.DATA_WIDTH(1)) i_tx_cdc (
        .src_resetn           (tx_resetn),
        .src_clk              (tx_clk),
        .src_data             (tx_unf),
        .dest_resetn          (axilite_resetn),
        .dest_clk             (axilite_clk),
        .dest_data            (axilite_unf));

    mem_fifo #(.DATA_WIDTH(64)) i_tx_fifo (
        .wr_clk               (rx_clk),
        .wr_resetn            (rx_resetn),
        .wr_valid             (rx_valid),
        .wr_data              (rx_data),
        .wr_limit             (rx_full),
        .rd_clk               (tx_clk),
        .rd_resetn            (tx_resetn),
        .rd_read              (tx_read),
        .rd_valid             (tx_valid),
        .rd_data              (tx_rddata),
        .rd_empty             (tx_empty));

endmodule

// ***************************************************************************
// ***************************************************************************
