// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Description:       AXI_ADRV9001, transmit data manager
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module axi_adrv9001_tx_dmgr (

    // transmit interface

    input   wire            tx_clk,
    input   wire            tx_resetn,

    input   wire            tx_valid,
    input   wire  [ 63:0]   tx_data,
    input   wire            tx_q1_i0,
    input   wire            tx_ss_mode,
    input   wire  [  2:0]   tx_ss_ratio,
    input   wire            tx_lsb1_msb0,
    input   wire            tx_cmos1_lvds0,
    input   wire  [  2:0]   tx_num_of_bits,
    input   wire            tx_lstrb1_pstrb0,
    input   wire            tx_mlane1_slane0,

    input   wire            tx_rdvalid,
    output  reg   [ 31:0]   tx_rdstrobe = 'd0,
    output  reg   [ 31:0]   tx_rddata = 'd0,
    output  reg   [  7:0]   tx_rddata_h = 'd0);

    // internal registers
 
    reg                     tx_valid_iq = 'd0;
    reg           [ 63:0]   tx_data_iq = 'd0;
    reg                     tx_valid_64 = 'd0;
    reg           [ 63:0]   tx_data_64 = 'd0;
    reg                     tx_wrcnt = 'd0;
    reg                     tx_wrvalid_0 = 'd0;
    reg           [ 31:0]   tx_wrdata_0 = 'd0;
    reg                     tx_wrvalid_1 = 'd0;
    reg           [ 31:0]   tx_wrdata_1 = 'd0;
    reg                     tx_wrvalid_2 = 'd0;
    reg           [ 31:0]   tx_wrdata_2 = 'd0;
    reg                     tx_wrvalid_3 = 'd0;
    reg           [ 31:0]   tx_wrdata_3 = 'd0;
    reg           [  1:0]   tx_rdcnt = 'd0;
    reg           [  4:0]   tx_ss_cnt = 'd0;
    reg           [  4:0]   tx_ss_max = 'd0;

    // internal signals

    wire                    tx_swap_iq;
    wire                    tx_rdvalid_m;
    wire                    tx_rdvalid_w;
    wire          [  4:0]   tx_ss_cnt_max;

    // iq swap

    assign tx_swap_iq = ((tx_cmos1_lvds0 == 1'b0) || ((tx_cmos1_lvds0 == 1'b1) &&
        (tx_num_of_bits == 3'd4))) ? tx_q1_i0 : 1'b0;

    always @(posedge tx_clk) begin
        tx_valid_iq <= tx_valid;
        if (tx_swap_iq == 1'b1) begin
            tx_data_iq <= {tx_data[47:32], tx_data[63:48],
                tx_data[15:0], tx_data[31:16]};
        end else begin
            tx_data_iq <= tx_data;
        end
    end

    // lsb-msb swap

    always @(posedge tx_clk) begin
        tx_valid_64 <= tx_valid_iq;
        case ({tx_lsb1_msb0, tx_num_of_bits})
            4'b1000: begin
                tx_data_64[63] <= tx_data_iq[63];
                tx_data_64[62] <= tx_data_iq[62];
                tx_data_64[61] <= tx_data_iq[61];
                tx_data_64[60] <= tx_data_iq[60];
                tx_data_64[59] <= tx_data_iq[59];
                tx_data_64[58] <= tx_data_iq[58];
                tx_data_64[57] <= tx_data_iq[56];
                tx_data_64[56] <= tx_data_iq[57];
                tx_data_64[55] <= tx_data_iq[55];
                tx_data_64[54] <= tx_data_iq[54];
                tx_data_64[53] <= tx_data_iq[53];
                tx_data_64[52] <= tx_data_iq[52];
                tx_data_64[51] <= tx_data_iq[51];
                tx_data_64[50] <= tx_data_iq[50];
                tx_data_64[49] <= tx_data_iq[48];
                tx_data_64[48] <= tx_data_iq[49];
                tx_data_64[47] <= tx_data_iq[47];
                tx_data_64[46] <= tx_data_iq[46];
                tx_data_64[45] <= tx_data_iq[45];
                tx_data_64[44] <= tx_data_iq[44];
                tx_data_64[43] <= tx_data_iq[43];
                tx_data_64[42] <= tx_data_iq[42];
                tx_data_64[41] <= tx_data_iq[40];
                tx_data_64[40] <= tx_data_iq[41];
                tx_data_64[39] <= tx_data_iq[39];
                tx_data_64[38] <= tx_data_iq[38];
                tx_data_64[37] <= tx_data_iq[37];
                tx_data_64[36] <= tx_data_iq[36];
                tx_data_64[35] <= tx_data_iq[35];
                tx_data_64[34] <= tx_data_iq[34];
                tx_data_64[33] <= tx_data_iq[32];
                tx_data_64[32] <= tx_data_iq[33];
                tx_data_64[31] <= tx_data_iq[31];
                tx_data_64[30] <= tx_data_iq[30];
                tx_data_64[29] <= tx_data_iq[29];
                tx_data_64[28] <= tx_data_iq[28];
                tx_data_64[27] <= tx_data_iq[27];
                tx_data_64[26] <= tx_data_iq[26];
                tx_data_64[25] <= tx_data_iq[24];
                tx_data_64[24] <= tx_data_iq[25];
                tx_data_64[23] <= tx_data_iq[23];
                tx_data_64[22] <= tx_data_iq[22];
                tx_data_64[21] <= tx_data_iq[21];
                tx_data_64[20] <= tx_data_iq[20];
                tx_data_64[19] <= tx_data_iq[19];
                tx_data_64[18] <= tx_data_iq[18];
                tx_data_64[17] <= tx_data_iq[16];
                tx_data_64[16] <= tx_data_iq[17];
                tx_data_64[15] <= tx_data_iq[15];
                tx_data_64[14] <= tx_data_iq[14];
                tx_data_64[13] <= tx_data_iq[13];
                tx_data_64[12] <= tx_data_iq[12];
                tx_data_64[11] <= tx_data_iq[11];
                tx_data_64[10] <= tx_data_iq[10];
                tx_data_64[ 9] <= tx_data_iq[ 8];
                tx_data_64[ 8] <= tx_data_iq[ 9];
                tx_data_64[ 7] <= tx_data_iq[ 7];
                tx_data_64[ 6] <= tx_data_iq[ 6];
                tx_data_64[ 5] <= tx_data_iq[ 5];
                tx_data_64[ 4] <= tx_data_iq[ 4];
                tx_data_64[ 3] <= tx_data_iq[ 3];
                tx_data_64[ 2] <= tx_data_iq[ 2];
                tx_data_64[ 1] <= tx_data_iq[ 0];
                tx_data_64[ 0] <= tx_data_iq[ 1];
            end
            4'b1001: begin
                tx_data_64[63] <= tx_data_iq[56];
                tx_data_64[62] <= tx_data_iq[57];
                tx_data_64[61] <= tx_data_iq[58];
                tx_data_64[60] <= tx_data_iq[59];
                tx_data_64[59] <= tx_data_iq[60];
                tx_data_64[58] <= tx_data_iq[61];
                tx_data_64[57] <= tx_data_iq[62];
                tx_data_64[56] <= tx_data_iq[63];
                tx_data_64[55] <= tx_data_iq[48];
                tx_data_64[54] <= tx_data_iq[49];
                tx_data_64[53] <= tx_data_iq[50];
                tx_data_64[52] <= tx_data_iq[51];
                tx_data_64[51] <= tx_data_iq[52];
                tx_data_64[50] <= tx_data_iq[53];
                tx_data_64[49] <= tx_data_iq[54];
                tx_data_64[48] <= tx_data_iq[55];
                tx_data_64[47] <= tx_data_iq[40];
                tx_data_64[46] <= tx_data_iq[41];
                tx_data_64[45] <= tx_data_iq[42];
                tx_data_64[44] <= tx_data_iq[43];
                tx_data_64[43] <= tx_data_iq[44];
                tx_data_64[42] <= tx_data_iq[45];
                tx_data_64[41] <= tx_data_iq[46];
                tx_data_64[40] <= tx_data_iq[47];
                tx_data_64[39] <= tx_data_iq[32];
                tx_data_64[38] <= tx_data_iq[33];
                tx_data_64[37] <= tx_data_iq[34];
                tx_data_64[36] <= tx_data_iq[35];
                tx_data_64[35] <= tx_data_iq[36];
                tx_data_64[34] <= tx_data_iq[37];
                tx_data_64[33] <= tx_data_iq[38];
                tx_data_64[32] <= tx_data_iq[39];
                tx_data_64[31] <= tx_data_iq[24];
                tx_data_64[30] <= tx_data_iq[25];
                tx_data_64[29] <= tx_data_iq[26];
                tx_data_64[28] <= tx_data_iq[27];
                tx_data_64[27] <= tx_data_iq[28];
                tx_data_64[26] <= tx_data_iq[29];
                tx_data_64[25] <= tx_data_iq[30];
                tx_data_64[24] <= tx_data_iq[31];
                tx_data_64[23] <= tx_data_iq[16];
                tx_data_64[22] <= tx_data_iq[17];
                tx_data_64[21] <= tx_data_iq[18];
                tx_data_64[20] <= tx_data_iq[19];
                tx_data_64[19] <= tx_data_iq[20];
                tx_data_64[18] <= tx_data_iq[21];
                tx_data_64[17] <= tx_data_iq[22];
                tx_data_64[16] <= tx_data_iq[23];
                tx_data_64[15] <= tx_data_iq[ 8];
                tx_data_64[14] <= tx_data_iq[ 9];
                tx_data_64[13] <= tx_data_iq[10];
                tx_data_64[12] <= tx_data_iq[11];
                tx_data_64[11] <= tx_data_iq[12];
                tx_data_64[10] <= tx_data_iq[13];
                tx_data_64[ 9] <= tx_data_iq[14];
                tx_data_64[ 8] <= tx_data_iq[15];
                tx_data_64[ 7] <= tx_data_iq[ 0];
                tx_data_64[ 6] <= tx_data_iq[ 1];
                tx_data_64[ 5] <= tx_data_iq[ 2];
                tx_data_64[ 4] <= tx_data_iq[ 3];
                tx_data_64[ 3] <= tx_data_iq[ 4];
                tx_data_64[ 2] <= tx_data_iq[ 5];
                tx_data_64[ 1] <= tx_data_iq[ 6];
                tx_data_64[ 0] <= tx_data_iq[ 7];
            end
            4'b1010: begin
                tx_data_64[63] <= tx_data_iq[48];
                tx_data_64[62] <= tx_data_iq[49];
                tx_data_64[61] <= tx_data_iq[50];
                tx_data_64[60] <= tx_data_iq[51];
                tx_data_64[59] <= tx_data_iq[52];
                tx_data_64[58] <= tx_data_iq[53];
                tx_data_64[57] <= tx_data_iq[54];
                tx_data_64[56] <= tx_data_iq[55];
                tx_data_64[55] <= tx_data_iq[56];
                tx_data_64[54] <= tx_data_iq[57];
                tx_data_64[53] <= tx_data_iq[58];
                tx_data_64[52] <= tx_data_iq[59];
                tx_data_64[51] <= tx_data_iq[60];
                tx_data_64[50] <= tx_data_iq[61];
                tx_data_64[49] <= tx_data_iq[62];
                tx_data_64[48] <= tx_data_iq[63];
                tx_data_64[47] <= tx_data_iq[32];
                tx_data_64[46] <= tx_data_iq[33];
                tx_data_64[45] <= tx_data_iq[34];
                tx_data_64[44] <= tx_data_iq[35];
                tx_data_64[43] <= tx_data_iq[36];
                tx_data_64[42] <= tx_data_iq[37];
                tx_data_64[41] <= tx_data_iq[38];
                tx_data_64[40] <= tx_data_iq[39];
                tx_data_64[39] <= tx_data_iq[40];
                tx_data_64[38] <= tx_data_iq[41];
                tx_data_64[37] <= tx_data_iq[42];
                tx_data_64[36] <= tx_data_iq[43];
                tx_data_64[35] <= tx_data_iq[44];
                tx_data_64[34] <= tx_data_iq[45];
                tx_data_64[33] <= tx_data_iq[46];
                tx_data_64[32] <= tx_data_iq[47];
                tx_data_64[31] <= tx_data_iq[16];
                tx_data_64[30] <= tx_data_iq[17];
                tx_data_64[29] <= tx_data_iq[18];
                tx_data_64[28] <= tx_data_iq[19];
                tx_data_64[27] <= tx_data_iq[20];
                tx_data_64[26] <= tx_data_iq[21];
                tx_data_64[25] <= tx_data_iq[22];
                tx_data_64[24] <= tx_data_iq[23];
                tx_data_64[23] <= tx_data_iq[24];
                tx_data_64[22] <= tx_data_iq[25];
                tx_data_64[21] <= tx_data_iq[26];
                tx_data_64[20] <= tx_data_iq[27];
                tx_data_64[19] <= tx_data_iq[28];
                tx_data_64[18] <= tx_data_iq[29];
                tx_data_64[17] <= tx_data_iq[30];
                tx_data_64[16] <= tx_data_iq[31];
                tx_data_64[15] <= tx_data_iq[ 0];
                tx_data_64[14] <= tx_data_iq[ 1];
                tx_data_64[13] <= tx_data_iq[ 2];
                tx_data_64[12] <= tx_data_iq[ 3];
                tx_data_64[11] <= tx_data_iq[ 4];
                tx_data_64[10] <= tx_data_iq[ 5];
                tx_data_64[ 9] <= tx_data_iq[ 6];
                tx_data_64[ 8] <= tx_data_iq[ 7];
                tx_data_64[ 7] <= tx_data_iq[ 8];
                tx_data_64[ 6] <= tx_data_iq[ 9];
                tx_data_64[ 5] <= tx_data_iq[10];
                tx_data_64[ 4] <= tx_data_iq[11];
                tx_data_64[ 3] <= tx_data_iq[12];
                tx_data_64[ 2] <= tx_data_iq[13];
                tx_data_64[ 1] <= tx_data_iq[14];
                tx_data_64[ 0] <= tx_data_iq[15];
            end
            4'b1011: begin
                tx_data_64[63] <= tx_data_iq[63];
                tx_data_64[62] <= tx_data_iq[62];
                tx_data_64[61] <= tx_data_iq[61];
                tx_data_64[60] <= tx_data_iq[60];
                tx_data_64[59] <= tx_data_iq[48];
                tx_data_64[58] <= tx_data_iq[49];
                tx_data_64[57] <= tx_data_iq[50];
                tx_data_64[56] <= tx_data_iq[51];
                tx_data_64[55] <= tx_data_iq[52];
                tx_data_64[54] <= tx_data_iq[53];
                tx_data_64[53] <= tx_data_iq[54];
                tx_data_64[52] <= tx_data_iq[55];
                tx_data_64[51] <= tx_data_iq[56];
                tx_data_64[50] <= tx_data_iq[57];
                tx_data_64[49] <= tx_data_iq[58];
                tx_data_64[48] <= tx_data_iq[59];
                tx_data_64[47] <= tx_data_iq[47];
                tx_data_64[46] <= tx_data_iq[46];
                tx_data_64[45] <= tx_data_iq[45];
                tx_data_64[44] <= tx_data_iq[44];
                tx_data_64[43] <= tx_data_iq[32];
                tx_data_64[42] <= tx_data_iq[33];
                tx_data_64[41] <= tx_data_iq[34];
                tx_data_64[40] <= tx_data_iq[35];
                tx_data_64[39] <= tx_data_iq[36];
                tx_data_64[38] <= tx_data_iq[37];
                tx_data_64[37] <= tx_data_iq[38];
                tx_data_64[36] <= tx_data_iq[39];
                tx_data_64[35] <= tx_data_iq[40];
                tx_data_64[34] <= tx_data_iq[41];
                tx_data_64[33] <= tx_data_iq[42];
                tx_data_64[32] <= tx_data_iq[43];
                tx_data_64[31] <= tx_data_iq[31];
                tx_data_64[30] <= tx_data_iq[30];
                tx_data_64[29] <= tx_data_iq[29];
                tx_data_64[28] <= tx_data_iq[28];
                tx_data_64[27] <= tx_data_iq[16];
                tx_data_64[26] <= tx_data_iq[17];
                tx_data_64[25] <= tx_data_iq[18];
                tx_data_64[24] <= tx_data_iq[19];
                tx_data_64[23] <= tx_data_iq[20];
                tx_data_64[22] <= tx_data_iq[21];
                tx_data_64[21] <= tx_data_iq[22];
                tx_data_64[20] <= tx_data_iq[23];
                tx_data_64[19] <= tx_data_iq[24];
                tx_data_64[18] <= tx_data_iq[25];
                tx_data_64[17] <= tx_data_iq[26];
                tx_data_64[16] <= tx_data_iq[27];
                tx_data_64[15] <= tx_data_iq[15];
                tx_data_64[14] <= tx_data_iq[14];
                tx_data_64[13] <= tx_data_iq[13];
                tx_data_64[12] <= tx_data_iq[12];
                tx_data_64[11] <= tx_data_iq[ 0];
                tx_data_64[10] <= tx_data_iq[ 1];
                tx_data_64[ 9] <= tx_data_iq[ 2];
                tx_data_64[ 8] <= tx_data_iq[ 3];
                tx_data_64[ 7] <= tx_data_iq[ 4];
                tx_data_64[ 6] <= tx_data_iq[ 5];
                tx_data_64[ 5] <= tx_data_iq[ 6];
                tx_data_64[ 4] <= tx_data_iq[ 7];
                tx_data_64[ 3] <= tx_data_iq[ 8];
                tx_data_64[ 2] <= tx_data_iq[ 9];
                tx_data_64[ 1] <= tx_data_iq[10];
                tx_data_64[ 0] <= tx_data_iq[11];
            end
            4'b1100: begin
                tx_data_64[63] <= tx_data_iq[48];
                tx_data_64[62] <= tx_data_iq[49];
                tx_data_64[61] <= tx_data_iq[50];
                tx_data_64[60] <= tx_data_iq[51];
                tx_data_64[59] <= tx_data_iq[52];
                tx_data_64[58] <= tx_data_iq[53];
                tx_data_64[57] <= tx_data_iq[54];
                tx_data_64[56] <= tx_data_iq[55];
                tx_data_64[55] <= tx_data_iq[56];
                tx_data_64[54] <= tx_data_iq[57];
                tx_data_64[53] <= tx_data_iq[58];
                tx_data_64[52] <= tx_data_iq[59];
                tx_data_64[51] <= tx_data_iq[60];
                tx_data_64[50] <= tx_data_iq[61];
                tx_data_64[49] <= tx_data_iq[62];
                tx_data_64[48] <= tx_data_iq[63];
                tx_data_64[47] <= tx_data_iq[32];
                tx_data_64[46] <= tx_data_iq[33];
                tx_data_64[45] <= tx_data_iq[34];
                tx_data_64[44] <= tx_data_iq[35];
                tx_data_64[43] <= tx_data_iq[36];
                tx_data_64[42] <= tx_data_iq[37];
                tx_data_64[41] <= tx_data_iq[38];
                tx_data_64[40] <= tx_data_iq[39];
                tx_data_64[39] <= tx_data_iq[40];
                tx_data_64[38] <= tx_data_iq[41];
                tx_data_64[37] <= tx_data_iq[42];
                tx_data_64[36] <= tx_data_iq[43];
                tx_data_64[35] <= tx_data_iq[44];
                tx_data_64[34] <= tx_data_iq[45];
                tx_data_64[33] <= tx_data_iq[46];
                tx_data_64[32] <= tx_data_iq[47];
                tx_data_64[31] <= tx_data_iq[16];
                tx_data_64[30] <= tx_data_iq[17];
                tx_data_64[29] <= tx_data_iq[18];
                tx_data_64[28] <= tx_data_iq[19];
                tx_data_64[27] <= tx_data_iq[20];
                tx_data_64[26] <= tx_data_iq[21];
                tx_data_64[25] <= tx_data_iq[22];
                tx_data_64[24] <= tx_data_iq[23];
                tx_data_64[23] <= tx_data_iq[24];
                tx_data_64[22] <= tx_data_iq[25];
                tx_data_64[21] <= tx_data_iq[26];
                tx_data_64[20] <= tx_data_iq[27];
                tx_data_64[19] <= tx_data_iq[28];
                tx_data_64[18] <= tx_data_iq[29];
                tx_data_64[17] <= tx_data_iq[30];
                tx_data_64[16] <= tx_data_iq[31];
                tx_data_64[15] <= tx_data_iq[ 0];
                tx_data_64[14] <= tx_data_iq[ 1];
                tx_data_64[13] <= tx_data_iq[ 2];
                tx_data_64[12] <= tx_data_iq[ 3];
                tx_data_64[11] <= tx_data_iq[ 4];
                tx_data_64[10] <= tx_data_iq[ 5];
                tx_data_64[ 9] <= tx_data_iq[ 6];
                tx_data_64[ 8] <= tx_data_iq[ 7];
                tx_data_64[ 7] <= tx_data_iq[ 8];
                tx_data_64[ 6] <= tx_data_iq[ 9];
                tx_data_64[ 5] <= tx_data_iq[10];
                tx_data_64[ 4] <= tx_data_iq[11];
                tx_data_64[ 3] <= tx_data_iq[12];
                tx_data_64[ 2] <= tx_data_iq[13];
                tx_data_64[ 1] <= tx_data_iq[14];
                tx_data_64[ 0] <= tx_data_iq[15];
            end
            default: begin
                tx_data_64 <= tx_data_iq;
            end
        endcase
    end

    // read to valid, write
 
    always @(negedge tx_resetn or posedge tx_clk) begin
        if (tx_resetn == 1'b0) begin
            tx_wrcnt <= 1'd0;
            tx_wrvalid_0 <= 1'd0;
            tx_wrdata_0 <= 32'd0;
            tx_wrvalid_1 <= 1'd0;
            tx_wrdata_1 <= 32'd0;
            tx_wrvalid_2 <= 1'd0;
            tx_wrdata_2 <= 32'd0;
            tx_wrvalid_3 <= 1'd0;
            tx_wrdata_3 <= 32'd0;
        end else begin
            if ((tx_valid_64 == 1'b1) && (tx_valid_iq == 1'b0)) begin
                tx_wrcnt <= ~tx_wrcnt;
            end
            if ((tx_valid_64 == 1'b1) && (tx_wrcnt == 1'd0)) begin
                tx_wrvalid_0 <= 1'd1;
                tx_wrdata_0 <= tx_data_64[31:0];
            end else if ((tx_rdvalid_m == 1'b1) && (tx_rdcnt == 2'd0)) begin
                tx_wrvalid_0 <= 1'd0;
                tx_wrdata_0 <= 32'd0;
            end
            if ((tx_valid_64 == 1'b1) && (tx_wrcnt == 1'd0)) begin
                tx_wrvalid_1 <= 1'd1;
                tx_wrdata_1 <= tx_data_64[63:32];
            end else if ((tx_rdvalid_m == 1'b1) && (tx_rdcnt == 2'd1)) begin
                tx_wrvalid_1 <= 1'd0;
                tx_wrdata_1 <= 32'd0;
            end
            if ((tx_valid_64 == 1'b1) && (tx_wrcnt == 1'd1)) begin
                tx_wrvalid_2 <= 1'd1;
                tx_wrdata_2 <= tx_data_64[31:0];
            end else if ((tx_rdvalid_m == 1'b1) && (tx_rdcnt == 2'd2)) begin
                tx_wrvalid_2 <= 1'd0;
                tx_wrdata_2 <= 32'd0;
            end
            if ((tx_valid_64 == 1'b1) && (tx_wrcnt == 1'd1)) begin
                tx_wrvalid_3 <= 1'd1;
                tx_wrdata_3 <= tx_data_64[63:32];
            end else if ((tx_rdvalid_m == 1'b1) && (tx_rdcnt == 2'd3)) begin
                tx_wrvalid_3 <= 1'd0;
                tx_wrdata_3 <= 32'd0;
            end
        end
    end

    // read to valid, read-data
 
    assign tx_rdvalid_m = tx_rdvalid & tx_rdvalid_w;
    assign tx_rdvalid_w = (tx_rdcnt == 2'd0) ? tx_wrvalid_0 : ((tx_rdcnt == 2'd1) ?
        tx_wrvalid_1 : ((tx_rdcnt == 2'd2) ? tx_wrvalid_2 : tx_wrvalid_3));

    always @(negedge tx_resetn or posedge tx_clk) begin
        if (tx_resetn == 1'b0) begin
            tx_rdcnt <= 2'd0;
            tx_rddata <= 32'd0;
            tx_rddata_h <= 8'd0;
        end else begin
            if (tx_rdvalid_m == 1'b1) begin
                tx_rdcnt <= tx_rdcnt + 1'b1;
                case (tx_rdcnt)
                    2'd0: tx_rddata <= tx_wrdata_0;
                    2'd1: tx_rddata <= tx_wrdata_1;
                    2'd2: tx_rddata <= tx_wrdata_2;
                    default: tx_rddata <= tx_wrdata_3;
                endcase
                tx_rddata_h <= {tx_rddata[19:16], tx_rddata[3:0]};
            end else if (tx_rdvalid == 1'b1) begin
                tx_rdcnt <= tx_rdcnt;
                tx_rddata <= 32'd0;
                tx_rddata_h <= 8'd0;
            end
        end
    end

    // read to valid, read-strobe
 
    always @(negedge tx_resetn or posedge tx_clk) begin
        if (tx_resetn == 1'b0) begin
            tx_rdstrobe <= 32'd0;
        end else begin
            if (tx_rdvalid == 1'b1) begin
                case (tx_num_of_bits)
                    3'd0: begin
                        if ((tx_ss_mode == 1'd1) || (tx_ss_ratio == 3'd0)) begin
                            tx_rdstrobe <= 32'h02020202;
                        end else if (tx_ss_ratio == 3'd1) begin
                            tx_rdstrobe <= 32'h00020002;
                        end else if (tx_ss_cnt == 5'd0) begin
                            tx_rdstrobe <= 32'h00000002;
                        end else begin
                            tx_rdstrobe <= 32'h00000000;
                        end
                    end
                    3'd1: begin
                        if ((tx_ss_mode == 1'd1) || (tx_ss_ratio == 3'd0)) begin
                            if (tx_lstrb1_pstrb0 == 1'd0) begin
                                tx_rdstrobe <= 32'h80808080;
                            end else begin
                                tx_rdstrobe <= 32'hf0f0f0f0;
                            end
                        end else if (tx_ss_ratio == 3'd1) begin
                            if (tx_lstrb1_pstrb0 == 1'd0) begin
                                tx_rdstrobe <= 32'h00800080;
                            end else begin
                                tx_rdstrobe <= 32'h00f000f0;
                            end
                        end else if (tx_ss_cnt == 5'd0) begin
                            if (tx_lstrb1_pstrb0 == 1'd0) begin
                                tx_rdstrobe <= 32'h00000080;
                            end else begin
                                tx_rdstrobe <= 32'h000000f0;
                            end
                        end else begin
                            tx_rdstrobe <= 32'h00000000;
                        end
                    end
                    3'd2: begin
                        if ((tx_ss_mode == 1'd1) || (tx_ss_ratio == 3'd0)) begin
                            if (tx_lstrb1_pstrb0 == 1'd0) begin
                                tx_rdstrobe <= 32'h80008000;
                            end else begin
                                tx_rdstrobe <= 32'hff00ff00;
                            end
                        end else if (tx_ss_cnt == 5'd0) begin
                            if (tx_lstrb1_pstrb0 == 1'd0) begin
                                tx_rdstrobe <= 32'h00008000;
                            end else begin
                                tx_rdstrobe <= 32'h0000ff00;
                            end
                        end else begin
                            tx_rdstrobe <= 32'h00000000;
                        end
                    end
                    3'd3: begin
                        if ((tx_ss_mode == 1'd1) || (tx_ss_cnt == 5'd0)) begin
                            if (tx_lstrb1_pstrb0 == 1'd0) begin
                                tx_rdstrobe <= 32'h08000000;
                            end else if (tx_mlane1_slane0 == 1'd1) begin
                                tx_rdstrobe <= 32'h0fc00000;
                            end else begin
                                tx_rdstrobe <= 32'h0fff0000;
                            end
                        end else begin
                            tx_rdstrobe <= 32'h00000000;
                        end
                    end
                    default: begin
                        if ((tx_ss_mode == 1'd1) || (tx_ss_cnt == 5'd0)) begin
                            if (tx_lstrb1_pstrb0 == 1'd0) begin
                                tx_rdstrobe <= 32'h80000000;
                            end else if (tx_mlane1_slane0 == 1'd0) begin
                                tx_rdstrobe <= 32'hffff0000;
                            end else if (tx_cmos1_lvds0 == 1'd1) begin
                                tx_rdstrobe <= 32'hf0000000;
                            end else begin
                                tx_rdstrobe <= 32'hff000000;
                            end
                        end else begin
                            tx_rdstrobe <= 32'h00000000;
                        end
                    end
                endcase
            end
        end
    end

    always @(negedge tx_resetn or posedge tx_clk) begin
        if (tx_resetn == 1'b0) begin
            tx_ss_cnt <= 5'd0;
        end else if (tx_rdvalid == 1'b1) begin
            if (tx_ss_cnt >= tx_ss_cnt_max) begin
                tx_ss_cnt <= 5'd0;
            end else begin
                tx_ss_cnt <= tx_ss_cnt + 1'b1;
            end
        end
    end

    assign tx_ss_cnt_max = (tx_num_of_bits <= 3'd1) ? {2'd0, tx_ss_max[4:2]} :
        ((tx_num_of_bits == 3'd2) ? {1'd0, tx_ss_max[4:1]} : tx_ss_max);

    always @(negedge tx_resetn or posedge tx_clk) begin
        if (tx_resetn == 1'b0) begin
            tx_ss_max <= 5'h00;
        end else begin
            case (tx_ss_ratio)
                3'h5: tx_ss_max <= 5'h1f;
                3'h4: tx_ss_max <= 5'h0f;
                3'h3: tx_ss_max <= 5'h07;
                3'h2: tx_ss_max <= 5'h03;
                3'h1: tx_ss_max <= 5'h01;
                default: tx_ss_max <= 5'h00;
            endcase
        end
    end

endmodule

// **********************************************************************************
// **********************************************************************************
