// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Description:       Auto generated, local modifications are discouraged.
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module axi_adrv9001_top_regs  #(parameter [3:0] ID = 0) (

    input   wire  [31:0]    axilite_version,
    input   wire  [31:0]    axilite_instance_id,
    output  reg   [31:0]    axilite_scratch = 'd0,
    output  reg   [31:0]    axilite_timer = 'd0,
    output  reg   [ 1:0]    axilite_resetb = 'd0,
    output  reg   [ 1:0]    axilite_mode = 'd0,
    input   wire            axilite_gp_intr,
    output  wire            axilite_intr_gp_intr,
    output  reg             axilite_gp_intr_enable = 'd0,
    output  reg   [ 1:0]    axilite_gp_intr_mode = 'd0,
    input   wire  [31:0]    axilite_usr_gpio_in,
    output  reg   [31:0]    axilite_usr_gpio_out = 'd0,
    output  reg             axilite_mcs_request = 'd0,
    input   wire            axilite_mcs_request_clr,
    output  reg   [ 3:0]    axilite_mcs_width = 'd0,
    output  reg   [ 3:0]    axilite_mcs_num = 'd0,
    output  reg             axilite_mcs_edge_fall1_rise0 = 'd0,
    output  reg   [31:0]    axilite_mcs_period = 'd0,
    output  reg   [ 1:0]    axilite_mcs_select = 'd0,
    output  reg             axilite_mcs_trigger = 'd0,
    input   wire            axilite_mcs_trigger_clr,
    output  reg   [15:0]    axilite_mcs_trigger_width = 'd0,
    output  reg   [ 1:0]    axilite_mcs_trigger_mode = 'd0,
    output  reg             axilite_mcs_tx_clk_resetn = 'd0,
    output  reg             axilite_mcs_tx_phy_resetn = 'd0,
    output  reg             axilite_mcs_tx_dp_resetn = 'd0,
    output  reg             axilite_mcs_rx_clk_resetn = 'd0,
    output  reg             axilite_mcs_rx_phy_resetn = 'd0,
    output  reg             axilite_mcs_rx_dp_resetn = 'd0,
    input   wire  [31:0]    axilite_mcs_clk_mon_count,
    output  reg             axilite_mcs_cdc_state = 'd0,
    input   wire            axilite_mcs_cdc_state_clr,
    output  reg   [31:0]    axilite_mcs_timer = 'd0,
    output  reg             axilite_mcs_swreset = 'd0,
    output  reg             axilite_mmcm_request = 'd0,
    input   wire            axilite_mmcm_request_clr,
    output  reg             axilite_mmcm_rd1_wr0 = 'd0,
    output  reg   [ 6:0]    axilite_mmcm_addr = 'd0,
    output  reg   [15:0]    axilite_mmcm_wrdata = 'd0,
    input   wire  [15:0]    axilite_mmcm_rddata,
    output  reg             axilite_mmcm_reset = 'd0,
    input   wire            axilite_mmcm_busy,
    input   wire            axilite_mmcm_unlocked,
    output  reg             axilite_mmcm_ref_clk_sel = 'd0,
    input   wire  [31:0]    axilite_mmcm_ref_clk_mon_count,
    output  reg             axilite_trig0_ext_oe = 'd0,
    output  reg             axilite_trig1_ext_oe = 'd0,
    input   wire            axilite_gp_intr_status,
    input   wire            axilite_rx0_intr_status,
    input   wire            axilite_rx1_intr_status,

    input   wire            axilite_clk,
    input   wire            axilite_resetn,
    input   wire            axilite_wrreq,
    input   wire  [15:0]    axilite_wraddr,
    input   wire  [31:0]    axilite_wrdata,
    output  reg             axilite_wrack = 'd0,
    input   wire            axilite_rdreq,
    input   wire  [15:0]    axilite_rdaddr,
    output  reg   [31:0]    axilite_rddata = 'd0,
    output  reg             axilite_rdack = 'd0);

    reg                     axilite_gp_intr_w1c = 'd0;
    reg                     axilite_mcs_request_clr_d = 'd0;
    reg                     axilite_mcs_trigger_clr_d = 'd0;
    reg                     axilite_mcs_cdc_state_clr_d = 'd0;
    reg                     axilite_mmcm_request_clr_d = 'd0;

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_wrack <= 'd0;
            axilite_rdack <= 'd0;
        end else begin
            if (axilite_wraddr[15:12] == ID) begin
                axilite_wrack <= axilite_wrreq;
            end else begin
                axilite_wrack <= 1'd0;
            end
            if (axilite_rdaddr[15:12] == ID) begin
                axilite_rdack <= axilite_rdreq;
            end else begin
                axilite_rdack <= 1'd0;
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_scratch <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h8)) begin
                axilite_scratch <= axilite_wrdata;
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_timer <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hc)) begin
                axilite_timer <= axilite_wrdata;
            end else if (axilite_timer > 0) begin
                axilite_timer <= axilite_timer - 1'b1;
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_resetb <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h20)) begin
                axilite_resetb <= axilite_wrdata[1:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_mode <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h24)) begin
                axilite_mode <= axilite_wrdata[1:0];
            end
        end
    end

    assign axilite_intr_gp_intr = axilite_gp_intr_w1c;

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_gp_intr_w1c <= 'h0;
        end else begin
            if (axilite_gp_intr == 1'b1) begin
                axilite_gp_intr_w1c <= 1'b1;
            end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h30)) begin
                axilite_gp_intr_w1c <= axilite_gp_intr_w1c & ~axilite_wrdata[0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_gp_intr_enable <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h34)) begin
                axilite_gp_intr_enable <= axilite_wrdata[0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_gp_intr_mode <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h38)) begin
                axilite_gp_intr_mode <= axilite_wrdata[1:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_usr_gpio_out <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h104)) begin
                axilite_usr_gpio_out <= axilite_wrdata;
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_mcs_request_clr_d <= 'd0;
            axilite_mcs_request <= 'h0;
        end else begin
            axilite_mcs_request_clr_d <= axilite_mcs_request_clr;
            if ((axilite_mcs_request_clr_d == 1'b0) && (axilite_mcs_request_clr == 1'b1)) begin
                axilite_mcs_request <= 1'b0;
            end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h200)) begin
                axilite_mcs_request <= axilite_mcs_request | axilite_wrdata[0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_mcs_width <= 'h1;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h204)) begin
                axilite_mcs_width <= axilite_wrdata[3:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_mcs_num <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h204)) begin
                axilite_mcs_num <= axilite_wrdata[11:8];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_mcs_edge_fall1_rise0 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h204)) begin
                axilite_mcs_edge_fall1_rise0 <= axilite_wrdata[16];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_mcs_period <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h208)) begin
                axilite_mcs_period <= axilite_wrdata;
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_mcs_select <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h20c)) begin
                axilite_mcs_select <= axilite_wrdata[1:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_mcs_trigger_clr_d <= 'd0;
            axilite_mcs_trigger <= 'h0;
        end else begin
            axilite_mcs_trigger_clr_d <= axilite_mcs_trigger_clr;
            if ((axilite_mcs_trigger_clr_d == 1'b0) && (axilite_mcs_trigger_clr == 1'b1)) begin
                axilite_mcs_trigger <= 1'b0;
            end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h210)) begin
                axilite_mcs_trigger <= axilite_mcs_trigger | axilite_wrdata[0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_mcs_trigger_width <= 'h40;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h214)) begin
                axilite_mcs_trigger_width <= axilite_wrdata[15:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_mcs_trigger_mode <= 'h2;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h218)) begin
                axilite_mcs_trigger_mode <= axilite_wrdata[1:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_mcs_tx_clk_resetn <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h220)) begin
                axilite_mcs_tx_clk_resetn <= axilite_wrdata[0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_mcs_tx_phy_resetn <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h220)) begin
                axilite_mcs_tx_phy_resetn <= axilite_wrdata[1];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_mcs_tx_dp_resetn <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h220)) begin
                axilite_mcs_tx_dp_resetn <= axilite_wrdata[2];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_mcs_rx_clk_resetn <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h230)) begin
                axilite_mcs_rx_clk_resetn <= axilite_wrdata[0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_mcs_rx_phy_resetn <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h230)) begin
                axilite_mcs_rx_phy_resetn <= axilite_wrdata[1];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_mcs_rx_dp_resetn <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h230)) begin
                axilite_mcs_rx_dp_resetn <= axilite_wrdata[2];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_mcs_cdc_state_clr_d <= 'd0;
            axilite_mcs_cdc_state <= 'h0;
        end else begin
            axilite_mcs_cdc_state_clr_d <= axilite_mcs_cdc_state_clr;
            if ((axilite_mcs_cdc_state_clr_d == 1'b0) && (axilite_mcs_cdc_state_clr == 1'b1)) begin
                axilite_mcs_cdc_state <= 1'b0;
            end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h250)) begin
                axilite_mcs_cdc_state <= axilite_mcs_cdc_state | axilite_wrdata[0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_mcs_timer <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h254)) begin
                axilite_mcs_timer <= axilite_wrdata;
            end else if (axilite_mcs_timer > 0) begin
                axilite_mcs_timer <= axilite_mcs_timer - 1'b1;
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_mcs_swreset <= 'h1;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h260)) begin
                axilite_mcs_swreset <= axilite_wrdata[0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_mmcm_request_clr_d <= 'd0;
            axilite_mmcm_request <= 'h0;
        end else begin
            axilite_mmcm_request_clr_d <= axilite_mmcm_request_clr;
            if ((axilite_mmcm_request_clr_d == 1'b0) && (axilite_mmcm_request_clr == 1'b1)) begin
                axilite_mmcm_request <= 1'b0;
            end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h300)) begin
                axilite_mmcm_request <= axilite_mmcm_request | axilite_wrdata[0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_mmcm_rd1_wr0 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h300)) begin
                axilite_mmcm_rd1_wr0 <= axilite_wrdata[1];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_mmcm_addr <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h304)) begin
                axilite_mmcm_addr <= axilite_wrdata[6:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_mmcm_wrdata <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h308)) begin
                axilite_mmcm_wrdata <= axilite_wrdata[15:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_mmcm_reset <= 'h1;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h310)) begin
                axilite_mmcm_reset <= axilite_wrdata[0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_mmcm_ref_clk_sel <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h340)) begin
                axilite_mmcm_ref_clk_sel <= axilite_wrdata[0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_trig0_ext_oe <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h400)) begin
                axilite_trig0_ext_oe <= axilite_wrdata[0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_trig1_ext_oe <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h400)) begin
                axilite_trig1_ext_oe <= axilite_wrdata[1];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_rddata <= 'd0;
        end else begin
            if ((axilite_rdreq == 1'b1) && (axilite_rdaddr[15:12] == ID)) begin
                case (axilite_rdaddr[11:0])
                    'h0: begin
                        axilite_rddata <= axilite_version;
                    end
                    'h4: begin
                        axilite_rddata <= axilite_instance_id;
                    end
                    'h8: begin
                        axilite_rddata <= axilite_scratch;
                    end
                    'hc: begin
                        axilite_rddata <= axilite_timer;
                    end
                    'h20: begin
                        axilite_rddata[1:0] <= axilite_resetb;
                        axilite_rddata[31:2] <= 'd0;
                    end
                    'h24: begin
                        axilite_rddata[1:0] <= axilite_mode;
                        axilite_rddata[31:2] <= 'd0;
                    end
                    'h30: begin
                        axilite_rddata[0] <= axilite_gp_intr_w1c;
                        axilite_rddata[31:1] <= 'd0;
                    end
                    'h34: begin
                        axilite_rddata[0] <= axilite_gp_intr_enable;
                        axilite_rddata[31:1] <= 'd0;
                    end
                    'h38: begin
                        axilite_rddata[1:0] <= axilite_gp_intr_mode;
                        axilite_rddata[31:2] <= 'd0;
                    end
                    'h100: begin
                        axilite_rddata <= axilite_usr_gpio_in;
                    end
                    'h104: begin
                        axilite_rddata <= axilite_usr_gpio_out;
                    end
                    'h200: begin
                        axilite_rddata[0] <= axilite_mcs_request;
                        axilite_rddata[31:1] <= 'd0;
                    end
                    'h204: begin
                        axilite_rddata[3:0] <= axilite_mcs_width;
                        axilite_rddata[7:4] <= 'd0;
                        axilite_rddata[11:8] <= axilite_mcs_num;
                        axilite_rddata[15:12] <= 'd0;
                        axilite_rddata[16] <= axilite_mcs_edge_fall1_rise0;
                        axilite_rddata[31:17] <= 'd0;
                    end
                    'h208: begin
                        axilite_rddata <= axilite_mcs_period;
                    end
                    'h20c: begin
                        axilite_rddata[1:0] <= axilite_mcs_select;
                        axilite_rddata[31:2] <= 'd0;
                    end
                    'h210: begin
                        axilite_rddata[0] <= axilite_mcs_trigger;
                        axilite_rddata[31:1] <= 'd0;
                    end
                    'h214: begin
                        axilite_rddata[15:0] <= axilite_mcs_trigger_width;
                        axilite_rddata[31:16] <= 'd0;
                    end
                    'h218: begin
                        axilite_rddata[1:0] <= axilite_mcs_trigger_mode;
                        axilite_rddata[31:2] <= 'd0;
                    end
                    'h220: begin
                        axilite_rddata[0] <= axilite_mcs_tx_clk_resetn;
                        axilite_rddata[1] <= axilite_mcs_tx_phy_resetn;
                        axilite_rddata[2] <= axilite_mcs_tx_dp_resetn;
                        axilite_rddata[31:3] <= 'd0;
                    end
                    'h230: begin
                        axilite_rddata[0] <= axilite_mcs_rx_clk_resetn;
                        axilite_rddata[1] <= axilite_mcs_rx_phy_resetn;
                        axilite_rddata[2] <= axilite_mcs_rx_dp_resetn;
                        axilite_rddata[31:3] <= 'd0;
                    end
                    'h240: begin
                        axilite_rddata <= axilite_mcs_clk_mon_count;
                    end
                    'h250: begin
                        axilite_rddata[0] <= axilite_mcs_cdc_state;
                        axilite_rddata[31:1] <= 'd0;
                    end
                    'h254: begin
                        axilite_rddata <= axilite_mcs_timer;
                    end
                    'h260: begin
                        axilite_rddata[0] <= axilite_mcs_swreset;
                        axilite_rddata[31:1] <= 'd0;
                    end
                    'h300: begin
                        axilite_rddata[0] <= axilite_mmcm_request;
                        axilite_rddata[1] <= axilite_mmcm_rd1_wr0;
                        axilite_rddata[31:2] <= 'd0;
                    end
                    'h304: begin
                        axilite_rddata[6:0] <= axilite_mmcm_addr;
                        axilite_rddata[31:7] <= 'd0;
                    end
                    'h308: begin
                        axilite_rddata[15:0] <= axilite_mmcm_wrdata;
                        axilite_rddata[31:16] <= 'd0;
                    end
                    'h30c: begin
                        axilite_rddata[15:0] <= axilite_mmcm_rddata;
                        axilite_rddata[31:16] <= 'd0;
                    end
                    'h310: begin
                        axilite_rddata[0] <= axilite_mmcm_reset;
                        axilite_rddata[31:1] <= 'd0;
                    end
                    'h314: begin
                        axilite_rddata[0] <= axilite_mmcm_busy;
                        axilite_rddata[1] <= axilite_mmcm_unlocked;
                        axilite_rddata[31:2] <= 'd0;
                    end
                    'h340: begin
                        axilite_rddata[0] <= axilite_mmcm_ref_clk_sel;
                        axilite_rddata[31:1] <= 'd0;
                    end
                    'h344: begin
                        axilite_rddata <= axilite_mmcm_ref_clk_mon_count;
                    end
                    'h400: begin
                        axilite_rddata[0] <= axilite_trig0_ext_oe;
                        axilite_rddata[1] <= axilite_trig1_ext_oe;
                        axilite_rddata[31:2] <= 'd0;
                    end
                    'h500: begin
                        axilite_rddata[0] <= axilite_gp_intr_status;
                        axilite_rddata[3:1] <= 'd0;
                        axilite_rddata[4] <= axilite_rx0_intr_status;
                        axilite_rddata[5] <= axilite_rx1_intr_status;
                        axilite_rddata[31:6] <= 'd0;
                    end
                    default: begin
                        axilite_rddata <= 32'd0;
                    end
                endcase
            end else begin
                axilite_rddata <= 32'd0;
            end
        end
    end

endmodule

// **********************************************************************************
// **********************************************************************************
