#!/usr/bin/perl
## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Description:       AXI_ADRV9001 top level registers
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################

use autodie;
require 'dooku.pl';

$addr_width = 16;
$addr_width_used = 12;

$no_of_instances = 1;
$instance_base_addr = 0x0;
$instance_offset_addr = 0x0;

setdooku(@ARGV);
module(0x0, 'axi_adrv9001_top');

## ##################################################################################
## ##################################################################################

define('OFFSET', 0x0000, 'Main address offset');

## ##################################################################################
## ##################################################################################

register(0x000, 'REG_VERSION');
field(0, 32, RO, 0x00060000, 'VERSION', 'This ip core version, default value depends on
    current fpga build. The format is unused[8], major[8], minor[8], and patch[8].');

register(0x004, 'REG_INSTANCE_ID');
field(0, 32, RO, 0x0, 'INSTANCE_ID', 'Indicates instance identifier of this core.
    In a master/slave system, core with INSTANCE_ID of 0 is the master.');

register(0x008, 'REG_SCRATCH');
field(0, 32, RW, 0x0, 'SCRATCH', 'General purpose scratch register, software may
    use this register for tempoaray variable storage.');

register(0x00c, 'REG_TIMER');
field(0, 32, RW, 0x0, 'TIMER', 'General purpose timer register, this is a count
    down timer, software may write desired interval and wait for it to reach zero.
    The count can be prematurely terminated, runs at AXILite clock (usually 100MHz).');

define('IO_LOW', 0x0, 'IO asserted logic 0');
define('IO_HIGH', 0x1, 'IO asserted logic 1');
define('IO_Z', 0x3, 'IO Tristated');

register(0x020, 'REG_RESETB');
field(0, 2, RW, 0x0, 'RESETB', 'This bit is directly mapped to device reset pin.
    After power-up, device is held in reset until software writes 0x1 to this bit.');

register(0x024, 'REG_MODE');
field(0, 2, RW, 0x0, 'MODE', 'This bit is directly mapped to device mode pin.
    Refer to device documentation for further details.
    If set to 0x2 or 0x3, the IO is tri-stated.');

register(0x030, 'REG_GP_INTR_STATUS');
field(0, 1, RW1C, 0x0, 'GP_INTR', 'This bit is set if an interrupt is detected (based on
    the GP_INTR bits below) on the device GPINT pin.  Software must write 0x1 to
    clear this bit.');

register(0x034, 'REG_GP_INTR_ENABLE');
field(0, 1, RW, 0x0, 'GP_INTR_ENABLE', 'Interrupt enable for GP_INTR.');

define('GP_INTR_HIGH', 0x0, 'IO is active high');
define('GP_INTR_LOW', 0x1, 'IO is active low');
define('GP_INTR_RISING_EDGE', 0x2, 'IO rising edge');
define('GP_INTR_FALLING_EDGE', 0x3, 'IO falling edge');

register(0x038, 'REG_GP_INTR_MODE');
field(0, 2, RW, 0x0, 'GP_INTR_MODE', 'These bits select the interrupt detection mode
    on the GPINT pin.');

## ##################################################################################
## ##################################################################################

register(0x100, 'REG_USR_GPIO_IN');
field(0, 32, RO, 0x0, 'USR_GPIO_IN', 'These bits are directly mapped to internal
    FPGA signals. The use of which is left to the down stream modules.');

register(0x104, 'REG_USR_GPIO_OUT');
field(0, 32, RW, 0x0, 'USR_GPIO_OUT', 'These bits are directly mapped to internal
    FPGA signals. The use of which is left to the down stream modules.');

## ##################################################################################
## ##################################################################################

register(0x200, 'REG_MCS_REQUEST');
field(0, 1, RW1HC, 0x0, 'MCS_REQUEST', 'A 0 to 1 transition on this bit initiates 
    MCS sequence generation as defined by the register fields below. This bit is
    cleared after the MCS sequence is completed.');

register(0x204, 'REG_MCS_CONTROL');
field(0, 4, RW, 0x1, 'MCS_WIDTH', 'This field defines the width of the mcs pulse in
    number of DEVICE_CLOCK cycles (must be less than MCS_PERIOD).');
field(8, 4, RW, 0x0, 'MCS_NUM', 'This field defines the number of MCS pulses to
    generate in a MCS sequence initiates by the MCS_REQUEST bit.');
field(16, 1, RW, 0x0, 'MCS_EDGE_FALL1_RISE0', 'This field defines the edge of DEVICE_CLOCK
    to assert/deassert mcs.  0 = rising-edge; 1 = falling-edge.');

register(0x208, 'REG_MCS_PERIOD');
field(0, 32, RW, 0x0, 'MCS_PERIOD', 'This field defines the number of DEVICE_CLOCK cycles
    between consecutive MCS pulses in the MCS sequence.');

register(0x20c, 'REG_MCS_SELECT');
field(0, 2, RW, 0x0, 'MCS_SELECT', 'This field controls external mcs signals
    those are distributed to other devices (in a MIMO configuration, it is advised
    to use the same setting across all interested parties). The following are supported:
    internal sequence (0x0), external (0x1), or disabled (0x3).');

define('MCS_SEQUENCE', 0x0, 'sequence mode');
define('MCS_EXTERNAL', 0x1, 'external pin mode');
define('MCS_DISABLED', 0x3, 'disabled');

register(0x210, 'REG_MCS_TRIGGER');
field(0, 1, RW1HC, 0x0, 'MCS_TRIGGER', 'If set, generates a MCS trigger internally.');

register(0x214, 'REG_MCS_TRIGGER_WIDTH');
field(0, 16, RW, 0x40, 'MCS_TRIGGER_WIDTH', 'Trigger width, in device clock cycles.');

register(0x218, 'REG_MCS_TRIGGER_MODE');
field(0, 2, RW, 0x2, 'MCS_TRIGGER_MODE', 'Trigger modes.');

define('MCS_TRIG_LOW', 0x0, 'asserted low for the duration of width.');
define('MCS_TRIG_HIGH', 0x1, 'asserted high for the duration of width.');
define('MCS_TRIG_TOGGLE', 0x2, 'toggle');

register(0x220, 'REG_MCS_TX_RESETN');
field(0, 1, RW, 0x0, 'MCS_TX_CLK_RESETN', 'The transmit clock reset.');
field(1, 1, RW, 0x0, 'MCS_TX_PHY_RESETN', 'The transmit phy (serdes) reset.');
field(2, 1, RW, 0x0, 'MCS_TX_DP_RESETN', 'The transmit data path reset.');

register(0x230, 'REG_MCS_RX_RESETN');
field(0, 1, RW, 0x0, 'MCS_RX_CLK_RESETN', 'The receive clock reset.');
field(1, 1, RW, 0x0, 'MCS_RX_PHY_RESETN', 'The receive phy (serdes) reset.');
field(2, 1, RW, 0x0, 'MCS_RX_DP_RESETN', 'The receive data path reset.');

register(0x240, 'REG_MCS_CLK_MON');
field(0, 32, RO, 0x0, 'MCS_CLK_MON_COUNT', 'Clock monitor frequency count. If read 0x0,
    indicates a loss of clock. The format is 16.16 x 100MHz');

register(0x250, 'REG_MCS_CDC_STATE');
field(0, 1, RW1HC, 0x0, 'MCS_CDC_STATE', 'If set, cleared when CDC transfer is complete.');

register(0x254, 'REG_MCS_TIMER');
field(0, 32, RW, 0x0, 'MCS_TIMER', 'General purpose timer for MCS.');

register(0x260, 'REG_MCS_SWRESET');
field(0, 1, RW, 0x1, 'MCS_SWRESET', 'The mcs logic, software reset.');

## ##################################################################################
## ##################################################################################

register(0x300, 'REG_MMCM_ACCESS');
field(0, 1, RW1HC, 0x0, 'MMCM_REQUEST', 'A 0 to 1 transition on this bit initiates an
    indirect access to the DEVICE_CLOCK, TDD_CLOCK, and GPIO_CLOCK MMCM inside the core.
    This bit is self-cleared when the access is complete. Refer to the vendor documentation
    for the MMCM register details.');
field(1, 1, RW, 0x0, 'MMCM_RD1_WR0', 'If set, the MMCM_REQUEST initiates a read
    operation, otherwise a write operation. Software may field write this bit separately
    from the MMCM_REQUEST above, however this and other MMCM access fields must be programmed
    before an MMCM_REQUEST.');

register(0x304, 'REG_MMCM_ADDR');
field(0, 7, RW, 0x0, 'MMCM_ADDR', 'This field defines the MMCM indirect register address.
    The width of this register depends on the device family being used.');

register(0x308, 'REG_MMCM_WRDATA');
field(0, 16, RW, 0x0, 'MMCM_WRDATA', 'This field defines the MMCM indirect register write
    data. The details of which depends on the device family being used.');

register(0x30c, 'REG_MMCM_RDDATA');
field(0, 16, RO, 0x0, 'MMCM_RDDATA', 'This field defines the MMCM indirect register read
    data. The details of which depends on the device family being used.');

register(0x310, 'REG_MMCM_RESET');
field(0, 1, RW, 0x1, 'MMCM_RESET', 'If set causes a MMCM reset, software must write
    0x0 once the device clock is running and stable as part of the initialization.');

register(0x314, 'REG_MMCM_STATUS');
field(0, 1, RO, 0x0, 'MMCM_BUSY', 'If set after a MMCM_REQUEST, indicates that the
    access is in-progress. If this bit is clear, indicates the interface is idle.
    The software must make sure this bit is clear before initiating a MMCM_REQUEST.');
field(1, 1, RO, 0x0, 'MMCM_UNLOCKED', 'If clear indicates that the MMCM clocks are
    locked and running. If this bit is set, none of the DEVICE_CLOCK, TDD_CLK, and
    GPIO_CLK are operational and their status unknown.');

register(0x340, 'REG_MMCM_REF_CLK_SEL');
field(0, 1, RW, 0x0, 'MMCM_REF_CLK_SEL', 'If set, selects device clock output as
    reference clock to the MMCM, otherwise system clock is used as mmcm reference clock.');

register(0x344, 'REG_MMCM_REF_CLK_MON');
field(0, 32, RO, 0x0, 'MMCM_REF_CLK_MON_COUNT', 'Clock monitor frequency count. If read 0x0,
    indicates a loss of clock. The format is 16.16 x 100MHz');

define('MMCM_POWER_ID', 0x27, 'MMCM, power register address, driver use only.');
define('MMCM_LOCK_ID', 0x18, 'MMCM, status register address, driver use only.');
define('MMCM_FILTER_ID', 0x4e, 'MMCM, filter register address, driver use only.');
define('MMCM_REF_DIV_ID', 0x16, 'MMCM, ref clock divider register address, driver use only.');
define('MMCM_REF_MUL_ID', 0x14, 'MMCM, ref clock multiplier register address, driver use only.');
define('MMCM_OUT0_DIV_ID', 0x08, 'MMCM, output 0 divider register address, driver use only.');
define('MMCM_OUT1_DIV_ID', 0x0a, 'MMCM, output 1 divider register address, driver use only.');
define('MMCM_OUT2_DIV_ID', 0x0c, 'MMCM, output 2 divider register address, driver use only.');
define('MMCM_OUT3_DIV_ID', 0x0e, 'MMCM, output 3 divider register address, driver use only.');

## ##################################################################################
## ##################################################################################

register(0x400, 'REG_TRIG_EXT_CTL');
field(0, 1, RW, 0x0, 'TRIG0_EXT_OE', 'This bit controls the output enable for
    external trigger 0, if set it is an output, otherwise input.');
field(1, 1, RW, 0x0, 'TRIG1_EXT_OE', 'This bit controls the output enable for
    external trigger 1, if set it is an output, otherwise input.');

## ##################################################################################
## ##################################################################################

register(0x500, 'REG_INTR_STATUS');
field(0, 1, RO, 0x0, 'GP_INTR_STATUS', 'Interrupt status, GP_INTR');
field(4, 1, RO, 0x0, 'RX0_INTR_STATUS', 'Interrupt status, RX0_INTR');
field(5, 1, RO, 0x0, 'RX1_INTR_STATUS', 'Interrupt status, RX1_INTR');

## ##################################################################################
## ##################################################################################

endregisters();
endmodule();
generate();

## ##################################################################################
## ##################################################################################
