### AXI\_ADRV9001\_TOP Register Map
The addresses shown are relative to the peripheral base address.

---
| Address | Bits | Field | Type | Default | Description |
| ------- | ---- | ----- | ---- | ------- | ----------- |
| 0x0 | [31:0] | version[31:0] | RO | 0x60000 | This ip core version, default value depends on current fpga build. The format is unused[8], major[8], minor[8], and patch[8]. |
| | | | | | |
| 0x4 | [31:0] | instance\_id[31:0] | RO | 0x0 | Indicates instance identifier of this core. In a master/slave system, core with INSTANCE\_ID of 0 is the master. |
| | | | | | |
| 0x8 | [31:0] | scratch[31:0] | RW | 0x0 | General purpose scratch register, software may use this register for tempoaray variable storage. |
| | | | | | |
| 0xc | [31:0] | timer[31:0] | RW | 0x0 | General purpose timer register, this is a count down timer, software may write desired interval and wait for it to reach zero. The count can be prematurely terminated, runs at AXILite clock (usually 100MHz). |
| | | | | | |
| 0x20 | [1:0] | resetb[1:0] | RW | 0x0 | This bit is directly mapped to device reset pin. After power-up, device is held in reset until software writes 0x1 to this bit. |
| | | | | | |
| 0x24 | [1:0] | mode[1:0] | RW | 0x0 | This bit is directly mapped to device mode pin. Refer to device documentation for further details. If set to 0x2 or 0x3, the IO is tri-stated. |
| | | | | | |
| 0x30 | [0:0] | gp\_intr | RW1C | 0x0 | This bit is set if an interrupt is detected (based on the GP\_INTR bits below) on the device GPINT pin. Software must write 0x1 to clear this bit. |
| | | | | | |
| 0x34 | [0:0] | gp\_intr\_enable | RW | 0x0 | Interrupt enable for GP\_INTR. |
| | | | | | |
| 0x38 | [1:0] | gp\_intr\_mode[1:0] | RW | 0x0 | These bits select the interrupt detection mode on the GPINT pin. |
| | | | | | |
| 0x100 | [31:0] | usr\_gpio\_in[31:0] | RO | 0x0 | These bits are directly mapped to internal FPGA signals. The use of which is left to the down stream modules. |
| | | | | | |
| 0x104 | [31:0] | usr\_gpio\_out[31:0] | RW | 0x0 | These bits are directly mapped to internal FPGA signals. The use of which is left to the down stream modules. |
| | | | | | |
| 0x200 | [0:0] | mcs\_request | RW1HC | 0x0 | A 0 to 1 transition on this bit initiates MCS sequence generation as defined by the register fields below. This bit is cleared after the MCS sequence is completed. |
| | | | | | |
| 0x204 | [3:0] | mcs\_width[3:0] | RW | 0x1 | This field defines the width of the mcs pulse in number of DEVICE\_CLOCK cycles (must be less than MCS\_PERIOD). |
| 0x204 | [11:8] | mcs\_num[3:0] | RW | 0x0 | This field defines the number of MCS pulses to generate in a MCS sequence initiates by the MCS\_REQUEST bit. |
| 0x204 | [16:16] | mcs\_edge\_fall1\_rise0 | RW | 0x0 | This field defines the edge of DEVICE\_CLOCK to assert/deassert mcs. 0 = rising-edge; 1 = falling-edge. |
| | | | | | |
| 0x208 | [31:0] | mcs\_period[31:0] | RW | 0x0 | This field defines the number of DEVICE\_CLOCK cycles between consecutive MCS pulses in the MCS sequence. |
| | | | | | |
| 0x20c | [1:0] | mcs\_select[1:0] | RW | 0x0 | This field controls external mcs signals those are distributed to other devices (in a MIMO configuration, it is advised to use the same setting across all interested parties). The following are supported: internal sequence (0x0), external (0x1), or disabled (0x3). |
| | | | | | |
| 0x210 | [0:0] | mcs\_trigger | RW1HC | 0x0 | If set, generates a MCS trigger internally. |
| | | | | | |
| 0x214 | [15:0] | mcs\_trigger\_width[15:0] | RW | 0x40 | Trigger width, in device clock cycles. |
| | | | | | |
| 0x218 | [1:0] | mcs\_trigger\_mode[1:0] | RW | 0x2 | Trigger modes. |
| | | | | | |
| 0x220 | [0:0] | mcs\_tx\_clk\_resetn | RW | 0x0 | The transmit clock reset. |
| 0x220 | [1:1] | mcs\_tx\_phy\_resetn | RW | 0x0 | The transmit phy (serdes) reset. |
| 0x220 | [2:2] | mcs\_tx\_dp\_resetn | RW | 0x0 | The transmit data path reset. |
| | | | | | |
| 0x230 | [0:0] | mcs\_rx\_clk\_resetn | RW | 0x0 | The receive clock reset. |
| 0x230 | [1:1] | mcs\_rx\_phy\_resetn | RW | 0x0 | The receive phy (serdes) reset. |
| 0x230 | [2:2] | mcs\_rx\_dp\_resetn | RW | 0x0 | The receive data path reset. |
| | | | | | |
| 0x240 | [31:0] | mcs\_clk\_mon\_count[31:0] | RO | 0x0 | Clock monitor frequency count. If read 0x0, indicates a loss of clock. The format is 16.16 x 100MHz |
| | | | | | |
| 0x250 | [0:0] | mcs\_cdc\_state | RW1HC | 0x0 | If set, cleared when CDC transfer is complete. |
| | | | | | |
| 0x254 | [31:0] | mcs\_timer[31:0] | RW | 0x0 | General purpose timer for MCS. |
| | | | | | |
| 0x260 | [0:0] | mcs\_swreset | RW | 0x1 | The mcs logic, software reset. |
| | | | | | |
| 0x300 | [0:0] | mmcm\_request | RW1HC | 0x0 | A 0 to 1 transition on this bit initiates an indirect access to the DEVICE\_CLOCK, TDD\_CLOCK, and GPIO\_CLOCK MMCM inside the core. This bit is self-cleared when the access is complete. Refer to the vendor documentation for the MMCM register details. |
| 0x300 | [1:1] | mmcm\_rd1\_wr0 | RW | 0x0 | If set, the MMCM\_REQUEST initiates a read operation, otherwise a write operation. Software may field write this bit separately from the MMCM\_REQUEST above, however this and other MMCM access fields must be programmed before an MMCM\_REQUEST. |
| | | | | | |
| 0x304 | [6:0] | mmcm\_addr[6:0] | RW | 0x0 | This field defines the MMCM indirect register address. The width of this register depends on the device family being used. |
| | | | | | |
| 0x308 | [15:0] | mmcm\_wrdata[15:0] | RW | 0x0 | This field defines the MMCM indirect register write data. The details of which depends on the device family being used. |
| | | | | | |
| 0x30c | [15:0] | mmcm\_rddata[15:0] | RO | 0x0 | This field defines the MMCM indirect register read data. The details of which depends on the device family being used. |
| | | | | | |
| 0x310 | [0:0] | mmcm\_reset | RW | 0x1 | If set causes a MMCM reset, software must write 0x0 once the device clock is running and stable as part of the initialization. |
| | | | | | |
| 0x314 | [0:0] | mmcm\_busy | RO | 0x0 | If set after a MMCM\_REQUEST, indicates that the access is in-progress. If this bit is clear, indicates the interface is idle. The software must make sure this bit is clear before initiating a MMCM\_REQUEST. |
| 0x314 | [1:1] | mmcm\_unlocked | RO | 0x0 | If clear indicates that the MMCM clocks are locked and running. If this bit is set, none of the DEVICE\_CLOCK, TDD\_CLK, and GPIO\_CLK are operational and their status unknown. |
| | | | | | |
| 0x340 | [0:0] | mmcm\_ref\_clk\_sel | RW | 0x0 | If set, selects device clock output as reference clock to the MMCM, otherwise system clock is used as mmcm reference clock. |
| | | | | | |
| 0x344 | [31:0] | mmcm\_ref\_clk\_mon\_count[31:0] | RO | 0x0 | Clock monitor frequency count. If read 0x0, indicates a loss of clock. The format is 16.16 x 100MHz |
| | | | | | |
| 0x400 | [0:0] | trig0\_ext\_oe | RW | 0x0 | This bit controls the output enable for external trigger 0, if set it is an output, otherwise input. |
| 0x400 | [1:1] | trig1\_ext\_oe | RW | 0x0 | This bit controls the output enable for external trigger 1, if set it is an output, otherwise input. |
| | | | | | |
| 0x500 | [0:0] | gp\_intr\_status | RO | 0x0 | Interrupt status, GP\_INTR |
| 0x500 | [4:4] | rx0\_intr\_status | RO | 0x0 | Interrupt status, RX0\_INTR |
| 0x500 | [5:5] | rx1\_intr\_status | RO | 0x0 | Interrupt status, RX1\_INTR |
| | | | | | |
---
