### AXI\_ADRV9001\_TDD Register Map
The addresses shown are relative to the peripheral base address.

---
| Address | Bits | Field | Type | Default | Description |
| ------- | ---- | ----- | ---- | ------- | ----------- |
| 0x0 | [31:0] | frame\_period[31:0] | RW | 0x0 | The number of clock cycles in the TDD frame |
| | | | | | |
| 0x4 | [31:0] | num\_of\_frames[31:0] | RW | 0x0 | The number of frames in the TDD sequence |
| | | | | | |
| 0x8 | [31:0] | frame\_switch\_period[31:0] | RW | 0x0 | The clock cycles value for premature termination of the current frame. |
| | | | | | |
| 0xc | [31:0] | frame\_switch\_number[31:0] | RW | 0x0 | The frame number for premature termination of the current clock count. This will be a shortened sequence. |
| | | | | | |
| 0x10 | [1:0] | trigger\_mode\_0[1:0] | RW | 0x0 | The core may optionally be controlled through the trigger inputs. There are five programmable trigger inputs, these bits control each one of the triggers independently. The data transfer is controlled as an AND function of all the trigger modes. In all modes, the duration of data transfer is controlled by the length. |
| 0x10 | [3:2] | trigger\_mode\_1[1:0] | RW | 0x0 | The core may optionally be controlled through the trigger inputs. There are five programmable trigger inputs, these bits control each one of the triggers independently. The data transfer is controlled as an AND function of all the trigger modes. In all modes, the duration of data transfer is controlled by the length. |
| 0x10 | [5:4] | trigger\_mode\_2[1:0] | RW | 0x0 | The core may optionally be controlled through the trigger inputs. There are five programmable trigger inputs, these bits control each one of the triggers independently. The data transfer is controlled as an AND function of all the trigger modes. In all modes, the duration of data transfer is controlled by the length. |
| 0x10 | [7:6] | trigger\_mode\_3[1:0] | RW | 0x0 | The core may optionally be controlled through the trigger inputs. There are five programmable trigger inputs, these bits control each one of the triggers independently. The data transfer is controlled as an AND function of all the trigger modes. In all modes, the duration of data transfer is controlled by the length. |
| | | | | | |
| 0x20 | [0:0] | start | RW1HC | 0x0 | If set, indicates a request to start the TDD sequence, all sequence parameters above must be programmed first before setting this bit. Hardware clears this bit once the sequence is completed OR a stop request is initiated. |
| 0x20 | [1:1] | stop | RW1HC | 0x0 | If set, indicates a request to stop the current sequence, Hardware clears this bit once the sequence is stopped. |
| 0x20 | [2:2] | sequence\_repeat | RW | 0x0 | If set, the current sequence is repeated until a STOP request is received. |
| 0x20 | [3:3] | frame\_switch\_enable | RW | 0x0 | If set, a sequence is shortened and the set frame is prematurely terminated. |
| | | | | | |
| 0x24 | [0:0] | swreset | RW1HC | 0x0 | If set, the counters are reset. Hardware clears this bit once the internal reset is completed. |
| | | | | | |
| 0x28 | [31:0] | timer[31:0] | RW | 0x0 | General purpose timer register, this is a count down timer, software may write desired interval and wait for it to reach zero. The count can be prematurely terminated, runs at AXILite clock (usually 100MHz). |
| | | | | | |
| 0x30 | [31:0] | clk\_mon\_count[31:0] | RO | 0x0 | Clock monitor frequency count. If read 0x0, indicates a loss of clock. The format is 16.16 x 100MHz |
| | | | | | |
| 0x40 | [0:0] | global\_enb | RW | 0x1 | If set allows global control of all enables if set to 0x0, all enables are asserted low, if set to 0x1, enables are asserted as per their individual setting. |
| | | | | | |
| 0x50 | [0:0] | cdc\_state | RW1HC | 0x0 | If set, cleared when CDC transfer is complete. |
| | | | | | |
| 0x100 | [31:0] | primary\_assert\_00[31:0] | RW | 0x0 | Primary, clock count- high. |
| | | | | | |
| 0x104 | [31:0] | primary\_deassert\_00[31:0] | RW | 0x0 | Primary, clock count- low. |
| | | | | | |
| 0x108 | [31:0] | secondary\_assert\_00[31:0] | RW | 0x0 | Secondary, clock count- high. |
| | | | | | |
| 0x10c | [31:0] | secondary\_deassert\_00[31:0] | RW | 0x0 | Secondary, clock count- low. |
| | | | | | |
| 0x110 | [31:0] | primary\_frame\_assert\_00[31:0] | RW | 0x0 | Primary, frame count- high. |
| | | | | | |
| 0x114 | [31:0] | primary\_frame\_deassert\_00[31:0] | RW | 0x0 | Primary, frame count- low. |
| | | | | | |
| 0x118 | [31:0] | secondary\_frame\_assert\_00[31:0] | RW | 0x0 | Secondary, frame count- high. |
| | | | | | |
| 0x11c | [31:0] | secondary\_frame\_deassert\_00[31:0] | RW | 0x0 | Secondary, frame count- low. |
| | | | | | |
| 0x120 | [1:0] | mode\_00[1:0] | RW | 0x0 | Software or hardware mode. |
| | | | | | |
| 0x124 | [0:0] | sync\_00 | RW | 0x0 | Interface clock synchronous select. |
| | | | | | |
| 0x128 | [11:0] | clk\_ratio\_00[11:0] | RO | 0x0 | Interface clock to TDD clock ratio. |
| | | | | | |
| 0x140 | [31:0] | primary\_assert\_01[31:0] | RW | 0x0 | Primary, clock count- high. |
| | | | | | |
| 0x144 | [31:0] | primary\_deassert\_01[31:0] | RW | 0x0 | Primary, clock count- low. |
| | | | | | |
| 0x148 | [31:0] | secondary\_assert\_01[31:0] | RW | 0x0 | Secondary, clock count- high. |
| | | | | | |
| 0x14c | [31:0] | secondary\_deassert\_01[31:0] | RW | 0x0 | Secondary, clock count- low. |
| | | | | | |
| 0x150 | [31:0] | primary\_frame\_assert\_01[31:0] | RW | 0x0 | Primary, frame count- high. |
| | | | | | |
| 0x154 | [31:0] | primary\_frame\_deassert\_01[31:0] | RW | 0x0 | Primary, frame count- low. |
| | | | | | |
| 0x158 | [31:0] | secondary\_frame\_assert\_01[31:0] | RW | 0x0 | Secondary, frame count- high. |
| | | | | | |
| 0x15c | [31:0] | secondary\_frame\_deassert\_01[31:0] | RW | 0x0 | Secondary, frame count- low. |
| | | | | | |
| 0x160 | [1:0] | mode\_01[1:0] | RW | 0x0 | Software or hardware mode. |
| | | | | | |
| 0x164 | [0:0] | sync\_01 | RW | 0x0 | Interface clock synchronous select. |
| | | | | | |
| 0x168 | [11:0] | clk\_ratio\_01[11:0] | RO | 0x0 | Interface clock to TDD clock ratio. |
| | | | | | |
| 0x180 | [31:0] | primary\_assert\_02[31:0] | RW | 0x0 | Primary, clock count- high. |
| | | | | | |
| 0x184 | [31:0] | primary\_deassert\_02[31:0] | RW | 0x0 | Primary, clock count- low. |
| | | | | | |
| 0x188 | [31:0] | secondary\_assert\_02[31:0] | RW | 0x0 | Secondary, clock count- high. |
| | | | | | |
| 0x18c | [31:0] | secondary\_deassert\_02[31:0] | RW | 0x0 | Secondary, clock count- low. |
| | | | | | |
| 0x190 | [31:0] | primary\_frame\_assert\_02[31:0] | RW | 0x0 | Primary, frame count- high. |
| | | | | | |
| 0x194 | [31:0] | primary\_frame\_deassert\_02[31:0] | RW | 0x0 | Primary, frame count- low. |
| | | | | | |
| 0x198 | [31:0] | secondary\_frame\_assert\_02[31:0] | RW | 0x0 | Secondary, frame count- high. |
| | | | | | |
| 0x19c | [31:0] | secondary\_frame\_deassert\_02[31:0] | RW | 0x0 | Secondary, frame count- low. |
| | | | | | |
| 0x1a0 | [1:0] | mode\_02[1:0] | RW | 0x0 | Software or hardware mode. |
| | | | | | |
| 0x1a4 | [0:0] | sync\_02 | RW | 0x0 | Interface clock synchronous select. |
| | | | | | |
| 0x1a8 | [11:0] | clk\_ratio\_02[11:0] | RO | 0x0 | Interface clock to TDD clock ratio. |
| | | | | | |
| 0x1c0 | [31:0] | primary\_assert\_03[31:0] | RW | 0x0 | Primary, clock count- high. |
| | | | | | |
| 0x1c4 | [31:0] | primary\_deassert\_03[31:0] | RW | 0x0 | Primary, clock count- low. |
| | | | | | |
| 0x1c8 | [31:0] | secondary\_assert\_03[31:0] | RW | 0x0 | Secondary, clock count- high. |
| | | | | | |
| 0x1cc | [31:0] | secondary\_deassert\_03[31:0] | RW | 0x0 | Secondary, clock count- low. |
| | | | | | |
| 0x1d0 | [31:0] | primary\_frame\_assert\_03[31:0] | RW | 0x0 | Primary, frame count- high. |
| | | | | | |
| 0x1d4 | [31:0] | primary\_frame\_deassert\_03[31:0] | RW | 0x0 | Primary, frame count- low. |
| | | | | | |
| 0x1d8 | [31:0] | secondary\_frame\_assert\_03[31:0] | RW | 0x0 | Secondary, frame count- high. |
| | | | | | |
| 0x1dc | [31:0] | secondary\_frame\_deassert\_03[31:0] | RW | 0x0 | Secondary, frame count- low. |
| | | | | | |
| 0x1e0 | [1:0] | mode\_03[1:0] | RW | 0x0 | Software or hardware mode. |
| | | | | | |
| 0x1e4 | [0:0] | sync\_03 | RW | 0x0 | Interface clock synchronous select. |
| | | | | | |
| 0x1e8 | [11:0] | clk\_ratio\_03[11:0] | RO | 0x0 | Interface clock to TDD clock ratio. |
| | | | | | |
| 0x200 | [31:0] | primary\_assert\_04[31:0] | RW | 0x0 | Primary, clock count- high. |
| | | | | | |
| 0x204 | [31:0] | primary\_deassert\_04[31:0] | RW | 0x0 | Primary, clock count- low. |
| | | | | | |
| 0x208 | [31:0] | secondary\_assert\_04[31:0] | RW | 0x0 | Secondary, clock count- high. |
| | | | | | |
| 0x20c | [31:0] | secondary\_deassert\_04[31:0] | RW | 0x0 | Secondary, clock count- low. |
| | | | | | |
| 0x210 | [31:0] | primary\_frame\_assert\_04[31:0] | RW | 0x0 | Primary, frame count- high. |
| | | | | | |
| 0x214 | [31:0] | primary\_frame\_deassert\_04[31:0] | RW | 0x0 | Primary, frame count- low. |
| | | | | | |
| 0x218 | [31:0] | secondary\_frame\_assert\_04[31:0] | RW | 0x0 | Secondary, frame count- high. |
| | | | | | |
| 0x21c | [31:0] | secondary\_frame\_deassert\_04[31:0] | RW | 0x0 | Secondary, frame count- low. |
| | | | | | |
| 0x220 | [1:0] | mode\_04[1:0] | RW | 0x0 | Software or hardware mode. |
| | | | | | |
| 0x224 | [0:0] | sync\_04 | RW | 0x0 | Interface clock synchronous select. |
| | | | | | |
| 0x228 | [11:0] | clk\_ratio\_04[11:0] | RO | 0x0 | Interface clock to TDD clock ratio. |
| | | | | | |
| 0x240 | [31:0] | primary\_assert\_05[31:0] | RW | 0x0 | Primary, clock count- high. |
| | | | | | |
| 0x244 | [31:0] | primary\_deassert\_05[31:0] | RW | 0x0 | Primary, clock count- low. |
| | | | | | |
| 0x248 | [31:0] | secondary\_assert\_05[31:0] | RW | 0x0 | Secondary, clock count- high. |
| | | | | | |
| 0x24c | [31:0] | secondary\_deassert\_05[31:0] | RW | 0x0 | Secondary, clock count- low. |
| | | | | | |
| 0x250 | [31:0] | primary\_frame\_assert\_05[31:0] | RW | 0x0 | Primary, frame count- high. |
| | | | | | |
| 0x254 | [31:0] | primary\_frame\_deassert\_05[31:0] | RW | 0x0 | Primary, frame count- low. |
| | | | | | |
| 0x258 | [31:0] | secondary\_frame\_assert\_05[31:0] | RW | 0x0 | Secondary, frame count- high. |
| | | | | | |
| 0x25c | [31:0] | secondary\_frame\_deassert\_05[31:0] | RW | 0x0 | Secondary, frame count- low. |
| | | | | | |
| 0x260 | [1:0] | mode\_05[1:0] | RW | 0x0 | Software or hardware mode. |
| | | | | | |
| 0x264 | [0:0] | sync\_05 | RW | 0x0 | Interface clock synchronous select. |
| | | | | | |
| 0x268 | [11:0] | clk\_ratio\_05[11:0] | RO | 0x0 | Interface clock to TDD clock ratio. |
| | | | | | |
| 0x280 | [31:0] | primary\_assert\_06[31:0] | RW | 0x0 | Primary, clock count- high. |
| | | | | | |
| 0x284 | [31:0] | primary\_deassert\_06[31:0] | RW | 0x0 | Primary, clock count- low. |
| | | | | | |
| 0x288 | [31:0] | secondary\_assert\_06[31:0] | RW | 0x0 | Secondary, clock count- high. |
| | | | | | |
| 0x28c | [31:0] | secondary\_deassert\_06[31:0] | RW | 0x0 | Secondary, clock count- low. |
| | | | | | |
| 0x290 | [31:0] | primary\_frame\_assert\_06[31:0] | RW | 0x0 | Primary, frame count- high. |
| | | | | | |
| 0x294 | [31:0] | primary\_frame\_deassert\_06[31:0] | RW | 0x0 | Primary, frame count- low. |
| | | | | | |
| 0x298 | [31:0] | secondary\_frame\_assert\_06[31:0] | RW | 0x0 | Secondary, frame count- high. |
| | | | | | |
| 0x29c | [31:0] | secondary\_frame\_deassert\_06[31:0] | RW | 0x0 | Secondary, frame count- low. |
| | | | | | |
| 0x2a0 | [1:0] | mode\_06[1:0] | RW | 0x0 | Software or hardware mode. |
| | | | | | |
| 0x2a4 | [0:0] | sync\_06 | RW | 0x0 | Interface clock synchronous select. |
| | | | | | |
| 0x2a8 | [11:0] | clk\_ratio\_06[11:0] | RO | 0x0 | Interface clock to TDD clock ratio. |
| | | | | | |
| 0x2c0 | [31:0] | primary\_assert\_07[31:0] | RW | 0x0 | Primary, clock count- high. |
| | | | | | |
| 0x2c4 | [31:0] | primary\_deassert\_07[31:0] | RW | 0x0 | Primary, clock count- low. |
| | | | | | |
| 0x2c8 | [31:0] | secondary\_assert\_07[31:0] | RW | 0x0 | Secondary, clock count- high. |
| | | | | | |
| 0x2cc | [31:0] | secondary\_deassert\_07[31:0] | RW | 0x0 | Secondary, clock count- low. |
| | | | | | |
| 0x2d0 | [31:0] | primary\_frame\_assert\_07[31:0] | RW | 0x0 | Primary, frame count- high. |
| | | | | | |
| 0x2d4 | [31:0] | primary\_frame\_deassert\_07[31:0] | RW | 0x0 | Primary, frame count- low. |
| | | | | | |
| 0x2d8 | [31:0] | secondary\_frame\_assert\_07[31:0] | RW | 0x0 | Secondary, frame count- high. |
| | | | | | |
| 0x2dc | [31:0] | secondary\_frame\_deassert\_07[31:0] | RW | 0x0 | Secondary, frame count- low. |
| | | | | | |
| 0x2e0 | [1:0] | mode\_07[1:0] | RW | 0x0 | Software or hardware mode. |
| | | | | | |
| 0x2e4 | [0:0] | sync\_07 | RW | 0x0 | Interface clock synchronous select. |
| | | | | | |
| 0x2e8 | [11:0] | clk\_ratio\_07[11:0] | RO | 0x0 | Interface clock to TDD clock ratio. |
| | | | | | |
| 0x300 | [31:0] | primary\_assert\_08[31:0] | RW | 0x0 | Primary, clock count- high. |
| | | | | | |
| 0x304 | [31:0] | primary\_deassert\_08[31:0] | RW | 0x0 | Primary, clock count- low. |
| | | | | | |
| 0x308 | [31:0] | secondary\_assert\_08[31:0] | RW | 0x0 | Secondary, clock count- high. |
| | | | | | |
| 0x30c | [31:0] | secondary\_deassert\_08[31:0] | RW | 0x0 | Secondary, clock count- low. |
| | | | | | |
| 0x310 | [31:0] | primary\_frame\_assert\_08[31:0] | RW | 0x0 | Primary, frame count- high. |
| | | | | | |
| 0x314 | [31:0] | primary\_frame\_deassert\_08[31:0] | RW | 0x0 | Primary, frame count- low. |
| | | | | | |
| 0x318 | [31:0] | secondary\_frame\_assert\_08[31:0] | RW | 0x0 | Secondary, frame count- high. |
| | | | | | |
| 0x31c | [31:0] | secondary\_frame\_deassert\_08[31:0] | RW | 0x0 | Secondary, frame count- low. |
| | | | | | |
| 0x320 | [1:0] | mode\_08[1:0] | RW | 0x0 | Software or hardware mode. |
| | | | | | |
| 0x324 | [0:0] | sync\_08 | RW | 0x0 | Interface clock synchronous select. |
| | | | | | |
| 0x328 | [11:0] | clk\_ratio\_08[11:0] | RO | 0x0 | Interface clock to TDD clock ratio. |
| | | | | | |
| 0x340 | [31:0] | primary\_assert\_09[31:0] | RW | 0x0 | Primary, clock count- high. |
| | | | | | |
| 0x344 | [31:0] | primary\_deassert\_09[31:0] | RW | 0x0 | Primary, clock count- low. |
| | | | | | |
| 0x348 | [31:0] | secondary\_assert\_09[31:0] | RW | 0x0 | Secondary, clock count- high. |
| | | | | | |
| 0x34c | [31:0] | secondary\_deassert\_09[31:0] | RW | 0x0 | Secondary, clock count- low. |
| | | | | | |
| 0x350 | [31:0] | primary\_frame\_assert\_09[31:0] | RW | 0x0 | Primary, frame count- high. |
| | | | | | |
| 0x354 | [31:0] | primary\_frame\_deassert\_09[31:0] | RW | 0x0 | Primary, frame count- low. |
| | | | | | |
| 0x358 | [31:0] | secondary\_frame\_assert\_09[31:0] | RW | 0x0 | Secondary, frame count- high. |
| | | | | | |
| 0x35c | [31:0] | secondary\_frame\_deassert\_09[31:0] | RW | 0x0 | Secondary, frame count- low. |
| | | | | | |
| 0x360 | [1:0] | mode\_09[1:0] | RW | 0x0 | Software or hardware mode. |
| | | | | | |
| 0x364 | [0:0] | sync\_09 | RW | 0x0 | Interface clock synchronous select. |
| | | | | | |
| 0x368 | [11:0] | clk\_ratio\_09[11:0] | RO | 0x0 | Interface clock to TDD clock ratio. |
| | | | | | |
| 0x380 | [31:0] | primary\_assert\_10[31:0] | RW | 0x0 | Primary, clock count- high. |
| | | | | | |
| 0x384 | [31:0] | primary\_deassert\_10[31:0] | RW | 0x0 | Primary, clock count- low. |
| | | | | | |
| 0x388 | [31:0] | secondary\_assert\_10[31:0] | RW | 0x0 | Secondary, clock count- high. |
| | | | | | |
| 0x38c | [31:0] | secondary\_deassert\_10[31:0] | RW | 0x0 | Secondary, clock count- low. |
| | | | | | |
| 0x390 | [31:0] | primary\_frame\_assert\_10[31:0] | RW | 0x0 | Primary, frame count- high. |
| | | | | | |
| 0x394 | [31:0] | primary\_frame\_deassert\_10[31:0] | RW | 0x0 | Primary, frame count- low. |
| | | | | | |
| 0x398 | [31:0] | secondary\_frame\_assert\_10[31:0] | RW | 0x0 | Secondary, frame count- high. |
| | | | | | |
| 0x39c | [31:0] | secondary\_frame\_deassert\_10[31:0] | RW | 0x0 | Secondary, frame count- low. |
| | | | | | |
| 0x3a0 | [1:0] | mode\_10[1:0] | RW | 0x0 | Software or hardware mode. |
| | | | | | |
| 0x3a4 | [0:0] | sync\_10 | RW | 0x0 | Interface clock synchronous select. |
| | | | | | |
| 0x3a8 | [11:0] | clk\_ratio\_10[11:0] | RO | 0x0 | Interface clock to TDD clock ratio. |
| | | | | | |
| 0x3c0 | [31:0] | primary\_assert\_11[31:0] | RW | 0x0 | Primary, clock count- high. |
| | | | | | |
| 0x3c4 | [31:0] | primary\_deassert\_11[31:0] | RW | 0x0 | Primary, clock count- low. |
| | | | | | |
| 0x3c8 | [31:0] | secondary\_assert\_11[31:0] | RW | 0x0 | Secondary, clock count- high. |
| | | | | | |
| 0x3cc | [31:0] | secondary\_deassert\_11[31:0] | RW | 0x0 | Secondary, clock count- low. |
| | | | | | |
| 0x3d0 | [31:0] | primary\_frame\_assert\_11[31:0] | RW | 0x0 | Primary, frame count- high. |
| | | | | | |
| 0x3d4 | [31:0] | primary\_frame\_deassert\_11[31:0] | RW | 0x0 | Primary, frame count- low. |
| | | | | | |
| 0x3d8 | [31:0] | secondary\_frame\_assert\_11[31:0] | RW | 0x0 | Secondary, frame count- high. |
| | | | | | |
| 0x3dc | [31:0] | secondary\_frame\_deassert\_11[31:0] | RW | 0x0 | Secondary, frame count- low. |
| | | | | | |
| 0x3e0 | [1:0] | mode\_11[1:0] | RW | 0x0 | Software or hardware mode. |
| | | | | | |
| 0x3e4 | [0:0] | sync\_11 | RW | 0x0 | Interface clock synchronous select. |
| | | | | | |
| 0x3e8 | [11:0] | clk\_ratio\_11[11:0] | RO | 0x0 | Interface clock to TDD clock ratio. |
| | | | | | |
| 0x400 | [31:0] | primary\_assert\_12[31:0] | RW | 0x0 | Primary, clock count- high. |
| | | | | | |
| 0x404 | [31:0] | primary\_deassert\_12[31:0] | RW | 0x0 | Primary, clock count- low. |
| | | | | | |
| 0x408 | [31:0] | secondary\_assert\_12[31:0] | RW | 0x0 | Secondary, clock count- high. |
| | | | | | |
| 0x40c | [31:0] | secondary\_deassert\_12[31:0] | RW | 0x0 | Secondary, clock count- low. |
| | | | | | |
| 0x410 | [31:0] | primary\_frame\_assert\_12[31:0] | RW | 0x0 | Primary, frame count- high. |
| | | | | | |
| 0x414 | [31:0] | primary\_frame\_deassert\_12[31:0] | RW | 0x0 | Primary, frame count- low. |
| | | | | | |
| 0x418 | [31:0] | secondary\_frame\_assert\_12[31:0] | RW | 0x0 | Secondary, frame count- high. |
| | | | | | |
| 0x41c | [31:0] | secondary\_frame\_deassert\_12[31:0] | RW | 0x0 | Secondary, frame count- low. |
| | | | | | |
| 0x420 | [1:0] | mode\_12[1:0] | RW | 0x0 | Software or hardware mode. |
| | | | | | |
| 0x424 | [0:0] | sync\_12 | RW | 0x0 | Interface clock synchronous select. |
| | | | | | |
| 0x428 | [11:0] | clk\_ratio\_12[11:0] | RO | 0x0 | Interface clock to TDD clock ratio. |
| | | | | | |
| 0x440 | [31:0] | primary\_assert\_13[31:0] | RW | 0x0 | Primary, clock count- high. |
| | | | | | |
| 0x444 | [31:0] | primary\_deassert\_13[31:0] | RW | 0x0 | Primary, clock count- low. |
| | | | | | |
| 0x448 | [31:0] | secondary\_assert\_13[31:0] | RW | 0x0 | Secondary, clock count- high. |
| | | | | | |
| 0x44c | [31:0] | secondary\_deassert\_13[31:0] | RW | 0x0 | Secondary, clock count- low. |
| | | | | | |
| 0x450 | [31:0] | primary\_frame\_assert\_13[31:0] | RW | 0x0 | Primary, frame count- high. |
| | | | | | |
| 0x454 | [31:0] | primary\_frame\_deassert\_13[31:0] | RW | 0x0 | Primary, frame count- low. |
| | | | | | |
| 0x458 | [31:0] | secondary\_frame\_assert\_13[31:0] | RW | 0x0 | Secondary, frame count- high. |
| | | | | | |
| 0x45c | [31:0] | secondary\_frame\_deassert\_13[31:0] | RW | 0x0 | Secondary, frame count- low. |
| | | | | | |
| 0x460 | [1:0] | mode\_13[1:0] | RW | 0x0 | Software or hardware mode. |
| | | | | | |
| 0x464 | [0:0] | sync\_13 | RW | 0x0 | Interface clock synchronous select. |
| | | | | | |
| 0x468 | [11:0] | clk\_ratio\_13[11:0] | RO | 0x0 | Interface clock to TDD clock ratio. |
| | | | | | |
| 0x480 | [31:0] | primary\_assert\_14[31:0] | RW | 0x0 | Primary, clock count- high. |
| | | | | | |
| 0x484 | [31:0] | primary\_deassert\_14[31:0] | RW | 0x0 | Primary, clock count- low. |
| | | | | | |
| 0x488 | [31:0] | secondary\_assert\_14[31:0] | RW | 0x0 | Secondary, clock count- high. |
| | | | | | |
| 0x48c | [31:0] | secondary\_deassert\_14[31:0] | RW | 0x0 | Secondary, clock count- low. |
| | | | | | |
| 0x490 | [31:0] | primary\_frame\_assert\_14[31:0] | RW | 0x0 | Primary, frame count- high. |
| | | | | | |
| 0x494 | [31:0] | primary\_frame\_deassert\_14[31:0] | RW | 0x0 | Primary, frame count- low. |
| | | | | | |
| 0x498 | [31:0] | secondary\_frame\_assert\_14[31:0] | RW | 0x0 | Secondary, frame count- high. |
| | | | | | |
| 0x49c | [31:0] | secondary\_frame\_deassert\_14[31:0] | RW | 0x0 | Secondary, frame count- low. |
| | | | | | |
| 0x4a0 | [1:0] | mode\_14[1:0] | RW | 0x0 | Software or hardware mode. |
| | | | | | |
| 0x4a4 | [0:0] | sync\_14 | RW | 0x0 | Interface clock synchronous select. |
| | | | | | |
| 0x4a8 | [11:0] | clk\_ratio\_14[11:0] | RO | 0x0 | Interface clock to TDD clock ratio. |
| | | | | | |
| 0x4c0 | [31:0] | primary\_assert\_15[31:0] | RW | 0x0 | Primary, clock count- high. |
| | | | | | |
| 0x4c4 | [31:0] | primary\_deassert\_15[31:0] | RW | 0x0 | Primary, clock count- low. |
| | | | | | |
| 0x4c8 | [31:0] | secondary\_assert\_15[31:0] | RW | 0x0 | Secondary, clock count- high. |
| | | | | | |
| 0x4cc | [31:0] | secondary\_deassert\_15[31:0] | RW | 0x0 | Secondary, clock count- low. |
| | | | | | |
| 0x4d0 | [31:0] | primary\_frame\_assert\_15[31:0] | RW | 0x0 | Primary, frame count- high. |
| | | | | | |
| 0x4d4 | [31:0] | primary\_frame\_deassert\_15[31:0] | RW | 0x0 | Primary, frame count- low. |
| | | | | | |
| 0x4d8 | [31:0] | secondary\_frame\_assert\_15[31:0] | RW | 0x0 | Secondary, frame count- high. |
| | | | | | |
| 0x4dc | [31:0] | secondary\_frame\_deassert\_15[31:0] | RW | 0x0 | Secondary, frame count- low. |
| | | | | | |
| 0x4e0 | [1:0] | mode\_15[1:0] | RW | 0x0 | Software or hardware mode. |
| | | | | | |
| 0x4e4 | [0:0] | sync\_15 | RW | 0x0 | Interface clock synchronous select. |
| | | | | | |
| 0x4e8 | [11:0] | clk\_ratio\_15[11:0] | RO | 0x0 | Interface clock to TDD clock ratio. |
| | | | | | |
| 0x500 | [31:0] | primary\_assert\_16[31:0] | RW | 0x0 | Primary, clock count- high. |
| | | | | | |
| 0x504 | [31:0] | primary\_deassert\_16[31:0] | RW | 0x0 | Primary, clock count- low. |
| | | | | | |
| 0x508 | [31:0] | secondary\_assert\_16[31:0] | RW | 0x0 | Secondary, clock count- high. |
| | | | | | |
| 0x50c | [31:0] | secondary\_deassert\_16[31:0] | RW | 0x0 | Secondary, clock count- low. |
| | | | | | |
| 0x510 | [31:0] | primary\_frame\_assert\_16[31:0] | RW | 0x0 | Primary, frame count- high. |
| | | | | | |
| 0x514 | [31:0] | primary\_frame\_deassert\_16[31:0] | RW | 0x0 | Primary, frame count- low. |
| | | | | | |
| 0x518 | [31:0] | secondary\_frame\_assert\_16[31:0] | RW | 0x0 | Secondary, frame count- high. |
| | | | | | |
| 0x51c | [31:0] | secondary\_frame\_deassert\_16[31:0] | RW | 0x0 | Secondary, frame count- low. |
| | | | | | |
| 0x520 | [1:0] | mode\_16[1:0] | RW | 0x0 | Software or hardware mode. |
| | | | | | |
| 0x524 | [0:0] | sync\_16 | RW | 0x0 | Interface clock synchronous select. |
| | | | | | |
| 0x528 | [11:0] | clk\_ratio\_16[11:0] | RO | 0x0 | Interface clock to TDD clock ratio. |
| | | | | | |
| 0x540 | [31:0] | primary\_assert\_17[31:0] | RW | 0x0 | Primary, clock count- high. |
| | | | | | |
| 0x544 | [31:0] | primary\_deassert\_17[31:0] | RW | 0x0 | Primary, clock count- low. |
| | | | | | |
| 0x548 | [31:0] | secondary\_assert\_17[31:0] | RW | 0x0 | Secondary, clock count- high. |
| | | | | | |
| 0x54c | [31:0] | secondary\_deassert\_17[31:0] | RW | 0x0 | Secondary, clock count- low. |
| | | | | | |
| 0x550 | [31:0] | primary\_frame\_assert\_17[31:0] | RW | 0x0 | Primary, frame count- high. |
| | | | | | |
| 0x554 | [31:0] | primary\_frame\_deassert\_17[31:0] | RW | 0x0 | Primary, frame count- low. |
| | | | | | |
| 0x558 | [31:0] | secondary\_frame\_assert\_17[31:0] | RW | 0x0 | Secondary, frame count- high. |
| | | | | | |
| 0x55c | [31:0] | secondary\_frame\_deassert\_17[31:0] | RW | 0x0 | Secondary, frame count- low. |
| | | | | | |
| 0x560 | [1:0] | mode\_17[1:0] | RW | 0x0 | Software or hardware mode. |
| | | | | | |
| 0x564 | [0:0] | sync\_17 | RW | 0x0 | Interface clock synchronous select. |
| | | | | | |
| 0x568 | [11:0] | clk\_ratio\_17[11:0] | RO | 0x0 | Interface clock to TDD clock ratio. |
| | | | | | |
| 0x580 | [31:0] | primary\_assert\_18[31:0] | RW | 0x0 | Primary, clock count- high. |
| | | | | | |
| 0x584 | [31:0] | primary\_deassert\_18[31:0] | RW | 0x0 | Primary, clock count- low. |
| | | | | | |
| 0x588 | [31:0] | secondary\_assert\_18[31:0] | RW | 0x0 | Secondary, clock count- high. |
| | | | | | |
| 0x58c | [31:0] | secondary\_deassert\_18[31:0] | RW | 0x0 | Secondary, clock count- low. |
| | | | | | |
| 0x590 | [31:0] | primary\_frame\_assert\_18[31:0] | RW | 0x0 | Primary, frame count- high. |
| | | | | | |
| 0x594 | [31:0] | primary\_frame\_deassert\_18[31:0] | RW | 0x0 | Primary, frame count- low. |
| | | | | | |
| 0x598 | [31:0] | secondary\_frame\_assert\_18[31:0] | RW | 0x0 | Secondary, frame count- high. |
| | | | | | |
| 0x59c | [31:0] | secondary\_frame\_deassert\_18[31:0] | RW | 0x0 | Secondary, frame count- low. |
| | | | | | |
| 0x5a0 | [1:0] | mode\_18[1:0] | RW | 0x0 | Software or hardware mode. |
| | | | | | |
| 0x5a4 | [0:0] | sync\_18 | RW | 0x0 | Interface clock synchronous select. |
| | | | | | |
| 0x5a8 | [11:0] | clk\_ratio\_18[11:0] | RO | 0x0 | Interface clock to TDD clock ratio. |
| | | | | | |
| 0x5c0 | [31:0] | primary\_assert\_19[31:0] | RW | 0x0 | Primary, clock count- high. |
| | | | | | |
| 0x5c4 | [31:0] | primary\_deassert\_19[31:0] | RW | 0x0 | Primary, clock count- low. |
| | | | | | |
| 0x5c8 | [31:0] | secondary\_assert\_19[31:0] | RW | 0x0 | Secondary, clock count- high. |
| | | | | | |
| 0x5cc | [31:0] | secondary\_deassert\_19[31:0] | RW | 0x0 | Secondary, clock count- low. |
| | | | | | |
| 0x5d0 | [31:0] | primary\_frame\_assert\_19[31:0] | RW | 0x0 | Primary, frame count- high. |
| | | | | | |
| 0x5d4 | [31:0] | primary\_frame\_deassert\_19[31:0] | RW | 0x0 | Primary, frame count- low. |
| | | | | | |
| 0x5d8 | [31:0] | secondary\_frame\_assert\_19[31:0] | RW | 0x0 | Secondary, frame count- high. |
| | | | | | |
| 0x5dc | [31:0] | secondary\_frame\_deassert\_19[31:0] | RW | 0x0 | Secondary, frame count- low. |
| | | | | | |
| 0x5e0 | [1:0] | mode\_19[1:0] | RW | 0x0 | Software or hardware mode. |
| | | | | | |
| 0x5e4 | [0:0] | sync\_19 | RW | 0x0 | Interface clock synchronous select. |
| | | | | | |
| 0x5e8 | [11:0] | clk\_ratio\_19[11:0] | RO | 0x0 | Interface clock to TDD clock ratio. |
| | | | | | |
| 0x600 | [31:0] | primary\_assert\_20[31:0] | RW | 0x0 | Primary, clock count- high. |
| | | | | | |
| 0x604 | [31:0] | primary\_deassert\_20[31:0] | RW | 0x0 | Primary, clock count- low. |
| | | | | | |
| 0x608 | [31:0] | secondary\_assert\_20[31:0] | RW | 0x0 | Secondary, clock count- high. |
| | | | | | |
| 0x60c | [31:0] | secondary\_deassert\_20[31:0] | RW | 0x0 | Secondary, clock count- low. |
| | | | | | |
| 0x610 | [31:0] | primary\_frame\_assert\_20[31:0] | RW | 0x0 | Primary, frame count- high. |
| | | | | | |
| 0x614 | [31:0] | primary\_frame\_deassert\_20[31:0] | RW | 0x0 | Primary, frame count- low. |
| | | | | | |
| 0x618 | [31:0] | secondary\_frame\_assert\_20[31:0] | RW | 0x0 | Secondary, frame count- high. |
| | | | | | |
| 0x61c | [31:0] | secondary\_frame\_deassert\_20[31:0] | RW | 0x0 | Secondary, frame count- low. |
| | | | | | |
| 0x620 | [1:0] | mode\_20[1:0] | RW | 0x0 | Software or hardware mode. |
| | | | | | |
| 0x624 | [0:0] | sync\_20 | RW | 0x0 | Interface clock synchronous select. |
| | | | | | |
| 0x628 | [11:0] | clk\_ratio\_20[11:0] | RO | 0x0 | Interface clock to TDD clock ratio. |
| | | | | | |
| 0x640 | [31:0] | primary\_assert\_21[31:0] | RW | 0x0 | Primary, clock count- high. |
| | | | | | |
| 0x644 | [31:0] | primary\_deassert\_21[31:0] | RW | 0x0 | Primary, clock count- low. |
| | | | | | |
| 0x648 | [31:0] | secondary\_assert\_21[31:0] | RW | 0x0 | Secondary, clock count- high. |
| | | | | | |
| 0x64c | [31:0] | secondary\_deassert\_21[31:0] | RW | 0x0 | Secondary, clock count- low. |
| | | | | | |
| 0x650 | [31:0] | primary\_frame\_assert\_21[31:0] | RW | 0x0 | Primary, frame count- high. |
| | | | | | |
| 0x654 | [31:0] | primary\_frame\_deassert\_21[31:0] | RW | 0x0 | Primary, frame count- low. |
| | | | | | |
| 0x658 | [31:0] | secondary\_frame\_assert\_21[31:0] | RW | 0x0 | Secondary, frame count- high. |
| | | | | | |
| 0x65c | [31:0] | secondary\_frame\_deassert\_21[31:0] | RW | 0x0 | Secondary, frame count- low. |
| | | | | | |
| 0x660 | [1:0] | mode\_21[1:0] | RW | 0x0 | Software or hardware mode. |
| | | | | | |
| 0x664 | [0:0] | sync\_21 | RW | 0x0 | Interface clock synchronous select. |
| | | | | | |
| 0x668 | [11:0] | clk\_ratio\_21[11:0] | RO | 0x0 | Interface clock to TDD clock ratio. |
| | | | | | |
| 0x680 | [31:0] | primary\_assert\_22[31:0] | RW | 0x0 | Primary, clock count- high. |
| | | | | | |
| 0x684 | [31:0] | primary\_deassert\_22[31:0] | RW | 0x0 | Primary, clock count- low. |
| | | | | | |
| 0x688 | [31:0] | secondary\_assert\_22[31:0] | RW | 0x0 | Secondary, clock count- high. |
| | | | | | |
| 0x68c | [31:0] | secondary\_deassert\_22[31:0] | RW | 0x0 | Secondary, clock count- low. |
| | | | | | |
| 0x690 | [31:0] | primary\_frame\_assert\_22[31:0] | RW | 0x0 | Primary, frame count- high. |
| | | | | | |
| 0x694 | [31:0] | primary\_frame\_deassert\_22[31:0] | RW | 0x0 | Primary, frame count- low. |
| | | | | | |
| 0x698 | [31:0] | secondary\_frame\_assert\_22[31:0] | RW | 0x0 | Secondary, frame count- high. |
| | | | | | |
| 0x69c | [31:0] | secondary\_frame\_deassert\_22[31:0] | RW | 0x0 | Secondary, frame count- low. |
| | | | | | |
| 0x6a0 | [1:0] | mode\_22[1:0] | RW | 0x0 | Software or hardware mode. |
| | | | | | |
| 0x6a4 | [0:0] | sync\_22 | RW | 0x0 | Interface clock synchronous select. |
| | | | | | |
| 0x6a8 | [11:0] | clk\_ratio\_22[11:0] | RO | 0x0 | Interface clock to TDD clock ratio. |
| | | | | | |
| 0x6c0 | [31:0] | primary\_assert\_23[31:0] | RW | 0x0 | Primary, clock count- high. |
| | | | | | |
| 0x6c4 | [31:0] | primary\_deassert\_23[31:0] | RW | 0x0 | Primary, clock count- low. |
| | | | | | |
| 0x6c8 | [31:0] | secondary\_assert\_23[31:0] | RW | 0x0 | Secondary, clock count- high. |
| | | | | | |
| 0x6cc | [31:0] | secondary\_deassert\_23[31:0] | RW | 0x0 | Secondary, clock count- low. |
| | | | | | |
| 0x6d0 | [31:0] | primary\_frame\_assert\_23[31:0] | RW | 0x0 | Primary, frame count- high. |
| | | | | | |
| 0x6d4 | [31:0] | primary\_frame\_deassert\_23[31:0] | RW | 0x0 | Primary, frame count- low. |
| | | | | | |
| 0x6d8 | [31:0] | secondary\_frame\_assert\_23[31:0] | RW | 0x0 | Secondary, frame count- high. |
| | | | | | |
| 0x6dc | [31:0] | secondary\_frame\_deassert\_23[31:0] | RW | 0x0 | Secondary, frame count- low. |
| | | | | | |
| 0x6e0 | [1:0] | mode\_23[1:0] | RW | 0x0 | Software or hardware mode. |
| | | | | | |
| 0x6e4 | [0:0] | sync\_23 | RW | 0x0 | Interface clock synchronous select. |
| | | | | | |
| 0x6e8 | [11:0] | clk\_ratio\_23[11:0] | RO | 0x0 | Interface clock to TDD clock ratio. |
| | | | | | |
| 0x700 | [31:0] | primary\_assert\_24[31:0] | RW | 0x0 | Primary, clock count- high. |
| | | | | | |
| 0x704 | [31:0] | primary\_deassert\_24[31:0] | RW | 0x0 | Primary, clock count- low. |
| | | | | | |
| 0x708 | [31:0] | secondary\_assert\_24[31:0] | RW | 0x0 | Secondary, clock count- high. |
| | | | | | |
| 0x70c | [31:0] | secondary\_deassert\_24[31:0] | RW | 0x0 | Secondary, clock count- low. |
| | | | | | |
| 0x710 | [31:0] | primary\_frame\_assert\_24[31:0] | RW | 0x0 | Primary, frame count- high. |
| | | | | | |
| 0x714 | [31:0] | primary\_frame\_deassert\_24[31:0] | RW | 0x0 | Primary, frame count- low. |
| | | | | | |
| 0x718 | [31:0] | secondary\_frame\_assert\_24[31:0] | RW | 0x0 | Secondary, frame count- high. |
| | | | | | |
| 0x71c | [31:0] | secondary\_frame\_deassert\_24[31:0] | RW | 0x0 | Secondary, frame count- low. |
| | | | | | |
| 0x720 | [1:0] | mode\_24[1:0] | RW | 0x0 | Software or hardware mode. |
| | | | | | |
| 0x724 | [0:0] | sync\_24 | RW | 0x0 | Interface clock synchronous select. |
| | | | | | |
| 0x728 | [11:0] | clk\_ratio\_24[11:0] | RO | 0x0 | Interface clock to TDD clock ratio. |
| | | | | | |
| 0x740 | [31:0] | primary\_assert\_25[31:0] | RW | 0x0 | Primary, clock count- high. |
| | | | | | |
| 0x744 | [31:0] | primary\_deassert\_25[31:0] | RW | 0x0 | Primary, clock count- low. |
| | | | | | |
| 0x748 | [31:0] | secondary\_assert\_25[31:0] | RW | 0x0 | Secondary, clock count- high. |
| | | | | | |
| 0x74c | [31:0] | secondary\_deassert\_25[31:0] | RW | 0x0 | Secondary, clock count- low. |
| | | | | | |
| 0x750 | [31:0] | primary\_frame\_assert\_25[31:0] | RW | 0x0 | Primary, frame count- high. |
| | | | | | |
| 0x754 | [31:0] | primary\_frame\_deassert\_25[31:0] | RW | 0x0 | Primary, frame count- low. |
| | | | | | |
| 0x758 | [31:0] | secondary\_frame\_assert\_25[31:0] | RW | 0x0 | Secondary, frame count- high. |
| | | | | | |
| 0x75c | [31:0] | secondary\_frame\_deassert\_25[31:0] | RW | 0x0 | Secondary, frame count- low. |
| | | | | | |
| 0x760 | [1:0] | mode\_25[1:0] | RW | 0x0 | Software or hardware mode. |
| | | | | | |
| 0x764 | [0:0] | sync\_25 | RW | 0x0 | Interface clock synchronous select. |
| | | | | | |
| 0x768 | [11:0] | clk\_ratio\_25[11:0] | RO | 0x0 | Interface clock to TDD clock ratio. |
| | | | | | |
| 0x780 | [31:0] | primary\_assert\_26[31:0] | RW | 0x0 | Primary, clock count- high. |
| | | | | | |
| 0x784 | [31:0] | primary\_deassert\_26[31:0] | RW | 0x0 | Primary, clock count- low. |
| | | | | | |
| 0x788 | [31:0] | secondary\_assert\_26[31:0] | RW | 0x0 | Secondary, clock count- high. |
| | | | | | |
| 0x78c | [31:0] | secondary\_deassert\_26[31:0] | RW | 0x0 | Secondary, clock count- low. |
| | | | | | |
| 0x790 | [31:0] | primary\_frame\_assert\_26[31:0] | RW | 0x0 | Primary, frame count- high. |
| | | | | | |
| 0x794 | [31:0] | primary\_frame\_deassert\_26[31:0] | RW | 0x0 | Primary, frame count- low. |
| | | | | | |
| 0x798 | [31:0] | secondary\_frame\_assert\_26[31:0] | RW | 0x0 | Secondary, frame count- high. |
| | | | | | |
| 0x79c | [31:0] | secondary\_frame\_deassert\_26[31:0] | RW | 0x0 | Secondary, frame count- low. |
| | | | | | |
| 0x7a0 | [1:0] | mode\_26[1:0] | RW | 0x0 | Software or hardware mode. |
| | | | | | |
| 0x7a4 | [0:0] | sync\_26 | RW | 0x0 | Interface clock synchronous select. |
| | | | | | |
| 0x7a8 | [11:0] | clk\_ratio\_26[11:0] | RO | 0x0 | Interface clock to TDD clock ratio. |
| | | | | | |
| 0x7c0 | [31:0] | primary\_assert\_27[31:0] | RW | 0x0 | Primary, clock count- high. |
| | | | | | |
| 0x7c4 | [31:0] | primary\_deassert\_27[31:0] | RW | 0x0 | Primary, clock count- low. |
| | | | | | |
| 0x7c8 | [31:0] | secondary\_assert\_27[31:0] | RW | 0x0 | Secondary, clock count- high. |
| | | | | | |
| 0x7cc | [31:0] | secondary\_deassert\_27[31:0] | RW | 0x0 | Secondary, clock count- low. |
| | | | | | |
| 0x7d0 | [31:0] | primary\_frame\_assert\_27[31:0] | RW | 0x0 | Primary, frame count- high. |
| | | | | | |
| 0x7d4 | [31:0] | primary\_frame\_deassert\_27[31:0] | RW | 0x0 | Primary, frame count- low. |
| | | | | | |
| 0x7d8 | [31:0] | secondary\_frame\_assert\_27[31:0] | RW | 0x0 | Secondary, frame count- high. |
| | | | | | |
| 0x7dc | [31:0] | secondary\_frame\_deassert\_27[31:0] | RW | 0x0 | Secondary, frame count- low. |
| | | | | | |
| 0x7e0 | [1:0] | mode\_27[1:0] | RW | 0x0 | Software or hardware mode. |
| | | | | | |
| 0x7e4 | [0:0] | sync\_27 | RW | 0x0 | Interface clock synchronous select. |
| | | | | | |
| 0x7e8 | [11:0] | clk\_ratio\_27[11:0] | RO | 0x0 | Interface clock to TDD clock ratio. |
| | | | | | |
---
