// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Description:       AXI_ADRV9001, TDD
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module axi_adrv9001_tdd #(

    parameter ID = 0,
    parameter INSTANCE_ID = 0) (

    // tdd dma interface

    input   wire                    rx0_resetn,
    input   wire                    rx0_clk,
    input   wire                    rx0_sync,
    output  wire                    rx0_enable,
    output  wire                    rx0_trig,
    input   wire                    orx0_sync,
    output  wire                    orx0_enable,
    output  wire                    orx0_trig,

    input   wire                    tx0_resetn,
    input   wire                    tx0_clk,
    input   wire                    tx0_sync,
    output  wire                    tx0_enable,
    output  wire                    tx0_trig,

    input   wire                    rx1_resetn,
    input   wire                    rx1_clk,
    input   wire                    rx1_sync,
    output  wire                    rx1_enable,
    output  wire                    rx1_trig,
    input   wire                    orx1_sync,
    output  wire                    orx1_enable,
    output  wire                    orx1_trig,

    input   wire                    tx1_resetn,
    input   wire                    tx1_clk,
    input   wire                    tx1_sync,
    output  wire                    tx1_enable,
    output  wire                    tx1_trig,

    output  wire                    spi_trig,
    output  wire                    gpio_trig,

    // tdd interface

    output  wire                    tdd_out_resetn,
    output  wire                    tdd_out_genb,
    output  wire                    tdd_out_state,
    output  wire                    tdd_out_last,
    output  wire  [ 31:0]           tdd_out_clk_cnt,
    output  wire  [ 31:0]           tdd_out_frm_cnt,

    input   wire                    tdd_clk,
    input   wire                    tdd_resetn,
    input   wire                    tdd_genb,
    input   wire                    tdd_state,
    input   wire                    tdd_last,
    input   wire  [ 31:0]           tdd_clk_cnt,
    input   wire  [ 31:0]           tdd_frm_cnt,

    output  wire                    tdd_rx0_device_enable,
    output  wire                    tdd_tx0_device_enable,
    output  wire                    tdd_rx1_device_enable,
    output  wire                    tdd_tx1_device_enable,
    output  wire                    tdd_orx0_gpio_enable,
    output  wire                    tdd_orx1_gpio_enable,
    output  wire                    tdd_tx0_gpio_enable,
    output  wire                    tdd_tx1_gpio_enable,
    output  wire                    tdd_ifrm0ctl0_gpio_enable,
    output  wire                    tdd_ifrm0ctl1_gpio_enable,
    output  wire                    tdd_ifrm1ctl0_gpio_enable,
    output  wire                    tdd_ifrm1ctl1_gpio_enable,
    output  wire                    tdd_trig0_ext_enable,
    output  wire                    tdd_trig1_ext_enable,

    // asynchronous events
 
    input   wire  [  3:0]           trig,

    // axi interface

    input   wire                    axilite_clk,
    input   wire                    axilite_resetn,
    input   wire                    axilite_wrreq,
    input   wire  [ 15:0]           axilite_wraddr,
    input   wire  [ 31:0]           axilite_wrdata,
    output  wire                    axilite_wrack,
    input   wire                    axilite_rdreq,
    input   wire  [ 15:0]           axilite_rdaddr,
    output  wire  [ 31:0]           axilite_rddata,
    output  wire                    axilite_rdack);

    // internal registers
 
    reg                             axilite_cdc_state_d = 'd0;
    reg                             axilite_cdc_state_clr_d = 'd0;
    reg                             axilite_cdc_state_int = 'd0;

    // internal signals
 
    wire          [(( 6* 1)-1):0]   resetn;
    wire          [(( 6* 1)-1):0]   clk;
    wire          [(( 6* 1)-1):0]   sync;
    wire          [(( 6* 1)-1):0]   trig_enable;
    wire          [(( 6* 1)-1):0]   dma_enable;
    wire          [((10* 1)-1):0]   tdd_trig_enable;
    wire          [((12* 1)-1):0]   tdd_dev_enable;
    wire          [(( 6* 1)-1):0]   tdd_dma_enable;
    wire                            tdd_int_resetn;
    wire          [ 31:0]           axilite_frame_period;
    wire          [ 31:0]           axilite_num_of_frames;
    wire          [ 31:0]           axilite_frame_switch_period;
    wire          [ 31:0]           axilite_frame_switch_number;
    wire          [  7:0]           axilite_trigger_mode;
    wire                            axilite_stop;
    wire                            axilite_start;
    wire                            axilite_request_clr;
    wire                            axilite_frame_switch_enable;
    wire                            axilite_sequence_repeat;
    wire                            axilite_swreset;
    wire                            axilite_swreset_clr;
    wire          [ 31:0]           axilite_clk_mon_count;
    wire                            axilite_global_enb;
    wire                            axilite_cdc_state;
    wire                            axilite_cdc_state_clr;
    wire                            axilite_cdc_state_clr_inv;
    wire          [((10*32)-1):0]   axilite_trig_pri_assert;
    wire          [((10*32)-1):0]   axilite_trig_pri_deassert;
    wire          [((10*32)-1):0]   axilite_trig_sec_assert;
    wire          [((10*32)-1):0]   axilite_trig_sec_deassert;
    wire          [((10*32)-1):0]   axilite_trig_pri_frame_assert;
    wire          [((10*32)-1):0]   axilite_trig_pri_frame_deassert;
    wire          [((10*32)-1):0]   axilite_trig_sec_frame_assert;
    wire          [((10*32)-1):0]   axilite_trig_sec_frame_deassert;
    wire          [((10* 2)-1):0]   axilite_trig_mode;
    wire          [((12*32)-1):0]   axilite_dev_pri_assert;
    wire          [((12*32)-1):0]   axilite_dev_pri_deassert;
    wire          [((12*32)-1):0]   axilite_dev_sec_assert;
    wire          [((12*32)-1):0]   axilite_dev_sec_deassert;
    wire          [((12*32)-1):0]   axilite_dev_pri_frame_assert;
    wire          [((12*32)-1):0]   axilite_dev_pri_frame_deassert;
    wire          [((12*32)-1):0]   axilite_dev_sec_frame_assert;
    wire          [((12*32)-1):0]   axilite_dev_sec_frame_deassert;
    wire          [((12* 2)-1):0]   axilite_dev_mode;
    wire          [(( 6*32)-1):0]   axilite_dma_pri_assert;
    wire          [(( 6*32)-1):0]   axilite_dma_pri_deassert;
    wire          [(( 6*32)-1):0]   axilite_dma_sec_assert;
    wire          [(( 6*32)-1):0]   axilite_dma_sec_deassert;
    wire          [(( 6*32)-1):0]   axilite_dma_pri_frame_assert;
    wire          [(( 6*32)-1):0]   axilite_dma_pri_frame_deassert;
    wire          [(( 6*32)-1):0]   axilite_dma_sec_frame_assert;
    wire          [(( 6*32)-1):0]   axilite_dma_sec_frame_deassert;
    wire          [(( 6* 2)-1):0]   axilite_dma_mode;
    wire          [(( 6* 1)-1):0]   axilite_dma_sync;
    wire          [(( 6*12)-1):0]   axilite_dma_clk_ratio;

    // cdc state
 
    assign axilite_cdc_state_clr_inv = ~axilite_cdc_state_clr;

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_cdc_state_d <= 'd0;
            axilite_cdc_state_clr_d <= 'd0;
            axilite_cdc_state_int <= 'd0;
        end else begin
            axilite_cdc_state_d <= axilite_cdc_state;
            axilite_cdc_state_clr_d <= axilite_cdc_state_clr;
            if ((axilite_cdc_state_clr_d == 1'd0) &&
                (axilite_cdc_state_clr == 1'd1)) begin
                axilite_cdc_state_int <= 1'd0;
            end else if ((axilite_cdc_state_d == 1'd0) &&
                (axilite_cdc_state == 1'd1)) begin
                axilite_cdc_state_int <= 1'd1;
            end
        end
    end

    // tdd trigger enables
 
    assign tdd_trig0_ext_enable = tdd_trig_enable[6];
    assign tdd_trig1_ext_enable = tdd_trig_enable[7];
    assign spi_trig = tdd_trig_enable[8];
    assign gpio_trig = tdd_trig_enable[9];
 
    generate
    for (genvar n = 0; n < 10; n = n + 1) begin: g_trig_enable
 
    tdd_enable i_trig_enable (
        .tdd_resetn                                         (tdd_int_resetn),
        .tdd_clk                                            (tdd_clk),
        .tdd_genb                                           (tdd_genb),
        .tdd_state                                          (tdd_state),
        .tdd_last                                           (tdd_last),
        .tdd_clk_cnt                                        (tdd_clk_cnt),
        .tdd_frm_cnt                                        (tdd_frm_cnt),
        .tdd_enable                                         (tdd_trig_enable[n]),
        .axilite_clk                                        (axilite_clk),
        .axilite_resetn                                     (axilite_resetn),
        .axilite_pri_assert                                 (axilite_trig_pri_assert[((n*32)+31):(n*32)]),
        .axilite_pri_deassert                               (axilite_trig_pri_deassert[((n*32)+31):(n*32)]),
        .axilite_sec_assert                                 (axilite_trig_sec_assert[((n*32)+31):(n*32)]),
        .axilite_sec_deassert                               (axilite_trig_sec_deassert[((n*32)+31):(n*32)]),
        .axilite_pri_frame_assert                           (axilite_trig_pri_frame_assert[((n*32)+31):(n*32)]),
        .axilite_pri_frame_deassert                         (axilite_trig_pri_frame_deassert[((n*32)+31):(n*32)]),
        .axilite_sec_frame_assert                           (axilite_trig_sec_frame_assert[((n*32)+31):(n*32)]),
        .axilite_sec_frame_deassert                         (axilite_trig_sec_frame_deassert[((n*32)+31):(n*32)]),
        .axilite_mode                                       (axilite_trig_mode[((n*2)+1):(n*2)]));

    end
    endgenerate

    // tdd device enables
 
    assign tdd_rx0_device_enable = tdd_dev_enable[0];
    assign tdd_tx0_device_enable = tdd_dev_enable[1];
    assign tdd_rx1_device_enable = tdd_dev_enable[2];
    assign tdd_tx1_device_enable = tdd_dev_enable[3];
    assign tdd_orx0_gpio_enable = tdd_dev_enable[4];
    assign tdd_orx1_gpio_enable = tdd_dev_enable[5];
    assign tdd_tx0_gpio_enable = tdd_dev_enable[6];
    assign tdd_tx1_gpio_enable = tdd_dev_enable[7];
    assign tdd_ifrm0ctl0_gpio_enable = tdd_dev_enable[8];
    assign tdd_ifrm0ctl1_gpio_enable = tdd_dev_enable[9];
    assign tdd_ifrm1ctl0_gpio_enable = tdd_dev_enable[10];
    assign tdd_ifrm1ctl1_gpio_enable = tdd_dev_enable[11];
 
    generate
    for (genvar n = 0; n < 12; n = n + 1) begin: g_dev_enable
 
    tdd_enable i_dev_enable (
        .tdd_resetn                                         (tdd_int_resetn),
        .tdd_clk                                            (tdd_clk),
        .tdd_genb                                           (tdd_genb),
        .tdd_state                                          (tdd_state),
        .tdd_last                                           (tdd_last),
        .tdd_clk_cnt                                        (tdd_clk_cnt),
        .tdd_frm_cnt                                        (tdd_frm_cnt),
        .tdd_enable                                         (tdd_dev_enable[n]),
        .axilite_clk                                        (axilite_clk),
        .axilite_resetn                                     (axilite_resetn),
        .axilite_pri_assert                                 (axilite_dev_pri_assert[((n*32)+31):(n*32)]),
        .axilite_pri_deassert                               (axilite_dev_pri_deassert[((n*32)+31):(n*32)]),
        .axilite_sec_assert                                 (axilite_dev_sec_assert[((n*32)+31):(n*32)]),
        .axilite_sec_deassert                               (axilite_dev_sec_deassert[((n*32)+31):(n*32)]),
        .axilite_pri_frame_assert                           (axilite_dev_pri_frame_assert[((n*32)+31):(n*32)]),
        .axilite_pri_frame_deassert                         (axilite_dev_pri_frame_deassert[((n*32)+31):(n*32)]),
        .axilite_sec_frame_assert                           (axilite_dev_sec_frame_assert[((n*32)+31):(n*32)]),
        .axilite_sec_frame_deassert                         (axilite_dev_sec_frame_deassert[((n*32)+31):(n*32)]),
        .axilite_mode                                       (axilite_dev_mode[((n*2)+1):(n*2)]));

    end
    endgenerate

    // tdd dma enables
 
    assign resetn[0] = rx0_resetn;
    assign clk[0] = rx0_clk;
    assign sync[0] = rx0_sync;
    assign rx0_enable = dma_enable[0];
    assign rx0_trig = trig_enable[0];
    assign resetn[1] = tx0_resetn;
    assign clk[1] = tx0_clk;
    assign sync[1] = tx0_sync;
    assign tx0_enable = dma_enable[1];
    assign tx0_trig = trig_enable[1];
    assign resetn[2] = rx1_resetn;
    assign clk[2] = rx1_clk;
    assign sync[2] = rx1_sync;
    assign rx1_enable = dma_enable[2];
    assign rx1_trig = trig_enable[2];
    assign resetn[3] = tx1_resetn;
    assign clk[3] = tx1_clk;
    assign sync[3] = tx1_sync;
    assign tx1_enable = dma_enable[3];
    assign tx1_trig = trig_enable[3];
    assign resetn[4] = rx0_resetn;
    assign clk[4] = rx0_clk;
    assign sync[4] = orx0_sync;
    assign orx0_enable = dma_enable[4];
    assign orx0_trig = trig_enable[4];
    assign resetn[5] = rx1_resetn;
    assign clk[5] = rx1_clk;
    assign sync[5] = orx1_sync;
    assign orx1_enable = dma_enable[5];
    assign orx1_trig = trig_enable[5];

 // tdd dma triggers

    generate
    for (genvar n = 0; n < 6; n = n + 1) begin: g_dma_enable
 
    cdc #(.DATA_WIDTH(1)) i_dma_trig_enable (
        .src_data                                           (tdd_trig_enable[n]),
        .dest_resetn                                        (resetn[n]),
        .dest_clk                                           (clk[n]),
        .dest_data                                          (trig_enable[n]));

    tdd_dma_enable i_dma_data_enable (
        .resetn                                             (resetn[n]),
        .clk                                                (clk[n]),
        .sync                                               (sync[n]),
        .enable                                             (dma_enable[n]),
        .tdd_resetn                                         (tdd_int_resetn),
        .tdd_clk                                            (tdd_clk),
        .tdd_genb                                           (tdd_genb),
        .tdd_state                                          (tdd_state),
        .tdd_last                                           (tdd_last),
        .tdd_clk_cnt                                        (tdd_clk_cnt),
        .tdd_frm_cnt                                        (tdd_frm_cnt),
        .axilite_clk                                        (axilite_clk),
        .axilite_resetn                                     (axilite_resetn),
        .axilite_clk_ratio                                  (axilite_dma_clk_ratio[((n*12)+11):(n*12)]),
        .axilite_frame_period                               (axilite_frame_period),
        .axilite_pri_assert                                 (axilite_dma_pri_assert[((n*32)+31):(n*32)]),
        .axilite_pri_deassert                               (axilite_dma_pri_deassert[((n*32)+31):(n*32)]),
        .axilite_sec_assert                                 (axilite_dma_sec_assert[((n*32)+31):(n*32)]),
        .axilite_sec_deassert                               (axilite_dma_sec_deassert[((n*32)+31):(n*32)]),
        .axilite_pri_frame_assert                           (axilite_dma_pri_frame_assert[((n*32)+31):(n*32)]),
        .axilite_pri_frame_deassert                         (axilite_dma_pri_frame_deassert[((n*32)+31):(n*32)]),
        .axilite_sec_frame_assert                           (axilite_dma_sec_frame_assert[((n*32)+31):(n*32)]),
        .axilite_sec_frame_deassert                         (axilite_dma_sec_frame_deassert[((n*32)+31):(n*32)]),
        .axilite_mode                                       (axilite_dma_mode[((n*2)+1):(n*2)]),
        .axilite_sync                                       (axilite_dma_sync[n]));

    end
    endgenerate

    generate
    if (INSTANCE_ID == 0) begin

    tdd_frame i_frame (
        .tdd_resetn                                         (tdd_int_resetn),
        .tdd_clk                                            (tdd_clk),
        .tdd_genb                                           (tdd_out_genb),
        .tdd_state                                          (tdd_out_state),
        .tdd_last                                           (tdd_out_last),
        .tdd_clk_cnt                                        (tdd_out_clk_cnt),
        .tdd_frm_cnt                                        (tdd_out_frm_cnt),
        .trig                                               (trig),
        .axilite_clk                                        (axilite_clk),
        .axilite_resetn                                     (axilite_resetn),
        .axilite_frame_period                               (axilite_frame_period),
        .axilite_num_of_frames                              (axilite_num_of_frames),
        .axilite_frame_switch_period                        (axilite_frame_switch_period),
        .axilite_frame_switch_number                        (axilite_frame_switch_number),
        .axilite_trigger_mode                               (axilite_trigger_mode),
        .axilite_frame_switch_enable                        (axilite_frame_switch_enable),
        .axilite_sequence_repeat                            (axilite_sequence_repeat),
        .axilite_global_enb                                 (axilite_global_enb),
        .axilite_cdc_state                                  (axilite_cdc_state_int),
        .axilite_cdc_state_clr                              (axilite_cdc_state_clr),
        .axilite_stop                                       (axilite_stop),
        .axilite_start                                      (axilite_start),
        .axilite_request_clr                                (axilite_request_clr));

    cdc_resetp i_cdc_resetp_tdd (
        .src_clk                                            (axilite_clk),
        .src_resetn                                         (~axilite_swreset),
        .dest_clk                                           (tdd_clk),
        .dest_resetp                                        (tdd_out_resetn));

    cdc #(.DATA_WIDTH(1)) i_cdc_axilite (
        .src_data                                           (~tdd_int_resetn),
        .dest_resetn                                        (axilite_resetn),
        .dest_clk                                           (axilite_clk),
        .dest_data                                          (axilite_swreset_clr));

    end else begin

    assign tdd_out_genb = 1'd0;
    assign tdd_out_state = 1'd0;
    assign tdd_out_last = 1'd0;
    assign tdd_out_clk_cnt = 32'd0;
    assign tdd_out_frm_cnt = 32'd0;
    assign tdd_out_resetn = 1'd0;
    assign axilite_request_clr = 1'd0;

    end
    endgenerate

    cdc_resetp i_cdc_resetp (
        .src_clk                                            (tdd_clk),
        .src_resetn                                         (tdd_resetn),
        .dest_clk                                           (tdd_clk),
        .dest_resetp                                        (tdd_int_resetn));

    clk_mon i_tdd_clk_mon (
        .clk                                                (tdd_clk),
        .axilite_resetn                                     (axilite_resetn),
        .axilite_clk                                        (axilite_clk),
        .axilite_clk_mon_count                              (axilite_clk_mon_count));

    axi_adrv9001_tdd_regs #(.ID(ID)) i_regs (
        .axilite_frame_period                               (axilite_frame_period),
        .axilite_num_of_frames                              (axilite_num_of_frames),
        .axilite_frame_switch_period                        (axilite_frame_switch_period),
        .axilite_frame_switch_number                        (axilite_frame_switch_number),
        .axilite_trigger_mode_0                             (axilite_trigger_mode[1:0]),
        .axilite_trigger_mode_1                             (axilite_trigger_mode[3:2]),
        .axilite_trigger_mode_2                             (axilite_trigger_mode[5:4]),
        .axilite_trigger_mode_3                             (axilite_trigger_mode[7:6]),
        .axilite_start                                      (axilite_start),
        .axilite_start_clr                                  (axilite_request_clr),
        .axilite_stop                                       (axilite_stop),
        .axilite_stop_clr                                   (axilite_request_clr),
        .axilite_sequence_repeat                            (axilite_sequence_repeat),
        .axilite_frame_switch_enable                        (axilite_frame_switch_enable),
        .axilite_swreset                                    (axilite_swreset),
        .axilite_swreset_clr                                (axilite_swreset_clr),
        .axilite_timer                                      (),
        .axilite_clk_mon_count                              (axilite_clk_mon_count),
        .axilite_global_enb                                 (axilite_global_enb),
        .axilite_cdc_state                                  (axilite_cdc_state),
        .axilite_cdc_state_clr                              (axilite_cdc_state_clr_inv),
        .axilite_primary_assert_00                          (axilite_trig_pri_assert[((0*32)+31):(0*32)]),
        .axilite_primary_deassert_00                        (axilite_trig_pri_deassert[((0*32)+31):(0*32)]),
        .axilite_secondary_assert_00                        (axilite_trig_sec_assert[((0*32)+31):(0*32)]),
        .axilite_secondary_deassert_00                      (axilite_trig_sec_deassert[((0*32)+31):(0*32)]),
        .axilite_primary_frame_assert_00                    (axilite_trig_pri_frame_assert[((0*32)+31):(0*32)]),
        .axilite_primary_frame_deassert_00                  (axilite_trig_pri_frame_deassert[((0*32)+31):(0*32)]),
        .axilite_secondary_frame_assert_00                  (axilite_trig_sec_frame_assert[((0*32)+31):(0*32)]),
        .axilite_secondary_frame_deassert_00                (axilite_trig_sec_frame_deassert[((0*32)+31):(0*32)]),
        .axilite_mode_00                                    (axilite_trig_mode[((0*2)+1):(0*2)]),
        .axilite_sync_00                                    (),
        .axilite_clk_ratio_00                               (),
        .axilite_primary_assert_01                          (axilite_trig_pri_assert[((1*32)+31):(1*32)]),
        .axilite_primary_deassert_01                        (axilite_trig_pri_deassert[((1*32)+31):(1*32)]),
        .axilite_secondary_assert_01                        (axilite_trig_sec_assert[((1*32)+31):(1*32)]),
        .axilite_secondary_deassert_01                      (axilite_trig_sec_deassert[((1*32)+31):(1*32)]),
        .axilite_primary_frame_assert_01                    (axilite_trig_pri_frame_assert[((1*32)+31):(1*32)]),
        .axilite_primary_frame_deassert_01                  (axilite_trig_pri_frame_deassert[((1*32)+31):(1*32)]),
        .axilite_secondary_frame_assert_01                  (axilite_trig_sec_frame_assert[((1*32)+31):(1*32)]),
        .axilite_secondary_frame_deassert_01                (axilite_trig_sec_frame_deassert[((1*32)+31):(1*32)]),
        .axilite_mode_01                                    (axilite_trig_mode[((1*2)+1):(1*2)]),
        .axilite_sync_01                                    (),
        .axilite_clk_ratio_01                               (),
        .axilite_primary_assert_02                          (axilite_trig_pri_assert[((2*32)+31):(2*32)]),
        .axilite_primary_deassert_02                        (axilite_trig_pri_deassert[((2*32)+31):(2*32)]),
        .axilite_secondary_assert_02                        (axilite_trig_sec_assert[((2*32)+31):(2*32)]),
        .axilite_secondary_deassert_02                      (axilite_trig_sec_deassert[((2*32)+31):(2*32)]),
        .axilite_primary_frame_assert_02                    (axilite_trig_pri_frame_assert[((2*32)+31):(2*32)]),
        .axilite_primary_frame_deassert_02                  (axilite_trig_pri_frame_deassert[((2*32)+31):(2*32)]),
        .axilite_secondary_frame_assert_02                  (axilite_trig_sec_frame_assert[((2*32)+31):(2*32)]),
        .axilite_secondary_frame_deassert_02                (axilite_trig_sec_frame_deassert[((2*32)+31):(2*32)]),
        .axilite_mode_02                                    (axilite_trig_mode[((2*2)+1):(2*2)]),
        .axilite_sync_02                                    (),
        .axilite_clk_ratio_02                               (),
        .axilite_primary_assert_03                          (axilite_trig_pri_assert[((3*32)+31):(3*32)]),
        .axilite_primary_deassert_03                        (axilite_trig_pri_deassert[((3*32)+31):(3*32)]),
        .axilite_secondary_assert_03                        (axilite_trig_sec_assert[((3*32)+31):(3*32)]),
        .axilite_secondary_deassert_03                      (axilite_trig_sec_deassert[((3*32)+31):(3*32)]),
        .axilite_primary_frame_assert_03                    (axilite_trig_pri_frame_assert[((3*32)+31):(3*32)]),
        .axilite_primary_frame_deassert_03                  (axilite_trig_pri_frame_deassert[((3*32)+31):(3*32)]),
        .axilite_secondary_frame_assert_03                  (axilite_trig_sec_frame_assert[((3*32)+31):(3*32)]),
        .axilite_secondary_frame_deassert_03                (axilite_trig_sec_frame_deassert[((3*32)+31):(3*32)]),
        .axilite_mode_03                                    (axilite_trig_mode[((3*2)+1):(3*2)]),
        .axilite_sync_03                                    (),
        .axilite_clk_ratio_03                               (),
        .axilite_primary_assert_04                          (axilite_trig_pri_assert[((4*32)+31):(4*32)]),
        .axilite_primary_deassert_04                        (axilite_trig_pri_deassert[((4*32)+31):(4*32)]),
        .axilite_secondary_assert_04                        (axilite_trig_sec_assert[((4*32)+31):(4*32)]),
        .axilite_secondary_deassert_04                      (axilite_trig_sec_deassert[((4*32)+31):(4*32)]),
        .axilite_primary_frame_assert_04                    (axilite_trig_pri_frame_assert[((4*32)+31):(4*32)]),
        .axilite_primary_frame_deassert_04                  (axilite_trig_pri_frame_deassert[((4*32)+31):(4*32)]),
        .axilite_secondary_frame_assert_04                  (axilite_trig_sec_frame_assert[((4*32)+31):(4*32)]),
        .axilite_secondary_frame_deassert_04                (axilite_trig_sec_frame_deassert[((4*32)+31):(4*32)]),
        .axilite_mode_04                                    (axilite_trig_mode[((4*2)+1):(4*2)]),
        .axilite_sync_04                                    (),
        .axilite_clk_ratio_04                               (),
        .axilite_primary_assert_05                          (axilite_trig_pri_assert[((5*32)+31):(5*32)]),
        .axilite_primary_deassert_05                        (axilite_trig_pri_deassert[((5*32)+31):(5*32)]),
        .axilite_secondary_assert_05                        (axilite_trig_sec_assert[((5*32)+31):(5*32)]),
        .axilite_secondary_deassert_05                      (axilite_trig_sec_deassert[((5*32)+31):(5*32)]),
        .axilite_primary_frame_assert_05                    (axilite_trig_pri_frame_assert[((5*32)+31):(5*32)]),
        .axilite_primary_frame_deassert_05                  (axilite_trig_pri_frame_deassert[((5*32)+31):(5*32)]),
        .axilite_secondary_frame_assert_05                  (axilite_trig_sec_frame_assert[((5*32)+31):(5*32)]),
        .axilite_secondary_frame_deassert_05                (axilite_trig_sec_frame_deassert[((5*32)+31):(5*32)]),
        .axilite_mode_05                                    (axilite_trig_mode[((5*2)+1):(5*2)]),
        .axilite_sync_05                                    (),
        .axilite_clk_ratio_05                               (),
        .axilite_primary_assert_06                          (axilite_trig_pri_assert[((6*32)+31):(6*32)]),
        .axilite_primary_deassert_06                        (axilite_trig_pri_deassert[((6*32)+31):(6*32)]),
        .axilite_secondary_assert_06                        (axilite_trig_sec_assert[((6*32)+31):(6*32)]),
        .axilite_secondary_deassert_06                      (axilite_trig_sec_deassert[((6*32)+31):(6*32)]),
        .axilite_primary_frame_assert_06                    (axilite_trig_pri_frame_assert[((6*32)+31):(6*32)]),
        .axilite_primary_frame_deassert_06                  (axilite_trig_pri_frame_deassert[((6*32)+31):(6*32)]),
        .axilite_secondary_frame_assert_06                  (axilite_trig_sec_frame_assert[((6*32)+31):(6*32)]),
        .axilite_secondary_frame_deassert_06                (axilite_trig_sec_frame_deassert[((6*32)+31):(6*32)]),
        .axilite_mode_06                                    (axilite_trig_mode[((6*2)+1):(6*2)]),
        .axilite_sync_06                                    (),
        .axilite_clk_ratio_06                               (),
        .axilite_primary_assert_07                          (axilite_trig_pri_assert[((7*32)+31):(7*32)]),
        .axilite_primary_deassert_07                        (axilite_trig_pri_deassert[((7*32)+31):(7*32)]),
        .axilite_secondary_assert_07                        (axilite_trig_sec_assert[((7*32)+31):(7*32)]),
        .axilite_secondary_deassert_07                      (axilite_trig_sec_deassert[((7*32)+31):(7*32)]),
        .axilite_primary_frame_assert_07                    (axilite_trig_pri_frame_assert[((7*32)+31):(7*32)]),
        .axilite_primary_frame_deassert_07                  (axilite_trig_pri_frame_deassert[((7*32)+31):(7*32)]),
        .axilite_secondary_frame_assert_07                  (axilite_trig_sec_frame_assert[((7*32)+31):(7*32)]),
        .axilite_secondary_frame_deassert_07                (axilite_trig_sec_frame_deassert[((7*32)+31):(7*32)]),
        .axilite_mode_07                                    (axilite_trig_mode[((7*2)+1):(7*2)]),
        .axilite_sync_07                                    (),
        .axilite_clk_ratio_07                               (),
        .axilite_primary_assert_08                          (axilite_trig_pri_assert[((8*32)+31):(8*32)]),
        .axilite_primary_deassert_08                        (axilite_trig_pri_deassert[((8*32)+31):(8*32)]),
        .axilite_secondary_assert_08                        (axilite_trig_sec_assert[((8*32)+31):(8*32)]),
        .axilite_secondary_deassert_08                      (axilite_trig_sec_deassert[((8*32)+31):(8*32)]),
        .axilite_primary_frame_assert_08                    (axilite_trig_pri_frame_assert[((8*32)+31):(8*32)]),
        .axilite_primary_frame_deassert_08                  (axilite_trig_pri_frame_deassert[((8*32)+31):(8*32)]),
        .axilite_secondary_frame_assert_08                  (axilite_trig_sec_frame_assert[((8*32)+31):(8*32)]),
        .axilite_secondary_frame_deassert_08                (axilite_trig_sec_frame_deassert[((8*32)+31):(8*32)]),
        .axilite_mode_08                                    (axilite_trig_mode[((8*2)+1):(8*2)]),
        .axilite_sync_08                                    (),
        .axilite_clk_ratio_08                               (),
        .axilite_primary_assert_09                          (axilite_trig_pri_assert[((9*32)+31):(9*32)]),
        .axilite_primary_deassert_09                        (axilite_trig_pri_deassert[((9*32)+31):(9*32)]),
        .axilite_secondary_assert_09                        (axilite_trig_sec_assert[((9*32)+31):(9*32)]),
        .axilite_secondary_deassert_09                      (axilite_trig_sec_deassert[((9*32)+31):(9*32)]),
        .axilite_primary_frame_assert_09                    (axilite_trig_pri_frame_assert[((9*32)+31):(9*32)]),
        .axilite_primary_frame_deassert_09                  (axilite_trig_pri_frame_deassert[((9*32)+31):(9*32)]),
        .axilite_secondary_frame_assert_09                  (axilite_trig_sec_frame_assert[((9*32)+31):(9*32)]),
        .axilite_secondary_frame_deassert_09                (axilite_trig_sec_frame_deassert[((9*32)+31):(9*32)]),
        .axilite_mode_09                                    (axilite_trig_mode[((9*2)+1):(9*2)]),
        .axilite_sync_09                                    (),
        .axilite_clk_ratio_09                               (),
        .axilite_primary_assert_10                          (axilite_dev_pri_assert[((0*32)+31):(0*32)]),
        .axilite_primary_deassert_10                        (axilite_dev_pri_deassert[((0*32)+31):(0*32)]),
        .axilite_secondary_assert_10                        (axilite_dev_sec_assert[((0*32)+31):(0*32)]),
        .axilite_secondary_deassert_10                      (axilite_dev_sec_deassert[((0*32)+31):(0*32)]),
        .axilite_primary_frame_assert_10                    (axilite_dev_pri_frame_assert[((0*32)+31):(0*32)]),
        .axilite_primary_frame_deassert_10                  (axilite_dev_pri_frame_deassert[((0*32)+31):(0*32)]),
        .axilite_secondary_frame_assert_10                  (axilite_dev_sec_frame_assert[((0*32)+31):(0*32)]),
        .axilite_secondary_frame_deassert_10                (axilite_dev_sec_frame_deassert[((0*32)+31):(0*32)]),
        .axilite_mode_10                                    (axilite_dev_mode[((0*2)+1):(0*2)]),
        .axilite_sync_10                                    (),
        .axilite_clk_ratio_10                               (),
        .axilite_primary_assert_11                          (axilite_dev_pri_assert[((1*32)+31):(1*32)]),
        .axilite_primary_deassert_11                        (axilite_dev_pri_deassert[((1*32)+31):(1*32)]),
        .axilite_secondary_assert_11                        (axilite_dev_sec_assert[((1*32)+31):(1*32)]),
        .axilite_secondary_deassert_11                      (axilite_dev_sec_deassert[((1*32)+31):(1*32)]),
        .axilite_primary_frame_assert_11                    (axilite_dev_pri_frame_assert[((1*32)+31):(1*32)]),
        .axilite_primary_frame_deassert_11                  (axilite_dev_pri_frame_deassert[((1*32)+31):(1*32)]),
        .axilite_secondary_frame_assert_11                  (axilite_dev_sec_frame_assert[((1*32)+31):(1*32)]),
        .axilite_secondary_frame_deassert_11                (axilite_dev_sec_frame_deassert[((1*32)+31):(1*32)]),
        .axilite_mode_11                                    (axilite_dev_mode[((1*2)+1):(1*2)]),
        .axilite_sync_11                                    (),
        .axilite_clk_ratio_11                               (),
        .axilite_primary_assert_12                          (axilite_dev_pri_assert[((2*32)+31):(2*32)]),
        .axilite_primary_deassert_12                        (axilite_dev_pri_deassert[((2*32)+31):(2*32)]),
        .axilite_secondary_assert_12                        (axilite_dev_sec_assert[((2*32)+31):(2*32)]),
        .axilite_secondary_deassert_12                      (axilite_dev_sec_deassert[((2*32)+31):(2*32)]),
        .axilite_primary_frame_assert_12                    (axilite_dev_pri_frame_assert[((2*32)+31):(2*32)]),
        .axilite_primary_frame_deassert_12                  (axilite_dev_pri_frame_deassert[((2*32)+31):(2*32)]),
        .axilite_secondary_frame_assert_12                  (axilite_dev_sec_frame_assert[((2*32)+31):(2*32)]),
        .axilite_secondary_frame_deassert_12                (axilite_dev_sec_frame_deassert[((2*32)+31):(2*32)]),
        .axilite_mode_12                                    (axilite_dev_mode[((2*2)+1):(2*2)]),
        .axilite_sync_12                                    (),
        .axilite_clk_ratio_12                               (),
        .axilite_primary_assert_13                          (axilite_dev_pri_assert[((3*32)+31):(3*32)]),
        .axilite_primary_deassert_13                        (axilite_dev_pri_deassert[((3*32)+31):(3*32)]),
        .axilite_secondary_assert_13                        (axilite_dev_sec_assert[((3*32)+31):(3*32)]),
        .axilite_secondary_deassert_13                      (axilite_dev_sec_deassert[((3*32)+31):(3*32)]),
        .axilite_primary_frame_assert_13                    (axilite_dev_pri_frame_assert[((3*32)+31):(3*32)]),
        .axilite_primary_frame_deassert_13                  (axilite_dev_pri_frame_deassert[((3*32)+31):(3*32)]),
        .axilite_secondary_frame_assert_13                  (axilite_dev_sec_frame_assert[((3*32)+31):(3*32)]),
        .axilite_secondary_frame_deassert_13                (axilite_dev_sec_frame_deassert[((3*32)+31):(3*32)]),
        .axilite_mode_13                                    (axilite_dev_mode[((3*2)+1):(3*2)]),
        .axilite_sync_13                                    (),
        .axilite_clk_ratio_13                               (),
        .axilite_primary_assert_14                          (axilite_dev_pri_assert[((4*32)+31):(4*32)]),
        .axilite_primary_deassert_14                        (axilite_dev_pri_deassert[((4*32)+31):(4*32)]),
        .axilite_secondary_assert_14                        (axilite_dev_sec_assert[((4*32)+31):(4*32)]),
        .axilite_secondary_deassert_14                      (axilite_dev_sec_deassert[((4*32)+31):(4*32)]),
        .axilite_primary_frame_assert_14                    (axilite_dev_pri_frame_assert[((4*32)+31):(4*32)]),
        .axilite_primary_frame_deassert_14                  (axilite_dev_pri_frame_deassert[((4*32)+31):(4*32)]),
        .axilite_secondary_frame_assert_14                  (axilite_dev_sec_frame_assert[((4*32)+31):(4*32)]),
        .axilite_secondary_frame_deassert_14                (axilite_dev_sec_frame_deassert[((4*32)+31):(4*32)]),
        .axilite_mode_14                                    (axilite_dev_mode[((4*2)+1):(4*2)]),
        .axilite_sync_14                                    (),
        .axilite_clk_ratio_14                               (),
        .axilite_primary_assert_15                          (axilite_dev_pri_assert[((5*32)+31):(5*32)]),
        .axilite_primary_deassert_15                        (axilite_dev_pri_deassert[((5*32)+31):(5*32)]),
        .axilite_secondary_assert_15                        (axilite_dev_sec_assert[((5*32)+31):(5*32)]),
        .axilite_secondary_deassert_15                      (axilite_dev_sec_deassert[((5*32)+31):(5*32)]),
        .axilite_primary_frame_assert_15                    (axilite_dev_pri_frame_assert[((5*32)+31):(5*32)]),
        .axilite_primary_frame_deassert_15                  (axilite_dev_pri_frame_deassert[((5*32)+31):(5*32)]),
        .axilite_secondary_frame_assert_15                  (axilite_dev_sec_frame_assert[((5*32)+31):(5*32)]),
        .axilite_secondary_frame_deassert_15                (axilite_dev_sec_frame_deassert[((5*32)+31):(5*32)]),
        .axilite_mode_15                                    (axilite_dev_mode[((5*2)+1):(5*2)]),
        .axilite_sync_15                                    (),
        .axilite_clk_ratio_15                               (),
        .axilite_primary_assert_16                          (axilite_dev_pri_assert[((6*32)+31):(6*32)]),
        .axilite_primary_deassert_16                        (axilite_dev_pri_deassert[((6*32)+31):(6*32)]),
        .axilite_secondary_assert_16                        (axilite_dev_sec_assert[((6*32)+31):(6*32)]),
        .axilite_secondary_deassert_16                      (axilite_dev_sec_deassert[((6*32)+31):(6*32)]),
        .axilite_primary_frame_assert_16                    (axilite_dev_pri_frame_assert[((6*32)+31):(6*32)]),
        .axilite_primary_frame_deassert_16                  (axilite_dev_pri_frame_deassert[((6*32)+31):(6*32)]),
        .axilite_secondary_frame_assert_16                  (axilite_dev_sec_frame_assert[((6*32)+31):(6*32)]),
        .axilite_secondary_frame_deassert_16                (axilite_dev_sec_frame_deassert[((6*32)+31):(6*32)]),
        .axilite_mode_16                                    (axilite_dev_mode[((6*2)+1):(6*2)]),
        .axilite_sync_16                                    (),
        .axilite_clk_ratio_16                               (),
        .axilite_primary_assert_17                          (axilite_dev_pri_assert[((7*32)+31):(7*32)]),
        .axilite_primary_deassert_17                        (axilite_dev_pri_deassert[((7*32)+31):(7*32)]),
        .axilite_secondary_assert_17                        (axilite_dev_sec_assert[((7*32)+31):(7*32)]),
        .axilite_secondary_deassert_17                      (axilite_dev_sec_deassert[((7*32)+31):(7*32)]),
        .axilite_primary_frame_assert_17                    (axilite_dev_pri_frame_assert[((7*32)+31):(7*32)]),
        .axilite_primary_frame_deassert_17                  (axilite_dev_pri_frame_deassert[((7*32)+31):(7*32)]),
        .axilite_secondary_frame_assert_17                  (axilite_dev_sec_frame_assert[((7*32)+31):(7*32)]),
        .axilite_secondary_frame_deassert_17                (axilite_dev_sec_frame_deassert[((7*32)+31):(7*32)]),
        .axilite_mode_17                                    (axilite_dev_mode[((7*2)+1):(7*2)]),
        .axilite_sync_17                                    (),
        .axilite_clk_ratio_17                               (),
        .axilite_primary_assert_18                          (axilite_dev_pri_assert[((8*32)+31):(8*32)]),
        .axilite_primary_deassert_18                        (axilite_dev_pri_deassert[((8*32)+31):(8*32)]),
        .axilite_secondary_assert_18                        (axilite_dev_sec_assert[((8*32)+31):(8*32)]),
        .axilite_secondary_deassert_18                      (axilite_dev_sec_deassert[((8*32)+31):(8*32)]),
        .axilite_primary_frame_assert_18                    (axilite_dev_pri_frame_assert[((8*32)+31):(8*32)]),
        .axilite_primary_frame_deassert_18                  (axilite_dev_pri_frame_deassert[((8*32)+31):(8*32)]),
        .axilite_secondary_frame_assert_18                  (axilite_dev_sec_frame_assert[((8*32)+31):(8*32)]),
        .axilite_secondary_frame_deassert_18                (axilite_dev_sec_frame_deassert[((8*32)+31):(8*32)]),
        .axilite_mode_18                                    (axilite_dev_mode[((8*2)+1):(8*2)]),
        .axilite_sync_18                                    (),
        .axilite_clk_ratio_18                               (),
        .axilite_primary_assert_19                          (axilite_dev_pri_assert[((9*32)+31):(9*32)]),
        .axilite_primary_deassert_19                        (axilite_dev_pri_deassert[((9*32)+31):(9*32)]),
        .axilite_secondary_assert_19                        (axilite_dev_sec_assert[((9*32)+31):(9*32)]),
        .axilite_secondary_deassert_19                      (axilite_dev_sec_deassert[((9*32)+31):(9*32)]),
        .axilite_primary_frame_assert_19                    (axilite_dev_pri_frame_assert[((9*32)+31):(9*32)]),
        .axilite_primary_frame_deassert_19                  (axilite_dev_pri_frame_deassert[((9*32)+31):(9*32)]),
        .axilite_secondary_frame_assert_19                  (axilite_dev_sec_frame_assert[((9*32)+31):(9*32)]),
        .axilite_secondary_frame_deassert_19                (axilite_dev_sec_frame_deassert[((9*32)+31):(9*32)]),
        .axilite_mode_19                                    (axilite_dev_mode[((9*2)+1):(9*2)]),
        .axilite_sync_19                                    (),
        .axilite_clk_ratio_19                               (),
        .axilite_primary_assert_20                          (axilite_dev_pri_assert[((10*32)+31):(10*32)]),
        .axilite_primary_deassert_20                        (axilite_dev_pri_deassert[((10*32)+31):(10*32)]),
        .axilite_secondary_assert_20                        (axilite_dev_sec_assert[((10*32)+31):(10*32)]),
        .axilite_secondary_deassert_20                      (axilite_dev_sec_deassert[((10*32)+31):(10*32)]),
        .axilite_primary_frame_assert_20                    (axilite_dev_pri_frame_assert[((10*32)+31):(10*32)]),
        .axilite_primary_frame_deassert_20                  (axilite_dev_pri_frame_deassert[((10*32)+31):(10*32)]),
        .axilite_secondary_frame_assert_20                  (axilite_dev_sec_frame_assert[((10*32)+31):(10*32)]),
        .axilite_secondary_frame_deassert_20                (axilite_dev_sec_frame_deassert[((10*32)+31):(10*32)]),
        .axilite_mode_20                                    (axilite_dev_mode[((10*2)+1):(10*2)]),
        .axilite_sync_20                                    (),
        .axilite_clk_ratio_20                               (),
        .axilite_primary_assert_21                          (axilite_dev_pri_assert[((11*32)+31):(11*32)]),
        .axilite_primary_deassert_21                        (axilite_dev_pri_deassert[((11*32)+31):(11*32)]),
        .axilite_secondary_assert_21                        (axilite_dev_sec_assert[((11*32)+31):(11*32)]),
        .axilite_secondary_deassert_21                      (axilite_dev_sec_deassert[((11*32)+31):(11*32)]),
        .axilite_primary_frame_assert_21                    (axilite_dev_pri_frame_assert[((11*32)+31):(11*32)]),
        .axilite_primary_frame_deassert_21                  (axilite_dev_pri_frame_deassert[((11*32)+31):(11*32)]),
        .axilite_secondary_frame_assert_21                  (axilite_dev_sec_frame_assert[((11*32)+31):(11*32)]),
        .axilite_secondary_frame_deassert_21                (axilite_dev_sec_frame_deassert[((11*32)+31):(11*32)]),
        .axilite_mode_21                                    (axilite_dev_mode[((11*2)+1):(11*2)]),
        .axilite_sync_21                                    (),
        .axilite_clk_ratio_21                               (),
        .axilite_primary_assert_22                          (axilite_dma_pri_assert[((0*32)+31):(0*32)]),
        .axilite_primary_deassert_22                        (axilite_dma_pri_deassert[((0*32)+31):(0*32)]),
        .axilite_secondary_assert_22                        (axilite_dma_sec_assert[((0*32)+31):(0*32)]),
        .axilite_secondary_deassert_22                      (axilite_dma_sec_deassert[((0*32)+31):(0*32)]),
        .axilite_primary_frame_assert_22                    (axilite_dma_pri_frame_assert[((0*32)+31):(0*32)]),
        .axilite_primary_frame_deassert_22                  (axilite_dma_pri_frame_deassert[((0*32)+31):(0*32)]),
        .axilite_secondary_frame_assert_22                  (axilite_dma_sec_frame_assert[((0*32)+31):(0*32)]),
        .axilite_secondary_frame_deassert_22                (axilite_dma_sec_frame_deassert[((0*32)+31):(0*32)]),
        .axilite_mode_22                                    (axilite_dma_mode[((0*2)+1):(0*2)]),
        .axilite_sync_22                                    (axilite_dma_sync[0]),
        .axilite_clk_ratio_22                               (axilite_dma_clk_ratio[((0*12)+11):(0*12)]),
        .axilite_primary_assert_23                          (axilite_dma_pri_assert[((1*32)+31):(1*32)]),
        .axilite_primary_deassert_23                        (axilite_dma_pri_deassert[((1*32)+31):(1*32)]),
        .axilite_secondary_assert_23                        (axilite_dma_sec_assert[((1*32)+31):(1*32)]),
        .axilite_secondary_deassert_23                      (axilite_dma_sec_deassert[((1*32)+31):(1*32)]),
        .axilite_primary_frame_assert_23                    (axilite_dma_pri_frame_assert[((1*32)+31):(1*32)]),
        .axilite_primary_frame_deassert_23                  (axilite_dma_pri_frame_deassert[((1*32)+31):(1*32)]),
        .axilite_secondary_frame_assert_23                  (axilite_dma_sec_frame_assert[((1*32)+31):(1*32)]),
        .axilite_secondary_frame_deassert_23                (axilite_dma_sec_frame_deassert[((1*32)+31):(1*32)]),
        .axilite_mode_23                                    (axilite_dma_mode[((1*2)+1):(1*2)]),
        .axilite_sync_23                                    (axilite_dma_sync[1]),
        .axilite_clk_ratio_23                               (axilite_dma_clk_ratio[((1*12)+11):(1*12)]),
        .axilite_primary_assert_24                          (axilite_dma_pri_assert[((2*32)+31):(2*32)]),
        .axilite_primary_deassert_24                        (axilite_dma_pri_deassert[((2*32)+31):(2*32)]),
        .axilite_secondary_assert_24                        (axilite_dma_sec_assert[((2*32)+31):(2*32)]),
        .axilite_secondary_deassert_24                      (axilite_dma_sec_deassert[((2*32)+31):(2*32)]),
        .axilite_primary_frame_assert_24                    (axilite_dma_pri_frame_assert[((2*32)+31):(2*32)]),
        .axilite_primary_frame_deassert_24                  (axilite_dma_pri_frame_deassert[((2*32)+31):(2*32)]),
        .axilite_secondary_frame_assert_24                  (axilite_dma_sec_frame_assert[((2*32)+31):(2*32)]),
        .axilite_secondary_frame_deassert_24                (axilite_dma_sec_frame_deassert[((2*32)+31):(2*32)]),
        .axilite_mode_24                                    (axilite_dma_mode[((2*2)+1):(2*2)]),
        .axilite_sync_24                                    (axilite_dma_sync[2]),
        .axilite_clk_ratio_24                               (axilite_dma_clk_ratio[((2*12)+11):(2*12)]),
        .axilite_primary_assert_25                          (axilite_dma_pri_assert[((3*32)+31):(3*32)]),
        .axilite_primary_deassert_25                        (axilite_dma_pri_deassert[((3*32)+31):(3*32)]),
        .axilite_secondary_assert_25                        (axilite_dma_sec_assert[((3*32)+31):(3*32)]),
        .axilite_secondary_deassert_25                      (axilite_dma_sec_deassert[((3*32)+31):(3*32)]),
        .axilite_primary_frame_assert_25                    (axilite_dma_pri_frame_assert[((3*32)+31):(3*32)]),
        .axilite_primary_frame_deassert_25                  (axilite_dma_pri_frame_deassert[((3*32)+31):(3*32)]),
        .axilite_secondary_frame_assert_25                  (axilite_dma_sec_frame_assert[((3*32)+31):(3*32)]),
        .axilite_secondary_frame_deassert_25                (axilite_dma_sec_frame_deassert[((3*32)+31):(3*32)]),
        .axilite_mode_25                                    (axilite_dma_mode[((3*2)+1):(3*2)]),
        .axilite_sync_25                                    (axilite_dma_sync[3]),
        .axilite_clk_ratio_25                               (axilite_dma_clk_ratio[((3*12)+11):(3*12)]),
        .axilite_primary_assert_26                          (axilite_dma_pri_assert[((4*32)+31):(4*32)]),
        .axilite_primary_deassert_26                        (axilite_dma_pri_deassert[((4*32)+31):(4*32)]),
        .axilite_secondary_assert_26                        (axilite_dma_sec_assert[((4*32)+31):(4*32)]),
        .axilite_secondary_deassert_26                      (axilite_dma_sec_deassert[((4*32)+31):(4*32)]),
        .axilite_primary_frame_assert_26                    (axilite_dma_pri_frame_assert[((4*32)+31):(4*32)]),
        .axilite_primary_frame_deassert_26                  (axilite_dma_pri_frame_deassert[((4*32)+31):(4*32)]),
        .axilite_secondary_frame_assert_26                  (axilite_dma_sec_frame_assert[((4*32)+31):(4*32)]),
        .axilite_secondary_frame_deassert_26                (axilite_dma_sec_frame_deassert[((4*32)+31):(4*32)]),
        .axilite_mode_26                                    (axilite_dma_mode[((4*2)+1):(4*2)]),
        .axilite_sync_26                                    (axilite_dma_sync[4]),
        .axilite_clk_ratio_26                               (axilite_dma_clk_ratio[((4*12)+11):(4*12)]),
        .axilite_primary_assert_27                          (axilite_dma_pri_assert[((5*32)+31):(5*32)]),
        .axilite_primary_deassert_27                        (axilite_dma_pri_deassert[((5*32)+31):(5*32)]),
        .axilite_secondary_assert_27                        (axilite_dma_sec_assert[((5*32)+31):(5*32)]),
        .axilite_secondary_deassert_27                      (axilite_dma_sec_deassert[((5*32)+31):(5*32)]),
        .axilite_primary_frame_assert_27                    (axilite_dma_pri_frame_assert[((5*32)+31):(5*32)]),
        .axilite_primary_frame_deassert_27                  (axilite_dma_pri_frame_deassert[((5*32)+31):(5*32)]),
        .axilite_secondary_frame_assert_27                  (axilite_dma_sec_frame_assert[((5*32)+31):(5*32)]),
        .axilite_secondary_frame_deassert_27                (axilite_dma_sec_frame_deassert[((5*32)+31):(5*32)]),
        .axilite_mode_27                                    (axilite_dma_mode[((5*2)+1):(5*2)]),
        .axilite_sync_27                                    (axilite_dma_sync[5]),
        .axilite_clk_ratio_27                               (axilite_dma_clk_ratio[((5*12)+11):(5*12)]),
        .axilite_clk                                        (axilite_clk),
        .axilite_resetn                                     (axilite_resetn),
        .axilite_wrreq                                      (axilite_wrreq),
        .axilite_wraddr                                     (axilite_wraddr),
        .axilite_wrdata                                     (axilite_wrdata),
        .axilite_wrack                                      (axilite_wrack),
        .axilite_rdreq                                      (axilite_rdreq),
        .axilite_rdaddr                                     (axilite_rdaddr),
        .axilite_rddata                                     (axilite_rddata),
        .axilite_rdack                                      (axilite_rdack));

endmodule

// **********************************************************************************
// **********************************************************************************
