// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Description:       Auto generated, local modifications are discouraged.
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module axi_adrv9001_ssi_regs  #(parameter [3:0] ID = 0) (

    input   wire  [31:0]    axilite_cmos_lvds_id,
    output  reg   [ 2:0]    axilite_num_of_bits = 'd0,
    output  reg             axilite_lstrb1_pstrb0 = 'd0,
    output  reg             axilite_mlane1_slane0 = 'd0,
    output  reg             axilite_sdr1_ddr0 = 'd0,
    output  reg             axilite_lsb1_msb0 = 'd0,
    output  reg             axilite_q1_i0 = 'd0,
    output  reg             axilite_fall1_rise0 = 'd0,
    input   wire            axilite_cmos1_lvds0,
    output  reg             axilite_clk_sel = 'd0,
    output  reg             axilite_clk_msb = 'd0,
    output  reg             axilite_clk_enb = 'd0,
    output  reg   [ 5:0]    axilite_buf_enable = 'd0,
    output  reg             axilite_init = 'd0,
    input   wire            axilite_init_clr,
    output  reg   [ 2:0]    axilite_ss_ratio = 'd0,
    output  reg   [ 2:0]    axilite_obs_ss_ratio = 'd0,
    output  reg             axilite_ss_mode = 'd0,
    output  reg   [ 3:0]    axilite_data_sel = 'd0,
    output  reg   [31:0]    axilite_data_pat_0 = 'd0,
    output  reg   [31:0]    axilite_data_pat_1 = 'd0,
    input   wire  [31:0]    axilite_data_0,
    input   wire  [31:0]    axilite_data_1,
    input   wire            axilite_frm_oos,
    output  wire            axilite_intr_frm_oos,
    input   wire            axilite_frm_err,
    output  wire            axilite_intr_frm_err,
    input   wire            axilite_mon_oos,
    output  wire            axilite_intr_mon_oos,
    input   wire            axilite_mon_err,
    output  wire            axilite_intr_mon_err,
    input   wire            axilite_lb_ovf,
    output  wire            axilite_intr_lb_ovf,
    input   wire            axilite_lb_unf,
    output  wire            axilite_intr_lb_unf,
    output  reg             axilite_align_sel = 'd0,
    input   wire            axilite_delay_unlocked,
    output  reg   [ 4:0]    axilite_wrdelay_00 = 'd0,
    input   wire  [ 4:0]    axilite_rddelay_00,
    output  reg   [ 4:0]    axilite_wrdelay_01 = 'd0,
    input   wire  [ 4:0]    axilite_rddelay_01,
    output  reg   [ 4:0]    axilite_wrdelay_02 = 'd0,
    input   wire  [ 4:0]    axilite_rddelay_02,
    output  reg   [ 4:0]    axilite_wrdelay_03 = 'd0,
    input   wire  [ 4:0]    axilite_rddelay_03,
    output  reg   [ 4:0]    axilite_wrdelay_04 = 'd0,
    input   wire  [ 4:0]    axilite_rddelay_04,
    output  reg   [ 4:0]    axilite_wrdelay_05 = 'd0,
    input   wire  [ 4:0]    axilite_rddelay_05,
    output  reg   [ 4:0]    axilite_wrdelay_06 = 'd0,
    input   wire  [ 4:0]    axilite_rddelay_06,
    output  reg   [ 4:0]    axilite_wrdelay_07 = 'd0,
    input   wire  [ 4:0]    axilite_rddelay_07,
    output  reg   [31:0]    axilite_delay_sweep = 'd0,
    output  reg   [31:0]    axilite_timer = 'd0,
    input   wire  [31:0]    axilite_clk_mon_count,
    input   wire  [15:0]    axilite_mcs_latency_count,
    input   wire            axilite_mcs_latency_busy,
    output  reg   [ 2:0]    axilite_mcs_delay_count = 'd0,
    input   wire  [31:0]    axilite_mcs_strobe,
    input   wire  [31:0]    axilite_mcs_data,
    input   wire  [31:0]    axilite_mcs_bstrobe,
    input   wire  [31:0]    axilite_mcs_bdata,
    output  reg             axilite_data_pat_pulse = 'd0,
    output  reg             axilite_data_pat_start = 'd0,
    input   wire            axilite_data_pat_start_clr,
    input   wire  [31:0]    axilite_data_pat_latency,
    output  reg             axilite_master_enable = 'd0,
    output  reg             axilite_obs_master_enable = 'd0,
    output  reg             axilite_intr_frm_oos_enable = 'd0,
    output  reg             axilite_intr_frm_err_enable = 'd0,
    output  reg             axilite_intr_mon_oos_enable = 'd0,
    output  reg             axilite_intr_mon_err_enable = 'd0,
    output  reg             axilite_intr_lb_ovf_enable = 'd0,
    output  reg             axilite_intr_lb_unf_enable = 'd0,

    input   wire            axilite_clk,
    input   wire            axilite_resetn,
    input   wire            axilite_wrreq,
    input   wire  [15:0]    axilite_wraddr,
    input   wire  [31:0]    axilite_wrdata,
    output  reg             axilite_wrack = 'd0,
    input   wire            axilite_rdreq,
    input   wire  [15:0]    axilite_rdaddr,
    output  reg   [31:0]    axilite_rddata = 'd0,
    output  reg             axilite_rdack = 'd0);

    reg                     axilite_init_clr_d = 'd0;
    reg                     axilite_frm_oos_w1c = 'd0;
    reg                     axilite_frm_err_w1c = 'd0;
    reg                     axilite_mon_oos_w1c = 'd0;
    reg                     axilite_mon_err_w1c = 'd0;
    reg                     axilite_lb_ovf_w1c = 'd0;
    reg                     axilite_lb_unf_w1c = 'd0;
    reg                     axilite_data_pat_start_clr_d = 'd0;

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_wrack <= 'd0;
            axilite_rdack <= 'd0;
        end else begin
            if (axilite_wraddr[15:12] == ID) begin
                axilite_wrack <= axilite_wrreq;
            end else begin
                axilite_wrack <= 1'd0;
            end
            if (axilite_rdaddr[15:12] == ID) begin
                axilite_rdack <= axilite_rdreq;
            end else begin
                axilite_rdack <= 1'd0;
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_num_of_bits <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h4)) begin
                axilite_num_of_bits <= axilite_wrdata[6:4];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_lstrb1_pstrb0 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h4)) begin
                axilite_lstrb1_pstrb0 <= axilite_wrdata[8];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_mlane1_slane0 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h4)) begin
                axilite_mlane1_slane0 <= axilite_wrdata[9];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_sdr1_ddr0 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h4)) begin
                axilite_sdr1_ddr0 <= axilite_wrdata[10];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_lsb1_msb0 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h4)) begin
                axilite_lsb1_msb0 <= axilite_wrdata[11];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_q1_i0 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h4)) begin
                axilite_q1_i0 <= axilite_wrdata[12];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_fall1_rise0 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h4)) begin
                axilite_fall1_rise0 <= axilite_wrdata[13];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_clk_sel <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h8)) begin
                axilite_clk_sel <= axilite_wrdata[0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_clk_msb <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h8)) begin
                axilite_clk_msb <= axilite_wrdata[1];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_clk_enb <= 'h1;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h8)) begin
                axilite_clk_enb <= axilite_wrdata[2];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_buf_enable <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h8)) begin
                axilite_buf_enable <= axilite_wrdata[13:8];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_init_clr_d <= 'd0;
            axilite_init <= 'h0;
        end else begin
            axilite_init_clr_d <= axilite_init_clr;
            if ((axilite_init_clr_d == 1'b0) && (axilite_init_clr == 1'b1)) begin
                axilite_init <= 1'b0;
            end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hc)) begin
                axilite_init <= axilite_init | axilite_wrdata[0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_ss_ratio <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h10)) begin
                axilite_ss_ratio <= axilite_wrdata[2:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_obs_ss_ratio <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h10)) begin
                axilite_obs_ss_ratio <= axilite_wrdata[6:4];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_ss_mode <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h10)) begin
                axilite_ss_mode <= axilite_wrdata[8];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_data_sel <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h20)) begin
                axilite_data_sel <= axilite_wrdata[3:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_data_pat_0 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h30)) begin
                axilite_data_pat_0 <= axilite_wrdata;
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_data_pat_1 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h34)) begin
                axilite_data_pat_1 <= axilite_wrdata;
            end
        end
    end

    assign axilite_intr_frm_oos = axilite_frm_oos_w1c;

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_frm_oos_w1c <= 'h0;
        end else begin
            if (axilite_frm_oos == 1'b1) begin
                axilite_frm_oos_w1c <= 1'b1;
            end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h60)) begin
                axilite_frm_oos_w1c <= axilite_frm_oos_w1c & ~axilite_wrdata[0];
            end
        end
    end

    assign axilite_intr_frm_err = axilite_frm_err_w1c;

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_frm_err_w1c <= 'h0;
        end else begin
            if (axilite_frm_err == 1'b1) begin
                axilite_frm_err_w1c <= 1'b1;
            end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h60)) begin
                axilite_frm_err_w1c <= axilite_frm_err_w1c & ~axilite_wrdata[1];
            end
        end
    end

    assign axilite_intr_mon_oos = axilite_mon_oos_w1c;

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_mon_oos_w1c <= 'h0;
        end else begin
            if (axilite_mon_oos == 1'b1) begin
                axilite_mon_oos_w1c <= 1'b1;
            end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h60)) begin
                axilite_mon_oos_w1c <= axilite_mon_oos_w1c & ~axilite_wrdata[2];
            end
        end
    end

    assign axilite_intr_mon_err = axilite_mon_err_w1c;

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_mon_err_w1c <= 'h0;
        end else begin
            if (axilite_mon_err == 1'b1) begin
                axilite_mon_err_w1c <= 1'b1;
            end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h60)) begin
                axilite_mon_err_w1c <= axilite_mon_err_w1c & ~axilite_wrdata[3];
            end
        end
    end

    assign axilite_intr_lb_ovf = axilite_lb_ovf_w1c;

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_lb_ovf_w1c <= 'h0;
        end else begin
            if (axilite_lb_ovf == 1'b1) begin
                axilite_lb_ovf_w1c <= 1'b1;
            end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h60)) begin
                axilite_lb_ovf_w1c <= axilite_lb_ovf_w1c & ~axilite_wrdata[8];
            end
        end
    end

    assign axilite_intr_lb_unf = axilite_lb_unf_w1c;

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_lb_unf_w1c <= 'h0;
        end else begin
            if (axilite_lb_unf == 1'b1) begin
                axilite_lb_unf_w1c <= 1'b1;
            end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h60)) begin
                axilite_lb_unf_w1c <= axilite_lb_unf_w1c & ~axilite_wrdata[9];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_align_sel <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h64)) begin
                axilite_align_sel <= axilite_wrdata[0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_wrdelay_00 <= 'h13;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h80)) begin
                axilite_wrdelay_00 <= axilite_wrdata[4:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_wrdelay_01 <= 'h13;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h84)) begin
                axilite_wrdelay_01 <= axilite_wrdata[4:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_wrdelay_02 <= 'h13;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h88)) begin
                axilite_wrdelay_02 <= axilite_wrdata[4:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_wrdelay_03 <= 'h13;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h8c)) begin
                axilite_wrdelay_03 <= axilite_wrdata[4:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_wrdelay_04 <= 'h13;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h90)) begin
                axilite_wrdelay_04 <= axilite_wrdata[4:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_wrdelay_05 <= 'h13;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h94)) begin
                axilite_wrdelay_05 <= axilite_wrdata[4:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_wrdelay_06 <= 'h13;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h98)) begin
                axilite_wrdelay_06 <= axilite_wrdata[4:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_wrdelay_07 <= 'h13;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h9c)) begin
                axilite_wrdelay_07 <= axilite_wrdata[4:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_delay_sweep <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hc0)) begin
                axilite_delay_sweep <= axilite_wrdata;
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_timer <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h100)) begin
                axilite_timer <= axilite_wrdata;
            end else if (axilite_timer > 0) begin
                axilite_timer <= axilite_timer - 1'b1;
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_mcs_delay_count <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h10c)) begin
                axilite_mcs_delay_count <= axilite_wrdata[2:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_data_pat_pulse <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h120)) begin
                axilite_data_pat_pulse <= axilite_wrdata[0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_data_pat_start_clr_d <= 'd0;
            axilite_data_pat_start <= 'h0;
        end else begin
            axilite_data_pat_start_clr_d <= axilite_data_pat_start_clr;
            if ((axilite_data_pat_start_clr_d == 1'b0) && (axilite_data_pat_start_clr == 1'b1)) begin
                axilite_data_pat_start <= 1'b0;
            end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h124)) begin
                axilite_data_pat_start <= axilite_data_pat_start | axilite_wrdata[0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_master_enable <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h140)) begin
                axilite_master_enable <= axilite_wrdata[0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_obs_master_enable <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h140)) begin
                axilite_obs_master_enable <= axilite_wrdata[1];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_intr_frm_oos_enable <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h204)) begin
                axilite_intr_frm_oos_enable <= axilite_wrdata[0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_intr_frm_err_enable <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h204)) begin
                axilite_intr_frm_err_enable <= axilite_wrdata[1];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_intr_mon_oos_enable <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h204)) begin
                axilite_intr_mon_oos_enable <= axilite_wrdata[2];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_intr_mon_err_enable <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h204)) begin
                axilite_intr_mon_err_enable <= axilite_wrdata[3];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_intr_lb_ovf_enable <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h204)) begin
                axilite_intr_lb_ovf_enable <= axilite_wrdata[8];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_intr_lb_unf_enable <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h204)) begin
                axilite_intr_lb_unf_enable <= axilite_wrdata[9];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_rddata <= 'd0;
        end else begin
            if ((axilite_rdreq == 1'b1) && (axilite_rdaddr[15:12] == ID)) begin
                case (axilite_rdaddr[11:0])
                    'h0: begin
                        axilite_rddata <= axilite_cmos_lvds_id;
                    end
                    'h4: begin
                        axilite_rddata[3:0] <= 'd0;
                        axilite_rddata[6:4] <= axilite_num_of_bits;
                        axilite_rddata[7] <= 'd0;
                        axilite_rddata[8] <= axilite_lstrb1_pstrb0;
                        axilite_rddata[9] <= axilite_mlane1_slane0;
                        axilite_rddata[10] <= axilite_sdr1_ddr0;
                        axilite_rddata[11] <= axilite_lsb1_msb0;
                        axilite_rddata[12] <= axilite_q1_i0;
                        axilite_rddata[13] <= axilite_fall1_rise0;
                        axilite_rddata[14] <= axilite_cmos1_lvds0;
                        axilite_rddata[31:15] <= 'd0;
                    end
                    'h8: begin
                        axilite_rddata[0] <= axilite_clk_sel;
                        axilite_rddata[1] <= axilite_clk_msb;
                        axilite_rddata[2] <= axilite_clk_enb;
                        axilite_rddata[7:3] <= 'd0;
                        axilite_rddata[13:8] <= axilite_buf_enable;
                        axilite_rddata[31:14] <= 'd0;
                    end
                    'hc: begin
                        axilite_rddata[0] <= axilite_init;
                        axilite_rddata[31:1] <= 'd0;
                    end
                    'h10: begin
                        axilite_rddata[2:0] <= axilite_ss_ratio;
                        axilite_rddata[3] <= 'd0;
                        axilite_rddata[6:4] <= axilite_obs_ss_ratio;
                        axilite_rddata[7] <= 'd0;
                        axilite_rddata[8] <= axilite_ss_mode;
                        axilite_rddata[31:9] <= 'd0;
                    end
                    'h20: begin
                        axilite_rddata[3:0] <= axilite_data_sel;
                        axilite_rddata[31:4] <= 'd0;
                    end
                    'h30: begin
                        axilite_rddata <= axilite_data_pat_0;
                    end
                    'h34: begin
                        axilite_rddata <= axilite_data_pat_1;
                    end
                    'h40: begin
                        axilite_rddata <= axilite_data_0;
                    end
                    'h44: begin
                        axilite_rddata <= axilite_data_1;
                    end
                    'h60: begin
                        axilite_rddata[0] <= axilite_frm_oos_w1c;
                        axilite_rddata[1] <= axilite_frm_err_w1c;
                        axilite_rddata[2] <= axilite_mon_oos_w1c;
                        axilite_rddata[3] <= axilite_mon_err_w1c;
                        axilite_rddata[7:4] <= 'd0;
                        axilite_rddata[8] <= axilite_lb_ovf_w1c;
                        axilite_rddata[9] <= axilite_lb_unf_w1c;
                        axilite_rddata[31:10] <= 'd0;
                    end
                    'h64: begin
                        axilite_rddata[0] <= axilite_align_sel;
                        axilite_rddata[31:1] <= 'd0;
                    end
                    'h70: begin
                        axilite_rddata[0] <= axilite_delay_unlocked;
                        axilite_rddata[31:1] <= 'd0;
                    end
                    'h80: begin
                        axilite_rddata[4:0] <= axilite_wrdelay_00;
                        axilite_rddata[7:5] <= 'd0;
                        axilite_rddata[12:8] <= axilite_rddelay_00;
                        axilite_rddata[31:13] <= 'd0;
                    end
                    'h84: begin
                        axilite_rddata[4:0] <= axilite_wrdelay_01;
                        axilite_rddata[7:5] <= 'd0;
                        axilite_rddata[12:8] <= axilite_rddelay_01;
                        axilite_rddata[31:13] <= 'd0;
                    end
                    'h88: begin
                        axilite_rddata[4:0] <= axilite_wrdelay_02;
                        axilite_rddata[7:5] <= 'd0;
                        axilite_rddata[12:8] <= axilite_rddelay_02;
                        axilite_rddata[31:13] <= 'd0;
                    end
                    'h8c: begin
                        axilite_rddata[4:0] <= axilite_wrdelay_03;
                        axilite_rddata[7:5] <= 'd0;
                        axilite_rddata[12:8] <= axilite_rddelay_03;
                        axilite_rddata[31:13] <= 'd0;
                    end
                    'h90: begin
                        axilite_rddata[4:0] <= axilite_wrdelay_04;
                        axilite_rddata[7:5] <= 'd0;
                        axilite_rddata[12:8] <= axilite_rddelay_04;
                        axilite_rddata[31:13] <= 'd0;
                    end
                    'h94: begin
                        axilite_rddata[4:0] <= axilite_wrdelay_05;
                        axilite_rddata[7:5] <= 'd0;
                        axilite_rddata[12:8] <= axilite_rddelay_05;
                        axilite_rddata[31:13] <= 'd0;
                    end
                    'h98: begin
                        axilite_rddata[4:0] <= axilite_wrdelay_06;
                        axilite_rddata[7:5] <= 'd0;
                        axilite_rddata[12:8] <= axilite_rddelay_06;
                        axilite_rddata[31:13] <= 'd0;
                    end
                    'h9c: begin
                        axilite_rddata[4:0] <= axilite_wrdelay_07;
                        axilite_rddata[7:5] <= 'd0;
                        axilite_rddata[12:8] <= axilite_rddelay_07;
                        axilite_rddata[31:13] <= 'd0;
                    end
                    'hc0: begin
                        axilite_rddata <= axilite_delay_sweep;
                    end
                    'h100: begin
                        axilite_rddata <= axilite_timer;
                    end
                    'h104: begin
                        axilite_rddata <= axilite_clk_mon_count;
                    end
                    'h108: begin
                        axilite_rddata[15:0] <= axilite_mcs_latency_count;
                        axilite_rddata[16] <= axilite_mcs_latency_busy;
                        axilite_rddata[31:17] <= 'd0;
                    end
                    'h10c: begin
                        axilite_rddata[2:0] <= axilite_mcs_delay_count;
                        axilite_rddata[31:3] <= 'd0;
                    end
                    'h110: begin
                        axilite_rddata <= axilite_mcs_strobe;
                    end
                    'h114: begin
                        axilite_rddata <= axilite_mcs_data;
                    end
                    'h118: begin
                        axilite_rddata <= axilite_mcs_bstrobe;
                    end
                    'h11c: begin
                        axilite_rddata <= axilite_mcs_bdata;
                    end
                    'h120: begin
                        axilite_rddata[0] <= axilite_data_pat_pulse;
                        axilite_rddata[31:1] <= 'd0;
                    end
                    'h124: begin
                        axilite_rddata[0] <= axilite_data_pat_start;
                        axilite_rddata[31:1] <= 'd0;
                    end
                    'h128: begin
                        axilite_rddata <= axilite_data_pat_latency;
                    end
                    'h140: begin
                        axilite_rddata[0] <= axilite_master_enable;
                        axilite_rddata[1] <= axilite_obs_master_enable;
                        axilite_rddata[31:2] <= 'd0;
                    end
                    'h204: begin
                        axilite_rddata[0] <= axilite_intr_frm_oos_enable;
                        axilite_rddata[1] <= axilite_intr_frm_err_enable;
                        axilite_rddata[2] <= axilite_intr_mon_oos_enable;
                        axilite_rddata[3] <= axilite_intr_mon_err_enable;
                        axilite_rddata[7:4] <= 'd0;
                        axilite_rddata[8] <= axilite_intr_lb_ovf_enable;
                        axilite_rddata[9] <= axilite_intr_lb_unf_enable;
                        axilite_rddata[31:10] <= 'd0;
                    end
                    default: begin
                        axilite_rddata <= 32'd0;
                    end
                endcase
            end else begin
                axilite_rddata <= 32'd0;
            end
        end
    end

endmodule

// **********************************************************************************
// **********************************************************************************
