#!/usr/bin/perl
## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Description:       AXI_ADRV9001 ssi registers
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################

use autodie;
require 'dooku.pl';

$addr_width = 16;
$addr_width_used = 12;

$no_of_instances = 4;
$instance_base_addr = 0x4000;
$instance_offset_addr = 0x1000;

setdooku(@ARGV);
module(0x0, 'axi_adrv9001_ssi');

## ##################################################################################
## ##################################################################################

define('RX_OFFSET_0', 0x4000, 'Receive 0 address offset');
define('RX_OFFSET_1', 0x5000, 'Receive 1 address offset');
define('TX_OFFSET_0', 0x6000, 'Transmit 0 address offset');
define('TX_OFFSET_1', 0x7000, 'Transmit 1 address offset');
define('OFFSET_0', 0x4000, 'Instance 0 address offset');
define('OFFSET_1', 0x5000, 'Instance 1 address offset');
define('OFFSET_2', 0x6000, 'Instance 2 address offset');
define('OFFSET_3', 0x7000, 'Instance 2 address offset');
define('ID_0', 0x0, 'Instance 0 identifier');
define('ID_1', 0x1, 'Instance 1 identifier');
define('ID_2', 0x2, 'Instance 2 identifier');
define('ID_3', 0x3, 'Instance 3 identifier');

## ##################################################################################
## ##################################################################################

define('TYPE_CMOS',  0x434d4f53, 'CMOS Identifier');
define('TYPE_LVDS',  0x4c564453, 'LVDS Identifier');
define('TYPE_GPIO',  0x4750494f, 'GPIO Identifier');

$LANES_S = 0;
$LANES_M = 1;

define('SINGLE_LANE', $LANES_1, 'Number of lanes');
define('MULTIPLE_LANES', $LANES_M, 'Number of lanes');

$BITS_02 = 0;
$BITS_08 = 1;
$BITS_16 = 2;
$BITS_24 = 3;
$BITS_32 = 4;
$BITS_64 = 5;

define('NUM_OF_BITS_02', $BITS_02, 'Number of bits');
define('NUM_OF_BITS_08', $BITS_08, 'Number of bits');
define('NUM_OF_BITS_16', $BITS_16, 'Number of bits');
define('NUM_OF_BITS_24', $BITS_24, 'Number of bits');
define('NUM_OF_BITS_32', $BITS_32, 'Number of bits');
define('NUM_OF_BITS_64', $BITS_64, 'Number of bits');

$STB_LEVEL = 1;
$STB_PULSE = 0;

define('STRB_TYPE_LEVEL', $STB_LEVEL, 'Strobe type');
define('STRB_TYPE_PULSE', $STB_PULSE, 'Strobe type');

$MODE_CMOS = 1;
$MODE_LVDS = 0;

define('MODE_CMOS', $MODE_CMOS, 'IO mode');
define('MODE_LVDS', $MODE_LVDS, 'IO mode');

## ##################################################################################
## ##################################################################################

define('CMOS_1L_PS_02X1', (($MODE_CMOS<<14) | ($LANES_S<<9) | ($STB_PULSE<<8) | ($BITS_02<<4)), 'Quick configuration');
define('CMOS_1L_LS_02X1', (($MODE_CMOS<<14) | ($LANES_S<<9) | ($STB_LEVEL<<8) | ($BITS_02<<4)), 'Quick configuration');
define('CMOS_1L_PS_08X1', (($MODE_CMOS<<14) | ($LANES_S<<9) | ($STB_PULSE<<8) | ($BITS_08<<4)), 'Quick configuration');
define('CMOS_1L_LS_08X1', (($MODE_CMOS<<14) | ($LANES_S<<9) | ($STB_LEVEL<<8) | ($BITS_08<<4)), 'Quick configuration');
define('CMOS_1L_PS_16X1', (($MODE_CMOS<<14) | ($LANES_S<<9) | ($STB_PULSE<<8) | ($BITS_16<<4)), 'Quick configuration');
define('CMOS_1L_LS_16X1', (($MODE_CMOS<<14) | ($LANES_S<<9) | ($STB_LEVEL<<8) | ($BITS_16<<4)), 'Quick configuration');
define('CMOS_1L_PS_32X1', (($MODE_CMOS<<14) | ($LANES_S<<9) | ($STB_PULSE<<8) | ($BITS_32<<4)), 'Quick configuration');
define('CMOS_1L_LS_32X1', (($MODE_CMOS<<14) | ($LANES_S<<9) | ($STB_LEVEL<<8) | ($BITS_32<<4)), 'Quick configuration');
define('CMOS_4L_PS_32X1', (($MODE_CMOS<<14) | ($LANES_M<<9) | ($STB_PULSE<<8) | ($BITS_32<<4)), 'Quick configuration');
define('CMOS_4L_LS_32X1', (($MODE_CMOS<<14) | ($LANES_M<<9) | ($STB_LEVEL<<8) | ($BITS_32<<4)), 'Quick configuration');
define('CMOS_1L_PS_64X1', (($MODE_CMOS<<14) | ($LANES_S<<9) | ($STB_PULSE<<8) | ($BITS_64<<4)), 'Quick configuration');
define('CMOS_1L_LS_64X1', (($MODE_CMOS<<14) | ($LANES_S<<9) | ($STB_LEVEL<<8) | ($BITS_64<<4)), 'Quick configuration');
define('CMOS_4L_PS_64X1', (($MODE_CMOS<<14) | ($LANES_M<<9) | ($STB_PULSE<<8) | ($BITS_64<<4)), 'Quick configuration');
define('CMOS_4L_LS_64X1', (($MODE_CMOS<<14) | ($LANES_M<<9) | ($STB_LEVEL<<8) | ($BITS_64<<4)), 'Quick configuration');
define('LVDS_1L_PS_24X1', (($MODE_LVDS<<14) | ($LANES_S<<9) | ($STB_PULSE<<8) | ($BITS_24<<4)), 'Quick configuration');
define('LVDS_1L_LS_24X1', (($MODE_LVDS<<14) | ($LANES_S<<9) | ($STB_LEVEL<<8) | ($BITS_24<<4)), 'Quick configuration');
define('LVDS_2L_PS_24X1', (($MODE_LVDS<<14) | ($LANES_M<<9) | ($STB_PULSE<<8) | ($BITS_24<<4)), 'Quick configuration');
define('LVDS_2L_LS_24X1', (($MODE_LVDS<<14) | ($LANES_M<<9) | ($STB_LEVEL<<8) | ($BITS_24<<4)), 'Quick configuration');
define('LVDS_1L_PS_32X1', (($MODE_LVDS<<14) | ($LANES_S<<9) | ($STB_PULSE<<8) | ($BITS_32<<4)), 'Quick configuration');
define('LVDS_1L_LS_32X1', (($MODE_LVDS<<14) | ($LANES_S<<9) | ($STB_LEVEL<<8) | ($BITS_32<<4)), 'Quick configuration');
define('LVDS_2L_PS_32X1', (($MODE_LVDS<<14) | ($LANES_M<<9) | ($STB_PULSE<<8) | ($BITS_32<<4)), 'Quick configuration');
define('LVDS_2L_LS_32X1', (($MODE_LVDS<<14) | ($LANES_M<<9) | ($STB_LEVEL<<8) | ($BITS_32<<4)), 'Quick configuration');
define('LVDS_1L_PS_64X1', (($MODE_LVDS<<14) | ($LANES_S<<9) | ($STB_PULSE<<8) | ($BITS_64<<4)), 'Quick configuration');
define('LVDS_1L_LS_64X1', (($MODE_LVDS<<14) | ($LANES_S<<9) | ($STB_LEVEL<<8) | ($BITS_64<<4)), 'Quick configuration');
define('LVDS_2L_PS_64X1', (($MODE_LVDS<<14) | ($LANES_M<<9) | ($STB_PULSE<<8) | ($BITS_64<<4)), 'Quick configuration');
define('LVDS_2L_LS_64X1', (($MODE_LVDS<<14) | ($LANES_M<<9) | ($STB_LEVEL<<8) | ($BITS_64<<4)), 'Quick configuration');

## ##################################################################################
## ##################################################################################

define('DATA_RATE_SDR',         0x1, 'data rate sel');
define('DATA_RATE_DDR',         0x0, 'data rate sel');
define('BIT_ORDER_LSB_FIRST',   0x1, 'bit order sel');
define('BIT_ORDER_MSB_FIRST',   0x0, 'bit order sel');
define('IQ_ORDER_Q_FIRST',      0x1, 'iq order sel');
define('IQ_ORDER_I_FIRST',      0x0, 'iq order sel');
define('EDGE_FALLING',          0x1, 'clock edge sel');
define('EDGE_RISING',           0x0, 'clock edge sel');
define('CLK_SEL_RX',            0x1, 'clock sel');
define('CLK_SEL_TX',            0x0, 'clock sel');
 
## ##################################################################################
## ##################################################################################

register(0x000, 'REG_CMOS_LVDS_ID');
field(0, 32, RO, 0x0, 'CMOS_LVDS_ID', 'An unambigous identifier indicates the
    current configuration of SSI interface. If configured as CMOS, this register
    reads 0x43-0x4d-0x4f-0x53, and if LVDS, reads 0x4c-0x56-0x44-0x53.');

register(0x004, 'REG_CONTROL');
field( 4, 3, RW, 0x0, 'NUM_OF_BITS', 'This field must be set to the desired number of
    bits in a sample.');
field( 8, 1, RW, 0x0, 'LSTRB1_PSTRB0', 'If set to 0x1, strobe is level, and is expected
    to be asserted high for all bits of I. Otherwise only the MSB.');
field( 9, 1, RW, 0x0, 'MLANE1_SLANE0', 'If set to 0x1, multiple lanes (2 for lvds or 4 for cmos),
    otherwise single lane.');
field(10, 1, RW, 0x0, 'SDR1_DDR0', 'This field must be set to the desired clock type.
    If set to 0x1, interface is SDR. If set to 0x0, interface is in DDR mode. This bit must be
    set carefully to match the device. The FPGA core supports SDR or DDR in all modes.');
field(11, 1, RW, 0x0, 'LSB1_MSB0', 'This field must be set to the desired bit order within
    the data frame. If set to 0x1, the first bit is LSB, if set to 0x0, it is MSB.');
field(12, 1, RW, 0x0, 'Q1_I0', 'This field must be set to the desired channel order within
    the data frame. If set to 0x1, the first sample is the Q channel. If set to 0x0, it is I.');
field(13, 1, RW, 0x0, 'FALL1_RISE0', 'This bit controls the data sampling edge in SDR mode,
    if set to 0x1, falling clock edges are used to capture data. If set to 0x0, data is sampled
    at the rising edges of the interface clock (receive only).');
field(14, 1, RO, 0x0, 'CMOS1_LVDS0', 'This is a read-only bit indicating the current
    configuration of this interface. If read 0x1, interface is in CMOS mode. If read 0x0, it is
    in LVDS mode. The software is expected to qualify the remaining fields in this register
    based on the value read in this bit.');

register(0x008, 'REG_IO_CONTROL');
field(0, 1, RW, 0x0, 'CLK_SEL', 'If this field is set, the transmit interface internal
    clock is sourced from the receive interface clock, otherwise, the transmit reference clock
    input sources the transmit interface internal clock (transmit only).');
field(1, 1, RW, 0x0, 'CLK_MSB', 'The transmit interface clock output may be inverted
    by setting this field to 0x1, as it controls the MSB bit in the clock output (transmit only).');
field(2, 1, RW, 0x1, 'CLK_ENB', 'Internal driver use only.');
field(8, 6, RW, 0x0, 'BUF_ENABLE', 'The core, by default, tri-states all the IO unless
    explicitly enabled by software. After a profile is loaded, this bit must be set to 0x1
    to enable all the output buffers in both LVDS and CMOS mode, BIT0 (LSB) is reference clock,
    BIT1 is strobe, BIT2 to BIT5 controls data0 to data3 (transmit only).');

register(0x00c, 'REG_INIT');
field(0, 1, RW1HC, 0x0, 'INIT', 'A 0 to 1 transition on this bit initiates a reset request
    at the interface. This is self-cleared, it is recommended that software set this bit after
    a profile is loaded to ensure a clean start.');

register(0x010, 'REG_SS_CONTROL');
field(0, 3, RW, 0x0, 'SS_RATIO', 'The sampling ratio at the interface.
    If set to 0x0 all the samples are valid and passed down stream. If otherwise, data is
    considered duplicates of 0x1(2), 0x2(4), 0x3(8), 0x4(16), and 0x5(32).');
field(4, 3, RW, 0x0, 'OBS_SS_RATIO', 'The sampling ratio at the interface
    for the observation channel. The behavior is the same as above (receive only).');
field(8, 1, RW, 0x0, 'SS_MODE', 'The sampling ratio based assertion control at the interface
    strobe signal. If set to 0x0 strobe and data behaves the same way. If set to 0x1 strobe is
    asserted for all samples (continous, transmit only).');

register(0x020, 'REG_DATA_SEL');
field(0, 4, RW, 0x0, 'DATA_SEL', 'This field selects the data types at the interface.');

define('DATA_SEL_DMA',          0x0, 'data select');
define('DATA_SEL_RX2TX_LB',     0x1, 'data select');
define('DATA_SEL_ZERO',         0x2, 'data select');
define('DATA_SEL_PATTERN',      0x3, 'data select');
define('DATA_SEL_NIBBLE_RAMP',  0x4, 'data select');
define('DATA_SEL_RAMP',         0x5, 'data select');
define('DATA_SEL_PRBS15',       0x6, 'data select');
define('DATA_SEL_PRBS7',        0x7, 'data select');
define('DATA_SEL_FS_X8',        0x8, 'data select');

register(0x030, 'REG_DATA_PAT_0');
field(0, 32, RW, 0x0, 'DATA_PAT_0', 'The data pattern low order bits.');

register(0x034, 'REG_DATA_PAT_1');
field(0, 32, RW, 0x0, 'DATA_PAT_1', 'The data pattern high order bits.');

register(0x040, 'REG_DATA_0');
field(0, 32, RO, 0x0, 'DATA_0', 'The received data, low order bits (receive only).');

register(0x044, 'REG_DATA_1');
field(0, 32, RO, 0x0, 'DATA_1', 'The received data, high order bits (receive only).');

register(0x060, 'REG_STATUS');
field(0, 1, RW1C, 0x0, 'FRM_OOS', 'Framer out of sync (receive only).');
field(1, 1, RW1C, 0x0, 'FRM_ERR', 'Framer errors (receive only).');
field(2, 1, RW1C, 0x0, 'MON_OOS', 'Monitor out of sync (receive only).');
field(3, 1, RW1C, 0x0, 'MON_ERR', 'Monitor errors (receive only).');
field(8, 1, RW1C, 0x0, 'LB_OVF', 'Loopback buffer overflow (transmit only).');
field(9, 1, RW1C, 0x0, 'LB_UNF', 'Loopback buffer underflow (transmit only).');

register(0x064, 'REG_ALIGN_SEL');
field(0, 1, RW, 0x0, 'ALIGN_SEL', 'If set, select delayed signals for alignment.');

register(0x070, 'REG_DELAY_UNLOCKED');
field(0, 1, RO, 0x0, 'DELAY_UNLOCKED', 'If clear, this bit indicates the delay controller
    is locked and calibrated. A delay setting is not guaranteed if this bit is set.');

define('DELAY_LANE_0',      0x0, "LANE_0");
define('DELAY_LANE_1',      0x1, "LANE_1");
define('DELAY_LANE_2',      0x2, "LANE_2");
define('DELAY_LANE_3',      0x3, "LANE_3");
define('DELAY_STROBE',      0x4, "STROBE");
define('DELAY_CLOCK',       0x5, "CLOCK");
define('DELAY_INT_CLOCK',   0x6, "INT_CLOCK");
define('DELAY_EXT_CLOCK',   0x7, "EXT_CLOCK");

$register_base = 0x80;
$register_offset = 0x4;
$register_count = 8;
$register_index = 0;

for ($register_index = 0; $register_index < $register_count; $register_index++) {
    register_loop("REG_DELAY_CONTROL_%02d");
    register_loop_field(0, 5, RW, 0x13, 'WRDELAY_%02d', 'The write delay, resoultion is ~78ps.');
    register_loop_field(8, 5, RO, 0x00, 'RDDELAY_%02d', 'The current delay.');
}

register(0x0c0, 'REG_DELAY_SWEEP');
field(0, 32, RW, 0x0, 'DELAY_SWEEP', 'This field is reserved for the driver.');

register(0x100, 'REG_TIMER');
field(0, 32, RW, 0x0, 'TIMER', 'General purpose timer register, this is a count
    down timer, software may write desired interval and wait for it to reach zero.
    The count can be prematurely terminated, runs at AXILite clock (usually 100MHz).');

register(0x104, 'REG_CLK_MON');
field(0, 32, RO, 0x0, 'CLK_MON_COUNT', 'Clock monitor frequency count. If read 0x0,
    indicates a loss of clock. The format is 16.16 x 100MHz');

register(0x108, 'REG_MCS_LATENCY');
field(0, 16, RO, 0x0, 'MCS_LATENCY_COUNT', 'MCS to first strobe latency count in
    half the interface clock period.');
field(16, 1, RO, 0x0, 'MCS_LATENCY_BUSY', 'MCS to first strobe latency count state busy.');

register(0x10c, 'REG_MCS_DELAY');
field(0, 3, RW, 0x0, 'MCS_DELAY_COUNT', 'MCS to first strobe delay count in
    half the interface clock period.');

register(0x110, 'REG_MCS_STROBE');
field(0, 32, RO, 0x0, 'MCS_STROBE', 'This is the first four non-zero, strobe
    bytes received on channel 0, after a reset.');

register(0x114, 'REG_MCS_DATA');
field(0, 32, RO, 0x0, 'MCS_DATA', 'This is the first four data bytes received
    on channel 0, aligned to strobe above, after a reset.');

register(0x118, 'REG_MCS_BSTROBE');
field(0, 32, RO, 0x0, 'MCS_BSTROBE', 'This is the first four strobe
    bytes received on channel 0, after a reset.');

register(0x11c, 'REG_MCS_BDATA');
field(0, 32, RO, 0x0, 'MCS_BDATA', 'This is the first four data bytes received
    on channel 0, aligned to strobe above, after a reset.');

register(0x120, 'REG_DATA_PAT_CTL');
field(0, 1, RW, 0x0, 'DATA_PAT_PULSE', 'If set, sends pattern as a pulse, pattern is
    inserted at the next scheduled sample time (transmit only).');

register(0x124, 'REG_DATA_PAT_START');
field(0, 1, RW1HC, 0x0, 'DATA_PAT_START', 'If set, pattern is inserted and hardware
    clears the bit after insertion and monitoring of pattern (transmit only).');

register(0x128, 'REG_DATA_PAT_LATENCY');
field(0, 32, RO, 0x0, 'DATA_PAT_LATENCY', 'The number of SSI clock cycles
    from transmit pattern pulse insert to receive pattern monitor (transmit only).');

register(0x140, 'REG_MASTER_ENABLE');
field(0, 1, RW, 0x0, 'MASTER_ENABLE', 'If set to 0x1, interface uses master enable,
    this signal is based on board configuration and must be sourced from another instance
    of the same core.');
field(1, 1, RW, 0x0, 'OBS_MASTER_ENABLE', 'If set to 0x1, interface uses master enable,
    this signal is based on board configuration and must be sourced from another instance
    of the same core (receive only).');

register(0x204, 'REG_INTR_ENABLE');
field(0, 1, RW, 0x0, 'INTR_FRM_OOS_ENABLE', 'Interrupt enable for INTR_FRM_OOS.');
field(1, 1, RW, 0x0, 'INTR_FRM_ERR_ENABLE', 'Interrupt enable for INTR_FRM_ERR.');
field(2, 1, RW, 0x0, 'INTR_MON_OOS_ENABLE', 'Interrupt enable for INTR_MON_OOS.');
field(3, 1, RW, 0x0, 'INTR_MON_ERR_ENABLE', 'Interrupt enable for INTR_MON_ERR.');
field(8, 1, RW, 0x0, 'INTR_LB_OVF_ENABLE', 'Interrupt enable for LB_OVF (transmit only).');
field(9, 1, RW, 0x0, 'INTR_LB_UNF_ENABLE', 'Interrupt enable for LB_UNF (transmit only).');

endregisters();
endmodule();
generate();

## ##################################################################################
## ##################################################################################
