### AXI\_ADRV9001\_SSI Register Map
The addresses shown are relative to the peripheral base address.

---
| Address | Bits | Field | Type | Default | Description |
| ------- | ---- | ----- | ---- | ------- | ----------- |
| 0x0 | [31:0] | cmos\_lvds\_id[31:0] | RO | 0x0 | An unambigous identifier indicates the current configuration of SSI interface. If configured as CMOS, this register reads 0x43-0x4d-0x4f-0x53, and if LVDS, reads 0x4c-0x56-0x44-0x53. |
| | | | | | |
| 0x4 | [6:4] | num\_of\_bits[2:0] | RW | 0x0 | This field must be set to the desired number of bits in a sample. |
| 0x4 | [8:8] | lstrb1\_pstrb0 | RW | 0x0 | If set to 0x1, strobe is level, and is expected to be asserted high for all bits of I. Otherwise only the MSB. |
| 0x4 | [9:9] | mlane1\_slane0 | RW | 0x0 | If set to 0x1, multiple lanes (2 for lvds or 4 for cmos), otherwise single lane. |
| 0x4 | [10:10] | sdr1\_ddr0 | RW | 0x0 | This field must be set to the desired clock type. If set to 0x1, interface is SDR. If set to 0x0, interface is in DDR mode. This bit must be set carefully to match the device. The FPGA core supports SDR or DDR in all modes. |
| 0x4 | [11:11] | lsb1\_msb0 | RW | 0x0 | This field must be set to the desired bit order within the data frame. If set to 0x1, the first bit is LSB, if set to 0x0, it is MSB. |
| 0x4 | [12:12] | q1\_i0 | RW | 0x0 | This field must be set to the desired channel order within the data frame. If set to 0x1, the first sample is the Q channel. If set to 0x0, it is I. |
| 0x4 | [13:13] | fall1\_rise0 | RW | 0x0 | This bit controls the data sampling edge in SDR mode, if set to 0x1, falling clock edges are used to capture data. If set to 0x0, data is sampled at the rising edges of the interface clock (receive only). |
| 0x4 | [14:14] | cmos1\_lvds0 | RO | 0x0 | This is a read-only bit indicating the current configuration of this interface. If read 0x1, interface is in CMOS mode. If read 0x0, it is in LVDS mode. The software is expected to qualify the remaining fields in this register based on the value read in this bit. |
| | | | | | |
| 0x8 | [0:0] | clk\_sel | RW | 0x0 | If this field is set, the transmit interface internal clock is sourced from the receive interface clock, otherwise, the transmit reference clock input sources the transmit interface internal clock (transmit only). |
| 0x8 | [1:1] | clk\_msb | RW | 0x0 | The transmit interface clock output may be inverted by setting this field to 0x1, as it controls the MSB bit in the clock output (transmit only). |
| 0x8 | [2:2] | clk\_enb | RW | 0x1 | Internal driver use only. |
| 0x8 | [13:8] | buf\_enable[5:0] | RW | 0x0 | The core, by default, tri-states all the IO unless explicitly enabled by software. After a profile is loaded, this bit must be set to 0x1 to enable all the output buffers in both LVDS and CMOS mode, BIT0 (LSB) is reference clock, BIT1 is strobe, BIT2 to BIT5 controls data0 to data3 (transmit only). |
| | | | | | |
| 0xc | [0:0] | init | RW1HC | 0x0 | A 0 to 1 transition on this bit initiates a reset request at the interface. This is self-cleared, it is recommended that software set this bit after a profile is loaded to ensure a clean start. |
| | | | | | |
| 0x10 | [2:0] | ss\_ratio[2:0] | RW | 0x0 | The sampling ratio at the interface. If set to 0x0 all the samples are valid and passed down stream. If otherwise, data is considered duplicates of 0x1(2), 0x2(4), 0x3(8), 0x4(16), and 0x5(32). |
| 0x10 | [6:4] | obs\_ss\_ratio[2:0] | RW | 0x0 | The sampling ratio at the interface for the observation channel. The behavior is the same as above (receive only). |
| 0x10 | [8:8] | ss\_mode | RW | 0x0 | The sampling ratio based assertion control at the interface strobe signal. If set to 0x0 strobe and data behaves the same way. If set to 0x1 strobe is asserted for all samples (continous, transmit only). |
| | | | | | |
| 0x20 | [3:0] | data\_sel[3:0] | RW | 0x0 | This field selects the data types at the interface. |
| | | | | | |
| 0x30 | [31:0] | data\_pat\_0[31:0] | RW | 0x0 | The data pattern low order bits. |
| | | | | | |
| 0x34 | [31:0] | data\_pat\_1[31:0] | RW | 0x0 | The data pattern high order bits. |
| | | | | | |
| 0x40 | [31:0] | data\_0[31:0] | RO | 0x0 | The received data, low order bits (receive only). |
| | | | | | |
| 0x44 | [31:0] | data\_1[31:0] | RO | 0x0 | The received data, high order bits (receive only). |
| | | | | | |
| 0x60 | [0:0] | frm\_oos | RW1C | 0x0 | Framer out of sync (receive only). |
| 0x60 | [1:1] | frm\_err | RW1C | 0x0 | Framer errors (receive only). |
| 0x60 | [2:2] | mon\_oos | RW1C | 0x0 | Monitor out of sync (receive only). |
| 0x60 | [3:3] | mon\_err | RW1C | 0x0 | Monitor errors (receive only). |
| 0x60 | [8:8] | lb\_ovf | RW1C | 0x0 | Loopback buffer overflow (transmit only). |
| 0x60 | [9:9] | lb\_unf | RW1C | 0x0 | Loopback buffer underflow (transmit only). |
| | | | | | |
| 0x64 | [0:0] | align\_sel | RW | 0x0 | If set, select delayed signals for alignment. |
| | | | | | |
| 0x70 | [0:0] | delay\_unlocked | RO | 0x0 | If clear, this bit indicates the delay controller is locked and calibrated. A delay setting is not guaranteed if this bit is set. |
| | | | | | |
| 0x80 | [4:0] | wrdelay\_00[4:0] | RW | 0x13 | The write delay, resoultion is ~78ps. |
| 0x80 | [12:8] | rddelay\_00[4:0] | RO | 0x0 | The current delay. |
| | | | | | |
| 0x84 | [4:0] | wrdelay\_01[4:0] | RW | 0x13 | The write delay, resoultion is ~78ps. |
| 0x84 | [12:8] | rddelay\_01[4:0] | RO | 0x0 | The current delay. |
| | | | | | |
| 0x88 | [4:0] | wrdelay\_02[4:0] | RW | 0x13 | The write delay, resoultion is ~78ps. |
| 0x88 | [12:8] | rddelay\_02[4:0] | RO | 0x0 | The current delay. |
| | | | | | |
| 0x8c | [4:0] | wrdelay\_03[4:0] | RW | 0x13 | The write delay, resoultion is ~78ps. |
| 0x8c | [12:8] | rddelay\_03[4:0] | RO | 0x0 | The current delay. |
| | | | | | |
| 0x90 | [4:0] | wrdelay\_04[4:0] | RW | 0x13 | The write delay, resoultion is ~78ps. |
| 0x90 | [12:8] | rddelay\_04[4:0] | RO | 0x0 | The current delay. |
| | | | | | |
| 0x94 | [4:0] | wrdelay\_05[4:0] | RW | 0x13 | The write delay, resoultion is ~78ps. |
| 0x94 | [12:8] | rddelay\_05[4:0] | RO | 0x0 | The current delay. |
| | | | | | |
| 0x98 | [4:0] | wrdelay\_06[4:0] | RW | 0x13 | The write delay, resoultion is ~78ps. |
| 0x98 | [12:8] | rddelay\_06[4:0] | RO | 0x0 | The current delay. |
| | | | | | |
| 0x9c | [4:0] | wrdelay\_07[4:0] | RW | 0x13 | The write delay, resoultion is ~78ps. |
| 0x9c | [12:8] | rddelay\_07[4:0] | RO | 0x0 | The current delay. |
| | | | | | |
| 0xc0 | [31:0] | delay\_sweep[31:0] | RW | 0x0 | This field is reserved for the driver. |
| | | | | | |
| 0x100 | [31:0] | timer[31:0] | RW | 0x0 | General purpose timer register, this is a count down timer, software may write desired interval and wait for it to reach zero. The count can be prematurely terminated, runs at AXILite clock (usually 100MHz). |
| | | | | | |
| 0x104 | [31:0] | clk\_mon\_count[31:0] | RO | 0x0 | Clock monitor frequency count. If read 0x0, indicates a loss of clock. The format is 16.16 x 100MHz |
| | | | | | |
| 0x108 | [15:0] | mcs\_latency\_count[15:0] | RO | 0x0 | MCS to first strobe latency count in half the interface clock period. |
| 0x108 | [16:16] | mcs\_latency\_busy | RO | 0x0 | MCS to first strobe latency count state busy. |
| | | | | | |
| 0x10c | [2:0] | mcs\_delay\_count[2:0] | RW | 0x0 | MCS to first strobe delay count in half the interface clock period. |
| | | | | | |
| 0x110 | [31:0] | mcs\_strobe[31:0] | RO | 0x0 | This is the first four non-zero, strobe bytes received on channel 0, after a reset. |
| | | | | | |
| 0x114 | [31:0] | mcs\_data[31:0] | RO | 0x0 | This is the first four data bytes received on channel 0, aligned to strobe above, after a reset. |
| | | | | | |
| 0x118 | [31:0] | mcs\_bstrobe[31:0] | RO | 0x0 | This is the first four strobe bytes received on channel 0, after a reset. |
| | | | | | |
| 0x11c | [31:0] | mcs\_bdata[31:0] | RO | 0x0 | This is the first four data bytes received on channel 0, aligned to strobe above, after a reset. |
| | | | | | |
| 0x120 | [0:0] | data\_pat\_pulse | RW | 0x0 | If set, sends pattern as a pulse, pattern is inserted at the next scheduled sample time (transmit only). |
| | | | | | |
| 0x124 | [0:0] | data\_pat\_start | RW1HC | 0x0 | If set, pattern is inserted and hardware clears the bit after insertion and monitoring of pattern (transmit only). |
| | | | | | |
| 0x128 | [31:0] | data\_pat\_latency[31:0] | RO | 0x0 | The number of SSI clock cycles from transmit pattern pulse insert to receive pattern monitor (transmit only). |
| | | | | | |
| 0x140 | [0:0] | master\_enable | RW | 0x0 | If set to 0x1, interface uses master enable, this signal is based on board configuration and must be sourced from another instance of the same core. |
| 0x140 | [1:1] | obs\_master\_enable | RW | 0x0 | If set to 0x1, interface uses master enable, this signal is based on board configuration and must be sourced from another instance of the same core (receive only). |
| | | | | | |
| 0x204 | [0:0] | intr\_frm\_oos\_enable | RW | 0x0 | Interrupt enable for INTR\_FRM\_OOS. |
| 0x204 | [1:1] | intr\_frm\_err\_enable | RW | 0x0 | Interrupt enable for INTR\_FRM\_ERR. |
| 0x204 | [2:2] | intr\_mon\_oos\_enable | RW | 0x0 | Interrupt enable for INTR\_MON\_OOS. |
| 0x204 | [3:3] | intr\_mon\_err\_enable | RW | 0x0 | Interrupt enable for INTR\_MON\_ERR. |
| 0x204 | [8:8] | intr\_lb\_ovf\_enable | RW | 0x0 | Interrupt enable for LB\_OVF (transmit only). |
| 0x204 | [9:9] | intr\_lb\_unf\_enable | RW | 0x0 | Interrupt enable for LB\_UNF (transmit only). |
| | | | | | |
---
