// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Description:       AXI_ADRV9001, receive sub-sampling (decimation)
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module axi_adrv9001_rx_ss (

    // transmit interface

    input   wire            rx_clk,
    input   wire            rx_resetn,
    input   wire            rx_ss_enable,
    input   wire            rx_ss_valid,
    input   wire  [ 63:0]   rx_ss_data,
    input   wire  [  2:0]   rx_ss_ratio,
    input   wire  [  2:0]   rx_num_of_bits,
    output  reg             rx_sync = 'd0,
    output  reg             rx_valid = 'd0,
    output  reg   [ 63:0]   rx_data = 'd0);

    // internal registers
 
    reg           [ 63:0]   rx_data_08 = 'd0;
    reg           [ 63:0]   rx_data_16 = 'd0;
    reg           [ 63:0]   rx_data_32 = 'd0;
    reg           [ 63:0]   rx_data_64 = 'd0;
    reg                     rx_ss_valid_d = 'd0;
    reg           [  4:0]   rx_ss_cnt = 'd0;
    reg           [  4:0]   rx_ss_max = 'd0;

    // internal signals

    wire          [  7:0]   rx_ss_sel;

    // sub sampling (decimation)

    always @(posedge rx_clk) begin
        if (rx_ss_valid == 1'd1) begin
            case (rx_ss_sel)
                8'b00000000: begin
                    rx_data_08 <= rx_ss_data;
                end
                8'b00100000: begin
                    rx_data_08[63:56] <= rx_data_08[63:56];
                    rx_data_08[55:48] <= rx_data_08[55:48];
                    rx_data_08[47:40] <= rx_data_08[47:40];
                    rx_data_08[39:32] <= rx_data_08[39:32];
                    rx_data_08[31:24] <= rx_ss_data[55:48];
                    rx_data_08[23:16] <= rx_ss_data[39:32];
                    rx_data_08[15: 8] <= rx_ss_data[23:16];
                    rx_data_08[ 7: 0] <= rx_ss_data[ 7: 0];
                end
                8'b00100001: begin
                    rx_data_08[63:56] <= rx_ss_data[55:48];
                    rx_data_08[55:48] <= rx_ss_data[39:32];
                    rx_data_08[47:40] <= rx_ss_data[23:16];
                    rx_data_08[39:32] <= rx_ss_data[ 7: 0];
                    rx_data_08[31:24] <= rx_data_08[31:24];
                    rx_data_08[23:16] <= rx_data_08[23:16];
                    rx_data_08[15: 8] <= rx_data_08[15: 8];
                    rx_data_08[ 7: 0] <= rx_data_08[ 7: 0];
                end
                8'b01000000: begin
                    rx_data_08[63:56] <= rx_data_08[63:56];
                    rx_data_08[55:48] <= rx_data_08[55:48];
                    rx_data_08[47:40] <= rx_data_08[47:40];
                    rx_data_08[39:32] <= rx_data_08[39:32];
                    rx_data_08[31:24] <= rx_data_08[31:24];
                    rx_data_08[23:16] <= rx_data_08[23:16];
                    rx_data_08[15: 8] <= rx_ss_data[39:32];
                    rx_data_08[ 7: 0] <= rx_ss_data[ 7: 0];
                end
                8'b01000001: begin
                    rx_data_08[63:56] <= rx_data_08[63:56];
                    rx_data_08[55:48] <= rx_data_08[55:48];
                    rx_data_08[47:40] <= rx_data_08[47:40];
                    rx_data_08[39:32] <= rx_data_08[39:32];
                    rx_data_08[31:24] <= rx_ss_data[39:32];
                    rx_data_08[23:16] <= rx_ss_data[ 7: 0];
                    rx_data_08[15: 8] <= rx_data_08[15: 8];
                    rx_data_08[ 7: 0] <= rx_data_08[ 7: 0];
                end
                8'b01000010: begin
                    rx_data_08[63:56] <= rx_data_08[63:56];
                    rx_data_08[55:48] <= rx_data_08[55:48];
                    rx_data_08[47:40] <= rx_ss_data[39:32];
                    rx_data_08[39:32] <= rx_ss_data[ 7: 0];
                    rx_data_08[31:24] <= rx_data_08[31:24];
                    rx_data_08[23:16] <= rx_data_08[23:16];
                    rx_data_08[15: 8] <= rx_data_08[15: 8];
                    rx_data_08[ 7: 0] <= rx_data_08[ 7: 0];
                end
                8'b01000011: begin
                    rx_data_08[63:56] <= rx_ss_data[39:32];
                    rx_data_08[55:48] <= rx_ss_data[ 7: 0];
                    rx_data_08[47:40] <= rx_data_08[47:40];
                    rx_data_08[39:32] <= rx_data_08[39:32];
                    rx_data_08[31:24] <= rx_data_08[31:24];
                    rx_data_08[23:16] <= rx_data_08[23:16];
                    rx_data_08[15: 8] <= rx_data_08[15: 8];
                    rx_data_08[ 7: 0] <= rx_data_08[ 7: 0];
                end
                8'b01100000, 8'b10000000, 8'b10100000: begin
                    rx_data_08[63:56] <= rx_data_08[63:56];
                    rx_data_08[55:48] <= rx_data_08[55:48];
                    rx_data_08[47:40] <= rx_data_08[47:40];
                    rx_data_08[39:32] <= rx_data_08[39:32];
                    rx_data_08[31:24] <= rx_data_08[31:24];
                    rx_data_08[23:16] <= rx_data_08[23:16];
                    rx_data_08[15: 8] <= rx_data_08[15: 8];
                    rx_data_08[ 7: 0] <= rx_ss_data[ 7: 0];
                end
                8'b01100001, 8'b10000010, 8'b10100100: begin
                    rx_data_08[63:56] <= rx_data_08[63:56];
                    rx_data_08[55:48] <= rx_data_08[55:48];
                    rx_data_08[47:40] <= rx_data_08[47:40];
                    rx_data_08[39:32] <= rx_data_08[39:32];
                    rx_data_08[31:24] <= rx_data_08[31:24];
                    rx_data_08[23:16] <= rx_data_08[23:16];
                    rx_data_08[15: 8] <= rx_ss_data[ 7: 0];
                    rx_data_08[ 7: 0] <= rx_data_08[ 7: 0];
                end
                8'b01100010, 8'b10000100, 8'b10101000: begin
                    rx_data_08[63:56] <= rx_data_08[63:56];
                    rx_data_08[55:48] <= rx_data_08[55:48];
                    rx_data_08[47:40] <= rx_data_08[47:40];
                    rx_data_08[39:32] <= rx_data_08[39:32];
                    rx_data_08[31:24] <= rx_data_08[31:24];
                    rx_data_08[23:16] <= rx_ss_data[ 7: 0];
                    rx_data_08[15: 8] <= rx_data_08[15: 8];
                    rx_data_08[ 7: 0] <= rx_data_08[ 7: 0];
                end
                8'b01100011, 8'b10000110, 8'b10101100: begin
                    rx_data_08[63:56] <= rx_data_08[63:56];
                    rx_data_08[55:48] <= rx_data_08[55:48];
                    rx_data_08[47:40] <= rx_data_08[47:40];
                    rx_data_08[39:32] <= rx_data_08[39:32];
                    rx_data_08[31:24] <= rx_ss_data[ 7: 0];
                    rx_data_08[23:16] <= rx_data_08[23:16];
                    rx_data_08[15: 8] <= rx_data_08[15: 8];
                    rx_data_08[ 7: 0] <= rx_data_08[ 7: 0];
                end
                8'b01100100, 8'b10001000, 8'b10110000: begin
                    rx_data_08[63:56] <= rx_data_08[63:56];
                    rx_data_08[55:48] <= rx_data_08[55:48];
                    rx_data_08[47:40] <= rx_data_08[47:40];
                    rx_data_08[39:32] <= rx_ss_data[ 7: 0];
                    rx_data_08[31:24] <= rx_data_08[31:24];
                    rx_data_08[23:16] <= rx_data_08[23:16];
                    rx_data_08[15: 8] <= rx_data_08[15: 8];
                    rx_data_08[ 7: 0] <= rx_data_08[ 7: 0];
                end
                8'b01100101, 8'b10001010, 8'b10110100: begin
                    rx_data_08[63:56] <= rx_data_08[63:56];
                    rx_data_08[55:48] <= rx_data_08[55:48];
                    rx_data_08[47:40] <= rx_ss_data[ 7: 0];
                    rx_data_08[39:32] <= rx_data_08[39:32];
                    rx_data_08[31:24] <= rx_data_08[31:24];
                    rx_data_08[23:16] <= rx_data_08[23:16];
                    rx_data_08[15: 8] <= rx_data_08[15: 8];
                    rx_data_08[ 7: 0] <= rx_data_08[ 7: 0];
                end
                8'b01100110, 8'b10001100, 8'b10111000: begin
                    rx_data_08[63:56] <= rx_data_08[63:56];
                    rx_data_08[55:48] <= rx_ss_data[ 7: 0];
                    rx_data_08[47:40] <= rx_data_08[47:40];
                    rx_data_08[39:32] <= rx_data_08[39:32];
                    rx_data_08[31:24] <= rx_data_08[31:24];
                    rx_data_08[23:16] <= rx_data_08[23:16];
                    rx_data_08[15: 8] <= rx_data_08[15: 8];
                    rx_data_08[ 7: 0] <= rx_data_08[ 7: 0];
                end
                8'b01100111, 8'b10001110, 8'b10111100: begin
                    rx_data_08[63:56] <= rx_ss_data[ 7: 0];
                    rx_data_08[55:48] <= rx_data_08[55:48];
                    rx_data_08[47:40] <= rx_data_08[47:40];
                    rx_data_08[39:32] <= rx_data_08[39:32];
                    rx_data_08[31:24] <= rx_data_08[31:24];
                    rx_data_08[23:16] <= rx_data_08[23:16];
                    rx_data_08[15: 8] <= rx_data_08[15: 8];
                    rx_data_08[ 7: 0] <= rx_data_08[ 7: 0];
                end
                default: begin
                    rx_data_08 <= rx_data_08;
                end
            endcase
        end
    end

    always @(posedge rx_clk) begin
        if (rx_ss_valid == 1'd1) begin
            case (rx_ss_sel)
                8'b00000000: begin
                    rx_data_16 <= rx_ss_data;
                end
                8'b00100000: begin
                    rx_data_16[63:48] <= rx_data_16[63:48];
                    rx_data_16[47:32] <= rx_data_16[47:32];
                    rx_data_16[31:16] <= rx_ss_data[47:32];
                    rx_data_16[15: 0] <= rx_ss_data[15: 0];
                end
                8'b00100001: begin
                    rx_data_16[63:48] <= rx_ss_data[47:32];
                    rx_data_16[47:32] <= rx_ss_data[15: 0];
                    rx_data_16[31:16] <= rx_data_16[31:16];
                    rx_data_16[15: 0] <= rx_data_16[15: 0];
                end
                8'b01000000, 8'b01100000, 8'b10000000,
                8'b10100000: begin
                    rx_data_16[63:48] <= rx_data_16[63:48];
                    rx_data_16[47:32] <= rx_data_16[47:32];
                    rx_data_16[31:16] <= rx_data_16[31:16];
                    rx_data_16[15: 0] <= rx_ss_data[15: 0];
                end
                8'b01000001, 8'b01100010, 8'b10000100,
                8'b10101000: begin
                    rx_data_16[63:48] <= rx_data_16[63:48];
                    rx_data_16[47:32] <= rx_data_16[47:32];
                    rx_data_16[31:16] <= rx_ss_data[15: 0];
                    rx_data_16[15: 0] <= rx_data_16[15: 0];
                end
                8'b01000010, 8'b01100100, 8'b10001000,
                8'b10110000: begin
                    rx_data_16[63:48] <= rx_data_16[63:48];
                    rx_data_16[47:32] <= rx_ss_data[15: 0];
                    rx_data_16[31:16] <= rx_data_16[31:16];
                    rx_data_16[15: 0] <= rx_data_16[15: 0];
                end
                8'b01000011, 8'b01100110, 8'b10001100,
                8'b10111000: begin
                    rx_data_16[63:48] <= rx_ss_data[15: 0];
                    rx_data_16[47:32] <= rx_data_16[47:32];
                    rx_data_16[31:16] <= rx_data_16[31:16];
                    rx_data_16[15: 0] <= rx_data_16[15: 0];
                end
                default: begin
                    rx_data_16 <= rx_data_16;
                end
            endcase
        end
    end

    always @(posedge rx_clk) begin
        if (rx_ss_valid == 1'd1) begin
            case (rx_ss_sel)
                8'b00000000: begin
                    rx_data_32 <= rx_ss_data;
                end
                8'b00100000, 8'b01000000, 8'b01100000,
                8'b10000000, 8'b10100000: begin
                    rx_data_32[63:32] <= rx_data_32[63:32];
                    rx_data_32[31: 0] <= rx_ss_data[31:0];
                end
                8'b00100001, 8'b01000010, 8'b01100100,
                8'b10001000, 8'b10110000: begin
                    rx_data_32[63:32] <= rx_ss_data[31:0];
                    rx_data_32[31: 0] <= rx_data_32[31:0];
                end
                default: begin
                    rx_data_32 <= rx_data_32;
                end
            endcase
        end
    end

    always @(posedge rx_clk) begin
        if (rx_ss_valid == 1'd1) begin
            rx_data_64 <= rx_ss_data;
        end
    end

    always @(negedge rx_resetn or posedge rx_clk) begin
        if (rx_resetn == 1'b0) begin
            rx_ss_valid_d <= 1'd0;
            rx_sync <= 1'd0;
            rx_valid <= 1'd0;
            rx_data <= 64'd0;
        end else begin
            if (rx_ss_cnt >= rx_ss_max) begin
                rx_ss_valid_d <= rx_ss_valid;
            end else begin
                rx_ss_valid_d <= 1'd0;
            end
            rx_sync <= rx_ss_valid_d;
            rx_valid <= rx_ss_enable & rx_ss_valid_d;
            case (rx_num_of_bits)
                3'b101: rx_data <= rx_data_64;
                3'b100: rx_data <= rx_data_32;
                3'b011: rx_data <= rx_data_32;
                3'b010: rx_data <= rx_data_16;
                3'b001: rx_data <= rx_data_08;
                3'b000: rx_data <= rx_data_08;
                default: rx_data <= 64'd0;
            endcase
        end
    end

    assign rx_ss_sel = {rx_ss_ratio, rx_ss_cnt};

    always @(negedge rx_resetn or posedge rx_clk) begin
        if (rx_resetn == 1'b0) begin
            rx_ss_cnt <= 5'd0;
        end else if (rx_ss_valid == 1'b1) begin
            if (rx_ss_cnt >= rx_ss_max) begin
                rx_ss_cnt <= 5'd0;
            end else begin
                rx_ss_cnt <= rx_ss_cnt + 1'b1;
            end
        end
    end

    always @(negedge rx_resetn or posedge rx_clk) begin
        if (rx_resetn == 1'b0) begin
            rx_ss_max <= 5'h00;
        end else begin
            case (rx_ss_ratio)
                3'd5: rx_ss_max <= 5'h1f;
                3'd4: rx_ss_max <= 5'h0f;
                3'd3: rx_ss_max <= 5'h07;
                3'd2: rx_ss_max <= 5'h03;
                3'd1: rx_ss_max <= 5'h01;
                default: rx_ss_max <= 5'h00;
            endcase
        end
    end

endmodule

// **********************************************************************************
// **********************************************************************************
