// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Description:       AXI_ADRV9001, receive data monitor
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module axi_adrv9001_rx #(

    parameter ID = 0,
    parameter DEVICE_TYPE = "ULTRASCALE",
    parameter PN_SWAP = 0,
    parameter GPIO2_CMOS1_LVDS0 = 0,
    parameter RESET_PIPE_LENGTH = 6,
    parameter MATCH_CLOCKING = 1,
    parameter IODELAY_GROUP = "IODELAY_GROUP",
    parameter IODELAY_CTRL_ENABLE = 1) (

    // receive interface

    input   wire            rx_cssi_clk_lssi_clk_p,
    input   wire            rx_cssi_nc_lssi_clk_n,
    input   wire            rx_cssi_strobe_lssi_strobe_p,
    input   wire            rx_cssi_nc_lssi_strobe_n,
    input   wire            rx_cssi_data1_lssi_data0_p,
    input   wire            rx_cssi_data0_lssi_data0_n,
    input   wire            rx_cssi_data3_lssi_data1_p,
    input   wire            rx_cssi_data2_lssi_data1_n,
    input   wire  [  7:0]   rx_cssi_gpio_in,
    output  wire  [  7:0]   rx_cssi_gpio_out,
    output  wire  [  7:0]   rx_cssi_gpio_enb,

    // internal interface

    output  wire            rx_buf_clk,
    output  wire            rx_clk,
    output  wire            rx_resetn,
    output  wire            rx_sync,
    output  wire            rx_valid,
    output  wire  [ 63:0]   rx_data,
    input   wire            rx_enable,
    output  wire            orx_sync,
    output  wire            orx_valid,
    output  wire  [ 63:0]   orx_data,
    input   wire            orx_enable,
    output  wire  [  7:0]   rx_gpio_in,
    input   wire  [  7:0]   rx_gpio_out,
    input   wire  [  7:0]   rx_gpio_enb,

    // mcs & transmit interface

    input   wire            mcs_clk_resetn,
    input   wire            mcs_phy_resetn,
    input   wire            mcs_dp_resetn,
    input   wire            rx_clk_resetn_in,
    input   wire            rx_phy_resetn_in,
    input   wire            rx_dp_resetn_in,
    output  wire            rx_clk_resetn_out,
    output  wire            rx_phy_resetn_out,
    output  wire            rx_dp_resetn_out,
    output  reg             rx_menable_out = 'd0,
    input   wire            rx_menable_in,
    output  reg             orx_menable_out = 'd0,
    input   wire            orx_menable_in,

    // delay interface

    input   wire            sys_delay_clk,
    input   wire            sys_delay_resetn,

    // axi interface

    input   wire            axilite_clk,
    input   wire            axilite_resetn,
    input   wire            axilite_wrreq,
    input   wire  [ 15:0]   axilite_wraddr,
    input   wire  [ 31:0]   axilite_wrdata,
    output  wire            axilite_wrack,
    input   wire            axilite_rdreq,
    input   wire  [ 15:0]   axilite_rdaddr,
    output  wire  [ 31:0]   axilite_rddata,
    output  wire            axilite_rdack,
    output  reg             axilite_intr = 1'd0);
    
    // cmos & lvds data lines

    localparam              GPIO2_CMOS1 = (GPIO2_CMOS1_LVDS0 == 1) ? 1 : 2;

    // supported interface modes

    localparam    [  5:0]   CMOS_1L_PS_02X1 = {1'b1, 1'b0, 1'b0, 3'b000};
    localparam    [  5:0]   CMOS_1L_LS_02X1 = {1'b1, 1'b0, 1'b1, 3'b000};
    localparam    [  5:0]   CMOS_1L_PS_08X1 = {1'b1, 1'b0, 1'b0, 3'b001};
    localparam    [  5:0]   CMOS_1L_LS_08X1 = {1'b1, 1'b0, 1'b1, 3'b001};
    localparam    [  5:0]   CMOS_1L_PS_16X1 = {1'b1, 1'b0, 1'b0, 3'b010};
    localparam    [  5:0]   CMOS_1L_LS_16X1 = {1'b1, 1'b0, 1'b1, 3'b010};
    localparam    [  5:0]   LVDS_1L_PS_24X1 = {1'b0, 1'b0, 1'b0, 3'b011};
    localparam    [  5:0]   LVDS_1L_LS_24X1 = {1'b0, 1'b0, 1'b1, 3'b011};
    localparam    [  5:0]   LVDS_2L_PS_24X1 = {1'b0, 1'b1, 1'b0, 3'b011};
    localparam    [  5:0]   LVDS_2L_LS_24X1 = {1'b0, 1'b1, 1'b1, 3'b011};
    localparam    [  5:0]   CMOS_1L_PS_32X1 = {1'b1, 1'b0, 1'b0, 3'b100};
    localparam    [  5:0]   CMOS_1L_LS_32X1 = {1'b1, 1'b0, 1'b1, 3'b100};
    localparam    [  5:0]   LVDS_1L_PS_32X1 = {1'b0, 1'b0, 1'b0, 3'b100};
    localparam    [  5:0]   LVDS_1L_LS_32X1 = {1'b0, 1'b0, 1'b1, 3'b100};
    localparam    [  5:0]   LVDS_2L_PS_32X1 = {1'b0, 1'b1, 1'b0, 3'b100};
    localparam    [  5:0]   LVDS_2L_LS_32X1 = {1'b0, 1'b1, 1'b1, 3'b100};
    localparam    [  5:0]   CMOS_4L_PS_32X1 = {1'b1, 1'b1, 1'b0, 3'b100};
    localparam    [  5:0]   CMOS_4L_LS_32X1 = {1'b1, 1'b1, 1'b1, 3'b100};
    localparam    [  5:0]   CMOS_1L_PS_64X1 = {1'b1, 1'b0, 1'b0, 3'b101};
    localparam    [  5:0]   CMOS_1L_LS_64X1 = {1'b1, 1'b0, 1'b1, 3'b101};
    localparam    [  5:0]   LVDS_1L_PS_64X1 = {1'b0, 1'b0, 1'b0, 3'b101};
    localparam    [  5:0]   LVDS_1L_LS_64X1 = {1'b0, 1'b0, 1'b1, 3'b101};
    localparam    [  5:0]   LVDS_2L_PS_64X1 = {1'b0, 1'b1, 1'b0, 3'b101};
    localparam    [  5:0]   LVDS_2L_LS_64X1 = {1'b0, 1'b1, 1'b1, 3'b101};
    localparam    [  5:0]   CMOS_4L_PS_64X1 = {1'b1, 1'b1, 1'b0, 3'b101};
    localparam    [  5:0]   CMOS_4L_LS_64X1 = {1'b1, 1'b1, 1'b1, 3'b101};

    // x2 data path
 
    localparam    [  2:0]   RX_SSTATE02_00 = 3'd0;
    localparam    [  2:0]   RX_SSTATE02_A8 = 3'd1;
    localparam    [  2:0]   RX_SSTATE02_88 = 3'd2;
    localparam    [  2:0]   RX_SSTATE02_80 = 3'd3;
    localparam    [  2:0]   RX_SSTATE02_22 = 3'd4;
    localparam    [  2:0]   RX_SSTATE02_20 = 3'd5;
    localparam    [  2:0]   RX_SSTATE02_08 = 3'd6;

    // internal registers
 
    reg                     rx_menable_fall = 'd0;
    reg                     orx_menable_fall = 'd0;
    reg                     rx_menable = 'd0;
    reg                     orx_menable = 'd0;
    reg                     rx_valid_int = 'd0;
    reg           [ 63:0]   rx_data_int = 'd0;
    reg                     rx_valid_bs = 'd0;
    reg           [ 63:0]   rx_data_bs = 'd0;
    reg                     rx_valid_iq = 'd0;
    reg           [ 63:0]   rx_data_iq = 'd0;
    reg           [  1:0]   rx_frm_oos_cnt = 'd0;
    reg                     rx_frm_oos = 'd0;
    reg                     rx_frm_err = 'd0;
    reg           [  2:0]   rx_mcnt64 = 'd0;
    reg                     rx_valid_64 = 'd0;
    reg           [ 63:0]   rx_data_64 = 'd0;
    reg                     rx_svalid_4p64 = 1'd0;
    reg                     rx_serr_4p64 = 1'd1;
    reg                     rx_scnt_4p64 = 1'd0;
    reg           [ 63:0]   rx_sdata_4p64 = 64'd0;
    reg                     rx_svalid_2p64 = 1'd0;
    reg                     rx_serr_2p64 = 1'd1;
    reg           [  1:0]   rx_scnt_2p64 = 2'd0;
    reg           [ 63:0]   rx_sdata_2p64 = 64'd0;
    reg                     rx_svalid_1p64 = 1'd0;
    reg                     rx_serr_1p64 = 1'd1;
    reg           [  2:0]   rx_scnt_1p64 = 3'd0;
    reg           [ 63:0]   rx_sdata_1p64 = 64'd0;
    reg                     rx_svalid_4p32 = 1'd0;
    reg                     rx_serr_4p32 = 1'd1;
    reg           [ 31:0]   rx_sdata_4p32 = 32'd0;
    reg                     rx_svalid_2p32 = 1'd0;
    reg                     rx_serr_2p32 = 1'd1;
    reg                     rx_scnt_2p32 = 1'd0;
    reg           [ 31:0]   rx_sdata_2p32 = 32'd0;
    reg                     rx_svalid_1p32 = 1'd0;
    reg                     rx_serr_1p32 = 1'd1;
    reg           [  1:0]   rx_scnt_1p32 = 2'd0;
    reg           [ 31:0]   rx_sdata_1p32 = 32'd0;
    reg                     rx_svalid_2p24 = 1'd0;
    reg                     rx_serr_2p24 = 1'd1;
    reg           [  1:0]   rx_scnt_2p24 = 2'd0;
    reg           [ 23:0]   rx_sdata_2p24 = 24'd0;
    reg           [  7:0]   rx_hdata_2p24 = 8'd0;
    reg                     rx_svalid_1p24 = 1'd0;
    reg                     rx_serr_1p24 = 1'd1;
    reg           [  1:0]   rx_scnt_1p24 = 2'd0;
    reg           [ 23:0]   rx_sdata_1p24 = 24'd0;
    reg                     rx_svalid_1p16 = 1'd0;
    reg                     rx_serr_1p16 = 1'd1;
    reg                     rx_scnt_1p16 = 1'd0;
    reg           [ 15:0]   rx_sdata_1p16 = 16'd0;
    reg                     rx_svalid_1p08 = 1'd0;
    reg                     rx_serr_1p08 = 1'd1;
    reg           [  7:0]   rx_sdata_1p08 = 8'd0;
    reg                     rx_svalid_1p02 = 1'd0;
    reg           [  2:0]   rx_sstate_1p02 = 3'd0;
    reg                     rx_serr_1p02 = 1'd1;
    reg           [  1:0]   rx_scnt_1p02 = 2'd0;
    reg           [  7:0]   rx_sdata_1p02 = 8'd0;
    reg           [  1:0]   rx_shold_1p02 = 2'd0;
    reg           [  2:0]   rx_mcs_bcount = 'd0;
    reg           [ 31:0]   rx_mcs_bstrobe = 'd0;
    reg           [ 31:0]   rx_mcs_bdata = 'd0;
    reg                     rx_bvalid = 'd0;
    reg           [  7:0]   rx_bstrobe = 'd0;
    reg           [  7:0]   rx_bdata_0 = 'd0;
    reg           [  7:0]   rx_bdata_1 = 'd0;
    reg           [  7:0]   rx_bdata_2 = 'd0;
    reg           [  7:0]   rx_bdata_3 = 'd0;
    reg           [  1:0]   rx_bskip = 'd0;
    reg           [  2:0]   rx_balign = 'd0;
    reg           [  7:0]   rx_dstrobe_d = 'd0;
    reg           [  7:0]   rx_ddata_0_d = 'd0;
    reg           [  7:0]   rx_ddata_1_d = 'd0;
    reg           [  7:0]   rx_ddata_2_d = 'd0;
    reg           [  7:0]   rx_ddata_3_d = 'd0;
    reg                     rx_dtoggle = 'd0;
    reg                     rx_dvalid = 'd0;
    reg           [  7:0]   rx_dstrobe = 'd0;
    reg           [  7:0]   rx_ddata_0 = 'd0;
    reg           [  7:0]   rx_ddata_1 = 'd0;
    reg           [  7:0]   rx_ddata_2 = 'd0;
    reg           [  7:0]   rx_ddata_3 = 'd0;
    reg                     rx_dp_resetn_reg = 'd0;
    reg                     rx_phy_resetn_reg = 'd0;
    reg                     rx_mcs_latency_busy = 'd0;
    reg           [ 15:0]   rx_mcs_latency_count = 'd0;
    reg           [  3:0]   rx_mcs_latency_incr = 'd0;
    reg           [  2:0]   rx_mcs_dcount = 'd0;
    reg           [ 31:0]   rx_mcs_strobe = 'd0;
    reg           [ 31:0]   rx_mcs_data = 'd0;
    reg                     axilite_delay_unlocked = 'd1;

    // internal signals
 
    wire                    rx_bstart;
    wire                    rx_cmos1_lvds0;
    wire          [  5:0]   rx_mode;
    wire                    rx_ienable;
    wire                    orx_ienable;
    wire          [ 63:0]   rx_mon_data;
    wire                    rx_mon_oos;
    wire                    rx_mon_err;
    wire          [  7:0]   rx_pstrobe;
    wire          [  7:0]   rx_pdata_0;
    wire          [  7:0]   rx_pdata_1;
    wire          [  7:0]   rx_pdata_2;
    wire          [  7:0]   rx_pdata_3;
    wire                    rx_hs_clk;
    wire                    rx_strobe_p;
    wire                    rx_strobe_n;
    wire          [  3:0]   rx_data_p;
    wire          [  3:0]   rx_data_n;
    wire                    rx_init_ack;
    wire          [  3:0]   rx_data_sel;
    wire                    rx_align_sel;
    wire          [ 63:0]   rx_pattern;
    wire          [  2:0]   rx_mcs_delay;
    wire          [  2:0]   rx_ss_ratio;
    wire          [  2:0]   orx_ss_ratio;
    wire                    rx_master_enable;
    wire                    orx_master_enable;
    wire                    rx_fall1_rise0;
    wire                    rx_q1_i0;
    wire                    rx_lsb1_msb0;
    wire                    rx_sdr1_ddr0;
    wire                    rx_mlane1_slane0;
    wire                    rx_lstrb1_pstrb0;
    wire          [  2:0]   rx_num_of_bits;
    wire          [  7:0]   rx_cmos_gpio_in;
    wire                    rx_clk_resetn;
    wire                    rx_clk_resetn_int;
    wire                    rx_cdc_resetn;
    wire                    rx_serdes_resetn;
    wire                    rx_serdes_data_resetn;
    wire                    rx_rst_clk;
    wire                    rx_dp_resetn_int;
    wire                    rx_phy_resetn_int;
    wire                    delay_locked;
    wire          [  3:0]   axilite_intr_status;
    wire          [  3:0]   axilite_intr_enable;
    wire          [  3:0]   axilite_intr_active;
    wire          [ 31:0]   axilite_cmos_lvds_id;
    wire          [  2:0]   axilite_num_of_bits;
    wire                    axilite_lstrb1_pstrb0;
    wire                    axilite_mlane1_slane0;
    wire                    axilite_sdr1_ddr0;
    wire                    axilite_lsb1_msb0;
    wire                    axilite_q1_i0;
    wire                    axilite_fall1_rise0;
    wire                    axilite_cmos1_lvds0;
    wire                    axilite_clk_enb;
    wire                    axilite_frm_oos;
    wire                    axilite_frm_err;
    wire                    axilite_mon_oos;
    wire                    axilite_mon_err;
    wire                    axilite_init_req;
    wire                    axilite_init_ack;
    wire          [  3:0]   axilite_data_sel;
    wire          [ 63:0]   axilite_pattern;
    wire          [ 63:0]   axilite_mon_data;
    wire          [  2:0]   axilite_rx_ss_ratio;
    wire          [  2:0]   axilite_orx_ss_ratio;
    wire                    axilite_rx_master_enable;
    wire                    axilite_orx_master_enable;
    wire                    axilite_align_sel;
    wire                    axilite_delay_locked;
    wire          [  4:0]   axilite_wrdelay_0;
    wire          [  4:0]   axilite_rddelay_0;
    wire          [  4:0]   axilite_wrdelay_1;
    wire          [  4:0]   axilite_rddelay_1;
    wire          [  4:0]   axilite_wrdelay_2;
    wire          [  4:0]   axilite_rddelay_2;
    wire          [  4:0]   axilite_wrdelay_3;
    wire          [  4:0]   axilite_rddelay_3;
    wire          [  4:0]   axilite_wrdelay_s;
    wire          [  4:0]   axilite_rddelay_s;
    wire          [ 31:0]   axilite_clk_mon_count;
    wire                    axilite_mcs_latency_busy;
    wire          [ 15:0]   axilite_mcs_latency_count;
    wire          [  2:0]   axilite_mcs_delay;
    wire          [ 31:0]   axilite_mcs_bstrobe;
    wire          [ 31:0]   axilite_mcs_bdata;
    wire          [ 31:0]   axilite_mcs_strobe;
    wire          [ 31:0]   axilite_mcs_data;

    // interrupts
 
    assign axilite_intr_active = axilite_intr_status & axilite_intr_enable;

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_intr <= 1'd0;
        end else begin
            axilite_intr <= | axilite_intr_active;
        end
    end

    // configuration options

    assign axilite_cmos_lvds_id = (GPIO2_CMOS1_LVDS0 == 0) ? 32'h4c564453 :
        ((GPIO2_CMOS1_LVDS0 == 1) ? 32'h434d4f53 : 32'h4750494f);
    assign axilite_cmos1_lvds0 = (GPIO2_CMOS1_LVDS0 == 0) ? 1'b0 : 1'b1;
    assign rx_cmos1_lvds0 = (GPIO2_CMOS1_LVDS0 == 0) ? 1'b0 : 1'b1;

    assign rx_mode[5:5] = rx_cmos1_lvds0;
    assign rx_mode[4:4] = rx_mlane1_slane0;
    assign rx_mode[3:3] = rx_lstrb1_pstrb0;
    assign rx_mode[2:0] = rx_num_of_bits;

    // enables
 
    assign rx_ienable = (rx_master_enable == 1'd1) ? rx_menable : rx_enable;
    assign orx_ienable = (orx_master_enable == 1'd1) ? orx_menable : orx_enable;

    always @(negedge rx_resetn or posedge rx_clk) begin
        if (rx_resetn == 1'd0) begin
            rx_menable_out <= 1'd0;
            orx_menable_out <= 1'd0;
        end else begin
            if (rx_sync == 1'd1) begin
                rx_menable_out <= rx_enable;
            end
            if (orx_sync == 1'd1) begin
                orx_menable_out <= orx_enable;
            end
        end
    end

    always @(negedge rx_resetn or negedge rx_clk) begin
        if (rx_resetn == 1'd0) begin
            rx_menable_fall <= 1'd0;
            orx_menable_fall <= 1'd0;
        end else begin
            rx_menable_fall <= rx_menable_in;
            orx_menable_fall <= orx_menable_in;
        end
    end

    always @(negedge rx_resetn or posedge rx_clk) begin
        if (rx_resetn == 1'd0) begin
            rx_menable <= 1'd0;
            orx_menable <= 1'd0;
        end else begin
            rx_menable <= rx_menable_fall;
            orx_menable <= orx_menable_fall;
        end
    end

    // internal-data

    always @(negedge rx_resetn or posedge rx_clk) begin
        if (rx_resetn == 1'd0) begin
            rx_valid_int <= 1'd0;
            rx_data_int <= 64'd0;
        end else begin
            rx_valid_int <= rx_valid_bs;
            rx_data_int <= rx_data_bs;
        end
    end

    // lsb-msb swap
 
    always @(negedge rx_resetn or posedge rx_clk) begin
        if (rx_resetn == 1'd0) begin
            rx_valid_bs <= 1'd0;
            rx_data_bs <= 64'd0;
        end else begin
            rx_valid_bs <= rx_valid_iq;
            case ({rx_lsb1_msb0, rx_num_of_bits})
                4'b1101: begin
                    rx_data_bs[63] <= rx_data_iq[32];
                    rx_data_bs[62] <= rx_data_iq[33];
                    rx_data_bs[61] <= rx_data_iq[34];
                    rx_data_bs[60] <= rx_data_iq[35];
                    rx_data_bs[59] <= rx_data_iq[36];
                    rx_data_bs[58] <= rx_data_iq[37];
                    rx_data_bs[57] <= rx_data_iq[38];
                    rx_data_bs[56] <= rx_data_iq[39];
                    rx_data_bs[55] <= rx_data_iq[40];
                    rx_data_bs[54] <= rx_data_iq[41];
                    rx_data_bs[53] <= rx_data_iq[42];
                    rx_data_bs[52] <= rx_data_iq[43];
                    rx_data_bs[51] <= rx_data_iq[44];
                    rx_data_bs[50] <= rx_data_iq[45];
                    rx_data_bs[49] <= rx_data_iq[46];
                    rx_data_bs[48] <= rx_data_iq[47];
                    rx_data_bs[47] <= rx_data_iq[48];
                    rx_data_bs[46] <= rx_data_iq[49];
                    rx_data_bs[45] <= rx_data_iq[50];
                    rx_data_bs[44] <= rx_data_iq[51];
                    rx_data_bs[43] <= rx_data_iq[52];
                    rx_data_bs[42] <= rx_data_iq[53];
                    rx_data_bs[41] <= rx_data_iq[54];
                    rx_data_bs[40] <= rx_data_iq[55];
                    rx_data_bs[39] <= rx_data_iq[56];
                    rx_data_bs[38] <= rx_data_iq[57];
                    rx_data_bs[37] <= rx_data_iq[58];
                    rx_data_bs[36] <= rx_data_iq[59];
                    rx_data_bs[35] <= rx_data_iq[60];
                    rx_data_bs[34] <= rx_data_iq[61];
                    rx_data_bs[33] <= rx_data_iq[62];
                    rx_data_bs[32] <= rx_data_iq[63];
                    rx_data_bs[31] <= rx_data_iq[ 0];
                    rx_data_bs[30] <= rx_data_iq[ 1];
                    rx_data_bs[29] <= rx_data_iq[ 2];
                    rx_data_bs[28] <= rx_data_iq[ 3];
                    rx_data_bs[27] <= rx_data_iq[ 4];
                    rx_data_bs[26] <= rx_data_iq[ 5];
                    rx_data_bs[25] <= rx_data_iq[ 6];
                    rx_data_bs[24] <= rx_data_iq[ 7];
                    rx_data_bs[23] <= rx_data_iq[ 8];
                    rx_data_bs[22] <= rx_data_iq[ 9];
                    rx_data_bs[21] <= rx_data_iq[10];
                    rx_data_bs[20] <= rx_data_iq[11];
                    rx_data_bs[19] <= rx_data_iq[12];
                    rx_data_bs[18] <= rx_data_iq[13];
                    rx_data_bs[17] <= rx_data_iq[14];
                    rx_data_bs[16] <= rx_data_iq[15];
                    rx_data_bs[15] <= rx_data_iq[16];
                    rx_data_bs[14] <= rx_data_iq[17];
                    rx_data_bs[13] <= rx_data_iq[18];
                    rx_data_bs[12] <= rx_data_iq[19];
                    rx_data_bs[11] <= rx_data_iq[20];
                    rx_data_bs[10] <= rx_data_iq[21];
                    rx_data_bs[ 9] <= rx_data_iq[22];
                    rx_data_bs[ 8] <= rx_data_iq[23];
                    rx_data_bs[ 7] <= rx_data_iq[24];
                    rx_data_bs[ 6] <= rx_data_iq[25];
                    rx_data_bs[ 5] <= rx_data_iq[26];
                    rx_data_bs[ 4] <= rx_data_iq[27];
                    rx_data_bs[ 3] <= rx_data_iq[28];
                    rx_data_bs[ 2] <= rx_data_iq[29];
                    rx_data_bs[ 1] <= rx_data_iq[30];
                    rx_data_bs[ 0] <= rx_data_iq[31];
                end
                4'b1100: begin
                    rx_data_bs[63] <= rx_data_iq[48];
                    rx_data_bs[62] <= rx_data_iq[49];
                    rx_data_bs[61] <= rx_data_iq[50];
                    rx_data_bs[60] <= rx_data_iq[51];
                    rx_data_bs[59] <= rx_data_iq[52];
                    rx_data_bs[58] <= rx_data_iq[53];
                    rx_data_bs[57] <= rx_data_iq[54];
                    rx_data_bs[56] <= rx_data_iq[55];
                    rx_data_bs[55] <= rx_data_iq[56];
                    rx_data_bs[54] <= rx_data_iq[57];
                    rx_data_bs[53] <= rx_data_iq[58];
                    rx_data_bs[52] <= rx_data_iq[59];
                    rx_data_bs[51] <= rx_data_iq[60];
                    rx_data_bs[50] <= rx_data_iq[61];
                    rx_data_bs[49] <= rx_data_iq[62];
                    rx_data_bs[48] <= rx_data_iq[63];
                    rx_data_bs[47] <= rx_data_iq[32];
                    rx_data_bs[46] <= rx_data_iq[33];
                    rx_data_bs[45] <= rx_data_iq[34];
                    rx_data_bs[44] <= rx_data_iq[35];
                    rx_data_bs[43] <= rx_data_iq[36];
                    rx_data_bs[42] <= rx_data_iq[37];
                    rx_data_bs[41] <= rx_data_iq[38];
                    rx_data_bs[40] <= rx_data_iq[39];
                    rx_data_bs[39] <= rx_data_iq[40];
                    rx_data_bs[38] <= rx_data_iq[41];
                    rx_data_bs[37] <= rx_data_iq[42];
                    rx_data_bs[36] <= rx_data_iq[43];
                    rx_data_bs[35] <= rx_data_iq[44];
                    rx_data_bs[34] <= rx_data_iq[45];
                    rx_data_bs[33] <= rx_data_iq[46];
                    rx_data_bs[32] <= rx_data_iq[47];
                    rx_data_bs[31] <= rx_data_iq[16];
                    rx_data_bs[30] <= rx_data_iq[17];
                    rx_data_bs[29] <= rx_data_iq[18];
                    rx_data_bs[28] <= rx_data_iq[19];
                    rx_data_bs[27] <= rx_data_iq[20];
                    rx_data_bs[26] <= rx_data_iq[21];
                    rx_data_bs[25] <= rx_data_iq[22];
                    rx_data_bs[24] <= rx_data_iq[23];
                    rx_data_bs[23] <= rx_data_iq[24];
                    rx_data_bs[22] <= rx_data_iq[25];
                    rx_data_bs[21] <= rx_data_iq[26];
                    rx_data_bs[20] <= rx_data_iq[27];
                    rx_data_bs[19] <= rx_data_iq[28];
                    rx_data_bs[18] <= rx_data_iq[29];
                    rx_data_bs[17] <= rx_data_iq[30];
                    rx_data_bs[16] <= rx_data_iq[31];
                    rx_data_bs[15] <= rx_data_iq[ 0];
                    rx_data_bs[14] <= rx_data_iq[ 1];
                    rx_data_bs[13] <= rx_data_iq[ 2];
                    rx_data_bs[12] <= rx_data_iq[ 3];
                    rx_data_bs[11] <= rx_data_iq[ 4];
                    rx_data_bs[10] <= rx_data_iq[ 5];
                    rx_data_bs[ 9] <= rx_data_iq[ 6];
                    rx_data_bs[ 8] <= rx_data_iq[ 7];
                    rx_data_bs[ 7] <= rx_data_iq[ 8];
                    rx_data_bs[ 6] <= rx_data_iq[ 9];
                    rx_data_bs[ 5] <= rx_data_iq[10];
                    rx_data_bs[ 4] <= rx_data_iq[11];
                    rx_data_bs[ 3] <= rx_data_iq[12];
                    rx_data_bs[ 2] <= rx_data_iq[13];
                    rx_data_bs[ 1] <= rx_data_iq[14];
                    rx_data_bs[ 0] <= rx_data_iq[15];
                end
                4'b1011: begin
                    rx_data_bs[63] <= rx_data_iq[63];
                    rx_data_bs[62] <= rx_data_iq[62];
                    rx_data_bs[61] <= rx_data_iq[61];
                    rx_data_bs[60] <= rx_data_iq[60];
                    rx_data_bs[59] <= rx_data_iq[48];
                    rx_data_bs[58] <= rx_data_iq[49];
                    rx_data_bs[57] <= rx_data_iq[50];
                    rx_data_bs[56] <= rx_data_iq[51];
                    rx_data_bs[55] <= rx_data_iq[52];
                    rx_data_bs[54] <= rx_data_iq[53];
                    rx_data_bs[53] <= rx_data_iq[54];
                    rx_data_bs[52] <= rx_data_iq[55];
                    rx_data_bs[51] <= rx_data_iq[56];
                    rx_data_bs[50] <= rx_data_iq[57];
                    rx_data_bs[49] <= rx_data_iq[58];
                    rx_data_bs[48] <= rx_data_iq[59];
                    rx_data_bs[47] <= rx_data_iq[47];
                    rx_data_bs[46] <= rx_data_iq[46];
                    rx_data_bs[45] <= rx_data_iq[45];
                    rx_data_bs[44] <= rx_data_iq[44];
                    rx_data_bs[43] <= rx_data_iq[32];
                    rx_data_bs[42] <= rx_data_iq[33];
                    rx_data_bs[41] <= rx_data_iq[34];
                    rx_data_bs[40] <= rx_data_iq[35];
                    rx_data_bs[39] <= rx_data_iq[36];
                    rx_data_bs[38] <= rx_data_iq[37];
                    rx_data_bs[37] <= rx_data_iq[38];
                    rx_data_bs[36] <= rx_data_iq[39];
                    rx_data_bs[35] <= rx_data_iq[40];
                    rx_data_bs[34] <= rx_data_iq[41];
                    rx_data_bs[33] <= rx_data_iq[42];
                    rx_data_bs[32] <= rx_data_iq[43];
                    rx_data_bs[31] <= rx_data_iq[31];
                    rx_data_bs[30] <= rx_data_iq[30];
                    rx_data_bs[29] <= rx_data_iq[29];
                    rx_data_bs[28] <= rx_data_iq[28];
                    rx_data_bs[27] <= rx_data_iq[16];
                    rx_data_bs[26] <= rx_data_iq[17];
                    rx_data_bs[25] <= rx_data_iq[18];
                    rx_data_bs[24] <= rx_data_iq[19];
                    rx_data_bs[23] <= rx_data_iq[20];
                    rx_data_bs[22] <= rx_data_iq[21];
                    rx_data_bs[21] <= rx_data_iq[22];
                    rx_data_bs[20] <= rx_data_iq[23];
                    rx_data_bs[19] <= rx_data_iq[24];
                    rx_data_bs[18] <= rx_data_iq[25];
                    rx_data_bs[17] <= rx_data_iq[26];
                    rx_data_bs[16] <= rx_data_iq[27];
                    rx_data_bs[15] <= rx_data_iq[15];
                    rx_data_bs[14] <= rx_data_iq[14];
                    rx_data_bs[13] <= rx_data_iq[13];
                    rx_data_bs[12] <= rx_data_iq[12];
                    rx_data_bs[11] <= rx_data_iq[ 0];
                    rx_data_bs[10] <= rx_data_iq[ 1];
                    rx_data_bs[ 9] <= rx_data_iq[ 2];
                    rx_data_bs[ 8] <= rx_data_iq[ 3];
                    rx_data_bs[ 7] <= rx_data_iq[ 4];
                    rx_data_bs[ 6] <= rx_data_iq[ 5];
                    rx_data_bs[ 5] <= rx_data_iq[ 6];
                    rx_data_bs[ 4] <= rx_data_iq[ 7];
                    rx_data_bs[ 3] <= rx_data_iq[ 8];
                    rx_data_bs[ 2] <= rx_data_iq[ 9];
                    rx_data_bs[ 1] <= rx_data_iq[10];
                    rx_data_bs[ 0] <= rx_data_iq[11];
                end
                4'b1010: begin
                    rx_data_bs[63] <= rx_data_iq[48];
                    rx_data_bs[62] <= rx_data_iq[49];
                    rx_data_bs[61] <= rx_data_iq[50];
                    rx_data_bs[60] <= rx_data_iq[51];
                    rx_data_bs[59] <= rx_data_iq[52];
                    rx_data_bs[58] <= rx_data_iq[53];
                    rx_data_bs[57] <= rx_data_iq[54];
                    rx_data_bs[56] <= rx_data_iq[55];
                    rx_data_bs[55] <= rx_data_iq[56];
                    rx_data_bs[54] <= rx_data_iq[57];
                    rx_data_bs[53] <= rx_data_iq[58];
                    rx_data_bs[52] <= rx_data_iq[59];
                    rx_data_bs[51] <= rx_data_iq[60];
                    rx_data_bs[50] <= rx_data_iq[61];
                    rx_data_bs[49] <= rx_data_iq[62];
                    rx_data_bs[48] <= rx_data_iq[63];
                    rx_data_bs[47] <= rx_data_iq[32];
                    rx_data_bs[46] <= rx_data_iq[33];
                    rx_data_bs[45] <= rx_data_iq[34];
                    rx_data_bs[44] <= rx_data_iq[35];
                    rx_data_bs[43] <= rx_data_iq[36];
                    rx_data_bs[42] <= rx_data_iq[37];
                    rx_data_bs[41] <= rx_data_iq[38];
                    rx_data_bs[40] <= rx_data_iq[39];
                    rx_data_bs[39] <= rx_data_iq[40];
                    rx_data_bs[38] <= rx_data_iq[41];
                    rx_data_bs[37] <= rx_data_iq[42];
                    rx_data_bs[36] <= rx_data_iq[43];
                    rx_data_bs[35] <= rx_data_iq[44];
                    rx_data_bs[34] <= rx_data_iq[45];
                    rx_data_bs[33] <= rx_data_iq[46];
                    rx_data_bs[32] <= rx_data_iq[47];
                    rx_data_bs[31] <= rx_data_iq[16];
                    rx_data_bs[30] <= rx_data_iq[17];
                    rx_data_bs[29] <= rx_data_iq[18];
                    rx_data_bs[28] <= rx_data_iq[19];
                    rx_data_bs[27] <= rx_data_iq[20];
                    rx_data_bs[26] <= rx_data_iq[21];
                    rx_data_bs[25] <= rx_data_iq[22];
                    rx_data_bs[24] <= rx_data_iq[23];
                    rx_data_bs[23] <= rx_data_iq[24];
                    rx_data_bs[22] <= rx_data_iq[25];
                    rx_data_bs[21] <= rx_data_iq[26];
                    rx_data_bs[20] <= rx_data_iq[27];
                    rx_data_bs[19] <= rx_data_iq[28];
                    rx_data_bs[18] <= rx_data_iq[29];
                    rx_data_bs[17] <= rx_data_iq[30];
                    rx_data_bs[16] <= rx_data_iq[31];
                    rx_data_bs[15] <= rx_data_iq[ 0];
                    rx_data_bs[14] <= rx_data_iq[ 1];
                    rx_data_bs[13] <= rx_data_iq[ 2];
                    rx_data_bs[12] <= rx_data_iq[ 3];
                    rx_data_bs[11] <= rx_data_iq[ 4];
                    rx_data_bs[10] <= rx_data_iq[ 5];
                    rx_data_bs[ 9] <= rx_data_iq[ 6];
                    rx_data_bs[ 8] <= rx_data_iq[ 7];
                    rx_data_bs[ 7] <= rx_data_iq[ 8];
                    rx_data_bs[ 6] <= rx_data_iq[ 9];
                    rx_data_bs[ 5] <= rx_data_iq[10];
                    rx_data_bs[ 4] <= rx_data_iq[11];
                    rx_data_bs[ 3] <= rx_data_iq[12];
                    rx_data_bs[ 2] <= rx_data_iq[13];
                    rx_data_bs[ 1] <= rx_data_iq[14];
                    rx_data_bs[ 0] <= rx_data_iq[15];
                end
                4'b1001: begin
                    rx_data_bs[63] <= rx_data_iq[56];
                    rx_data_bs[62] <= rx_data_iq[57];
                    rx_data_bs[61] <= rx_data_iq[58];
                    rx_data_bs[60] <= rx_data_iq[59];
                    rx_data_bs[59] <= rx_data_iq[60];
                    rx_data_bs[58] <= rx_data_iq[61];
                    rx_data_bs[57] <= rx_data_iq[62];
                    rx_data_bs[56] <= rx_data_iq[63];
                    rx_data_bs[55] <= rx_data_iq[48];
                    rx_data_bs[54] <= rx_data_iq[49];
                    rx_data_bs[53] <= rx_data_iq[50];
                    rx_data_bs[52] <= rx_data_iq[51];
                    rx_data_bs[51] <= rx_data_iq[52];
                    rx_data_bs[50] <= rx_data_iq[53];
                    rx_data_bs[49] <= rx_data_iq[54];
                    rx_data_bs[48] <= rx_data_iq[55];
                    rx_data_bs[47] <= rx_data_iq[40];
                    rx_data_bs[46] <= rx_data_iq[41];
                    rx_data_bs[45] <= rx_data_iq[42];
                    rx_data_bs[44] <= rx_data_iq[43];
                    rx_data_bs[43] <= rx_data_iq[44];
                    rx_data_bs[42] <= rx_data_iq[45];
                    rx_data_bs[41] <= rx_data_iq[46];
                    rx_data_bs[40] <= rx_data_iq[47];
                    rx_data_bs[39] <= rx_data_iq[32];
                    rx_data_bs[38] <= rx_data_iq[33];
                    rx_data_bs[37] <= rx_data_iq[34];
                    rx_data_bs[36] <= rx_data_iq[35];
                    rx_data_bs[35] <= rx_data_iq[36];
                    rx_data_bs[34] <= rx_data_iq[37];
                    rx_data_bs[33] <= rx_data_iq[38];
                    rx_data_bs[32] <= rx_data_iq[39];
                    rx_data_bs[31] <= rx_data_iq[24];
                    rx_data_bs[30] <= rx_data_iq[25];
                    rx_data_bs[29] <= rx_data_iq[26];
                    rx_data_bs[28] <= rx_data_iq[27];
                    rx_data_bs[27] <= rx_data_iq[28];
                    rx_data_bs[26] <= rx_data_iq[29];
                    rx_data_bs[25] <= rx_data_iq[30];
                    rx_data_bs[24] <= rx_data_iq[31];
                    rx_data_bs[23] <= rx_data_iq[16];
                    rx_data_bs[22] <= rx_data_iq[17];
                    rx_data_bs[21] <= rx_data_iq[18];
                    rx_data_bs[20] <= rx_data_iq[19];
                    rx_data_bs[19] <= rx_data_iq[20];
                    rx_data_bs[18] <= rx_data_iq[21];
                    rx_data_bs[17] <= rx_data_iq[22];
                    rx_data_bs[16] <= rx_data_iq[23];
                    rx_data_bs[15] <= rx_data_iq[ 8];
                    rx_data_bs[14] <= rx_data_iq[ 9];
                    rx_data_bs[13] <= rx_data_iq[10];
                    rx_data_bs[12] <= rx_data_iq[11];
                    rx_data_bs[11] <= rx_data_iq[12];
                    rx_data_bs[10] <= rx_data_iq[13];
                    rx_data_bs[ 9] <= rx_data_iq[14];
                    rx_data_bs[ 8] <= rx_data_iq[15];
                    rx_data_bs[ 7] <= rx_data_iq[ 0];
                    rx_data_bs[ 6] <= rx_data_iq[ 1];
                    rx_data_bs[ 5] <= rx_data_iq[ 2];
                    rx_data_bs[ 4] <= rx_data_iq[ 3];
                    rx_data_bs[ 3] <= rx_data_iq[ 4];
                    rx_data_bs[ 2] <= rx_data_iq[ 5];
                    rx_data_bs[ 1] <= rx_data_iq[ 6];
                    rx_data_bs[ 0] <= rx_data_iq[ 7];
                end
                4'b1000: begin
                    rx_data_bs[63] <= rx_data_iq[63];
                    rx_data_bs[62] <= rx_data_iq[62];
                    rx_data_bs[61] <= rx_data_iq[61];
                    rx_data_bs[60] <= rx_data_iq[60];
                    rx_data_bs[59] <= rx_data_iq[59];
                    rx_data_bs[58] <= rx_data_iq[58];
                    rx_data_bs[57] <= rx_data_iq[56];
                    rx_data_bs[56] <= rx_data_iq[57];
                    rx_data_bs[55] <= rx_data_iq[55];
                    rx_data_bs[54] <= rx_data_iq[54];
                    rx_data_bs[53] <= rx_data_iq[53];
                    rx_data_bs[52] <= rx_data_iq[52];
                    rx_data_bs[51] <= rx_data_iq[51];
                    rx_data_bs[50] <= rx_data_iq[50];
                    rx_data_bs[49] <= rx_data_iq[48];
                    rx_data_bs[48] <= rx_data_iq[49];
                    rx_data_bs[47] <= rx_data_iq[47];
                    rx_data_bs[46] <= rx_data_iq[46];
                    rx_data_bs[45] <= rx_data_iq[45];
                    rx_data_bs[44] <= rx_data_iq[44];
                    rx_data_bs[43] <= rx_data_iq[43];
                    rx_data_bs[42] <= rx_data_iq[42];
                    rx_data_bs[41] <= rx_data_iq[40];
                    rx_data_bs[40] <= rx_data_iq[41];
                    rx_data_bs[39] <= rx_data_iq[39];
                    rx_data_bs[38] <= rx_data_iq[38];
                    rx_data_bs[37] <= rx_data_iq[37];
                    rx_data_bs[36] <= rx_data_iq[36];
                    rx_data_bs[35] <= rx_data_iq[35];
                    rx_data_bs[34] <= rx_data_iq[34];
                    rx_data_bs[33] <= rx_data_iq[32];
                    rx_data_bs[32] <= rx_data_iq[33];
                    rx_data_bs[31] <= rx_data_iq[31];
                    rx_data_bs[30] <= rx_data_iq[30];
                    rx_data_bs[29] <= rx_data_iq[29];
                    rx_data_bs[28] <= rx_data_iq[28];
                    rx_data_bs[27] <= rx_data_iq[27];
                    rx_data_bs[26] <= rx_data_iq[26];
                    rx_data_bs[25] <= rx_data_iq[24];
                    rx_data_bs[24] <= rx_data_iq[25];
                    rx_data_bs[23] <= rx_data_iq[23];
                    rx_data_bs[22] <= rx_data_iq[22];
                    rx_data_bs[21] <= rx_data_iq[21];
                    rx_data_bs[20] <= rx_data_iq[20];
                    rx_data_bs[19] <= rx_data_iq[19];
                    rx_data_bs[18] <= rx_data_iq[18];
                    rx_data_bs[17] <= rx_data_iq[16];
                    rx_data_bs[16] <= rx_data_iq[17];
                    rx_data_bs[15] <= rx_data_iq[15];
                    rx_data_bs[14] <= rx_data_iq[14];
                    rx_data_bs[13] <= rx_data_iq[13];
                    rx_data_bs[12] <= rx_data_iq[12];
                    rx_data_bs[11] <= rx_data_iq[11];
                    rx_data_bs[10] <= rx_data_iq[10];
                    rx_data_bs[ 9] <= rx_data_iq[ 8];
                    rx_data_bs[ 8] <= rx_data_iq[ 9];
                    rx_data_bs[ 7] <= rx_data_iq[ 7];
                    rx_data_bs[ 6] <= rx_data_iq[ 6];
                    rx_data_bs[ 5] <= rx_data_iq[ 5];
                    rx_data_bs[ 4] <= rx_data_iq[ 4];
                    rx_data_bs[ 3] <= rx_data_iq[ 3];
                    rx_data_bs[ 2] <= rx_data_iq[ 2];
                    rx_data_bs[ 1] <= rx_data_iq[ 0];
                    rx_data_bs[ 0] <= rx_data_iq[ 1];
                end
                default: begin
                    rx_data_bs <= rx_data_iq;
                end
            endcase
        end
    end

    // iq swap

    always @(negedge rx_resetn or posedge rx_clk) begin
        if (rx_resetn == 1'd0) begin
            rx_valid_iq <= 1'd0;
            rx_data_iq <= 64'd0;
        end else begin
            rx_valid_iq <= rx_valid_64;
            case ({rx_q1_i0, rx_num_of_bits})
                4'b1100, 4'b1011: rx_data_iq <= {rx_data_64[48:32], rx_data_64[63:47],
                    rx_data_64[15:0], rx_data_64[31:16]};
                4'b1101: rx_data_iq <= {rx_data_64[31:0], rx_data_64[63:32]};
                default: rx_data_iq <= rx_data_64;
            endcase
        end
    end

    // delineation error counter and oos

    always @(negedge rx_resetn or posedge rx_clk) begin
        if (rx_resetn == 1'b0) begin
            rx_frm_oos_cnt <= 2'd0;
            rx_frm_oos <= 1'b1;
        end else begin
            if ((rx_frm_oos ^ rx_frm_err) == 1'b1) begin
                rx_frm_oos_cnt <= rx_frm_oos_cnt + 1'b1;
            end else begin
                rx_frm_oos_cnt <= 'd0;
            end
            if (rx_frm_oos_cnt >= 2'd3) begin
                rx_frm_oos <= rx_frm_err;
            end
        end
    end

    // de-framed data
 
    always @(negedge rx_resetn or posedge rx_clk) begin
        if (rx_resetn == 1'b0) begin
            rx_frm_err <= 1'd1;
            rx_mcnt64 <= 3'd0;
            rx_valid_64 <= 1'd0;
            rx_data_64 <= 32'd0;
        end else begin
            case (rx_mode)
                CMOS_4L_PS_64X1, CMOS_4L_LS_64X1: begin
                    rx_frm_err <= rx_serr_4p64;
                    rx_mcnt64 <= 3'd0;
                    rx_valid_64 <= rx_svalid_4p64;
                    rx_data_64 <= rx_sdata_4p64;
                end
                LVDS_2L_PS_64X1, LVDS_2L_LS_64X1: begin
                    rx_frm_err <= rx_serr_2p64;
                    rx_mcnt64 <= 3'd0;
                    rx_valid_64 <= rx_svalid_2p64;
                    rx_data_64 <= rx_sdata_2p64;
                end
                LVDS_1L_PS_64X1, CMOS_1L_PS_64X1, LVDS_1L_LS_64X1, CMOS_1L_LS_64X1: begin
                    rx_frm_err <= rx_serr_1p64;
                    rx_mcnt64 <= 3'd0;
                    rx_valid_64 <= rx_svalid_1p64;
                    rx_data_64 <= rx_sdata_1p64;
                end
                CMOS_4L_PS_32X1, CMOS_4L_LS_32X1: begin
                    rx_frm_err <= rx_serr_4p32;
                    if (rx_svalid_4p32 == 1'd1) begin
                        rx_mcnt64 <= rx_mcnt64 + 1'd1;
                    end
                    rx_valid_64 <= rx_mcnt64[0] & rx_svalid_4p32;
                    if ((rx_svalid_4p32 == 1'd1) && (rx_mcnt64[0] == 1'd1)) begin
                        rx_data_64[63:32] <= rx_sdata_4p32;
                    end
                    if ((rx_svalid_4p32 == 1'd1) && (rx_mcnt64[0] == 1'd0)) begin
                        rx_data_64[31: 0] <= rx_sdata_4p32;
                    end
                end
                LVDS_2L_PS_32X1, LVDS_2L_LS_32X1: begin
                    rx_frm_err <= rx_serr_2p32;
                    if (rx_svalid_2p32 == 1'd1) begin
                        rx_mcnt64 <= rx_mcnt64 + 1'd1;
                    end
                    rx_valid_64 <= rx_mcnt64[0] & rx_svalid_2p32;
                    if ((rx_svalid_2p32 == 1'd1) && (rx_mcnt64[0] == 1'd1)) begin
                        rx_data_64[63:32] <= rx_sdata_2p32;
                    end
                    if ((rx_svalid_2p32 == 1'd1) && (rx_mcnt64[0] == 1'd0)) begin
                        rx_data_64[31: 0] <= rx_sdata_2p32;
                    end
                end
                LVDS_1L_PS_32X1, CMOS_1L_PS_32X1, LVDS_1L_LS_32X1, CMOS_1L_LS_32X1: begin
                    rx_frm_err <= rx_serr_1p32;
                    if (rx_svalid_1p32 == 1'd1) begin
                        rx_mcnt64 <= rx_mcnt64 + 1'd1;
                    end
                    rx_valid_64 <= rx_mcnt64[0] & rx_svalid_1p32;
                    if ((rx_svalid_1p32 == 1'd1) && (rx_mcnt64[0] == 1'd1)) begin
                        rx_data_64[63:32] <= rx_sdata_1p32;
                    end
                    if ((rx_svalid_1p32 == 1'd1) && (rx_mcnt64[0] == 1'd0)) begin
                        rx_data_64[31: 0] <= rx_sdata_1p32;
                    end
                end
                LVDS_2L_PS_24X1, LVDS_2L_LS_24X1: begin
                    rx_frm_err <= rx_serr_2p24;
                    if (rx_svalid_2p24 == 1'd1) begin
                        rx_mcnt64 <= rx_mcnt64 + 1'd1;
                    end
                    rx_valid_64 <= rx_mcnt64[0] & rx_svalid_2p24;
                    if ((rx_svalid_2p24 == 1'd1) && (rx_mcnt64[0] == 1'd1)) begin
                        rx_data_64[63:48] <= {4'd0, rx_sdata_2p24[23:12]};
                        rx_data_64[47:32] <= {4'd0, rx_sdata_2p24[11: 0]};
                    end
                    if ((rx_svalid_2p24 == 1'd1) && (rx_mcnt64[0] == 1'd0)) begin
                        rx_data_64[31:16] <= {4'd0, rx_sdata_2p24[23:12]};
                        rx_data_64[15: 0] <= {4'd0, rx_sdata_2p24[11: 0]};
                    end
                end
                LVDS_1L_PS_24X1, LVDS_1L_LS_24X1: begin
                    rx_frm_err <= rx_serr_1p24;
                    if (rx_svalid_1p24 == 1'd1) begin
                        rx_mcnt64 <= rx_mcnt64 + 1'd1;
                    end
                    rx_valid_64 <= rx_mcnt64[0] & rx_svalid_1p24;
                    if ((rx_svalid_1p24 == 1'd1) && (rx_mcnt64[0] == 1'd1)) begin
                        rx_data_64[63:48] <= {4'd0, rx_sdata_1p24[23:12]};
                        rx_data_64[47:32] <= {4'd0, rx_sdata_1p24[11: 0]};
                    end
                    if ((rx_svalid_1p24 == 1'd1) && (rx_mcnt64[0] == 1'd0)) begin
                        rx_data_64[31:16] <= {4'd0, rx_sdata_1p24[23:12]};
                        rx_data_64[15: 0] <= {4'd0, rx_sdata_1p24[11: 0]};
                    end
                end
                CMOS_1L_PS_16X1, CMOS_1L_LS_16X1: begin
                    rx_frm_err <= rx_serr_1p16;
                    if (rx_svalid_1p16 == 1'd1) begin
                        rx_mcnt64 <= rx_mcnt64 + 1'd1;
                    end
                    rx_valid_64 <= (rx_mcnt64[1:0] == 2'd3) ? rx_svalid_1p16 : 1'd0;
                    if ((rx_svalid_1p16 == 1'd1) && (rx_mcnt64[1:0] == 2'd3)) begin
                        rx_data_64[63:48] <= rx_sdata_1p16;
                    end
                    if ((rx_svalid_1p16 == 1'd1) && (rx_mcnt64[1:0] == 2'd2)) begin
                        rx_data_64[47:32] <= rx_sdata_1p16;
                    end
                    if ((rx_svalid_1p16 == 1'd1) && (rx_mcnt64[1:0] == 2'd1)) begin
                        rx_data_64[31:16] <= rx_sdata_1p16;
                    end
                    if ((rx_svalid_1p16 == 1'd1) && (rx_mcnt64[1:0] == 2'd0)) begin
                        rx_data_64[15: 0] <= rx_sdata_1p16;
                    end
                end
                CMOS_1L_PS_08X1, CMOS_1L_LS_08X1: begin
                    rx_frm_err <= rx_serr_1p08;
                    if (rx_svalid_1p08 == 1'd1) begin
                        rx_mcnt64 <= rx_mcnt64 + 1'd1;
                    end
                    rx_valid_64 <= (rx_mcnt64[2:0] == 3'd7) ? rx_svalid_1p08 : 1'd0;
                    if ((rx_svalid_1p08 == 1'd1) && (rx_mcnt64[2:0] == 3'd7)) begin
                        rx_data_64[63:56] <= rx_sdata_1p08;
                    end
                    if ((rx_svalid_1p08 == 1'd1) && (rx_mcnt64[2:0] == 3'd6)) begin
                        rx_data_64[55:48] <= rx_sdata_1p08;
                    end
                    if ((rx_svalid_1p08 == 1'd1) && (rx_mcnt64[2:0] == 3'd5)) begin
                        rx_data_64[47:40] <= rx_sdata_1p08;
                    end
                    if ((rx_svalid_1p08 == 1'd1) && (rx_mcnt64[2:0] == 3'd4)) begin
                        rx_data_64[39:32] <= rx_sdata_1p08;
                    end
                    if ((rx_svalid_1p08 == 1'd1) && (rx_mcnt64[2:0] == 3'd3)) begin
                        rx_data_64[31:24] <= rx_sdata_1p08;
                    end
                    if ((rx_svalid_1p08 == 1'd1) && (rx_mcnt64[2:0] == 3'd2)) begin
                        rx_data_64[23:16] <= rx_sdata_1p08;
                    end
                    if ((rx_svalid_1p08 == 1'd1) && (rx_mcnt64[2:0] == 3'd1)) begin
                        rx_data_64[15: 8] <= rx_sdata_1p08;
                    end
                    if ((rx_svalid_1p08 == 1'd1) && (rx_mcnt64[2:0] == 3'd0)) begin
                        rx_data_64[ 7: 0] <= rx_sdata_1p08;
                    end
                end
                CMOS_1L_PS_02X1, CMOS_1L_LS_02X1: begin
                    rx_frm_err <= rx_serr_1p02;
                    if (rx_svalid_1p02 == 1'd1) begin
                        rx_mcnt64 <= rx_mcnt64 + 1'd1;
                    end
                    rx_valid_64 <= rx_mcnt64[0] & rx_svalid_1p02;
                    if ((rx_svalid_1p02 == 1'd1) && (rx_mcnt64[0] == 1'd1)) begin
                        rx_data_64[63:56] <= {6'd0, rx_sdata_1p02[7:6]};
                    end
                    if ((rx_svalid_1p02 == 1'd1) && (rx_mcnt64[0] == 1'd1)) begin
                        rx_data_64[55:48] <= {6'd0, rx_sdata_1p02[5:4]};
                    end
                    if ((rx_svalid_1p02 == 1'd1) && (rx_mcnt64[0] == 1'd1)) begin
                        rx_data_64[47:40] <= {6'd0, rx_sdata_1p02[3:2]};
                    end
                    if ((rx_svalid_1p02 == 1'd1) && (rx_mcnt64[0] == 1'd1)) begin
                        rx_data_64[39:32] <= {6'd0, rx_sdata_1p02[1:0]};
                    end
                    if ((rx_svalid_1p02 == 1'd1) && (rx_mcnt64[0] == 1'd0)) begin
                        rx_data_64[31:24] <= {6'd0, rx_sdata_1p02[7:6]};
                    end
                    if ((rx_svalid_1p02 == 1'd1) && (rx_mcnt64[0] == 1'd0)) begin
                        rx_data_64[23:16] <= {6'd0, rx_sdata_1p02[5:4]};
                    end
                    if ((rx_svalid_1p02 == 1'd1) && (rx_mcnt64[0] == 1'd0)) begin
                        rx_data_64[15: 8] <= {6'd0, rx_sdata_1p02[3:2]};
                    end
                    if ((rx_svalid_1p02 == 1'd1) && (rx_mcnt64[0] == 1'd0)) begin
                        rx_data_64[ 7: 0] <= {6'd0, rx_sdata_1p02[1:0]};
                    end
                end
                default: begin
                    rx_frm_err <= 1'd1;
                    rx_mcnt64 <= 3'd0;
                    rx_valid_64 <= 1'd0;
                    rx_data_64 <= 32'd0;
                end
            endcase
        end
    end

    // mode: CMOS_4L_PS_64X1, CMOS_4L_LS_64X1

    always @(negedge rx_resetn or posedge rx_clk) begin
        if (rx_resetn == 1'd0) begin
            rx_svalid_4p64 <= 1'd0;
            rx_serr_4p64 <= 1'd1;
            rx_scnt_4p64 <= 1'd0;
            rx_sdata_4p64 <= 64'd0;
        end else begin
            if (rx_bvalid == 1'd0) begin
                rx_svalid_4p64 <= 1'd0;
                rx_serr_4p64 <= rx_serr_4p64;
                rx_scnt_4p64 <= rx_scnt_4p64;
                rx_sdata_4p64 <= rx_sdata_4p64;
            end else if (rx_scnt_4p64 == 1'd0) begin
                rx_svalid_4p64 <= 1'd0;
                if (((rx_lstrb1_pstrb0 == 1'd0) && (rx_bstrobe == 8'h80)) ||
                    ((rx_lstrb1_pstrb0 == 1'd1) && (rx_bstrobe == 8'hff))) begin
                    rx_serr_4p64 <= 1'd0;
                end else if (rx_bstrobe != 8'h00) begin
                    rx_serr_4p64 <= 1'd1;
                end
                if (((rx_lstrb1_pstrb0 == 1'd0) && (rx_bstrobe == 8'h80)) ||
                    ((rx_lstrb1_pstrb0 == 1'd1) && (rx_bstrobe == 8'hff))) begin
                    rx_scnt_4p64 <= 1'd1;
                end
                rx_sdata_4p64[63:48] <= {rx_bdata_1, 8'd0};
                rx_sdata_4p64[47:32] <= {rx_bdata_0, 8'd0};
                rx_sdata_4p64[31:16] <= {rx_bdata_3, 8'd0};
                rx_sdata_4p64[15: 0] <= {rx_bdata_2, 8'd0};
            end else begin
                rx_svalid_4p64 <= (rx_bstrobe == 8'h00) ? 1'd1 : 1'd0;
                rx_serr_4p64 <= (rx_bstrobe == 8'h00) ? 1'd0 : 1'd1;
                rx_scnt_4p64 <= 1'd0;
                rx_sdata_4p64[63:48] <= {rx_sdata_4p64[63:56], rx_bdata_1};
                rx_sdata_4p64[47:32] <= {rx_sdata_4p64[47:40], rx_bdata_0};
                rx_sdata_4p64[31:16] <= {rx_sdata_4p64[31:24], rx_bdata_3};
                rx_sdata_4p64[15: 0] <= {rx_sdata_4p64[15: 8], rx_bdata_2};
            end
        end
    end

    // mode: LVDS_2L_PS_64X1, LVDS_2L_LS_64X1
 
    always @(negedge rx_resetn or posedge rx_clk) begin
        if (rx_resetn == 1'd0) begin
            rx_svalid_2p64 <= 1'd0;
            rx_serr_2p64 <= 1'd1;
            rx_scnt_2p64 <= 2'd0;
            rx_sdata_2p64 <= 64'd0;
        end else begin
            if (rx_bvalid == 1'd0) begin
                rx_svalid_2p64 <= 1'd0;
                rx_serr_2p64 <= rx_serr_2p64;
                rx_scnt_2p64 <= rx_scnt_2p64;
                rx_sdata_2p64 <= rx_sdata_2p64;
            end else begin
                case (rx_scnt_2p64)
                    2'd0: begin
                        rx_svalid_2p64 <= 1'd0;
                        if (((rx_lstrb1_pstrb0 == 1'd0) && (rx_bstrobe == 8'h80)) ||
                            ((rx_lstrb1_pstrb0 == 1'd1) && (rx_bstrobe == 8'hff))) begin
                            rx_serr_2p64 <= 1'd0;
                        end else if (rx_bstrobe != 8'h00) begin
                            rx_serr_2p64 <= 1'd1;
                        end
                        if (((rx_lstrb1_pstrb0 == 1'd0) && (rx_bstrobe == 8'h80)) ||
                            ((rx_lstrb1_pstrb0 == 1'd1) && (rx_bstrobe == 8'hff))) begin
                            rx_scnt_2p64 <= 2'd1;
                        end
                        rx_sdata_2p64[63:32] <= {rx_bdata_0, 24'd0};
                        rx_sdata_2p64[31: 0] <= {rx_bdata_1, 24'd0};
                    end
                    2'd1: begin
                        rx_svalid_2p64 <= 1'd0;
                        rx_serr_2p64 <= (((rx_lstrb1_pstrb0 == 1'd0) && (rx_bstrobe == 8'h00)) ||
                            ((rx_lstrb1_pstrb0 == 1'd1) && (rx_bstrobe == 8'hff))) ? 1'b0 : 1'b1;
                        if (((rx_lstrb1_pstrb0 == 1'd0) && (rx_bstrobe == 8'h00)) ||
                            ((rx_lstrb1_pstrb0 == 1'd1) && (rx_bstrobe == 8'hff))) begin
                            rx_scnt_2p64 <= 2'd2;
                        end else begin
                            rx_scnt_2p64 <= 2'd0;
                        end
                        rx_sdata_2p64[63:32] <= {rx_sdata_2p64[63:56], rx_bdata_0, 16'd0};
                        rx_sdata_2p64[31: 0] <= {rx_sdata_2p64[31:24], rx_bdata_1, 16'd0};
                    end
                    2'd2: begin
                        rx_svalid_2p64 <= 1'd0;
                        rx_serr_2p64 <= (rx_bstrobe == 8'h00) ? 1'b0 : 1'b1;
                        if (rx_bstrobe == 8'h00) begin
                            rx_scnt_2p64 <= 2'd3;
                        end else begin
                            rx_scnt_2p64 <= 2'd0;
                        end
                        rx_sdata_2p64[63:32] <= {rx_sdata_2p64[63:48], rx_bdata_0, 8'd0};
                        rx_sdata_2p64[31: 0] <= {rx_sdata_2p64[31:16], rx_bdata_1, 8'd0};
                    end
                    default: begin
                        rx_svalid_2p64 <= (rx_bstrobe == 8'h00) ? 1'b1 : 1'b0;
                        rx_serr_2p64 <= (rx_bstrobe == 8'h00) ? 1'b0 : 1'b1;
                        rx_scnt_2p64 <= 2'd0;
                        rx_sdata_2p64[63:32] <= {rx_sdata_2p64[63:40], rx_bdata_0};
                        rx_sdata_2p64[31: 0] <= {rx_sdata_2p64[31: 8], rx_bdata_1};
                    end
                endcase
            end
        end
    end

    // mode: CMOS_1L_PS_64X1, LVDS_1L_PS_64X1, CMOS_1L_LS_64X1, LVDS_1L_LS_64X1

    always @(negedge rx_resetn or posedge rx_clk) begin
        if (rx_resetn == 1'd0) begin
            rx_svalid_1p64 <= 1'd0;
            rx_serr_1p64 <= 1'd1;
            rx_scnt_1p64 <= 3'd0;
            rx_sdata_1p64 <= 64'd0;
        end else begin
            if (rx_bvalid == 1'd0) begin
                rx_svalid_1p64 <= 1'd0;
                rx_serr_1p64 <= rx_serr_1p64;
                rx_scnt_1p64 <= rx_scnt_1p64;
                rx_sdata_1p64 <= rx_sdata_1p64;
            end else begin
                case (rx_scnt_1p64)
                    3'd0: begin
                        rx_svalid_1p64 <= 1'd0;
                        if (((rx_lstrb1_pstrb0 == 1'd0) && (rx_bstrobe == 8'h80)) ||
                            ((rx_lstrb1_pstrb0 == 1'd1) && (rx_bstrobe == 8'hff))) begin
                            rx_serr_1p64 <= 1'd0;
                        end else if (rx_bstrobe != 8'h00) begin
                            rx_serr_1p64 <= 1'd1;
                        end
                        if (((rx_lstrb1_pstrb0 == 1'd0) && (rx_bstrobe == 8'h80)) ||
                            ((rx_lstrb1_pstrb0 == 1'd1) && (rx_bstrobe == 8'hff))) begin
                            rx_scnt_1p64 <= 3'd1;
                        end
                        rx_sdata_1p64[63:32] <= {rx_bdata_0, 24'd0};
                        rx_sdata_1p64[31: 0] <= 32'd0;
                    end
                    3'd1: begin
                        rx_svalid_1p64 <= 1'd0;
                        rx_serr_1p64 <= (((rx_lstrb1_pstrb0 == 1'd0) && (rx_bstrobe == 8'h00)) ||
                            ((rx_lstrb1_pstrb0 == 1'd1) && (rx_bstrobe == 8'hff))) ? 1'b0 : 1'b1;
                        if (((rx_lstrb1_pstrb0 == 1'd0) && (rx_bstrobe == 8'h00)) ||
                            ((rx_lstrb1_pstrb0 == 1'd1) && (rx_bstrobe == 8'hff))) begin
                            rx_scnt_1p64 <= 3'd2;
                        end else begin
                            rx_scnt_1p64 <= 3'd0;
                        end
                        rx_sdata_1p64[63:32] <= {rx_sdata_1p64[63:56], rx_bdata_0, 16'd0};
                        rx_sdata_1p64[31: 0] <= 32'd0;
                    end
                    3'd2: begin
                        rx_svalid_1p64 <= 1'd0;
                        rx_serr_1p64 <= (((rx_lstrb1_pstrb0 == 1'd0) && (rx_bstrobe == 8'h00)) ||
                            ((rx_lstrb1_pstrb0 == 1'd1) && (rx_bstrobe == 8'hff))) ? 1'b0 : 1'b1;
                        if (((rx_lstrb1_pstrb0 == 1'd0) && (rx_bstrobe == 8'h00)) ||
                            ((rx_lstrb1_pstrb0 == 1'd1) && (rx_bstrobe == 8'hff))) begin
                            rx_scnt_1p64 <= 3'd3;
                        end else begin
                            rx_scnt_1p64 <= 3'd0;
                        end
                        rx_sdata_1p64[63:32] <= {rx_sdata_1p64[63:48], rx_bdata_0, 8'd0};
                        rx_sdata_1p64[31: 0] <= 32'd0;
                    end
                    3'd3: begin
                        rx_svalid_1p64 <= 1'd0;
                        rx_serr_1p64 <= (((rx_lstrb1_pstrb0 == 1'd0) && (rx_bstrobe == 8'h00)) ||
                            ((rx_lstrb1_pstrb0 == 1'd1) && (rx_bstrobe == 8'hff))) ? 1'b0 : 1'b1;
                        if (((rx_lstrb1_pstrb0 == 1'd0) && (rx_bstrobe == 8'h00)) ||
                            ((rx_lstrb1_pstrb0 == 1'd1) && (rx_bstrobe == 8'hff))) begin
                            rx_scnt_1p64 <= 3'd4;
                        end else begin
                            rx_scnt_1p64 <= 3'd0;
                        end
                        rx_sdata_1p64[63:32] <= {rx_sdata_1p64[63:40], rx_bdata_0};
                        rx_sdata_1p64[31: 0] <= 32'd0;
                    end
                    3'd4: begin
                        rx_svalid_1p64 <= 1'd0;
                        rx_serr_1p64 <= (rx_bstrobe == 8'h00) ? 1'b0 : 1'b1;
                        if (rx_bstrobe == 8'h00) begin
                            rx_scnt_1p64 <= 3'd5;
                        end else begin
                            rx_scnt_1p64 <= 3'd0;
                        end
                        rx_sdata_1p64[63:32] <= rx_sdata_1p64[63:32];
                        rx_sdata_1p64[31: 0] <= {rx_bdata_0, 24'd0};
                    end
                    3'd5: begin
                        rx_svalid_1p64 <= 1'd0;
                        rx_serr_1p64 <= (rx_bstrobe == 8'h00) ? 1'b0 : 1'b1;
                        if (rx_bstrobe == 8'h00) begin
                            rx_scnt_1p64 <= 3'd6;
                        end else begin
                            rx_scnt_1p64 <= 3'd0;
                        end
                        rx_sdata_1p64[63:32] <= rx_sdata_1p64[63:32];
                        rx_sdata_1p64[31: 0] <= {rx_sdata_1p64[31:24], rx_bdata_0, 16'd0};
                    end
                    3'd6: begin
                        rx_svalid_1p64 <= 1'd0;
                        rx_serr_1p64 <= (rx_bstrobe == 8'h00) ? 1'b0 : 1'b1;
                        if (rx_bstrobe == 8'h00) begin
                            rx_scnt_1p64 <= 3'd7;
                        end else begin
                            rx_scnt_1p64 <= 3'd0;
                        end
                        rx_sdata_1p64[63:32] <= rx_sdata_1p64[63:32];
                        rx_sdata_1p64[31: 0] <= {rx_sdata_1p64[31:16], rx_bdata_0, 8'd0};
                    end
                    default: begin
                        rx_svalid_1p64 <= (rx_bstrobe == 8'h00) ? 1'b1 : 1'b0;
                        rx_serr_1p64 <= (rx_bstrobe == 8'h00) ? 1'b0 : 1'b1;
                        rx_scnt_1p64 <= 3'd0;
                        rx_sdata_1p64[63:32] <= rx_sdata_1p64[63:32];
                        rx_sdata_1p64[31: 0] <= {rx_sdata_1p64[31:8], rx_bdata_0};
                    end
                endcase
            end
        end
    end

    // mode: CMOS_4L_PS_32X1, CMOS_4L_LS_32X1

    always @(negedge rx_resetn or posedge rx_clk) begin
        if (rx_resetn == 1'd0) begin
            rx_svalid_4p32 <= 1'd0;
            rx_serr_4p32 <= 1'd1;
            rx_sdata_4p32 <= 32'd0;
        end else begin
            if (rx_bvalid == 1'd0) begin
                rx_svalid_4p32 <= 1'd0;
                rx_serr_4p32 <= rx_serr_4p32;
                rx_sdata_4p32 <= rx_sdata_4p32;
            end else begin
                rx_svalid_4p32 <= (((rx_lstrb1_pstrb0 == 1'd0) && (rx_bstrobe == 8'h80)) ||
                    ((rx_lstrb1_pstrb0 == 1'd1) && (rx_bstrobe == 8'hf0))) ? 1'd1 : 1'd0;
                if (((rx_lstrb1_pstrb0 == 1'd0) && (rx_bstrobe == 8'h80)) ||
                    ((rx_lstrb1_pstrb0 == 1'd1) && (rx_bstrobe == 8'hf0))) begin
                    rx_serr_4p32 <= 1'd0;
                end else if (rx_bstrobe != 8'h00) begin
                    rx_serr_4p32 <= 1'd1;
                end
                rx_sdata_4p32[31:16] <= {rx_bdata_1, rx_bdata_0};
                rx_sdata_4p32[15: 0] <= {rx_bdata_3, rx_bdata_2};
            end
        end
    end

    // mode: LVDS_2L_PS_32X1, LVDS_2L_LS_32X1
 
    always @(negedge rx_resetn or posedge rx_clk) begin
        if (rx_resetn == 1'd0) begin
            rx_svalid_2p32 <= 1'd0;
            rx_serr_2p32 <= 1'd1;
            rx_scnt_2p32 <= 1'd0;
            rx_sdata_2p32 <= 32'd0;
        end else begin
            if (rx_bvalid == 1'd0) begin
                rx_svalid_2p32 <= 1'd0;
                rx_serr_2p32 <= rx_serr_2p32;
                rx_scnt_2p32 <= rx_scnt_2p32;
                rx_sdata_2p32 <= rx_sdata_2p32;
            end else if (rx_scnt_2p32 == 1'd0) begin
                rx_svalid_2p32 <= 1'd0;
                if (((rx_lstrb1_pstrb0 == 1'd0) && (rx_bstrobe == 8'h80)) ||
                    ((rx_lstrb1_pstrb0 == 1'd1) && (rx_bstrobe == 8'hff))) begin
                    rx_serr_2p32 <= 1'd0;
                end else if (rx_bstrobe != 8'h00) begin
                    rx_serr_2p32 <= 1'd1;
                end
                if (((rx_lstrb1_pstrb0 == 1'd0) && (rx_bstrobe == 8'h80)) ||
                    ((rx_lstrb1_pstrb0 == 1'd1) && (rx_bstrobe == 8'hff))) begin
                    rx_scnt_2p32 <= 1'd1;
                end
                rx_sdata_2p32[31:16] <= {rx_bdata_0, 8'd0};
                rx_sdata_2p32[15: 0] <= {rx_bdata_1, 8'd0};
            end else begin
                rx_svalid_2p32 <= (rx_bstrobe == 8'h00) ? 1'b1 : 1'b0;
                rx_serr_2p32 <= (rx_bstrobe == 8'h00) ? 1'b0 : 1'b1;
                rx_scnt_2p32 <= 1'd0;
                rx_sdata_2p32[31:16] <= {rx_sdata_2p32[31:24], rx_bdata_0};
                rx_sdata_2p32[15: 0] <= {rx_sdata_2p32[15: 8], rx_bdata_1};
            end
        end
    end

    // mode: CMOS_1L_PS_32X1, LVDS_1L_PS_32X1, CMOS_1L_LS_32X1, LVDS_1L_LS_32X1

    always @(negedge rx_resetn or posedge rx_clk) begin
        if (rx_resetn == 1'd0) begin
            rx_svalid_1p32 <= 1'd0;
            rx_serr_1p32 <= 1'd1;
            rx_scnt_1p32 <= 2'd0;
            rx_sdata_1p32 <= 32'd0;
        end else begin
            if (rx_bvalid == 1'd0) begin
                rx_svalid_1p32 <= 1'd0;
                rx_serr_1p32 <= rx_serr_1p32;
                rx_scnt_1p32 <= rx_scnt_1p32;
                rx_sdata_1p32 <= rx_sdata_1p32;
            end else begin
                case (rx_scnt_1p32)
                    2'd0: begin
                        rx_svalid_1p32 <= 1'd0;
                        if (((rx_lstrb1_pstrb0 == 1'd0) && (rx_bstrobe == 8'h80)) ||
                            ((rx_lstrb1_pstrb0 == 1'd1) && (rx_bstrobe == 8'hff))) begin
                            rx_serr_1p32 <= 1'd0;
                        end else if (rx_bstrobe != 8'h00) begin
                            rx_serr_1p32 <= 1'd1;
                        end
                        if (((rx_lstrb1_pstrb0 == 1'd0) && (rx_bstrobe == 8'h80)) ||
                            ((rx_lstrb1_pstrb0 == 1'd1) && (rx_bstrobe == 8'hff))) begin
                            rx_scnt_1p32 <= 2'd1;
                        end
                        rx_sdata_1p32[31:16] <= {rx_bdata_0, 8'd0};
                        rx_sdata_1p32[15: 0] <= 16'd0;
                    end
                    2'd1: begin
                        rx_svalid_1p32 <= 1'd0;
                        rx_serr_1p32 <= (((rx_lstrb1_pstrb0 == 1'd0) && (rx_bstrobe == 8'h00)) ||
                            ((rx_lstrb1_pstrb0 == 1'd1) && (rx_bstrobe == 8'hff))) ? 1'b0 : 1'b1;
                        if (((rx_lstrb1_pstrb0 == 1'd0) && (rx_bstrobe == 8'h00)) ||
                            ((rx_lstrb1_pstrb0 == 1'd1) && (rx_bstrobe == 8'hff))) begin
                            rx_scnt_1p32 <= 2'd2;
                        end else begin
                            rx_scnt_1p32 <= 2'd0;
                        end
                        rx_sdata_1p32[31:16] <= {rx_sdata_1p32[31:24], rx_bdata_0};
                        rx_sdata_1p32[15: 0] <= 16'd0;
                    end
                    2'd2: begin
                        rx_svalid_1p32 <= 1'd0;
                        rx_serr_1p32 <= (rx_bstrobe == 8'h00) ? 1'b0 : 1'b1;
                        if (rx_bstrobe == 8'h00) begin
                            rx_scnt_1p32 <= 2'd3;
                        end else begin
                            rx_scnt_1p32 <= 2'd0;
                        end
                        rx_sdata_1p32[31:16] <= rx_sdata_1p32[31:16];
                        rx_sdata_1p32[15: 0] <= {rx_bdata_0, 8'd0};
                    end
                    default: begin
                        rx_svalid_1p32 <= (rx_bstrobe == 8'h00) ? 1'b1 : 1'b0;
                        rx_serr_1p32 <= (rx_bstrobe == 8'h00) ? 1'b0 : 1'b1;
                        rx_scnt_1p32 <= 2'd0;
                        rx_sdata_1p32[31:16] <= rx_sdata_1p32[31:16];
                        rx_sdata_1p32[15: 0] <= {rx_sdata_1p32[15:8], rx_bdata_0};
                    end
                endcase
            end
        end
    end

    // mode: LVDS_2L_PS_24X1, LVDS_2L_LS_24X1
 
    always @(negedge rx_resetn or posedge rx_clk) begin
        if (rx_resetn == 1'd0) begin
            rx_svalid_2p24 <= 1'd0;
            rx_serr_2p24 <= 1'd1;
            rx_scnt_2p24 <= 2'd0;
            rx_sdata_2p24 <= 24'd0;
            rx_hdata_2p24 <= 8'd0;
        end else begin
            if (rx_bvalid == 1'd0) begin
                rx_svalid_2p24 <= 1'd0;
                rx_serr_2p24 <= rx_serr_2p24;
                rx_scnt_2p24 <= rx_scnt_2p24;
                rx_sdata_2p24 <= rx_sdata_2p24;
                rx_hdata_2p24 <= rx_hdata_2p24;
            end else begin
                case (rx_scnt_2p24)
                    2'd0: begin
                        rx_svalid_2p24 <= 1'd0;
                        if (((rx_lstrb1_pstrb0 == 1'd0) && (rx_bstrobe == 8'h80)) ||
                            ((rx_lstrb1_pstrb0 == 1'd1) && (rx_bstrobe == 8'hfc))) begin
                            rx_serr_2p24 <= 1'd0;
                        end else if (rx_bstrobe != 8'h00) begin
                            rx_serr_2p24 <= 1'd1;
                        end
                        if (((rx_lstrb1_pstrb0 == 1'd0) && (rx_bstrobe == 8'h80)) ||
                            ((rx_lstrb1_pstrb0 == 1'd1) && (rx_bstrobe == 8'hfc))) begin
                            rx_scnt_2p24 <= 2'd1;
                        end
                        rx_sdata_2p24[23:12] <= {rx_bdata_0, 4'd0};
                        rx_sdata_2p24[11: 0] <= {rx_bdata_1, 4'd0};
                        rx_hdata_2p24 <= 8'd0;
                    end
                    2'd1: begin
                        rx_svalid_2p24 <= (((rx_lstrb1_pstrb0 == 1'd0) && (rx_bstrobe == 8'h08)) ||
                            ((rx_lstrb1_pstrb0 == 1'd1) && (rx_bstrobe == 8'h0f)) ||
                            (rx_bstrobe == 8'h00)) ? 1'b1 : 1'b0;
                        rx_serr_2p24 <= (((rx_lstrb1_pstrb0 == 1'd0) && (rx_bstrobe == 8'h08)) ||
                            ((rx_lstrb1_pstrb0 == 1'd1) && (rx_bstrobe == 8'h0f)) ||
                            (rx_bstrobe == 8'h00)) ? 1'b0 : 1'b1;
                        if (((rx_lstrb1_pstrb0 == 1'd0) && (rx_bstrobe == 8'h08)) ||
                            ((rx_lstrb1_pstrb0 == 1'd1) && (rx_bstrobe == 8'h0f))) begin
                            rx_scnt_2p24 <= 2'd2;
                        end else begin
                            rx_scnt_2p24 <= 2'd0;
                        end
                        rx_sdata_2p24[23:12] <= {rx_sdata_2p24[23:16], rx_bdata_0[7:4]};
                        rx_sdata_2p24[11: 0] <= {rx_sdata_2p24[11: 4], rx_bdata_1[7:4]};
                        rx_hdata_2p24[7:4] <= rx_bdata_0[3:0];
                        rx_hdata_2p24[3:0] <= rx_bdata_1[3:0];
                    end
                    default: begin
                        rx_svalid_2p24 <= (((rx_lstrb1_pstrb0 == 1'd0) && (rx_bstrobe == 8'h00)) ||
                            ((rx_lstrb1_pstrb0 == 1'd1) && (rx_bstrobe == 8'hc0))) ? 1'd1 : 1'd0;
                        rx_serr_2p24 <= (((rx_lstrb1_pstrb0 == 1'd0) && (rx_bstrobe == 8'h00)) ||
                            ((rx_lstrb1_pstrb0 == 1'd1) && (rx_bstrobe == 8'hc0))) ? 1'd0 : 1'd1;
                        rx_scnt_2p24 <= 2'd0;
                        rx_sdata_2p24[23:12] <= {rx_hdata_2p24[7:4], rx_bdata_0};
                        rx_sdata_2p24[11: 0] <= {rx_hdata_2p24[3:0], rx_bdata_1};
                        rx_hdata_2p24 <= 8'd0;
                    end
                endcase
            end
        end
    end

    // mode: LVDS_1L_PS_24X1, LVDS_1L_LS_24X1
 
    always @(negedge rx_resetn or posedge rx_clk) begin
        if (rx_resetn == 1'd0) begin
            rx_svalid_1p24 <= 1'd0;
            rx_serr_1p24 <= 1'd1;
            rx_scnt_1p24 <= 2'd0;
            rx_sdata_1p24 <= 24'd0;
        end else begin
            if (rx_bvalid == 1'd0) begin
                rx_svalid_1p24 <= 1'd0;
                rx_serr_1p24 <= rx_serr_1p24;
                rx_scnt_1p24 <= rx_scnt_1p24;
                rx_sdata_1p24 <= rx_sdata_1p24;
            end else begin
                case (rx_scnt_1p24)
                    2'd0: begin
                        rx_svalid_1p24 <= 1'd0;
                        if (((rx_lstrb1_pstrb0 == 1'd0) && (rx_bstrobe == 8'h80)) ||
                            ((rx_lstrb1_pstrb0 == 1'd1) && (rx_bstrobe == 8'hff))) begin
                            rx_serr_1p24 <= 1'd0;
                        end else if (rx_bstrobe != 8'h00) begin
                            rx_serr_1p24 <= 1'd1;
                        end
                        if (((rx_lstrb1_pstrb0 == 1'd0) && (rx_bstrobe == 8'h80)) ||
                            ((rx_lstrb1_pstrb0 == 1'd1) && (rx_bstrobe == 8'hff))) begin
                            rx_scnt_1p24 <= 2'd1;
                        end
                        rx_sdata_1p24[23:12] <= {rx_bdata_0, 4'd0};
                        rx_sdata_1p24[11: 0] <= 12'd0;
                    end
                    2'd1: begin
                        rx_svalid_1p24 <= 1'd0;
                        rx_serr_1p24 <= (((rx_lstrb1_pstrb0 == 1'd0) && (rx_bstrobe == 8'h00)) ||
                            ((rx_lstrb1_pstrb0 == 1'd1) && (rx_bstrobe == 8'hf0))) ? 1'd0 : 1'd1;
                        if (((rx_lstrb1_pstrb0 == 1'd0) && (rx_bstrobe == 8'h00)) ||
                            ((rx_lstrb1_pstrb0 == 1'd1) && (rx_bstrobe == 8'hf0))) begin
                            rx_scnt_1p24 <= 2'd2;
                        end else begin
                            rx_scnt_1p24 <= 2'd0;
                        end
                        rx_sdata_1p24[23:12] <= {rx_sdata_1p24[23:16], rx_bdata_0[7:4]};
                        rx_sdata_1p24[11: 0] <= {rx_bdata_0[3: 0], 8'd0};
                    end
                    default: begin
                        rx_svalid_1p24 <= (rx_bstrobe == 8'h00) ? 1'd1 : 1'd0;
                        rx_serr_1p24 <= (rx_bstrobe == 8'h00) ? 1'd0 : 1'd1;
                        rx_scnt_1p24 <= 2'd0;
                        rx_sdata_1p24[23:12] <= rx_sdata_1p24[23:12];
                        rx_sdata_1p24[11: 0] <= {rx_sdata_1p24[11:8], rx_bdata_0};
                    end
                endcase
            end
        end
    end

    // mode: CMOS_1L_PS_16X1, CMOS_1L_LS_16X1

    always @(negedge rx_resetn or posedge rx_clk) begin
        if (rx_resetn == 1'd0) begin
            rx_svalid_1p16 <= 1'd0;
            rx_serr_1p16 <= 1'd1;
            rx_scnt_1p16 <= 1'd0;
            rx_sdata_1p16 <= 16'd0;
        end else begin
            if (rx_bvalid == 1'd0) begin
                rx_svalid_1p16 <= 1'd0;
                rx_serr_1p16 <= rx_serr_1p16;
                rx_scnt_1p16 <= rx_scnt_1p16;
                rx_sdata_1p16 <= rx_sdata_1p16;
            end else if (rx_scnt_1p16 == 1'd0) begin
                rx_svalid_1p16 <= 1'd0;
                if (((rx_lstrb1_pstrb0 == 1'd0) && (rx_bstrobe == 8'h80)) ||
                    ((rx_lstrb1_pstrb0 == 1'd1) && (rx_bstrobe == 8'hff))) begin
                    rx_serr_1p16 <= 1'd0;
                end else if (rx_bstrobe != 8'h00) begin
                    rx_serr_1p16 <= 1'd1;
                end
                if (((rx_lstrb1_pstrb0 == 1'd0) && (rx_bstrobe == 8'h80)) ||
                    ((rx_lstrb1_pstrb0 == 1'd1) && (rx_bstrobe == 8'hff))) begin
                    rx_scnt_1p16 <= 1'd1;
                end
                rx_sdata_1p16 <= {rx_bdata_0, 8'd0};
            end else begin
                rx_svalid_1p16 <= (rx_bstrobe == 8'h00) ? 1'd1 : 1'd0;
                rx_serr_1p16 <= (rx_bstrobe == 8'h00) ? 1'd0 : 1'd1;
                rx_scnt_1p16 <= 1'd0;
                rx_sdata_1p16 <= {rx_sdata_1p16[15:8], rx_bdata_0};
            end
        end
    end

    // mode: CMOS_1L_PS_08X1, CMOS_1L_LS_08X1

    always @(negedge rx_resetn or posedge rx_clk) begin
        if (rx_resetn == 1'd0) begin
            rx_svalid_1p08 <= 1'd0;
            rx_serr_1p08 <= 1'd1;
            rx_sdata_1p08 <= 8'd0;
        end else begin
            if ((rx_bvalid == 1'd0) || (rx_bstrobe == 8'h00)) begin
                rx_svalid_1p08 <= 1'd0;
                rx_serr_1p08 <= rx_serr_1p08;
                rx_sdata_1p08 <= rx_sdata_1p08;
            end else if (((rx_lstrb1_pstrb0 == 1'd0) && (rx_bstrobe == 8'h80)) ||
                ((rx_lstrb1_pstrb0 == 1'd1) && (rx_bstrobe == 8'hf0))) begin
                rx_svalid_1p08 <= 1'd1;
                rx_serr_1p08 <= 1'd0;
                rx_sdata_1p08 <= rx_bdata_0;
            end else begin
                rx_svalid_1p08 <= 1'd0;
                rx_serr_1p08 <= 1'd1;
                rx_sdata_1p08 <= 8'd0;
            end
        end
    end

    // mode: CMOS_1L_PS_02X1, CMOS_1L_LS_02X1

    always @(negedge rx_resetn or posedge rx_clk) begin
        if (rx_resetn == 1'd0) begin
            rx_svalid_1p02 <= 1'd0;
            rx_sstate_1p02 <= 3'd0;
            rx_serr_1p02 <= 1'd1;
            rx_scnt_1p02 <= 2'd0;
            rx_sdata_1p02 <= 8'd0;
            rx_shold_1p02 <= 2'd0;
        end else begin
            case (rx_sstate_1p02)
                RX_SSTATE02_08: begin
                    if ((rx_bvalid == 1'd0) || (rx_bstrobe == 8'h00)) begin
                        rx_svalid_1p02 <= 1'd0;
                        rx_sstate_1p02 <= RX_SSTATE02_08;
                        rx_serr_1p02 <= rx_serr_1p02;
                        rx_scnt_1p02 <= rx_scnt_1p02;
                        rx_sdata_1p02 <= rx_sdata_1p02;
                        rx_shold_1p02 <= rx_shold_1p02;
                    end else if (rx_bstrobe == 8'h08) begin
                        rx_svalid_1p02 <= &rx_scnt_1p02;
                        rx_sstate_1p02 <= RX_SSTATE02_08;
                        rx_serr_1p02 <= 1'd0;
                        rx_scnt_1p02 <= rx_scnt_1p02 + 1'd1;
                        rx_sdata_1p02 <= {rx_bdata_0[3:2], rx_sdata_1p02[7:2]};
                        rx_shold_1p02 <= 2'd0;
                    end else begin
                        rx_svalid_1p02 <= 1'd0;
                        rx_sstate_1p02 <= RX_SSTATE02_00;
                        rx_serr_1p02 <= 1'd1;
                        rx_scnt_1p02 <= 2'd0;
                        rx_sdata_1p02 <= 8'd0;
                        rx_shold_1p02 <= 2'd0;
                    end
                end
                RX_SSTATE02_20: begin
                    if ((rx_bvalid == 1'd0) || (rx_bstrobe == 8'h00)) begin
                        rx_svalid_1p02 <= 1'd0;
                        rx_sstate_1p02 <= RX_SSTATE02_20;
                        rx_serr_1p02 <= rx_serr_1p02;
                        rx_scnt_1p02 <= rx_scnt_1p02;
                        rx_sdata_1p02 <= rx_sdata_1p02;
                        rx_shold_1p02 <= rx_shold_1p02;
                    end else if (rx_bstrobe == 8'h20) begin
                        rx_svalid_1p02 <= &rx_scnt_1p02;
                        rx_sstate_1p02 <= RX_SSTATE02_20;
                        rx_serr_1p02 <= 1'd0;
                        rx_scnt_1p02 <= rx_scnt_1p02 + 1'd1;
                        rx_sdata_1p02 <= {rx_bdata_0[5:4], rx_sdata_1p02[7:2]};
                        rx_shold_1p02 <= 2'd0;
                    end else begin
                        rx_svalid_1p02 <= 1'd0;
                        rx_sstate_1p02 <= RX_SSTATE02_00;
                        rx_serr_1p02 <= 1'd1;
                        rx_scnt_1p02 <= 2'd0;
                        rx_sdata_1p02 <= 8'd0;
                        rx_shold_1p02 <= 2'd0;
                    end
                end
                RX_SSTATE02_22: begin
                    if (rx_bvalid == 1'd0) begin
                        rx_svalid_1p02 <= 1'd0;
                        rx_sstate_1p02 <= RX_SSTATE02_22;
                        rx_serr_1p02 <= rx_serr_1p02;
                        rx_scnt_1p02 <= rx_scnt_1p02;
                        rx_sdata_1p02 <= rx_sdata_1p02;
                        rx_shold_1p02 <= rx_shold_1p02;
                    end else if (rx_bstrobe == 8'h22) begin
                        rx_svalid_1p02 <= rx_scnt_1p02[1];
                        rx_sstate_1p02 <= RX_SSTATE02_22;
                        rx_serr_1p02 <= 1'd0;
                        if (rx_scnt_1p02 == 2'd1) begin
                            rx_scnt_1p02 <= 2'd3;
                            rx_sdata_1p02 <= {rx_bdata_0[1:0], rx_bdata_0[5:4],
                                rx_shold_1p02, rx_sdata_1p02[7:6]};
                            rx_shold_1p02 <= 2'd0;
                        end else begin
                            rx_scnt_1p02 <= 2'd1;
                            rx_sdata_1p02 <= {rx_bdata_0[5:4], rx_sdata_1p02[7:2]};
                            rx_shold_1p02 <= rx_bdata_0[1:0];
                        end
                    end else begin
                        rx_svalid_1p02 <= 1'd0;
                        rx_sstate_1p02 <= RX_SSTATE02_00;
                        rx_serr_1p02 <= 1'd1;
                        rx_scnt_1p02 <= 2'd0;
                        rx_sdata_1p02 <= 8'd0;
                        rx_shold_1p02 <= 2'd0;
                    end
                end
                RX_SSTATE02_80: begin
                    if ((rx_bvalid == 1'd0) || (rx_bstrobe == 8'h00)) begin
                        rx_svalid_1p02 <= 1'd0;
                        rx_sstate_1p02 <= RX_SSTATE02_80;
                        rx_serr_1p02 <= rx_serr_1p02;
                        rx_scnt_1p02 <= rx_scnt_1p02;
                        rx_sdata_1p02 <= rx_sdata_1p02;
                        rx_shold_1p02 <= rx_shold_1p02;
                    end else if (rx_bstrobe == 8'h80) begin
                        rx_svalid_1p02 <= & rx_scnt_1p02;
                        rx_sstate_1p02 <= RX_SSTATE02_80;
                        rx_serr_1p02 <= 1'd0;
                        rx_scnt_1p02 <= rx_scnt_1p02 + 1'd1;
                        rx_sdata_1p02 <= {rx_bdata_0[7:6], rx_sdata_1p02[7:2]};
                    end else begin
                        rx_svalid_1p02 <= 1'd0;
                        rx_sstate_1p02 <= RX_SSTATE02_00;
                        rx_serr_1p02 <= 1'd1;
                        rx_scnt_1p02 <= 2'd0;
                        rx_sdata_1p02 <= 8'd0;
                        rx_shold_1p02 <= 2'd0;
                    end
                end
                RX_SSTATE02_88: begin
                    if (rx_bvalid == 1'd0) begin
                        rx_svalid_1p02 <= 1'd0;
                        rx_sstate_1p02 <= RX_SSTATE02_88;
                        rx_serr_1p02 <= rx_serr_1p02;
                        rx_scnt_1p02 <= rx_scnt_1p02;
                        rx_sdata_1p02 <= rx_sdata_1p02;
                        rx_shold_1p02 <= rx_shold_1p02;
                    end else if (rx_bstrobe == 8'h88) begin
                        rx_svalid_1p02 <= rx_scnt_1p02[1];
                        rx_sstate_1p02 <= RX_SSTATE02_88;
                        rx_serr_1p02 <= 1'd0;
                        case (rx_scnt_1p02)
                            2'd0: begin
                                rx_scnt_1p02 <= 2'd2;
                                rx_sdata_1p02 <= {rx_bdata_0[3:2], rx_bdata_0[7:6],
                                    rx_sdata_1p02[7:4]};
                                rx_shold_1p02 <= 2'd0;
                            end
                            2'd1: begin
                                rx_scnt_1p02 <= 2'd3;
                                rx_sdata_1p02 <= {rx_bdata_0[3:2], rx_bdata_0[7:6],
                                    rx_shold_1p02, rx_sdata_1p02[7:6]};
                                rx_shold_1p02 <= 2'd0;
                            end
                            2'd2: begin
                                rx_scnt_1p02 <= 2'd0;
                                rx_sdata_1p02 <= {rx_bdata_0[3:2], rx_bdata_0[7:6],
                                    rx_sdata_1p02[7:4]};
                                rx_shold_1p02 <= 2'd0;
                            end
                            default: begin
                                rx_scnt_1p02 <= 2'd1;
                                rx_sdata_1p02 <= {rx_bdata_0[7:6], rx_sdata_1p02[7:2]};
                                rx_shold_1p02 <= rx_bdata_0[3:2];
                            end
                        endcase
                    end else begin
                        rx_svalid_1p02 <= 1'd0;
                        rx_sstate_1p02 <= RX_SSTATE02_00;
                        rx_serr_1p02 <= 1'd1;
                        rx_scnt_1p02 <= 2'd0;
                        rx_sdata_1p02 <= 8'd0;
                        rx_shold_1p02 <= 2'd0;
                    end
                end
                RX_SSTATE02_A8: begin
                    if ((rx_bvalid == 1'd0) || (rx_bstrobe == 8'h00)) begin
                        rx_svalid_1p02 <= 1'd0;
                        rx_sstate_1p02 <= RX_SSTATE02_A8;
                        rx_serr_1p02 <= rx_serr_1p02;
                        rx_scnt_1p02 <= rx_scnt_1p02;
                        rx_sdata_1p02 <= rx_sdata_1p02;
                        rx_shold_1p02 <= rx_shold_1p02;
                    end else begin
                        case (rx_bstrobe)
                            8'h88: begin
                                rx_svalid_1p02 <= 1'd1;
                                rx_sstate_1p02 <= RX_SSTATE02_88;
                                rx_serr_1p02 <= 1'd0;
                                rx_scnt_1p02 <= 2'd1;
                                rx_sdata_1p02 <= {rx_bdata_0[7:6], rx_sdata_1p02[7:2]};
                                rx_shold_1p02 <= rx_bdata_0[3:2];
                            end
                            8'h08: begin
                                rx_svalid_1p02 <= 1'd1;
                                rx_sstate_1p02 <= RX_SSTATE02_08;
                                rx_serr_1p02 <= 1'd0;
                                rx_scnt_1p02 <= 2'd0;
                                rx_sdata_1p02 <= {rx_bdata_0[3:2], rx_sdata_1p02[7:2]};
                                rx_shold_1p02 <= 2'd0;
                            end
                            default: begin
                                rx_svalid_1p02 <= 1'd0;
                                rx_sstate_1p02 <= RX_SSTATE02_00;
                                rx_serr_1p02 <= 1'd1;
                                rx_scnt_1p02 <= 2'd0;
                                rx_sdata_1p02 <= 8'd0;
                                rx_shold_1p02 <= 2'd0;
                            end
                        endcase
                    end
                end
                default: begin
                    if ((rx_bvalid == 1'd0) || (rx_bstrobe == 8'h00)) begin
                        rx_svalid_1p02 <= 1'd0;
                        rx_sstate_1p02 <= RX_SSTATE02_00;
                        rx_serr_1p02 <= rx_serr_1p02;
                        rx_scnt_1p02 <= rx_scnt_1p02;
                        rx_sdata_1p02 <= rx_sdata_1p02;
                        rx_shold_1p02 <= rx_shold_1p02;
                    end else begin
                        case (rx_bstrobe)
                            8'haa: begin
                                rx_svalid_1p02 <= 1'd1;
                                rx_sstate_1p02 <= RX_SSTATE02_00;
                                rx_serr_1p02 <= 1'd0;
                                rx_sdata_1p02 <= {rx_bdata_0[1:0], rx_bdata_0[3:2],
                                    rx_bdata_0[5:4], rx_bdata_0[7:6]};
                                rx_shold_1p02 <= 2'd0;
                            end
                            8'ha8: begin
                                rx_svalid_1p02 <= 1'd0;
                                rx_sstate_1p02 <= RX_SSTATE02_A8;
                                rx_serr_1p02 <= 1'd0;
                                rx_scnt_1p02 <= 2'd3;
                                rx_sdata_1p02 <= {rx_bdata_0[3:2], rx_bdata_0[5:4],
                                    rx_bdata_0[7:6], 2'd0};
                                rx_shold_1p02 <= 2'd0;
                            end
                            8'ha2: begin
                                rx_svalid_1p02 <= 1'd0;
                                rx_sstate_1p02 <= RX_SSTATE02_22;
                                rx_serr_1p02 <= 1'd0;
                                rx_scnt_1p02 <= 2'd3;
                                rx_sdata_1p02 <= {rx_bdata_0[1:0], rx_bdata_0[5:4],
                                    rx_bdata_0[7:6], 2'd0};
                                rx_shold_1p02 <= 2'd0;
                            end
                            8'ha0: begin
                                rx_svalid_1p02 <= 1'd0;
                                rx_sstate_1p02 <= RX_SSTATE02_20;
                                rx_serr_1p02 <= 1'd0;
                                rx_scnt_1p02 <= 2'd2;
                                rx_sdata_1p02 <= {rx_bdata_0[5:4], rx_bdata_0[7:6], 4'd0};
                                rx_shold_1p02 <= 2'd0;
                            end
                            8'h88: begin
                                rx_svalid_1p02 <= 1'd0;
                                rx_sstate_1p02 <= RX_SSTATE02_88;
                                rx_serr_1p02 <= 1'd0;
                                rx_scnt_1p02 <= 2'd2;
                                rx_sdata_1p02 <= {rx_bdata_0[3:2], rx_bdata_0[7:6], 4'd0};
                                rx_shold_1p02 <= 2'd0;
                            end
                            8'h80: begin
                                rx_svalid_1p02 <= 1'd0;
                                rx_sstate_1p02 <= RX_SSTATE02_80;
                                rx_serr_1p02 <= 1'd0;
                                rx_scnt_1p02 <= 2'd1;
                                rx_sdata_1p02 <= {rx_bdata_0[7:6], 6'd0};
                                rx_shold_1p02 <= 2'd0;
                            end
                            default: begin
                                rx_svalid_1p02 <= 1'd0;
                                rx_sstate_1p02 <= RX_SSTATE02_00;
                                rx_serr_1p02 <= 1'd1;
                                rx_scnt_1p02 <= 2'd0;
                                rx_sdata_1p02 <= 8'd0;
                                rx_shold_1p02 <= 2'd0;
                            end
                        endcase
                    end
                end
            endcase
        end
    end

    // aligned bytes reporting

    always @(negedge rx_resetn or posedge rx_clk) begin
        if (rx_resetn == 1'd0) begin
            rx_mcs_bcount <= 3'd0;
            rx_mcs_bstrobe <= 32'd0;
            rx_mcs_bdata <= 32'd0;
        end else begin
            if ((rx_bvalid == 1'd1) && (rx_mcs_bcount[2] == 1'd0)) begin
                rx_mcs_bcount <= rx_mcs_bcount + 1'd1;
            end
            if ((rx_bvalid == 1'd1) && (rx_mcs_bcount == 3'd0)) begin
                rx_mcs_bstrobe[7:0] <= rx_bstrobe;
                rx_mcs_bdata[7:0] <= rx_bdata_0;
            end
            if ((rx_bvalid == 1'd1) && (rx_mcs_bcount == 3'd1)) begin
                rx_mcs_bstrobe[15:8] <= rx_bstrobe;
                rx_mcs_bdata[15:8] <= rx_bdata_0;
            end
            if ((rx_bvalid == 1'd1) && (rx_mcs_bcount == 3'd2)) begin
                rx_mcs_bstrobe[23:16] <= rx_bstrobe;
                rx_mcs_bdata[23:16] <= rx_bdata_0;
            end
            if ((rx_bvalid == 1'd1) && (rx_mcs_bcount == 3'd3)) begin
                rx_mcs_bstrobe[31:24] <= rx_bstrobe;
                rx_mcs_bdata[31:24] <= rx_bdata_0;
            end
        end
    end

    // alignment
 
    always @(negedge rx_serdes_data_resetn or posedge rx_clk) begin
        if (rx_serdes_data_resetn == 1'd0) begin
            rx_bvalid <= 1'd0;
            rx_bstrobe <= 8'd0;
            rx_bdata_0 <= 8'd0;
            rx_bdata_1 <= 8'd0;
            rx_bdata_2 <= 8'd0;
            rx_bdata_3 <= 8'd0;
        end else begin
            rx_bvalid <= rx_dvalid;
            case (rx_balign)
                3'd0: begin
                    rx_bstrobe <= (rx_align_sel == 1'b1) ? rx_dstrobe : rx_dstrobe_d;
                    rx_bdata_0 <= (rx_align_sel == 1'b1) ? rx_ddata_0 : rx_ddata_0_d;
                    rx_bdata_1 <= (rx_align_sel == 1'b1) ? rx_ddata_1 : rx_ddata_1_d;
                    rx_bdata_2 <= (rx_align_sel == 1'b1) ? rx_ddata_2 : rx_ddata_2_d;
                    rx_bdata_3 <= (rx_align_sel == 1'b1) ? rx_ddata_3 : rx_ddata_3_d;
                end
                3'd1: begin
                    rx_bstrobe <= {rx_dstrobe_d[6:0], rx_dstrobe[7]};
                    rx_bdata_0 <= {rx_ddata_0_d[6:0], rx_ddata_0[7]};
                    rx_bdata_1 <= {rx_ddata_1_d[6:0], rx_ddata_1[7]};
                    rx_bdata_2 <= {rx_ddata_2_d[6:0], rx_ddata_2[7]};
                    rx_bdata_3 <= {rx_ddata_3_d[6:0], rx_ddata_3[7]};
                end
                3'd2: begin
                    rx_bstrobe <= {rx_dstrobe_d[5:0], rx_dstrobe[7:6]};
                    rx_bdata_0 <= {rx_ddata_0_d[5:0], rx_ddata_0[7:6]};
                    rx_bdata_1 <= {rx_ddata_1_d[5:0], rx_ddata_1[7:6]};
                    rx_bdata_2 <= {rx_ddata_2_d[5:0], rx_ddata_2[7:6]};
                    rx_bdata_3 <= {rx_ddata_3_d[5:0], rx_ddata_3[7:6]};
                end
                3'd3: begin
                    rx_bstrobe <= {rx_dstrobe_d[4:0], rx_dstrobe[7:5]};
                    rx_bdata_0 <= {rx_ddata_0_d[4:0], rx_ddata_0[7:5]};
                    rx_bdata_1 <= {rx_ddata_1_d[4:0], rx_ddata_1[7:5]};
                    rx_bdata_2 <= {rx_ddata_2_d[4:0], rx_ddata_2[7:5]};
                    rx_bdata_3 <= {rx_ddata_3_d[4:0], rx_ddata_3[7:5]};
                end
                3'd4: begin
                    rx_bstrobe <= {rx_dstrobe_d[3:0], rx_dstrobe[7:4]};
                    rx_bdata_0 <= {rx_ddata_0_d[3:0], rx_ddata_0[7:4]};
                    rx_bdata_1 <= {rx_ddata_1_d[3:0], rx_ddata_1[7:4]};
                    rx_bdata_2 <= {rx_ddata_2_d[3:0], rx_ddata_2[7:4]};
                    rx_bdata_3 <= {rx_ddata_3_d[3:0], rx_ddata_3[7:4]};
                end
                3'd5: begin
                    rx_bstrobe <= {rx_dstrobe_d[2:0], rx_dstrobe[7:3]};
                    rx_bdata_0 <= {rx_ddata_0_d[2:0], rx_ddata_0[7:3]};
                    rx_bdata_1 <= {rx_ddata_1_d[2:0], rx_ddata_1[7:3]};
                    rx_bdata_2 <= {rx_ddata_2_d[2:0], rx_ddata_2[7:3]};
                    rx_bdata_3 <= {rx_ddata_3_d[2:0], rx_ddata_3[7:3]};
                end
                3'd6: begin
                    rx_bstrobe <= {rx_dstrobe_d[1:0], rx_dstrobe[7:2]};
                    rx_bdata_0 <= {rx_ddata_0_d[1:0], rx_ddata_0[7:2]};
                    rx_bdata_1 <= {rx_ddata_1_d[1:0], rx_ddata_1[7:2]};
                    rx_bdata_2 <= {rx_ddata_2_d[1:0], rx_ddata_2[7:2]};
                    rx_bdata_3 <= {rx_ddata_3_d[1:0], rx_ddata_3[7:2]};
                end
                default: begin
                    rx_bstrobe <= {rx_dstrobe_d[0], rx_dstrobe[7:1]};
                    rx_bdata_0 <= {rx_ddata_0_d[0], rx_ddata_0[7:1]};
                    rx_bdata_1 <= {rx_ddata_1_d[0], rx_ddata_1[7:1]};
                    rx_bdata_2 <= {rx_ddata_2_d[0], rx_ddata_2[7:1]};
                    rx_bdata_3 <= {rx_ddata_3_d[0], rx_ddata_3[7:1]};
                end
            endcase
        end
    end

    always @(negedge rx_serdes_data_resetn or posedge rx_clk) begin
        if (rx_serdes_data_resetn == 1'b0) begin
            rx_bskip <= 2'd0;
            rx_balign <= 3'd0;
        end else begin
            if ((rx_mlane1_slane0 == 1'd1) && (rx_num_of_bits == 3'b011)) begin
                if (rx_dvalid == 1'd1) begin
                    if (rx_bskip[1] == 1'd1) begin
                        rx_bskip <= 2'b00;
                    end else if (rx_bskip[0] == 1'd1) begin
                        rx_bskip <= 2'b10;
                    end else if (rx_bstart == 1'd1) begin
                        rx_bskip <= 2'b01;
                    end
                end
            end else begin
                rx_bskip <= 2'b00;
            end
            if ((rx_dvalid == 1'd1) && (rx_bskip == 2'd0)) begin
                if ((rx_dstrobe[7] == 1'd1) && (rx_dstrobe_d[0] == 1'd0)) begin
                    rx_balign <= 3'd0;
                end else if (rx_dstrobe[7:6] == 2'd1) begin
                    rx_balign <= 3'd1;
                end else if (rx_dstrobe[6:5] == 2'd1) begin
                    rx_balign <= 3'd2;
                end else if (rx_dstrobe[5:4] == 2'd1) begin
                    rx_balign <= 3'd3;
                end else if (rx_dstrobe[4:3] == 2'd1) begin
                    rx_balign <= 3'd4;
                end else if (rx_dstrobe[3:2] == 2'd1) begin
                    rx_balign <= 3'd5;
                end else if (rx_dstrobe[2:1] == 2'd1) begin
                    rx_balign <= 3'd6;
                end else if (rx_dstrobe[1:0] == 2'd1) begin
                    rx_balign <= 3'd7;
                end
            end
        end
    end

    assign rx_bstart = (((rx_dstrobe[7] == 1'd1) && (rx_dstrobe_d[0] == 1'd0)) ||
        (rx_dstrobe[7:6] == 2'd1) || (rx_dstrobe[6:5] == 2'd1) ||
        (rx_dstrobe[5:4] == 2'd1) || (rx_dstrobe[4:3] == 2'd1) ||
        (rx_dstrobe[3:2] == 2'd1) || (rx_dstrobe[2:1] == 2'd1) ||
        (rx_dstrobe[1:0] == 2'd1)) ? rx_dvalid : 1'd0;

    // pipelined data

    always @(negedge rx_serdes_data_resetn or posedge rx_clk) begin
        if (rx_serdes_data_resetn == 1'b0) begin
            rx_dstrobe_d <= 8'd0;
            rx_ddata_0_d <= 8'd0;
            rx_ddata_1_d <= 8'd0;
            rx_ddata_2_d <= 8'd0;
            rx_ddata_3_d <= 8'd0;
        end else begin
            if (rx_dvalid == 1'b1) begin
                rx_dstrobe_d <= rx_dstrobe;
                rx_ddata_0_d <= rx_ddata_0;
                rx_ddata_1_d <= rx_ddata_1;
                rx_ddata_2_d <= rx_ddata_2;
                rx_ddata_3_d <= rx_ddata_3;
            end
        end
    end

    // sdr-ddr and sdr-clock-edge-select
 
    always @(negedge rx_serdes_data_resetn or posedge rx_clk) begin
        if (rx_serdes_data_resetn == 1'b0) begin
            rx_dtoggle <= 1'd0;
            rx_dvalid <= 1'b0;
            rx_dstrobe <= 8'd0;
            rx_ddata_0 <= 8'd0;
            rx_ddata_1 <= 8'd0;
            rx_ddata_2 <= 8'd0;
            rx_ddata_3 <= 8'd0;
        end else begin
            rx_dtoggle <= ~rx_dtoggle;
            if (rx_sdr1_ddr0 == 1'b0) begin
                rx_dvalid <= 1'b1;
                rx_dstrobe <= rx_pstrobe;
                rx_ddata_0 <= rx_pdata_0;
                rx_ddata_1 <= rx_pdata_1;
                rx_ddata_2 <= rx_pdata_2;
                rx_ddata_3 <= rx_pdata_3;
            end else if (rx_dtoggle == 1'b0) begin
                rx_dvalid <= 1'b0;
                rx_dstrobe[3:0] <= 4'd0;
                rx_ddata_0[3:0] <= 4'd0;
                rx_ddata_1[3:0] <= 4'd0;
                rx_ddata_2[3:0] <= 4'd0;
                rx_ddata_3[3:0] <= 4'd0;
                if (rx_fall1_rise0 == 1'b1) begin
                    rx_dstrobe[7] <= rx_pstrobe[6];
                    rx_dstrobe[6] <= rx_pstrobe[4];
                    rx_dstrobe[5] <= rx_pstrobe[2];
                    rx_dstrobe[4] <= rx_pstrobe[0];
                    rx_ddata_0[7] <= rx_pdata_0[6];
                    rx_ddata_0[6] <= rx_pdata_0[4];
                    rx_ddata_0[5] <= rx_pdata_0[2];
                    rx_ddata_0[4] <= rx_pdata_0[0];
                    rx_ddata_1[7] <= rx_pdata_1[6];
                    rx_ddata_1[6] <= rx_pdata_1[4];
                    rx_ddata_1[5] <= rx_pdata_1[2];
                    rx_ddata_1[4] <= rx_pdata_1[0];
                    rx_ddata_2[7] <= rx_pdata_2[6];
                    rx_ddata_2[6] <= rx_pdata_2[4];
                    rx_ddata_2[5] <= rx_pdata_2[2];
                    rx_ddata_2[4] <= rx_pdata_2[0];
                    rx_ddata_3[7] <= rx_pdata_3[6];
                    rx_ddata_3[6] <= rx_pdata_3[4];
                    rx_ddata_3[5] <= rx_pdata_3[2];
                    rx_ddata_3[4] <= rx_pdata_3[0];
                end else begin
                    rx_dstrobe[7] <= rx_pstrobe[7];
                    rx_dstrobe[6] <= rx_pstrobe[5];
                    rx_dstrobe[5] <= rx_pstrobe[3];
                    rx_dstrobe[4] <= rx_pstrobe[1];
                    rx_ddata_0[7] <= rx_pdata_0[7];
                    rx_ddata_0[6] <= rx_pdata_0[5];
                    rx_ddata_0[5] <= rx_pdata_0[3];
                    rx_ddata_0[4] <= rx_pdata_0[1];
                    rx_ddata_1[7] <= rx_pdata_1[7];
                    rx_ddata_1[6] <= rx_pdata_1[5];
                    rx_ddata_1[5] <= rx_pdata_1[3];
                    rx_ddata_1[4] <= rx_pdata_1[1];
                    rx_ddata_2[7] <= rx_pdata_2[7];
                    rx_ddata_2[6] <= rx_pdata_2[5];
                    rx_ddata_2[5] <= rx_pdata_2[3];
                    rx_ddata_2[4] <= rx_pdata_2[1];
                    rx_ddata_3[7] <= rx_pdata_3[7];
                    rx_ddata_3[6] <= rx_pdata_3[5];
                    rx_ddata_3[5] <= rx_pdata_3[3];
                    rx_ddata_3[4] <= rx_pdata_3[1];
                end
            end else begin
                rx_dvalid <= 1'b1;
                rx_dstrobe[7:4] <= rx_dstrobe[7:4];
                rx_ddata_0[7:4] <= rx_ddata_0[7:4];
                rx_ddata_1[7:4] <= rx_ddata_1[7:4];
                rx_ddata_2[7:4] <= rx_ddata_2[7:4];
                rx_ddata_3[7:4] <= rx_ddata_3[7:4];
                if (rx_fall1_rise0 == 1'b1) begin
                    rx_dstrobe[3] <= rx_pstrobe[6];
                    rx_dstrobe[2] <= rx_pstrobe[4];
                    rx_dstrobe[1] <= rx_pstrobe[2];
                    rx_dstrobe[0] <= rx_pstrobe[0];
                    rx_ddata_0[3] <= rx_pdata_0[6];
                    rx_ddata_0[2] <= rx_pdata_0[4];
                    rx_ddata_0[1] <= rx_pdata_0[2];
                    rx_ddata_0[0] <= rx_pdata_0[0];
                    rx_ddata_1[3] <= rx_pdata_1[6];
                    rx_ddata_1[2] <= rx_pdata_1[4];
                    rx_ddata_1[1] <= rx_pdata_1[2];
                    rx_ddata_1[0] <= rx_pdata_1[0];
                    rx_ddata_2[3] <= rx_pdata_2[6];
                    rx_ddata_2[2] <= rx_pdata_2[4];
                    rx_ddata_2[1] <= rx_pdata_2[2];
                    rx_ddata_2[0] <= rx_pdata_2[0];
                    rx_ddata_3[3] <= rx_pdata_3[6];
                    rx_ddata_3[2] <= rx_pdata_3[4];
                    rx_ddata_3[1] <= rx_pdata_3[2];
                    rx_ddata_3[0] <= rx_pdata_3[0];
                end else begin
                    rx_dstrobe[3] <= rx_pstrobe[7];
                    rx_dstrobe[2] <= rx_pstrobe[5];
                    rx_dstrobe[1] <= rx_pstrobe[3];
                    rx_dstrobe[0] <= rx_pstrobe[1];
                    rx_ddata_0[3] <= rx_pdata_0[7];
                    rx_ddata_0[2] <= rx_pdata_0[5];
                    rx_ddata_0[1] <= rx_pdata_0[3];
                    rx_ddata_0[0] <= rx_pdata_0[1];
                    rx_ddata_1[3] <= rx_pdata_1[7];
                    rx_ddata_1[2] <= rx_pdata_1[5];
                    rx_ddata_1[1] <= rx_pdata_1[3];
                    rx_ddata_1[0] <= rx_pdata_1[1];
                    rx_ddata_2[3] <= rx_pdata_2[7];
                    rx_ddata_2[2] <= rx_pdata_2[5];
                    rx_ddata_2[1] <= rx_pdata_2[3];
                    rx_ddata_2[0] <= rx_pdata_2[1];
                    rx_ddata_3[3] <= rx_pdata_3[7];
                    rx_ddata_3[2] <= rx_pdata_3[5];
                    rx_ddata_3[1] <= rx_pdata_3[3];
                    rx_ddata_3[0] <= rx_pdata_3[1];
                end
            end
        end
    end

    // serdes & data-path reset

    assign rx_dp_resetn_out = rx_dp_resetn_reg;

    always @(negedge rx_dp_resetn_int or posedge rx_clk) begin
        if (rx_dp_resetn_int == 1'd0) begin
            rx_dp_resetn_reg <= 'd0;
        end else begin
            if (rx_bstrobe != 0) begin
                rx_dp_resetn_reg <= 'd1;
            end
        end
    end

    assign rx_phy_resetn_out = rx_phy_resetn_reg;

    always @(negedge rx_phy_resetn_int or posedge rx_clk) begin
        if (rx_phy_resetn_int == 1'd0) begin
            rx_phy_resetn_reg <= 'd0;
        end else begin
            if (rx_pstrobe != 0) begin
                rx_phy_resetn_reg <= 'd1;
            end
        end
    end

    // mcs reset and its latency monitoring
 
    always @(negedge rx_serdes_data_resetn or posedge rx_clk) begin
        if (rx_serdes_data_resetn == 1'b0) begin
            rx_mcs_latency_busy <= 1'd1;
            rx_mcs_latency_count <= 16'd0;
            rx_mcs_latency_incr <= 4'd8;
        end else begin
            if ((rx_dvalid == 1'd1) && (rx_dstrobe != 8'd0)) begin
                rx_mcs_latency_busy <= 1'd0;
            end
            rx_mcs_latency_count <= rx_mcs_latency_count + rx_mcs_latency_incr;
            if (rx_mcs_latency_busy == 1'd0) begin
                rx_mcs_latency_incr <= 4'd0;
            end else if ((rx_dvalid == 1'd0) || (rx_dstrobe == 8'd0)) begin
                rx_mcs_latency_incr <= 4'd8;
            end else if (rx_dstrobe[7] == 1'd1) begin
                rx_mcs_latency_incr <= 4'd0;
            end else if (rx_dstrobe[6] == 1'd1) begin
                rx_mcs_latency_incr <= 4'd1;
            end else if (rx_dstrobe[5] == 1'd1) begin
                rx_mcs_latency_incr <= 4'd2;
            end else if (rx_dstrobe[4] == 1'd1) begin
                rx_mcs_latency_incr <= 4'd3;
            end else if (rx_dstrobe[3] == 1'd1) begin
                rx_mcs_latency_incr <= 4'd4;
            end else if (rx_dstrobe[2] == 1'd1) begin
                rx_mcs_latency_incr <= 4'd5;
            end else if (rx_dstrobe[1] == 1'd1) begin
                rx_mcs_latency_incr <= 4'd6;
            end else if (rx_dstrobe[0] == 1'd1) begin
                rx_mcs_latency_incr <= 4'd7;
            end
        end
    end

    // mcs monitoring (strobe)

    always @(negedge rx_serdes_data_resetn or posedge rx_clk) begin
        if (rx_serdes_data_resetn == 1'd0) begin
            rx_mcs_dcount <= 3'd0;
            rx_mcs_strobe <= 32'd0;
            rx_mcs_data <= 32'd0;
        end else begin
            if ((rx_mcs_dcount[2] == 1'd0) && (rx_dvalid == 1'd1) &&
                (rx_mcs_latency_busy == 1'd0)) begin
                rx_mcs_dcount <= rx_mcs_dcount + 1'd1;
            end
            if ((rx_dvalid == 1'd1) && (rx_mcs_dcount == 3'd0)) begin
                rx_mcs_strobe[31:24] <= rx_dstrobe;
                rx_mcs_data[31:24] <= rx_ddata_0;
            end
            if ((rx_dvalid == 1'd1) && (rx_mcs_dcount == 3'd1)) begin
                rx_mcs_strobe[23:16] <= rx_dstrobe;
                rx_mcs_data[23:16] <= rx_ddata_0;
            end
            if ((rx_dvalid == 1'd1) && (rx_mcs_dcount == 3'd2)) begin
                rx_mcs_strobe[15:8] <= rx_dstrobe;
                rx_mcs_data[15:8] <= rx_ddata_0;
            end
            if ((rx_dvalid == 1'd1) && (rx_mcs_dcount == 3'd3)) begin
                rx_mcs_strobe[7:0] <= rx_dstrobe;
                rx_mcs_data[7:0] <= rx_ddata_0;
            end
        end
    end

    // axilite delay unlocked
 
    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_delay_unlocked <= 1'd1;
        end else begin
            axilite_delay_unlocked <= ~axilite_delay_locked;
        end
    end

    // io buffers

    assign rx_gpio_in = (GPIO2_CMOS1_LVDS0 == 1) ? rx_cmos_gpio_in : rx_cssi_gpio_in;
    assign rx_cssi_gpio_out = rx_gpio_out;
    assign rx_cssi_gpio_enb = rx_gpio_enb;

    assign rx_cmos_gpio_in[6] = ((DEVICE_TYPE == "7SERIES") && (GPIO2_CMOS1_LVDS0 == 1)) ? rx_buf_clk : 1'd0;
    assign rx_cmos_gpio_in[7] = ((DEVICE_TYPE == "7SERIES") && (GPIO2_CMOS1_LVDS0 == 1)) ? rx_cssi_nc_lssi_clk_n : 1'd0;

    assign rx_strobe_p = ((GPIO2_CMOS1_LVDS0 == 1) && (PN_SWAP == 1)) ? rx_cssi_nc_lssi_strobe_n : rx_cssi_strobe_lssi_strobe_p;
    assign rx_strobe_n = ((GPIO2_CMOS1_LVDS0 == 1) && (PN_SWAP == 1)) ? rx_cssi_strobe_lssi_strobe_p : rx_cssi_nc_lssi_strobe_n;
    
    assign rx_data_p[0] = (GPIO2_CMOS1_LVDS0 == 0) ? rx_cssi_data1_lssi_data0_p : ((PN_SWAP == 1) ?
        rx_cssi_data1_lssi_data0_p : rx_cssi_data0_lssi_data0_n);
    assign rx_data_n[0] = (GPIO2_CMOS1_LVDS0 == 0) ? rx_cssi_data0_lssi_data0_n : 1'd0;
    assign rx_data_p[1] = (GPIO2_CMOS1_LVDS0 == 0) ? rx_cssi_data3_lssi_data1_p : ((PN_SWAP == 1) ?
        rx_cssi_data0_lssi_data0_n : rx_cssi_data1_lssi_data0_p);
    assign rx_data_n[1] = (GPIO2_CMOS1_LVDS0 == 0) ? rx_cssi_data2_lssi_data1_n : 1'd0;
    assign rx_data_p[2] = (GPIO2_CMOS1_LVDS0 == 0) ? 1'd0 : ((PN_SWAP == 1) ?
        rx_cssi_data3_lssi_data1_p : rx_cssi_data2_lssi_data1_n);
    assign rx_data_n[2] = (GPIO2_CMOS1_LVDS0 == 0) ? 1'd0 : 1'd0;
    assign rx_data_p[3] = (GPIO2_CMOS1_LVDS0 == 0) ? 1'd0 : ((PN_SWAP == 1) ?
        rx_cssi_data2_lssi_data1_n : rx_cssi_data3_lssi_data1_p);
    assign rx_data_n[3] = (GPIO2_CMOS1_LVDS0 == 0) ? 1'd0 : 1'd0;

    // instantiations

    axi_adrv9001_rx_ss i_orx_ss (
        .rx_clk                                 (rx_clk),
        .rx_resetn                              (rx_resetn),
        .rx_ss_enable                           (orx_ienable),
        .rx_ss_valid                            (rx_valid_int),
        .rx_ss_data                             (rx_data_int),
        .rx_ss_ratio                            (orx_ss_ratio),
        .rx_num_of_bits                         (rx_num_of_bits),
        .rx_sync                                (orx_sync),
        .rx_valid                               (orx_valid),
        .rx_data                                (orx_data));

    axi_adrv9001_rx_ss i_rx_ss (
        .rx_clk                                 (rx_clk),
        .rx_resetn                              (rx_resetn),
        .rx_ss_enable                           (rx_ienable),
        .rx_ss_valid                            (rx_valid_int),
        .rx_ss_data                             (rx_data_int),
        .rx_ss_ratio                            (rx_ss_ratio),
        .rx_num_of_bits                         (rx_num_of_bits),
        .rx_sync                                (rx_sync),
        .rx_valid                               (rx_valid),
        .rx_data                                (rx_data));

    axi_adrv9001_rx_dmon i_rx_dmon (
        .rx_clk                                 (rx_clk),
        .rx_resetn                              (rx_resetn),
        .rx_valid                               (rx_valid_int),
        .rx_data                                (rx_data_int),
        .rx_pattern                             (rx_pattern),
        .rx_data_sel                            (rx_data_sel),
        .rx_num_of_bits                         (rx_num_of_bits),
        .rx_mon_data                            (rx_mon_data),
        .rx_mon_oos                             (rx_mon_oos),
        .rx_mon_err                             (rx_mon_err));

    clk_mon i_rx_clk_mon (
        .clk                                    (rx_clk),
        .axilite_resetn                         (axilite_resetn),
        .axilite_clk                            (axilite_clk),
        .axilite_clk_mon_count                  (axilite_clk_mon_count));

    axi_adrv9001_rx_if #(
        .GPIO2_CMOS1_LVDS0                      (GPIO2_CMOS1_LVDS0),
        .PN_SWAP                                (PN_SWAP),
        .DEVICE_TYPE                            (DEVICE_TYPE),
        .IODELAY_GROUP                          (IODELAY_GROUP))
    i_rx_pdata_0 (
        .rx_resetn                              (rx_serdes_resetn),
        .rx_hs_clk                              (rx_hs_clk),
        .rx_clk                                 (rx_clk),
        .rx_align                               (1'd0),
        .rx_data_p                              (rx_data_p[0]),
        .rx_data_n                              (rx_data_n[0]),
        .rx_pdata                               (rx_pdata_0),
        .rx_gpio_in_p                           (rx_cmos_gpio_in[0]),
        .rx_gpio_in_n                           (),
        .rx_mcs_delay                           (rx_mcs_delay),
        .axilite_resetn                         (axilite_resetn),
        .axilite_clk                            (axilite_clk),
        .axilite_delay_wrdata                   (axilite_wrdelay_0),
        .axilite_delay_rddata                   (axilite_rddelay_0));

    axi_adrv9001_rx_if #(
        .GPIO2_CMOS1_LVDS0                      (GPIO2_CMOS1_LVDS0),
        .PN_SWAP                                (PN_SWAP),
        .DEVICE_TYPE                            (DEVICE_TYPE),
        .IODELAY_GROUP                          (IODELAY_GROUP))
    i_rx_pdata_1 (
        .rx_resetn                              (rx_serdes_resetn),
        .rx_hs_clk                              (rx_hs_clk),
        .rx_clk                                 (rx_clk),
        .rx_align                               (1'd0),
        .rx_data_p                              (rx_data_p[1]),
        .rx_data_n                              (rx_data_n[1]),
        .rx_pdata                               (rx_pdata_1),
        .rx_gpio_in_p                           (rx_cmos_gpio_in[1]),
        .rx_gpio_in_n                           (),
        .rx_mcs_delay                           (rx_mcs_delay),
        .axilite_resetn                         (axilite_resetn),
        .axilite_clk                            (axilite_clk),
        .axilite_delay_wrdata                   (axilite_wrdelay_1),
        .axilite_delay_rddata                   (axilite_rddelay_1));

    axi_adrv9001_rx_if #(
        .GPIO2_CMOS1_LVDS0                      (GPIO2_CMOS1),
        .PN_SWAP                                (PN_SWAP),
        .DEVICE_TYPE                            (DEVICE_TYPE),
        .IODELAY_GROUP                          (IODELAY_GROUP))
    i_rx_pdata_2 (
        .rx_resetn                              (rx_serdes_resetn),
        .rx_hs_clk                              (rx_hs_clk),
        .rx_clk                                 (rx_clk),
        .rx_align                               (1'd0),
        .rx_data_p                              (rx_data_p[2]),
        .rx_data_n                              (rx_data_n[2]),
        .rx_pdata                               (rx_pdata_2),
        .rx_gpio_in_p                           (rx_cmos_gpio_in[2]),
        .rx_gpio_in_n                           (),
        .rx_mcs_delay                           (rx_mcs_delay),
        .axilite_resetn                         (axilite_resetn),
        .axilite_clk                            (axilite_clk),
        .axilite_delay_wrdata                   (axilite_wrdelay_2),
        .axilite_delay_rddata                   (axilite_rddelay_2));

    axi_adrv9001_rx_if #(
        .GPIO2_CMOS1_LVDS0                      (GPIO2_CMOS1),
        .PN_SWAP                                (PN_SWAP),
        .DEVICE_TYPE                            (DEVICE_TYPE),
        .IODELAY_GROUP                          (IODELAY_GROUP))
    i_rx_pdata_3 (
        .rx_resetn                              (rx_serdes_resetn),
        .rx_hs_clk                              (rx_hs_clk),
        .rx_clk                                 (rx_clk),
        .rx_align                               (1'd0),
        .rx_data_p                              (rx_data_p[3]),
        .rx_data_n                              (rx_data_n[3]),
        .rx_pdata                               (rx_pdata_3),
        .rx_gpio_in_p                           (rx_cmos_gpio_in[3]),
        .rx_gpio_in_n                           (),
        .rx_mcs_delay                           (rx_mcs_delay),
        .axilite_resetn                         (axilite_resetn),
        .axilite_clk                            (axilite_clk),
        .axilite_delay_wrdata                   (axilite_wrdelay_3),
        .axilite_delay_rddata                   (axilite_rddelay_3));

    axi_adrv9001_rx_if #(
        .GPIO2_CMOS1_LVDS0                      (GPIO2_CMOS1_LVDS0),
        .PN_SWAP                                (PN_SWAP),
        .DEVICE_TYPE                            (DEVICE_TYPE),
        .IODELAY_GROUP                          (IODELAY_GROUP))
    i_rx_pstrobe (
        .rx_resetn                              (rx_serdes_resetn),
        .rx_hs_clk                              (rx_hs_clk),
        .rx_clk                                 (rx_clk),
        .rx_align                               (1'd0),
        .rx_data_p                              (rx_strobe_p),
        .rx_data_n                              (rx_strobe_n),
        .rx_pdata                               (rx_pstrobe),
        .rx_gpio_in_p                           (rx_cmos_gpio_in[4]),
        .rx_gpio_in_n                           (rx_cmos_gpio_in[5]),
        .rx_mcs_delay                           (rx_mcs_delay),
        .axilite_resetn                         (axilite_resetn),
        .axilite_clk                            (axilite_clk),
        .axilite_delay_wrdata                   (axilite_wrdelay_s),
        .axilite_delay_rddata                   (axilite_rddelay_s));

    axi_adrv9001_rst_cntrl #(
        .RESET_PIPE_LENGTH                      (RESET_PIPE_LENGTH))
    i_rx_rst_cntrl (
        .axilite_init_req                       (axilite_init_req),
        .axilite_clk_enb                        (axilite_clk_enb),
        .axilite_master_enable                  (axilite_rx_master_enable),
        .mcs_clk_resetn                         (mcs_clk_resetn),
        .mcs_phy_resetn                         (mcs_phy_resetn),
        .mcs_dp_resetn                          (mcs_dp_resetn),
        .clk_resetn_in                          (rx_clk_resetn_in),
        .phy_resetn_in                          (rx_phy_resetn_in),
        .dp_resetn_in                           (rx_dp_resetn_in),
        .clk_resetn_out                         (rx_clk_resetn_out),
        .phy_resetn_out                         (rx_phy_resetn_int),
        .dp_resetn_out                          (rx_dp_resetn_int),
        .rst_clk                                (rx_rst_clk),
        .clk_resetn                             (rx_clk_resetn),
        .clk                                    (rx_clk),
        .cdc_resetn                             (rx_cdc_resetn),
        .serdes_resetn                          (rx_serdes_resetn),
        .serdes_data_resetn                     (rx_serdes_data_resetn),
        .resetn                                 (rx_resetn),
        .init_ack                               (rx_init_ack));

    generate
    if (GPIO2_CMOS1_LVDS0 == 2) begin

    assign rx_clk_resetn_int = 1'd0;
    assign rx_clk = 1'd0;
    assign rx_hs_clk = 1'd0;
    assign rx_rst_clk = 1'd0;

    end else if (DEVICE_TYPE == "ULTRASCALE") begin

    FDCE #(
        .INIT                                   (1'd0))
    i_clk_resetn (
        .CE                                     (1'd1),
        .D                                      (1'd1),
        .C                                      (rx_rst_clk),
        .CLR                                    (~rx_clk_resetn),
        .Q                                      (rx_clk_resetn_int));

    BUFGCE_DIV #(
        .IS_CLR_INVERTED                        (1'd1),
        .BUFGCE_DIVIDE                          (4))
    i_clk (
        .CE                                     (axilite_clk_enb),
        .CLR                                    (rx_clk_resetn_int),
        .I                                      (rx_buf_clk),
        .O                                      (rx_clk));

    if (MATCH_CLOCKING == 1) begin

    BUFGCE_DIV #(
        .IS_CLR_INVERTED                        (1'd1),
        .BUFGCE_DIVIDE                          (1))
    i_hs_clk (
        .CE                                     (axilite_clk_enb),
        .CLR                                    (rx_clk_resetn_int),
        .I                                      (rx_buf_clk),
        .O                                      (rx_hs_clk));

    end else begin

    BUFGCE i_hs_clk (
        .CE                                     (axilite_clk_enb),
        .I                                      (rx_buf_clk),
        .O                                      (rx_hs_clk));

    end

    assign rx_rst_clk = rx_buf_clk;

    end else begin

    assign rx_clk_resetn_int = 1'd0;

    BUFR #(.BUFR_DIVIDE("4")) i_clk (
        .CE                                     (axilite_clk_enb),
        .CLR                                    (~rx_clk_resetn),
        .I                                      (rx_buf_clk),
        .O                                      (rx_clk));

    BUFIO i_hs_clk (
        .I                                      (rx_buf_clk),
        .O                                      (rx_hs_clk));

    assign rx_rst_clk = rx_buf_clk;

    end
    endgenerate

    generate
    if (GPIO2_CMOS1_LVDS0 == 0) begin

    IBUFDS i_rx_sclock (
        .I                                      (rx_cssi_clk_lssi_clk_p),
        .IB                                     (rx_cssi_nc_lssi_clk_n),
        .O                                      (rx_buf_clk));

    end else if (GPIO2_CMOS1_LVDS0 == 1) begin

    IBUF i_rx_sclock (
        .I                                      (rx_cssi_clk_lssi_clk_p),
        .O                                      (rx_buf_clk));

    end else begin

    assign rx_buf_clk = 1'd0;

    end
    endgenerate

    generate
    if (IODELAY_CTRL_ENABLE == 0) begin

    assign delay_locked = 1'b1;

    end else if (DEVICE_TYPE == "ULTRASCALE") begin

    (* IODELAY_GROUP = IODELAY_GROUP *)
    IDELAYCTRL #(.SIM_DEVICE("ULTRASCALE")) i_delay_ctrl (
        .RST                                    (~sys_delay_resetn),
        .REFCLK                                 (sys_delay_clk),
        .RDY                                    (delay_locked));

    end else begin

    (* IODELAY_GROUP = IODELAY_GROUP *)
    IDELAYCTRL i_delay_ctrl (
        .RST                                    (~sys_delay_resetn),
        .REFCLK                                 (sys_delay_clk),
        .RDY                                    (delay_locked));

    end
    endgenerate

    cdc_cntrl #(.DATA_WIDTH(89)) i_rx_cdc_cntrl (
        .src_resetn                             (axilite_resetn),
        .src_clk                                (axilite_clk),
        .src_data                               ({axilite_data_sel,
                                                    axilite_align_sel,
                                                    axilite_pattern,
                                                    axilite_mcs_delay,
                                                    axilite_rx_ss_ratio,
                                                    axilite_orx_ss_ratio,
                                                    axilite_rx_master_enable,
                                                    axilite_orx_master_enable,
                                                    axilite_fall1_rise0,
                                                    axilite_q1_i0,
                                                    axilite_lsb1_msb0,
                                                    axilite_sdr1_ddr0,
                                                    axilite_mlane1_slane0,
                                                    axilite_lstrb1_pstrb0,
                                                    axilite_num_of_bits}),
        .dest_resetn                            (rx_cdc_resetn),
        .dest_clk                               (rx_clk),
        .dest_data                              ({rx_data_sel,
                                                    rx_align_sel,
                                                    rx_pattern,
                                                    rx_mcs_delay,
                                                    rx_ss_ratio,
                                                    orx_ss_ratio,
                                                    rx_master_enable,
                                                    orx_master_enable,
                                                    rx_fall1_rise0,
                                                    rx_q1_i0,
                                                    rx_lsb1_msb0,
                                                    rx_sdr1_ddr0,
                                                    rx_mlane1_slane0,
                                                    rx_lstrb1_pstrb0,
                                                    rx_num_of_bits}));

    cdc_cntrl #(.DATA_WIDTH(211)) i_axilite_cdc_cntrl (
        .src_resetn                             (rx_cdc_resetn),
        .src_clk                                (rx_clk),
        .src_data                               ({rx_frm_oos,
                                                    rx_mon_oos,
                                                    rx_mon_data,
                                                    rx_mcs_bstrobe,
                                                    rx_mcs_bdata,
                                                    rx_mcs_strobe,
                                                    rx_mcs_data,
                                                    rx_mcs_latency_busy,
                                                    rx_mcs_latency_count}),
        .dest_resetn                            (axilite_resetn),
        .dest_clk                               (axilite_clk),
        .dest_data                              ({axilite_frm_oos,
                                                    axilite_mon_oos,
                                                    axilite_mon_data,
                                                    axilite_mcs_bstrobe,
                                                    axilite_mcs_bdata,
                                                    axilite_mcs_strobe,
                                                    axilite_mcs_data,
                                                    axilite_mcs_latency_busy,
                                                    axilite_mcs_latency_count}));

    cdc_event #(.DATA_WIDTH(3)) i_axilite_cdc_event (
        .src_resetn                             (rx_cdc_resetn),
        .src_clk                                (rx_clk),
        .src_data                               ({rx_init_ack,
                                                    rx_mon_err,
                                                    rx_frm_err}),
        .dest_resetn                            (axilite_resetn),
        .dest_clk                               (axilite_clk),
        .dest_data                              ({axilite_init_ack,
                                                    axilite_mon_err,
                                                    axilite_frm_err}));

    cdc #(.DATA_WIDTH(1)) i_axilite_cdc (
        .src_data                               (delay_locked),
        .dest_resetn                            (axilite_resetn),
        .dest_clk                               (axilite_clk),
        .dest_data                              (axilite_delay_locked));

    axi_adrv9001_ssi_regs #(.ID(ID)) i_rx_regs (
        .axilite_cmos_lvds_id                   (axilite_cmos_lvds_id),
        .axilite_num_of_bits                    (axilite_num_of_bits),
        .axilite_lstrb1_pstrb0                  (axilite_lstrb1_pstrb0),
        .axilite_mlane1_slane0                  (axilite_mlane1_slane0),
        .axilite_sdr1_ddr0                      (axilite_sdr1_ddr0),
        .axilite_lsb1_msb0                      (axilite_lsb1_msb0),
        .axilite_q1_i0                          (axilite_q1_i0),
        .axilite_fall1_rise0                    (axilite_fall1_rise0),
        .axilite_cmos1_lvds0                    (axilite_cmos1_lvds0),
        .axilite_clk_sel                        (),
        .axilite_clk_msb                        (),
        .axilite_clk_enb                        (axilite_clk_enb),
        .axilite_buf_enable                     (),
        .axilite_init                           (axilite_init_req),
        .axilite_init_clr                       (axilite_init_ack),
        .axilite_ss_ratio                       (axilite_rx_ss_ratio),
        .axilite_obs_ss_ratio                   (axilite_orx_ss_ratio),
        .axilite_ss_mode                        (),
        .axilite_data_sel                       (axilite_data_sel),
        .axilite_data_pat_0                     (axilite_pattern[31:0]),
        .axilite_data_pat_1                     (axilite_pattern[63:32]),
        .axilite_data_0                         (axilite_mon_data[31:0]),
        .axilite_data_1                         (axilite_mon_data[63:32]),
        .axilite_frm_oos                        (axilite_frm_oos),
        .axilite_intr_frm_oos                   (axilite_intr_status[0]),
        .axilite_frm_err                        (axilite_frm_err),
        .axilite_intr_frm_err                   (axilite_intr_status[1]),
        .axilite_mon_oos                        (axilite_mon_oos),
        .axilite_intr_mon_oos                   (axilite_intr_status[2]),
        .axilite_mon_err                        (axilite_mon_err),
        .axilite_intr_mon_err                   (axilite_intr_status[3]),
        .axilite_lb_ovf                         ('d0),
        .axilite_intr_lb_ovf                    (),
        .axilite_lb_unf                         ('d0),
        .axilite_intr_lb_unf                    (),
        .axilite_align_sel                      (axilite_align_sel),
        .axilite_delay_unlocked                 (axilite_delay_unlocked),
        .axilite_wrdelay_00                     (axilite_wrdelay_0),
        .axilite_rddelay_00                     (axilite_rddelay_0),
        .axilite_wrdelay_01                     (axilite_wrdelay_1),
        .axilite_rddelay_01                     (axilite_rddelay_1),
        .axilite_wrdelay_02                     (axilite_wrdelay_2),
        .axilite_rddelay_02                     (axilite_rddelay_2),
        .axilite_wrdelay_03                     (axilite_wrdelay_3),
        .axilite_rddelay_03                     (axilite_rddelay_3),
        .axilite_wrdelay_04                     (axilite_wrdelay_s),
        .axilite_rddelay_04                     (axilite_rddelay_s),
        .axilite_wrdelay_05                     (),
        .axilite_rddelay_05                     (5'd0),
        .axilite_wrdelay_06                     (),
        .axilite_rddelay_06                     (5'd0),
        .axilite_wrdelay_07                     (),
        .axilite_rddelay_07                     (5'd0),
        .axilite_delay_sweep                    (),
        .axilite_timer                          (),
        .axilite_clk_mon_count                  (axilite_clk_mon_count),
        .axilite_mcs_latency_count              (axilite_mcs_latency_count),
        .axilite_mcs_latency_busy               (axilite_mcs_latency_busy),
        .axilite_mcs_delay_count                (axilite_mcs_delay),
        .axilite_mcs_strobe                     (axilite_mcs_strobe),
        .axilite_mcs_data                       (axilite_mcs_data),
        .axilite_mcs_bstrobe                    (axilite_mcs_bstrobe),
        .axilite_mcs_bdata                      (axilite_mcs_bdata),
        .axilite_data_pat_pulse                 (),
        .axilite_data_pat_start                 (),
        .axilite_data_pat_start_clr             ('d0),
        .axilite_data_pat_latency               ('d0),
        .axilite_master_enable                  (axilite_rx_master_enable),
        .axilite_obs_master_enable              (axilite_orx_master_enable),
        .axilite_intr_frm_oos_enable            (axilite_intr_enable[0]),
        .axilite_intr_frm_err_enable            (axilite_intr_enable[1]),
        .axilite_intr_mon_oos_enable            (axilite_intr_enable[2]),
        .axilite_intr_mon_err_enable            (axilite_intr_enable[3]),
        .axilite_intr_lb_ovf_enable             (),
        .axilite_intr_lb_unf_enable             (),
        .axilite_clk                            (axilite_clk),
        .axilite_resetn                         (axilite_resetn),
        .axilite_wrreq                          (axilite_wrreq),
        .axilite_wraddr                         (axilite_wraddr),
        .axilite_wrdata                         (axilite_wrdata),
        .axilite_wrack                          (axilite_wrack),
        .axilite_rdreq                          (axilite_rdreq),
        .axilite_rdaddr                         (axilite_rdaddr),
        .axilite_rddata                         (axilite_rddata),
        .axilite_rdack                          (axilite_rdack));

endmodule

// **********************************************************************************
// **********************************************************************************
