// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Description:       Auto generated, local modifications are discouraged.
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module axi_adrv9001_gpio_regs  #(parameter [3:0] ID = 0) (

    output  reg   [31:0]    axilite_timer = 'd0,
    input   wire  [11:0]    axilite_dgpio_pio_data,
    output  reg   [11:0]    axilite_dgpio_pio_data_out = 'd0,
    output  reg   [11:0]    axilite_dgpio_pio_data_out_enb = 'd0,
    output  reg   [11:0]    axilite_dgpio_pio_data_mode = 'd0,
    output  reg   [ 3:0]    axilite_dgpio_pio_sel_00 = 'd0,
    output  reg   [ 3:0]    axilite_dgpio_pio_sel_01 = 'd0,
    output  reg   [ 3:0]    axilite_dgpio_pio_sel_02 = 'd0,
    output  reg   [ 3:0]    axilite_dgpio_pio_sel_03 = 'd0,
    output  reg   [ 3:0]    axilite_dgpio_pio_sel_04 = 'd0,
    output  reg   [ 3:0]    axilite_dgpio_pio_sel_05 = 'd0,
    output  reg   [ 3:0]    axilite_dgpio_pio_sel_06 = 'd0,
    output  reg   [ 3:0]    axilite_dgpio_pio_sel_07 = 'd0,
    output  reg   [ 3:0]    axilite_dgpio_pio_sel_08 = 'd0,
    output  reg   [ 3:0]    axilite_dgpio_pio_sel_09 = 'd0,
    output  reg   [ 3:0]    axilite_dgpio_pio_sel_10 = 'd0,
    output  reg   [ 3:0]    axilite_dgpio_pio_sel_11 = 'd0,
    output  reg             axilite_dgpio_pio_buf_enable = 'd0,
    output  reg             axilite_dgpio_pio_buf_data_wr = 'd0,
    output  reg   [11:0]    axilite_dgpio_pio_buf_data_data = 'd0,
    output  reg   [11:0]    axilite_dgpio_pio_buf_mode = 'd0,
    input   wire            axilite_dgpio_pio_buf_full,
    input   wire            axilite_dgpio_pio_buf_empty,
    output  reg   [ 1:0]    axilite_dgpio_pio_buf_trigger_mode_0 = 'd0,
    output  reg   [ 1:0]    axilite_dgpio_pio_buf_trigger_mode_1 = 'd0,
    output  reg   [ 1:0]    axilite_dgpio_pio_buf_trigger_mode_2 = 'd0,
    output  reg   [ 1:0]    axilite_dgpio_pio_buf_trigger_mode_3 = 'd0,
    output  reg   [ 1:0]    axilite_dgpio_pio_buf_trigger_mode_4 = 'd0,
    input   wire  [ 7:0]    axilite_rx0_pio_data,
    output  reg   [ 7:0]    axilite_rx0_pio_data_out = 'd0,
    output  reg   [ 7:0]    axilite_rx0_pio_data_out_enb = 'd0,
    input   wire  [ 7:0]    axilite_rx1_pio_data,
    output  reg   [ 7:0]    axilite_rx1_pio_data_out = 'd0,
    output  reg   [ 7:0]    axilite_rx1_pio_data_out_enb = 'd0,
    input   wire  [ 9:0]    axilite_tx0_pio_data,
    output  reg   [ 9:0]    axilite_tx0_pio_data_out = 'd0,
    output  reg   [ 9:0]    axilite_tx0_pio_data_out_enb = 'd0,
    input   wire  [ 9:0]    axilite_tx1_pio_data,
    output  reg   [ 9:0]    axilite_tx1_pio_data_out = 'd0,
    output  reg   [ 9:0]    axilite_tx1_pio_data_out_enb = 'd0,
    output  reg   [ 2:0]    axilite_trig_src_group = 'd0,
    output  reg   [ 3:0]    axilite_trig_src_pin = 'd0,
    output  reg   [ 2:0]    axilite_gainindex_src_group = 'd0,
    output  reg   [ 3:0]    axilite_gainindex_00_src_pin = 'd0,
    output  reg   [ 3:0]    axilite_gainindex_01_src_pin = 'd0,
    output  reg   [ 3:0]    axilite_gainindex_02_src_pin = 'd0,
    output  reg   [ 3:0]    axilite_gainindex_03_src_pin = 'd0,
    output  reg   [ 3:0]    axilite_gainindex_04_src_pin = 'd0,
    output  reg   [ 3:0]    axilite_gainindex_05_src_pin = 'd0,
    output  reg   [ 3:0]    axilite_gainindex_06_src_pin = 'd0,
    output  reg   [ 3:0]    axilite_gainindex_07_src_pin = 'd0,
    input   wire  [31:0]    axilite_clk_mon_count,
    output  reg   [ 3:0]    axilite_sspi_ssn0_sel = 'd0,
    output  reg   [ 3:0]    axilite_sspi_ssn1_sel = 'd0,
    output  reg   [ 3:0]    axilite_sspi_ssn2_sel = 'd0,
    output  reg   [ 3:0]    axilite_sspi_ssn3_sel = 'd0,
    output  reg   [ 3:0]    axilite_sspi_bidir_count = 'd0,
    output  reg             axilite_sspi_bidir_enable = 'd0,
    output  reg             axilite_sspi_miso_edge_sel = 'd0,
    output  reg             axilite_sspi_mosi_edge_sel = 'd0,
    input   wire            axilite_sspi_mosi_full,
    input   wire            axilite_sspi_mosi_empty,
    input   wire            axilite_sspi_miso_full,
    input   wire            axilite_sspi_miso_empty,
    input   wire  [ 3:0]    axilite_sspi_ss,
    output  wire  [ 3:0]    axilite_intr_sspi_ss,
    output  reg             axilite_sspi_mosi_data_rd = 'd0,
    input   wire  [ 7:0]    axilite_sspi_mosi_data_data,
    output  reg             axilite_sspi_miso_data_wr = 'd0,
    output  reg   [ 7:0]    axilite_sspi_miso_data_data = 'd0,
    output  reg             axilite_sspi_swreset = 'd0,
    input   wire            axilite_sspi_swreset_clr,
    output  reg             axilite_sspi_enable = 'd0,

    input   wire            axilite_clk,
    input   wire            axilite_resetn,
    input   wire            axilite_wrreq,
    input   wire  [15:0]    axilite_wraddr,
    input   wire  [31:0]    axilite_wrdata,
    output  reg             axilite_wrack = 'd0,
    input   wire            axilite_rdreq,
    input   wire  [15:0]    axilite_rdaddr,
    output  reg   [31:0]    axilite_rddata = 'd0,
    output  reg             axilite_rdack = 'd0);

    reg           [ 3:0]    axilite_sspi_ss_w1c = 'd0;
    reg                     axilite_sspi_swreset_clr_d = 'd0;

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_wrack <= 'd0;
            axilite_rdack <= 'd0;
        end else begin
            if (axilite_wraddr[15:12] == ID) begin
                axilite_wrack <= axilite_wrreq;
            end else begin
                axilite_wrack <= 1'd0;
            end
            if (axilite_rdaddr[15:12] == ID) begin
                axilite_rdack <= axilite_rdreq;
            end else begin
                axilite_rdack <= 1'd0;
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_timer <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h0)) begin
                axilite_timer <= axilite_wrdata;
            end else if (axilite_timer > 0) begin
                axilite_timer <= axilite_timer - 1'b1;
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_dgpio_pio_data_out <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h104)) begin
                axilite_dgpio_pio_data_out <= axilite_wrdata[11:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_dgpio_pio_data_out_enb <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h108)) begin
                axilite_dgpio_pio_data_out_enb <= axilite_wrdata[11:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_dgpio_pio_data_mode <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h10c)) begin
                axilite_dgpio_pio_data_mode <= axilite_wrdata[11:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_dgpio_pio_sel_00 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h110)) begin
                axilite_dgpio_pio_sel_00 <= axilite_wrdata[3:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_dgpio_pio_sel_01 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h114)) begin
                axilite_dgpio_pio_sel_01 <= axilite_wrdata[3:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_dgpio_pio_sel_02 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h118)) begin
                axilite_dgpio_pio_sel_02 <= axilite_wrdata[3:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_dgpio_pio_sel_03 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h11c)) begin
                axilite_dgpio_pio_sel_03 <= axilite_wrdata[3:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_dgpio_pio_sel_04 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h120)) begin
                axilite_dgpio_pio_sel_04 <= axilite_wrdata[3:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_dgpio_pio_sel_05 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h124)) begin
                axilite_dgpio_pio_sel_05 <= axilite_wrdata[3:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_dgpio_pio_sel_06 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h128)) begin
                axilite_dgpio_pio_sel_06 <= axilite_wrdata[3:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_dgpio_pio_sel_07 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h12c)) begin
                axilite_dgpio_pio_sel_07 <= axilite_wrdata[3:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_dgpio_pio_sel_08 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h130)) begin
                axilite_dgpio_pio_sel_08 <= axilite_wrdata[3:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_dgpio_pio_sel_09 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h134)) begin
                axilite_dgpio_pio_sel_09 <= axilite_wrdata[3:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_dgpio_pio_sel_10 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h138)) begin
                axilite_dgpio_pio_sel_10 <= axilite_wrdata[3:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_dgpio_pio_sel_11 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h13c)) begin
                axilite_dgpio_pio_sel_11 <= axilite_wrdata[3:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_dgpio_pio_buf_enable <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h180)) begin
                axilite_dgpio_pio_buf_enable <= axilite_wrdata[0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_dgpio_pio_buf_data_wr <= 'd0;
            axilite_dgpio_pio_buf_data_data <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h184)) begin
                axilite_dgpio_pio_buf_data_wr <= 1'd1;
                axilite_dgpio_pio_buf_data_data <= axilite_wrdata[11:0];
            end else begin
                axilite_dgpio_pio_buf_data_wr <= 1'd0;
                axilite_dgpio_pio_buf_data_data <= axilite_dgpio_pio_buf_data_data;
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_dgpio_pio_buf_mode <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h18c)) begin
                axilite_dgpio_pio_buf_mode <= axilite_wrdata[11:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_dgpio_pio_buf_trigger_mode_0 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h1c0)) begin
                axilite_dgpio_pio_buf_trigger_mode_0 <= axilite_wrdata[1:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_dgpio_pio_buf_trigger_mode_1 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h1c0)) begin
                axilite_dgpio_pio_buf_trigger_mode_1 <= axilite_wrdata[3:2];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_dgpio_pio_buf_trigger_mode_2 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h1c0)) begin
                axilite_dgpio_pio_buf_trigger_mode_2 <= axilite_wrdata[5:4];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_dgpio_pio_buf_trigger_mode_3 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h1c0)) begin
                axilite_dgpio_pio_buf_trigger_mode_3 <= axilite_wrdata[7:6];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_dgpio_pio_buf_trigger_mode_4 <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h1c0)) begin
                axilite_dgpio_pio_buf_trigger_mode_4 <= axilite_wrdata[9:8];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_rx0_pio_data_out <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h204)) begin
                axilite_rx0_pio_data_out <= axilite_wrdata[7:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_rx0_pio_data_out_enb <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h208)) begin
                axilite_rx0_pio_data_out_enb <= axilite_wrdata[7:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_rx1_pio_data_out <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h304)) begin
                axilite_rx1_pio_data_out <= axilite_wrdata[7:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_rx1_pio_data_out_enb <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h308)) begin
                axilite_rx1_pio_data_out_enb <= axilite_wrdata[7:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_tx0_pio_data_out <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h404)) begin
                axilite_tx0_pio_data_out <= axilite_wrdata[9:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_tx0_pio_data_out_enb <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h408)) begin
                axilite_tx0_pio_data_out_enb <= axilite_wrdata[9:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_tx1_pio_data_out <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h504)) begin
                axilite_tx1_pio_data_out <= axilite_wrdata[9:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_tx1_pio_data_out_enb <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h508)) begin
                axilite_tx1_pio_data_out_enb <= axilite_wrdata[9:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_trig_src_group <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h600)) begin
                axilite_trig_src_group <= axilite_wrdata[2:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_trig_src_pin <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h604)) begin
                axilite_trig_src_pin <= axilite_wrdata[3:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_gainindex_src_group <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h700)) begin
                axilite_gainindex_src_group <= axilite_wrdata[2:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_gainindex_00_src_pin <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h704)) begin
                axilite_gainindex_00_src_pin <= axilite_wrdata[3:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_gainindex_01_src_pin <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h708)) begin
                axilite_gainindex_01_src_pin <= axilite_wrdata[3:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_gainindex_02_src_pin <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h70c)) begin
                axilite_gainindex_02_src_pin <= axilite_wrdata[3:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_gainindex_03_src_pin <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h710)) begin
                axilite_gainindex_03_src_pin <= axilite_wrdata[3:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_gainindex_04_src_pin <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h714)) begin
                axilite_gainindex_04_src_pin <= axilite_wrdata[3:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_gainindex_05_src_pin <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h718)) begin
                axilite_gainindex_05_src_pin <= axilite_wrdata[3:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_gainindex_06_src_pin <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h71c)) begin
                axilite_gainindex_06_src_pin <= axilite_wrdata[3:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_gainindex_07_src_pin <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h720)) begin
                axilite_gainindex_07_src_pin <= axilite_wrdata[3:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_sspi_ssn0_sel <= 'hf;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h900)) begin
                axilite_sspi_ssn0_sel <= axilite_wrdata[3:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_sspi_ssn1_sel <= 'hf;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h900)) begin
                axilite_sspi_ssn1_sel <= axilite_wrdata[7:4];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_sspi_ssn2_sel <= 'hf;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h900)) begin
                axilite_sspi_ssn2_sel <= axilite_wrdata[11:8];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_sspi_ssn3_sel <= 'hf;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h900)) begin
                axilite_sspi_ssn3_sel <= axilite_wrdata[15:12];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_sspi_bidir_count <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h904)) begin
                axilite_sspi_bidir_count <= axilite_wrdata[3:0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_sspi_bidir_enable <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h904)) begin
                axilite_sspi_bidir_enable <= axilite_wrdata[4];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_sspi_miso_edge_sel <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h904)) begin
                axilite_sspi_miso_edge_sel <= axilite_wrdata[5];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_sspi_mosi_edge_sel <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h904)) begin
                axilite_sspi_mosi_edge_sel <= axilite_wrdata[6];
            end
        end
    end

    assign axilite_intr_sspi_ss = axilite_sspi_ss_w1c;

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_sspi_ss_w1c <= 'h0;
        end else begin
            if (axilite_sspi_ss[0] == 1'b1) begin
                axilite_sspi_ss_w1c[0] <= 1'b1;
            end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h90c)) begin
                axilite_sspi_ss_w1c[0] <= axilite_sspi_ss_w1c[0] & ~axilite_wrdata[0];
            end
            if (axilite_sspi_ss[1] == 1'b1) begin
                axilite_sspi_ss_w1c[1] <= 1'b1;
            end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h90c)) begin
                axilite_sspi_ss_w1c[1] <= axilite_sspi_ss_w1c[1] & ~axilite_wrdata[1];
            end
            if (axilite_sspi_ss[2] == 1'b1) begin
                axilite_sspi_ss_w1c[2] <= 1'b1;
            end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h90c)) begin
                axilite_sspi_ss_w1c[2] <= axilite_sspi_ss_w1c[2] & ~axilite_wrdata[2];
            end
            if (axilite_sspi_ss[3] == 1'b1) begin
                axilite_sspi_ss_w1c[3] <= 1'b1;
            end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h90c)) begin
                axilite_sspi_ss_w1c[3] <= axilite_sspi_ss_w1c[3] & ~axilite_wrdata[3];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_sspi_mosi_data_rd <= 'd0;
        end else begin
            if ((axilite_rdreq == 1'b1) && (axilite_rdaddr[15:12] == ID) && (axilite_rdaddr[11:0] == 'h910)) begin
                axilite_sspi_mosi_data_rd <= 1'd1;
            end else begin
                axilite_sspi_mosi_data_rd <= 1'd0;
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_sspi_miso_data_wr <= 'd0;
            axilite_sspi_miso_data_data <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h914)) begin
                axilite_sspi_miso_data_wr <= 1'd1;
                axilite_sspi_miso_data_data <= axilite_wrdata[7:0];
            end else begin
                axilite_sspi_miso_data_wr <= 1'd0;
                axilite_sspi_miso_data_data <= axilite_sspi_miso_data_data;
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_sspi_swreset_clr_d <= 'd0;
            axilite_sspi_swreset <= 'h0;
        end else begin
            axilite_sspi_swreset_clr_d <= axilite_sspi_swreset_clr;
            if ((axilite_sspi_swreset_clr_d == 1'b0) && (axilite_sspi_swreset_clr == 1'b1)) begin
                axilite_sspi_swreset <= 1'b0;
            end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h920)) begin
                axilite_sspi_swreset <= axilite_sspi_swreset | axilite_wrdata[0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_sspi_enable <= 'h0;
        end else begin
            if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h924)) begin
                axilite_sspi_enable <= axilite_wrdata[0];
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_rddata <= 'd0;
        end else begin
            if ((axilite_rdreq == 1'b1) && (axilite_rdaddr[15:12] == ID)) begin
                case (axilite_rdaddr[11:0])
                    'h0: begin
                        axilite_rddata <= axilite_timer;
                    end
                    'h100: begin
                        axilite_rddata[11:0] <= axilite_dgpio_pio_data;
                        axilite_rddata[31:12] <= 'd0;
                    end
                    'h104: begin
                        axilite_rddata[11:0] <= axilite_dgpio_pio_data_out;
                        axilite_rddata[31:12] <= 'd0;
                    end
                    'h108: begin
                        axilite_rddata[11:0] <= axilite_dgpio_pio_data_out_enb;
                        axilite_rddata[31:12] <= 'd0;
                    end
                    'h10c: begin
                        axilite_rddata[11:0] <= axilite_dgpio_pio_data_mode;
                        axilite_rddata[31:12] <= 'd0;
                    end
                    'h110: begin
                        axilite_rddata[3:0] <= axilite_dgpio_pio_sel_00;
                        axilite_rddata[31:4] <= 'd0;
                    end
                    'h114: begin
                        axilite_rddata[3:0] <= axilite_dgpio_pio_sel_01;
                        axilite_rddata[31:4] <= 'd0;
                    end
                    'h118: begin
                        axilite_rddata[3:0] <= axilite_dgpio_pio_sel_02;
                        axilite_rddata[31:4] <= 'd0;
                    end
                    'h11c: begin
                        axilite_rddata[3:0] <= axilite_dgpio_pio_sel_03;
                        axilite_rddata[31:4] <= 'd0;
                    end
                    'h120: begin
                        axilite_rddata[3:0] <= axilite_dgpio_pio_sel_04;
                        axilite_rddata[31:4] <= 'd0;
                    end
                    'h124: begin
                        axilite_rddata[3:0] <= axilite_dgpio_pio_sel_05;
                        axilite_rddata[31:4] <= 'd0;
                    end
                    'h128: begin
                        axilite_rddata[3:0] <= axilite_dgpio_pio_sel_06;
                        axilite_rddata[31:4] <= 'd0;
                    end
                    'h12c: begin
                        axilite_rddata[3:0] <= axilite_dgpio_pio_sel_07;
                        axilite_rddata[31:4] <= 'd0;
                    end
                    'h130: begin
                        axilite_rddata[3:0] <= axilite_dgpio_pio_sel_08;
                        axilite_rddata[31:4] <= 'd0;
                    end
                    'h134: begin
                        axilite_rddata[3:0] <= axilite_dgpio_pio_sel_09;
                        axilite_rddata[31:4] <= 'd0;
                    end
                    'h138: begin
                        axilite_rddata[3:0] <= axilite_dgpio_pio_sel_10;
                        axilite_rddata[31:4] <= 'd0;
                    end
                    'h13c: begin
                        axilite_rddata[3:0] <= axilite_dgpio_pio_sel_11;
                        axilite_rddata[31:4] <= 'd0;
                    end
                    'h180: begin
                        axilite_rddata[0] <= axilite_dgpio_pio_buf_enable;
                        axilite_rddata[31:1] <= 'd0;
                    end
                    'h184: begin
                        axilite_rddata[11:0] <= axilite_dgpio_pio_buf_data_data;
                        axilite_rddata[31:12] <= 'd0;
                    end
                    'h18c: begin
                        axilite_rddata[11:0] <= axilite_dgpio_pio_buf_mode;
                        axilite_rddata[31:12] <= 'd0;
                    end
                    'h1a0: begin
                        axilite_rddata[0] <= axilite_dgpio_pio_buf_full;
                        axilite_rddata[1] <= axilite_dgpio_pio_buf_empty;
                        axilite_rddata[31:2] <= 'd0;
                    end
                    'h1c0: begin
                        axilite_rddata[1:0] <= axilite_dgpio_pio_buf_trigger_mode_0;
                        axilite_rddata[3:2] <= axilite_dgpio_pio_buf_trigger_mode_1;
                        axilite_rddata[5:4] <= axilite_dgpio_pio_buf_trigger_mode_2;
                        axilite_rddata[7:6] <= axilite_dgpio_pio_buf_trigger_mode_3;
                        axilite_rddata[9:8] <= axilite_dgpio_pio_buf_trigger_mode_4;
                        axilite_rddata[31:10] <= 'd0;
                    end
                    'h200: begin
                        axilite_rddata[7:0] <= axilite_rx0_pio_data;
                        axilite_rddata[31:8] <= 'd0;
                    end
                    'h204: begin
                        axilite_rddata[7:0] <= axilite_rx0_pio_data_out;
                        axilite_rddata[31:8] <= 'd0;
                    end
                    'h208: begin
                        axilite_rddata[7:0] <= axilite_rx0_pio_data_out_enb;
                        axilite_rddata[31:8] <= 'd0;
                    end
                    'h300: begin
                        axilite_rddata[7:0] <= axilite_rx1_pio_data;
                        axilite_rddata[31:8] <= 'd0;
                    end
                    'h304: begin
                        axilite_rddata[7:0] <= axilite_rx1_pio_data_out;
                        axilite_rddata[31:8] <= 'd0;
                    end
                    'h308: begin
                        axilite_rddata[7:0] <= axilite_rx1_pio_data_out_enb;
                        axilite_rddata[31:8] <= 'd0;
                    end
                    'h400: begin
                        axilite_rddata[9:0] <= axilite_tx0_pio_data;
                        axilite_rddata[31:10] <= 'd0;
                    end
                    'h404: begin
                        axilite_rddata[9:0] <= axilite_tx0_pio_data_out;
                        axilite_rddata[31:10] <= 'd0;
                    end
                    'h408: begin
                        axilite_rddata[9:0] <= axilite_tx0_pio_data_out_enb;
                        axilite_rddata[31:10] <= 'd0;
                    end
                    'h500: begin
                        axilite_rddata[9:0] <= axilite_tx1_pio_data;
                        axilite_rddata[31:10] <= 'd0;
                    end
                    'h504: begin
                        axilite_rddata[9:0] <= axilite_tx1_pio_data_out;
                        axilite_rddata[31:10] <= 'd0;
                    end
                    'h508: begin
                        axilite_rddata[9:0] <= axilite_tx1_pio_data_out_enb;
                        axilite_rddata[31:10] <= 'd0;
                    end
                    'h600: begin
                        axilite_rddata[2:0] <= axilite_trig_src_group;
                        axilite_rddata[31:3] <= 'd0;
                    end
                    'h604: begin
                        axilite_rddata[3:0] <= axilite_trig_src_pin;
                        axilite_rddata[31:4] <= 'd0;
                    end
                    'h700: begin
                        axilite_rddata[2:0] <= axilite_gainindex_src_group;
                        axilite_rddata[31:3] <= 'd0;
                    end
                    'h704: begin
                        axilite_rddata[3:0] <= axilite_gainindex_00_src_pin;
                        axilite_rddata[31:4] <= 'd0;
                    end
                    'h708: begin
                        axilite_rddata[3:0] <= axilite_gainindex_01_src_pin;
                        axilite_rddata[31:4] <= 'd0;
                    end
                    'h70c: begin
                        axilite_rddata[3:0] <= axilite_gainindex_02_src_pin;
                        axilite_rddata[31:4] <= 'd0;
                    end
                    'h710: begin
                        axilite_rddata[3:0] <= axilite_gainindex_03_src_pin;
                        axilite_rddata[31:4] <= 'd0;
                    end
                    'h714: begin
                        axilite_rddata[3:0] <= axilite_gainindex_04_src_pin;
                        axilite_rddata[31:4] <= 'd0;
                    end
                    'h718: begin
                        axilite_rddata[3:0] <= axilite_gainindex_05_src_pin;
                        axilite_rddata[31:4] <= 'd0;
                    end
                    'h71c: begin
                        axilite_rddata[3:0] <= axilite_gainindex_06_src_pin;
                        axilite_rddata[31:4] <= 'd0;
                    end
                    'h720: begin
                        axilite_rddata[3:0] <= axilite_gainindex_07_src_pin;
                        axilite_rddata[31:4] <= 'd0;
                    end
                    'h800: begin
                        axilite_rddata <= axilite_clk_mon_count;
                    end
                    'h900: begin
                        axilite_rddata[3:0] <= axilite_sspi_ssn0_sel;
                        axilite_rddata[7:4] <= axilite_sspi_ssn1_sel;
                        axilite_rddata[11:8] <= axilite_sspi_ssn2_sel;
                        axilite_rddata[15:12] <= axilite_sspi_ssn3_sel;
                        axilite_rddata[31:16] <= 'd0;
                    end
                    'h904: begin
                        axilite_rddata[3:0] <= axilite_sspi_bidir_count;
                        axilite_rddata[4] <= axilite_sspi_bidir_enable;
                        axilite_rddata[5] <= axilite_sspi_miso_edge_sel;
                        axilite_rddata[6] <= axilite_sspi_mosi_edge_sel;
                        axilite_rddata[31:7] <= 'd0;
                    end
                    'h908: begin
                        axilite_rddata[0] <= axilite_sspi_mosi_full;
                        axilite_rddata[1] <= axilite_sspi_mosi_empty;
                        axilite_rddata[2] <= axilite_sspi_miso_full;
                        axilite_rddata[3] <= axilite_sspi_miso_empty;
                        axilite_rddata[31:4] <= 'd0;
                    end
                    'h90c: begin
                        axilite_rddata[3:0] <= axilite_sspi_ss_w1c;
                        axilite_rddata[31:4] <= 'd0;
                    end
                    'h910: begin
                        axilite_rddata[7:0] <= axilite_sspi_mosi_data_data;
                        axilite_rddata[31:8] <= 'd0;
                    end
                    'h914: begin
                        axilite_rddata[7:0] <= axilite_sspi_miso_data_data;
                        axilite_rddata[31:8] <= 'd0;
                    end
                    'h920: begin
                        axilite_rddata[0] <= axilite_sspi_swreset;
                        axilite_rddata[31:1] <= 'd0;
                    end
                    'h924: begin
                        axilite_rddata[0] <= axilite_sspi_enable;
                        axilite_rddata[31:1] <= 'd0;
                    end
                    default: begin
                        axilite_rddata <= 32'd0;
                    end
                endcase
            end else begin
                axilite_rddata <= 32'd0;
            end
        end
    end

endmodule

// **********************************************************************************
// **********************************************************************************
