#!/usr/bin/perl
## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Description:       AXI_ADRV9001 top level registers
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################

use autodie;
require 'dooku.pl';

$addr_width = 16;
$addr_width_used = 12;

$no_of_instances = 1;
$instance_base_addr = 0x1000;
$instance_offset_addr = 0x0;

setdooku(@ARGV);
module(0x0, 'axi_adrv9001_gpio');

## ##################################################################################
## ##################################################################################

define('OFFSET', 0x1000, 'GPIO address offset');

## ##################################################################################
## ##################################################################################

register(0x000, 'REG_TIMER');
field(0, 32, RW, 0x0, 'TIMER', 'General purpose timer register, this is a count
    down timer, software may write desired interval and wait for it to reach zero.
    The count can be prematurely terminated, runs at AXILite clock (usually 100MHz).');

register(0x100, 'REG_DGPIO_PIO_DATA');
field(0, 12, RO, 0x0, 'DGPIO_PIO_DATA', 'These bits are directly mapped to the
    device digital GPIO pins. These bits always indicate the current data on these
    pins regardless of who is driving them (FPGA or device).');

register(0x104, 'REG_DGPIO_PIO_DATA_OUT');
field(0, 12, RW, 0x0, 'DGPIO_PIO_DATA_OUT', 'These register bits directly drive
    the digital GPIO pins, in output mode.');

register(0x108, 'REG_DGPIO_PIO_DATA_OUT_ENB');
field(0, 12, RW, 0x0, 'DGPIO_PIO_DATA_OUT_ENB', 'These register bits controls the
    direction of GPIO. If set, the corresponding pin output buffer is enabled.');

register(0x10c, 'REG_DGPIO_PIO_DATA_MODE');
field(0, 12, RW, 0x0, 'DGPIO_PIO_DATA_MODE', 'These register bits controls the
    source of GPIO in output mode. If set to 0x1, the corresponding pin is in hardware
    mode controlled by the bits below. If set to 0x0, the corresponding pin is in
    software mode and is controlled by the DGPIO_DATA_OUT register.');

define('MODE_SW_REG', 0x0, 'GPIO is in software register mode');
define('MODE_SW_BUF', 0x2, 'GPIO is in software buffer mode');
define('MODE_HW_TDD', 0x1, 'GPIO is in hardware TDD mode');

$register_base = 0x110;
$register_offset = 0x4;
$register_count = 12;
$register_index = 0;

for ($register_index = 0; $register_index < $register_count; $register_index++) {
    register_loop("REG_DGPIO_PIO_SEL_%02d");
    register_loop_field(0, 4, RW, 0x0, "DGPIO_PIO_SEL_%02d", 'These bits control the source of
        digital GPIO in hardware mode.');
}

define('HW_TX0_TDD_SEL',  0x0, 'Selects Transmit-0 TDD signal as GPIO source');
define('HW_RX0_TDD_SEL',  0x1, 'Selects Receive-0 TDD signal as GPIO source');
define('HW_ORX0_TDD_SEL', 0x2, 'Selects Observation Receive-0 TDD signal as GPIO source');
define('HW_AUX0_TDD_SEL', 0x3, 'Selects Auxiliary-0 TDD signal as GPIO source');
define('HW_TX1_TDD_SEL',  0x4, 'Selects Transmit-1 TDD signal as GPIO source');
define('HW_RX1_TDD_SEL',  0x5, 'Selects Receive-1 TDD signal as GPIO source');
define('HW_ORX1_TDD_SEL', 0x6, 'Selects Observation Receive-1 TDD signal as GPIO source');
define('HW_AUX1_TDD_SEL', 0x7, 'Selects Auxiliary-1 TDD signal as GPIO source');
define('HW_CTL0_TDD_SEL', 0x8, 'Selects Control-0 TDD signal as GPIO source');
define('HW_CTL1_TDD_SEL', 0x9, 'Selects Control-1 TDD signal as GPIO source');
define('HW_CTL2_TDD_SEL', 0xa, 'Selects Control-2 TDD signal as GPIO source');
define('HW_CTL3_TDD_SEL', 0xb, 'Selects Control-3 TDD signal as GPIO source');

register(0x180, 'REG_DGPIO_PIO_BUF_ENABLE');
field(0, 1, RW, 0x0, 'DGPIO_PIO_BUF_ENABLE', 'If set, buffer access is enabled,
    this bit must be set before any buffer access.');

register(0x184, 'REG_DGPIO_PIO_BUF_DATA');
field(0, 12, MW, 0x0, 'DGPIO_PIO_BUF_DATA', 'These buffer write data, data is
    sent in the order it is written after BUF_ENABLE above.');

register(0x18c, 'REG_DGPIO_PIO_BUF_MODE');
field(0, 12, RW, 0x0, 'DGPIO_PIO_BUF_MODE', 'These register bits controls the
    source of GPIO in software output mode. If set to 0x1, the corresponding pin is
    driven by the buffer below, otherwise the corresponding DGPIO_DATA_OUT bit.');

register(0x1a0, 'REG_DGPIO_PIO_BUF_STATUS');
field(0, 1, RO, 0x0, 'DGPIO_PIO_BUF_FULL', 'The data buffer is full.');
field(1, 1, RO, 0x0, 'DGPIO_PIO_BUF_EMPTY', 'The data buffer is empty.');

$field_base = 0;
$field_offset = 2;
$field_width = 2;
$field_type = "RW";
$field_default = 0x0;
$field_count = 5;
$field_index = 0;

register(0x1c0, 'REG_DGPIO_PIO_BUF_TRIGGERS');
for ($field_index = 0; $field_index < $field_count; $field_index++) {
    field_loop("DGPIO_PIO_BUF_TRIGGER_MODE_%d", "The core may optionally be controlled through
    the trigger inputs. There are five programmable trigger inputs, these bits
    control each one of the triggers independently. The data transfer is controlled
    as an AND function of all the trigger modes. In all modes, the duration of data
    transfer is controlled by the length.");
}

define('BUF_TRIGGER_DISABLE',      0x000, 'Trigger source is disabled');
define('BUF_TRIGGER_RISING_EDGE',  0x001, 'Transfer begins at rising edge of this input');
define('BUF_TRIGGER_FALLING_EDGE', 0x002, 'Transfer begins at falling edge of this input');
define('BUF_TRIGGER_EDGE',         0x003, 'Transfer begins at either edge of this input');

register(0x200, 'REG_RX0_PIO_DATA');
field(0, 8, RO, 0x0, 'RX0_PIO_DATA', 'These bits are directly mapped to the
    device RXSSI0 pins. In data, strobe, and clock order (msb to lsb)');

register(0x204, 'REG_RX0_PIO_DATA_OUT');
field(0, 8, RW, 0x0, 'RX0_PIO_DATA_OUT', 'These register bits directly drive
    the RXSSI0 pins, in output mode.');

register(0x208, 'REG_RX0_PIO_DATA_OUT_ENB');
field(0, 8, RW, 0x0, 'RX0_PIO_DATA_OUT_ENB', 'These register bits controls the
    direction of RXSSI0 pins. If set, the corresponding pin output buffer is enabled.');

register(0x300, 'REG_RX1_PIO_DATA');
field(0, 8, RO, 0x0, 'RX1_PIO_DATA', 'These bits are directly mapped to the
    device RXSSI1 pins. In data, strobe, and clock order (msb to lsb)');

register(0x304, 'REG_RX1_PIO_DATA_OUT');
field(0, 8, RW, 0x0, 'RX1_PIO_DATA_OUT', 'These register bits directly drive
    the RXSSI1 pins, in output mode.');

register(0x308, 'REG_RX1_PIO_DATA_OUT_ENB');
field(0, 8, RW, 0x0, 'RX1_PIO_DATA_OUT_ENB', 'These register bits controls the
    direction of RXSSI1 pins. If set, the corresponding pin output buffer is enabled.');

register(0x400, 'REG_TX0_PIO_DATA');
field(0, 10, RO, 0x0, 'TX0_PIO_DATA', 'These bits are directly mapped to the
    device TXSSI0 pins. In data, strobe, clock, and ref-clock order (msb to lsb)');

register(0x404, 'REG_TX0_PIO_DATA_OUT');
field(0, 10, RW, 0x0, 'TX0_PIO_DATA_OUT', 'These register bits directly drive
    the TXSSI0 pins, in output mode.');

register(0x408, 'REG_TX0_PIO_DATA_OUT_ENB');
field(0, 10, RW, 0x0, 'TX0_PIO_DATA_OUT_ENB', 'These register bits controls the
    direction of TXSSI0 pins. If set, the corresponding pin output buffer is enabled.');

register(0x500, 'REG_TX1_PIO_DATA');
field(0, 10, RO, 0x0, 'TX1_PIO_DATA', 'These bits are directly mapped to the
    device TXSSI1 pins. In data, strobe, clock, and ref-clock order (msb to lsb)');

register(0x504, 'REG_TX1_PIO_DATA_OUT');
field(0, 10, RW, 0x0, 'TX1_PIO_DATA_OUT', 'These register bits directly drive
    the TXSSI1 pins, in output mode.');

register(0x508, 'REG_TX1_PIO_DATA_OUT_ENB');
field(0, 10, RW, 0x0, 'TX1_PIO_DATA_OUT_ENB', 'These register bits controls the
    direction of TXSSI1 pins. If set, the corresponding pin output buffer is enabled.');

define('IO_GROUP_DGPIO',  0x0, 'Select DGPIO as the source');
define('IO_GROUP_RXSSI0', 0x1, 'Select Receive-0 SSI as the source');
define('IO_GROUP_RXSSI1', 0x2, 'Select Receive-1 SSI as the source');
define('IO_GROUP_TXSSI0', 0x3, 'Select Transmit-0 SSI as the source');
define('IO_GROUP_TXSSI1', 0x4, 'Select Transmit-1 SSI as the source');

register(0x600, 'REG_TRIG_SRC_GROUP');
field(0, 3, RW, 0x0, 'TRIG_SRC_GROUP', 'The source GPIO group, DGPIO (0x0),
    RXSSI0 (0x1), RXSSI1 (0x2), TXSSI0 (0x3) or TXSSI1 (0x4).');

register(0x604, 'REG_TRIG_SRC_PIN');
field(0, 4, RW, 0x0, 'TRIG_SRC_PIN', 'The source GPIO pin number.');

register(0x700, "REG_GAININDEX_SRC_GROUP");
field(0, 3, RW, 0x0, "GAININDEX_SRC_GROUP", 'The source GPIO group, DGPIO (0x0),
    RXSSI0 (0x1), RXSSI1 (0x2), TXSSI0 (0x3) or TXSSI1 (0x4).');

$register_base = 0x704;
$register_offset = 0x4;
$register_count = 8;
$register_index = 0;

for ($register_index = 0; $register_index < $register_count; $register_index++) {
    register_loop("REG_GAININDEX_%02d_SRC_PIN");
    register_loop_field(0, 4, RW, 0x0, "GAININDEX_%02d_SRC_PIN", 'The source GPIO pin number.');
}

register(0x800, 'REG_CLK_MON');
field(0, 32, RO, 0x0, 'CLK_MON_COUNT', 'Clock monitor frequency count. If read 0x0,
    indicates a loss of clock. The format is 16.16 x 100MHz');

register(0x900, 'REG_SSPI_SELECT');
field( 0, 4, RW, 0xf, 'SSPI_SSN0_SEL', 'SPI SSN0-GPIO pin number.');
field( 4, 4, RW, 0xf, 'SSPI_SSN1_SEL', 'SPI SSN1-GPIO pin number.');
field( 8, 4, RW, 0xf, 'SSPI_SSN2_SEL', 'SPI SSN2-GPIO pin number.');
field(12, 4, RW, 0xf, 'SSPI_SSN3_SEL', 'SPI SSN3-GPIO pin number.');

register(0x904, 'REG_SSPI_CONTROL');
field(0, 4, RW, 0x0, 'SSPI_BIDIR_COUNT', 'The bidrectional mode byte count.');
field(4, 1, RW, 0x0, 'SSPI_BIDIR_ENABLE', 'The bidrectional mode enable.');
field(5, 1, RW, 0x0, 'SSPI_MISO_EDGE_SEL', 'The sampling edge of MISO data.');
field(6, 1, RW, 0x0, 'SSPI_MOSI_EDGE_SEL', 'The sampling edge of MOSI data.');

register(0x908, 'REG_SSPI_STATUS');
field(0, 1, RO, 0x0, 'SSPI_MOSI_FULL', 'The mosi data fifo is full.');
field(1, 1, RO, 0x0, 'SSPI_MOSI_EMPTY', 'The mosi data fifo is empty.');
field(2, 1, RO, 0x0, 'SSPI_MISO_FULL', 'The miso data fifo is full.');
field(3, 1, RO, 0x0, 'SSPI_MISO_EMPTY', 'The miso data fifo is empty.');

register(0x90c, 'REG_SSPI_SS');
field(0, 4, RW1C, 0x0, 'SSPI_SS', 'The slave select input.');

register(0x910, 'REG_SSPI_MOSI_DATA');
field(0, 8, MR, 0x0, 'SSPI_MOSI_DATA', 'The mosi data.');

register(0x914, 'REG_SSPI_MISO_DATA');
field(0, 8, MW, 0x0, 'SSPI_MISO_DATA', 'The miso data.');

register(0x920, 'REG_SSPI_SWRESET');
field(0, 1, RW1HC, 0x0, 'SSPI_SWRESET', 'If set, core is reset, hardware cleared.');

register(0x924, 'REG_SSPI_ENABLE');
field(0, 1, RW, 0x0, 'SSPI_ENABLE', 'If set, SPI interface is enabled, otherwise discarded.');

endregisters();
endmodule();
generate();

## ##################################################################################
## ##################################################################################
