### AXI\_ADRV9001\_GPIO Register Map
The addresses shown are relative to the peripheral base address.

---
| Address | Bits | Field | Type | Default | Description |
| ------- | ---- | ----- | ---- | ------- | ----------- |
| 0x0 | [31:0] | timer[31:0] | RW | 0x0 | General purpose timer register, this is a count down timer, software may write desired interval and wait for it to reach zero. The count can be prematurely terminated, runs at AXILite clock (usually 100MHz). |
| | | | | | |
| 0x100 | [11:0] | dgpio\_pio\_data[11:0] | RO | 0x0 | These bits are directly mapped to the device digital GPIO pins. These bits always indicate the current data on these pins regardless of who is driving them (FPGA or device). |
| | | | | | |
| 0x104 | [11:0] | dgpio\_pio\_data\_out[11:0] | RW | 0x0 | These register bits directly drive the digital GPIO pins, in output mode. |
| | | | | | |
| 0x108 | [11:0] | dgpio\_pio\_data\_out\_enb[11:0] | RW | 0x0 | These register bits controls the direction of GPIO. If set, the corresponding pin output buffer is enabled. |
| | | | | | |
| 0x10c | [11:0] | dgpio\_pio\_data\_mode[11:0] | RW | 0x0 | These register bits controls the source of GPIO in output mode. If set to 0x1, the corresponding pin is in hardware mode controlled by the bits below. If set to 0x0, the corresponding pin is in software mode and is controlled by the DGPIO\_DATA\_OUT register. |
| | | | | | |
| 0x110 | [3:0] | dgpio\_pio\_sel\_00[3:0] | RW | 0x0 | These bits control the source of digital GPIO in hardware mode. |
| | | | | | |
| 0x114 | [3:0] | dgpio\_pio\_sel\_01[3:0] | RW | 0x0 | These bits control the source of digital GPIO in hardware mode. |
| | | | | | |
| 0x118 | [3:0] | dgpio\_pio\_sel\_02[3:0] | RW | 0x0 | These bits control the source of digital GPIO in hardware mode. |
| | | | | | |
| 0x11c | [3:0] | dgpio\_pio\_sel\_03[3:0] | RW | 0x0 | These bits control the source of digital GPIO in hardware mode. |
| | | | | | |
| 0x120 | [3:0] | dgpio\_pio\_sel\_04[3:0] | RW | 0x0 | These bits control the source of digital GPIO in hardware mode. |
| | | | | | |
| 0x124 | [3:0] | dgpio\_pio\_sel\_05[3:0] | RW | 0x0 | These bits control the source of digital GPIO in hardware mode. |
| | | | | | |
| 0x128 | [3:0] | dgpio\_pio\_sel\_06[3:0] | RW | 0x0 | These bits control the source of digital GPIO in hardware mode. |
| | | | | | |
| 0x12c | [3:0] | dgpio\_pio\_sel\_07[3:0] | RW | 0x0 | These bits control the source of digital GPIO in hardware mode. |
| | | | | | |
| 0x130 | [3:0] | dgpio\_pio\_sel\_08[3:0] | RW | 0x0 | These bits control the source of digital GPIO in hardware mode. |
| | | | | | |
| 0x134 | [3:0] | dgpio\_pio\_sel\_09[3:0] | RW | 0x0 | These bits control the source of digital GPIO in hardware mode. |
| | | | | | |
| 0x138 | [3:0] | dgpio\_pio\_sel\_10[3:0] | RW | 0x0 | These bits control the source of digital GPIO in hardware mode. |
| | | | | | |
| 0x13c | [3:0] | dgpio\_pio\_sel\_11[3:0] | RW | 0x0 | These bits control the source of digital GPIO in hardware mode. |
| | | | | | |
| 0x180 | [0:0] | dgpio\_pio\_buf\_enable | RW | 0x0 | If set, buffer access is enabled, this bit must be set before any buffer access. |
| | | | | | |
| 0x184 | [11:0] | dgpio\_pio\_buf\_data[11:0] | MW | 0x0 | These buffer write data, data is sent in the order it is written after BUF\_ENABLE above. |
| | | | | | |
| 0x18c | [11:0] | dgpio\_pio\_buf\_mode[11:0] | RW | 0x0 | These register bits controls the source of GPIO in software output mode. If set to 0x1, the corresponding pin is driven by the buffer below, otherwise the corresponding DGPIO\_DATA\_OUT bit. |
| | | | | | |
| 0x1a0 | [0:0] | dgpio\_pio\_buf\_full | RO | 0x0 | The data buffer is full. |
| 0x1a0 | [1:1] | dgpio\_pio\_buf\_empty | RO | 0x0 | The data buffer is empty. |
| | | | | | |
| 0x1c0 | [1:0] | dgpio\_pio\_buf\_trigger\_mode\_0[1:0] | RW | 0x0 | The core may optionally be controlled through the trigger inputs. There are five programmable trigger inputs, these bits control each one of the triggers independently. The data transfer is controlled as an AND function of all the trigger modes. In all modes, the duration of data transfer is controlled by the length. |
| 0x1c0 | [3:2] | dgpio\_pio\_buf\_trigger\_mode\_1[1:0] | RW | 0x0 | The core may optionally be controlled through the trigger inputs. There are five programmable trigger inputs, these bits control each one of the triggers independently. The data transfer is controlled as an AND function of all the trigger modes. In all modes, the duration of data transfer is controlled by the length. |
| 0x1c0 | [5:4] | dgpio\_pio\_buf\_trigger\_mode\_2[1:0] | RW | 0x0 | The core may optionally be controlled through the trigger inputs. There are five programmable trigger inputs, these bits control each one of the triggers independently. The data transfer is controlled as an AND function of all the trigger modes. In all modes, the duration of data transfer is controlled by the length. |
| 0x1c0 | [7:6] | dgpio\_pio\_buf\_trigger\_mode\_3[1:0] | RW | 0x0 | The core may optionally be controlled through the trigger inputs. There are five programmable trigger inputs, these bits control each one of the triggers independently. The data transfer is controlled as an AND function of all the trigger modes. In all modes, the duration of data transfer is controlled by the length. |
| 0x1c0 | [9:8] | dgpio\_pio\_buf\_trigger\_mode\_4[1:0] | RW | 0x0 | The core may optionally be controlled through the trigger inputs. There are five programmable trigger inputs, these bits control each one of the triggers independently. The data transfer is controlled as an AND function of all the trigger modes. In all modes, the duration of data transfer is controlled by the length. |
| | | | | | |
| 0x200 | [7:0] | rx0\_pio\_data[7:0] | RO | 0x0 | These bits are directly mapped to the device RXSSI0 pins. In data, strobe, and clock order (msb to lsb) |
| | | | | | |
| 0x204 | [7:0] | rx0\_pio\_data\_out[7:0] | RW | 0x0 | These register bits directly drive the RXSSI0 pins, in output mode. |
| | | | | | |
| 0x208 | [7:0] | rx0\_pio\_data\_out\_enb[7:0] | RW | 0x0 | These register bits controls the direction of RXSSI0 pins. If set, the corresponding pin output buffer is enabled. |
| | | | | | |
| 0x300 | [7:0] | rx1\_pio\_data[7:0] | RO | 0x0 | These bits are directly mapped to the device RXSSI1 pins. In data, strobe, and clock order (msb to lsb) |
| | | | | | |
| 0x304 | [7:0] | rx1\_pio\_data\_out[7:0] | RW | 0x0 | These register bits directly drive the RXSSI1 pins, in output mode. |
| | | | | | |
| 0x308 | [7:0] | rx1\_pio\_data\_out\_enb[7:0] | RW | 0x0 | These register bits controls the direction of RXSSI1 pins. If set, the corresponding pin output buffer is enabled. |
| | | | | | |
| 0x400 | [9:0] | tx0\_pio\_data[9:0] | RO | 0x0 | These bits are directly mapped to the device TXSSI0 pins. In data, strobe, clock, and ref-clock order (msb to lsb) |
| | | | | | |
| 0x404 | [9:0] | tx0\_pio\_data\_out[9:0] | RW | 0x0 | These register bits directly drive the TXSSI0 pins, in output mode. |
| | | | | | |
| 0x408 | [9:0] | tx0\_pio\_data\_out\_enb[9:0] | RW | 0x0 | These register bits controls the direction of TXSSI0 pins. If set, the corresponding pin output buffer is enabled. |
| | | | | | |
| 0x500 | [9:0] | tx1\_pio\_data[9:0] | RO | 0x0 | These bits are directly mapped to the device TXSSI1 pins. In data, strobe, clock, and ref-clock order (msb to lsb) |
| | | | | | |
| 0x504 | [9:0] | tx1\_pio\_data\_out[9:0] | RW | 0x0 | These register bits directly drive the TXSSI1 pins, in output mode. |
| | | | | | |
| 0x508 | [9:0] | tx1\_pio\_data\_out\_enb[9:0] | RW | 0x0 | These register bits controls the direction of TXSSI1 pins. If set, the corresponding pin output buffer is enabled. |
| | | | | | |
| 0x600 | [2:0] | trig\_src\_group[2:0] | RW | 0x0 | The source GPIO group, DGPIO (0x0), RXSSI0 (0x1), RXSSI1 (0x2), TXSSI0 (0x3) or TXSSI1 (0x4). |
| | | | | | |
| 0x604 | [3:0] | trig\_src\_pin[3:0] | RW | 0x0 | The source GPIO pin number. |
| | | | | | |
| 0x700 | [2:0] | gainindex\_src\_group[2:0] | RW | 0x0 | The source GPIO group, DGPIO (0x0), RXSSI0 (0x1), RXSSI1 (0x2), TXSSI0 (0x3) or TXSSI1 (0x4). |
| | | | | | |
| 0x704 | [3:0] | gainindex\_00\_src\_pin[3:0] | RW | 0x0 | The source GPIO pin number. |
| | | | | | |
| 0x708 | [3:0] | gainindex\_01\_src\_pin[3:0] | RW | 0x0 | The source GPIO pin number. |
| | | | | | |
| 0x70c | [3:0] | gainindex\_02\_src\_pin[3:0] | RW | 0x0 | The source GPIO pin number. |
| | | | | | |
| 0x710 | [3:0] | gainindex\_03\_src\_pin[3:0] | RW | 0x0 | The source GPIO pin number. |
| | | | | | |
| 0x714 | [3:0] | gainindex\_04\_src\_pin[3:0] | RW | 0x0 | The source GPIO pin number. |
| | | | | | |
| 0x718 | [3:0] | gainindex\_05\_src\_pin[3:0] | RW | 0x0 | The source GPIO pin number. |
| | | | | | |
| 0x71c | [3:0] | gainindex\_06\_src\_pin[3:0] | RW | 0x0 | The source GPIO pin number. |
| | | | | | |
| 0x720 | [3:0] | gainindex\_07\_src\_pin[3:0] | RW | 0x0 | The source GPIO pin number. |
| | | | | | |
| 0x800 | [31:0] | clk\_mon\_count[31:0] | RO | 0x0 | Clock monitor frequency count. If read 0x0, indicates a loss of clock. The format is 16.16 x 100MHz |
| | | | | | |
| 0x900 | [3:0] | sspi\_ssn0\_sel[3:0] | RW | 0xf | SPI SSN0-GPIO pin number. |
| 0x900 | [7:4] | sspi\_ssn1\_sel[3:0] | RW | 0xf | SPI SSN1-GPIO pin number. |
| 0x900 | [11:8] | sspi\_ssn2\_sel[3:0] | RW | 0xf | SPI SSN2-GPIO pin number. |
| 0x900 | [15:12] | sspi\_ssn3\_sel[3:0] | RW | 0xf | SPI SSN3-GPIO pin number. |
| | | | | | |
| 0x904 | [3:0] | sspi\_bidir\_count[3:0] | RW | 0x0 | The bidrectional mode byte count. |
| 0x904 | [4:4] | sspi\_bidir\_enable | RW | 0x0 | The bidrectional mode enable. |
| 0x904 | [5:5] | sspi\_miso\_edge\_sel | RW | 0x0 | The sampling edge of MISO data. |
| 0x904 | [6:6] | sspi\_mosi\_edge\_sel | RW | 0x0 | The sampling edge of MOSI data. |
| | | | | | |
| 0x908 | [0:0] | sspi\_mosi\_full | RO | 0x0 | The mosi data fifo is full. |
| 0x908 | [1:1] | sspi\_mosi\_empty | RO | 0x0 | The mosi data fifo is empty. |
| 0x908 | [2:2] | sspi\_miso\_full | RO | 0x0 | The miso data fifo is full. |
| 0x908 | [3:3] | sspi\_miso\_empty | RO | 0x0 | The miso data fifo is empty. |
| | | | | | |
| 0x90c | [3:0] | sspi\_ss[3:0] | RW1C | 0x0 | The slave select input. |
| | | | | | |
| 0x910 | [7:0] | sspi\_mosi\_data[7:0] | MR | 0x0 | The mosi data. |
| | | | | | |
| 0x914 | [7:0] | sspi\_miso\_data[7:0] | MW | 0x0 | The miso data. |
| | | | | | |
| 0x920 | [0:0] | sspi\_swreset | RW1HC | 0x0 | If set, core is reset, hardware cleared. |
| | | | | | |
| 0x924 | [0:0] | sspi\_enable | RW | 0x0 | If set, SPI interface is enabled, otherwise discarded. |
| | | | | | |
---
