// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Description:       AXI_ADRV9001, Clocks
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module axi_adrv9001_clkgen #(

    parameter DEVICE_TYPE = "ULTRASCALE") (

    // system interface

    input   wire            sys_ref_clk_p,
    input   wire            sys_ref_clk_n,
    input   wire            dev_ref_clk,
    output  wire            dev_clk,
    output  wire            gpio_clk,
    output  wire            tdd_clk,

    // axi interface

    input   wire            axilite_clk,
    input   wire            axilite_resetn,
    input   wire            axilite_mmcm_reset,
    input   wire            axilite_mmcm_request,
    output  reg             axilite_mmcm_ack = 'd0,
    input   wire            axilite_mmcm_rd1_wr0,
    input   wire  [  6:0]   axilite_mmcm_addr,
    input   wire  [ 15:0]   axilite_mmcm_wrdata,
    output  reg   [ 15:0]   axilite_mmcm_rddata = 'd0,
    output  reg             axilite_mmcm_busy = 'd0,
    output  reg             axilite_mmcm_unlocked = 'd1,
    input   wire            axilite_mmcm_ref_clk_sel,
    output  wire  [ 31:0]   axilite_mmcm_ref_clk_mon_count);

    // internal registers

    reg                     axilite_mmcm_request_d = 'd0;
    reg                     axilite_mmcm_enable = 'd0;
    reg                     axilite_mmcm_wr1_rd0 = 'd0;
    reg                     axilite_clk0_sel = 1'b1;
    reg                     axilite_clk1_sel = 1'b0;

    // internal signals
 
    wire                    sys_ref_clk;
    wire                    ref_clk;
    wire                    fb_clk;
    wire                    mmcm_fb_clk;
    wire                    mmcm_dev_clk;
    wire                    mmcm_dev_gpio_clk;
    wire                    mmcm_dev_tdd_clk;
    wire                    mmcm_locked;
    wire                    axilite_mmcm_locked;
    wire          [ 15:0]   axilite_mmcm_rddata_int;
    wire                    axilite_mmcm_ready;
    wire                    axilite_mmcm_request_p;

    // request, ack & busy

    assign axilite_mmcm_request_p = ~axilite_mmcm_request_d & axilite_mmcm_request;

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_mmcm_unlocked <= 1'd1;
            axilite_mmcm_request_d <= 1'd0;
            axilite_mmcm_rddata <= 16'd0;
            axilite_mmcm_busy <= 1'd0;
            axilite_mmcm_ack <= 1'd0;
            axilite_mmcm_enable <= 1'd0;
            axilite_mmcm_wr1_rd0 <= 1'd0;
        end else begin
            axilite_mmcm_unlocked <= ~axilite_mmcm_locked;
            axilite_mmcm_request_d <= axilite_mmcm_request;
            if (axilite_mmcm_ready == 1'b1) begin
                axilite_mmcm_rddata <= axilite_mmcm_rddata_int;
            end
            if (axilite_mmcm_busy == 1'b1) begin
                axilite_mmcm_busy <= ~axilite_mmcm_ready;
                axilite_mmcm_ack <= axilite_mmcm_ready;
                axilite_mmcm_enable <= 1'd0;
                axilite_mmcm_wr1_rd0 <= 1'd0;
            end else begin
                axilite_mmcm_busy <= axilite_mmcm_request_p;
                axilite_mmcm_ack <= 1'd0;
                axilite_mmcm_enable <= axilite_mmcm_request_p;
                axilite_mmcm_wr1_rd0 <= axilite_mmcm_request_p & ~axilite_mmcm_rd1_wr0;
            end
        end
    end

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'b0) begin
            axilite_clk0_sel <= 1'd1;
            axilite_clk1_sel <= 1'd0;
        end else begin
            axilite_clk0_sel <= ~axilite_mmcm_ref_clk_sel;
            axilite_clk1_sel <= axilite_mmcm_ref_clk_sel;
        end
    end

    // instantiations

    clk_mon i_clk_mon (
        .clk                    (ref_clk),
        .axilite_resetn         (axilite_resetn),
        .axilite_clk            (axilite_clk),
        .axilite_clk_mon_count  (axilite_mmcm_ref_clk_mon_count));

    cdc #(.DATA_WIDTH(1)) i_locked (
        .src_data               (mmcm_locked),
        .dest_resetn            (axilite_resetn),
        .dest_clk               (axilite_clk),
        .dest_data              (axilite_mmcm_locked));

    BUFG i_fb_clk (
        .I                      (mmcm_fb_clk),
        .O                      (fb_clk));

    BUFG i_dev_clk (
        .I                      (mmcm_dev_clk),
        .O                      (dev_clk));

    BUFG i_dev_gpio_clk (
        .I                      (mmcm_dev_gpio_clk),
        .O                      (gpio_clk));

    BUFG i_dev_tdd_clk (
        .I                      (mmcm_dev_tdd_clk),
        .O                      (tdd_clk));
        
    IBUFDS i_sys_ref_clk (
        .I                      (sys_ref_clk_p),
        .IB                     (sys_ref_clk_n),
        .O                      (sys_ref_clk));

    BUFGCTRL i_mux_clk (
        .IGNORE0                (1'b0),
        .IGNORE1                (1'b0),
        .CE0                    (1'b1),
        .CE1                    (1'b1),
        .S0                     (axilite_clk0_sel),
        .S1                     (axilite_clk1_sel),
        .I0                     (sys_ref_clk),
        .I1                     (dev_ref_clk),
        .O                      (ref_clk));

    generate
    if (DEVICE_TYPE == "ULTRASCALE") begin

    MMCME4_ADV #(
        .BANDWIDTH              ("HIGH"),
        .CLKOUT4_CASCADE        ("FALSE"),
        .COMPENSATION           ("ZHOLD"),
        .STARTUP_WAIT           ("FALSE"),
        .DIVCLK_DIVIDE          (1),
        .CLKFBOUT_MULT_F        (31.250),
        .CLKFBOUT_PHASE         (0.0),
        .CLKFBOUT_USE_FINE_PS   ("FALSE"),
        .CLKOUT0_DIVIDE_F       (6.000),
        .CLKOUT0_PHASE          (0.000),
        .CLKOUT0_DUTY_CYCLE     (0.500),
        .CLKOUT0_USE_FINE_PS    ("FALSE"),
        .CLKOUT1_DIVIDE         (6),
        .CLKOUT1_PHASE          (0.000),
        .CLKOUT1_DUTY_CYCLE     (0.500),
        .CLKOUT1_USE_FINE_PS    ("FALSE"),
        .CLKOUT2_DIVIDE         (6),
        .CLKOUT2_PHASE          (0.000),
        .CLKOUT2_DUTY_CYCLE     (0.500),
        .CLKOUT2_USE_FINE_PS    ("FALSE"),
        .CLKIN1_PERIOD          (26.042))
    i_mmcm (
        .CLKINSEL               (1'd1),
        .CLKIN2                 (1'd0),
        .CLKFBOUTB              (),
        .CLKINSTOPPED           (),
        .CLKFBSTOPPED           (),
        .CLKOUT0B               (),
        .CLKOUT1B               (),
        .CLKOUT2B               (),
        .CLKOUT3B               (),
        .PSCLK                  (1'd0),
        .PSEN                   (1'd0),
        .PSINCDEC               (1'd0),
        .PSDONE                 (),
        .PWRDWN                 (1'd0),
        .CDDCREQ                (1'd0),
        .CDDCDONE               (),
        .DCLK                   (axilite_clk),
        .RST                    (axilite_mmcm_reset),
        .DEN                    (axilite_mmcm_enable),
        .DWE                    (axilite_mmcm_wr1_rd0),
        .DADDR                  (axilite_mmcm_addr),
        .DI                     (axilite_mmcm_wrdata),
        .DO                     (axilite_mmcm_rddata_int),
        .DRDY                   (axilite_mmcm_ready),
        .LOCKED                 (mmcm_locked),
        .CLKIN1                 (ref_clk),
        .CLKFBOUT               (mmcm_fb_clk),
        .CLKFBIN                (fb_clk),
        .CLKOUT0                (mmcm_dev_clk),
        .CLKOUT1                (mmcm_dev_gpio_clk),
        .CLKOUT2                (mmcm_dev_tdd_clk),
        .CLKOUT3                (),
        .CLKOUT4                (),
        .CLKOUT5                (),
        .CLKOUT6                ());

    end else begin

    MMCME2_ADV #(
        .BANDWIDTH              ("HIGH"),
        .CLKOUT4_CASCADE        ("FALSE"),
        .COMPENSATION           ("ZHOLD"),
        .STARTUP_WAIT           ("FALSE"),
        .DIVCLK_DIVIDE          (1),
        .CLKFBOUT_MULT_F        (31.250),
        .CLKFBOUT_PHASE         (0.000),
        .CLKFBOUT_USE_FINE_PS   ("FALSE"),
        .CLKOUT0_DIVIDE_F       (6.000),
        .CLKOUT0_PHASE          (0.000),
        .CLKOUT0_DUTY_CYCLE     (0.500),
        .CLKOUT0_USE_FINE_PS    ("FALSE"),
        .CLKOUT1_DIVIDE         (6),
        .CLKOUT1_PHASE          (0.000),
        .CLKOUT1_DUTY_CYCLE     (0.500),
        .CLKOUT1_USE_FINE_PS    ("FALSE"),
        .CLKOUT2_DIVIDE         (6),
        .CLKOUT2_PHASE          (0.000),
        .CLKOUT2_DUTY_CYCLE     (0.500),
        .CLKOUT2_USE_FINE_PS    ("FALSE"),
        .CLKIN1_PERIOD          (26.042))
    i_mmcm (
        .CLKINSEL               (1'b1),
        .CLKIN2                 (1'b0),
        .CLKFBOUTB              (),
        .CLKINSTOPPED           (),
        .CLKFBSTOPPED           (),
        .CLKOUT0B               (),
        .CLKOUT1B               (),
        .CLKOUT2B               (),
        .CLKOUT3B               (),
        .PSCLK                  (1'b0),
        .PSEN                   (1'b0),
        .PSINCDEC               (1'b0),
        .PSDONE                 (),
        .PWRDWN                 (1'b0),
        .DCLK                   (axilite_clk),
        .RST                    (axilite_mmcm_reset),
        .DEN                    (axilite_mmcm_enable),
        .DWE                    (axilite_mmcm_wr1_rd0),
        .DADDR                  (axilite_mmcm_addr),
        .DI                     (axilite_mmcm_wrdata),
        .DO                     (axilite_mmcm_rddata_int),
        .DRDY                   (axilite_mmcm_ready),
        .LOCKED                 (mmcm_locked),
        .CLKIN1                 (ref_clk),
        .CLKFBOUT               (mmcm_fb_clk),
        .CLKFBIN                (fb_clk),
        .CLKOUT0                (mmcm_dev_clk),
        .CLKOUT1                (mmcm_dev_gpio_clk),
        .CLKOUT2                (mmcm_dev_tdd_clk),
        .CLKOUT3                (),
        .CLKOUT4                (),
        .CLKOUT5                (),
        .CLKOUT6                ());

    end
    endgenerate

endmodule

// **********************************************************************************
// **********************************************************************************
