// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Description:       AXI_ADRV9001
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module axi_adrv9001 #(

    parameter AXI_ADRV9001_INSTANCE_ID = 0,
    parameter AXI_ADRV9001_DEVICE_TYPE = "ULTRASCALE",
    parameter AXI_ADRV9001_GPIO_SPI_DISABLE = 0,
    parameter AXI_ADRV9001_MCS_OUT_CMOS1_LVDS0 = 0,
    parameter AXI_ADRV9001_RX_RESET_PIPE_LENGTH = 8,
    parameter AXI_ADRV9001_TX_RESET_PIPE_LENGTH = 8,
    parameter AXI_ADRV9001_RX_RESET_SEL = 0,
    parameter AXI_ADRV9001_TX_RESET_SEL = 0,
    parameter AXI_ADRV9001_RX0_GPIO2_CMOS1_LVDS0 = 0,
    parameter AXI_ADRV9001_RX1_GPIO2_CMOS1_LVDS0 = 0,
    parameter AXI_ADRV9001_TX0_GPIO2_CMOS1_LVDS0 = 0,
    parameter AXI_ADRV9001_TX1_GPIO2_CMOS1_LVDS0 = 0,
    parameter AXI_ADRV9001_RX0_MATCH_CLOCKING = 0,
    parameter AXI_ADRV9001_RX1_MATCH_CLOCKING = 0,
    parameter AXI_ADRV9001_TX0_MATCH_CLOCKING = 0,
    parameter AXI_ADRV9001_TX1_MATCH_CLOCKING = 0,
    parameter AXI_ADRV9001_RX0_PN_SWAP = 0,
    parameter AXI_ADRV9001_RX1_PN_SWAP = 0,
    parameter AXI_ADRV9001_TX0_REFCLK_DISABLE = 0,
    parameter AXI_ADRV9001_TX1_REFCLK_DISABLE = 0,
    parameter AXI_ADRV9001_RX0_IODELAY_CTRL_ENABLE = 1,
    parameter AXI_ADRV9001_RX1_IODELAY_CTRL_ENABLE = 0,
    parameter AXI_ADRV9001_TX0_IODELAY_CTRL_ENABLE = 0,
    parameter AXI_ADRV9001_TX1_IODELAY_CTRL_ENABLE = 0,
    parameter AXI_ADRV9001_RX0_IODELAY_GROUP = "AXI_ADRV9001_IODELAY",
    parameter AXI_ADRV9001_RX1_IODELAY_GROUP = "AXI_ADRV9001_IODELAY",
    parameter AXI_ADRV9001_TX0_IODELAY_GROUP = "AXI_ADRV9001_IODELAY",
    parameter AXI_ADRV9001_TX1_IODELAY_GROUP = "AXI_ADRV9001_IODELAY") (

    // system interface

    input   wire            sys_delay_clk,
    input   wire            sys_ref_clk_p,
    input   wire            sys_ref_clk_n,
    input   wire            sys_mcs_in_p,
    input   wire            sys_mcs_in_n,
    output  wire            sys_mcs_out_p,
    output  wire            sys_mcs_out_n,

    // adrv9001 interface

    input   wire            dio_rx0_cssi_clk_lssi_clk_p,
    input   wire            dio_rx0_cssi_nc_lssi_clk_n,
    input   wire            dio_rx0_cssi_strobe_lssi_strobe_p,
    input   wire            dio_rx0_cssi_nc_lssi_strobe_n,
    input   wire            dio_rx0_cssi_data1_lssi_data0_p,
    input   wire            dio_rx0_cssi_data0_lssi_data0_n,
    input   wire            dio_rx0_cssi_data3_lssi_data1_p,
    input   wire            dio_rx0_cssi_data2_lssi_data1_n,
    input   wire  [  7:0]   dio_rx0_cssi_gpio_in,
    output  wire  [  7:0]   dio_rx0_cssi_gpio_out,
    output  wire  [  7:0]   dio_rx0_cssi_gpio_enb,
    input   wire            dio_rx1_cssi_clk_lssi_clk_p,
    input   wire            dio_rx1_cssi_nc_lssi_clk_n,
    input   wire            dio_rx1_cssi_strobe_lssi_strobe_p,
    input   wire            dio_rx1_cssi_nc_lssi_strobe_n,
    input   wire            dio_rx1_cssi_data1_lssi_data0_p,
    input   wire            dio_rx1_cssi_data0_lssi_data0_n,
    input   wire            dio_rx1_cssi_data3_lssi_data1_p,
    input   wire            dio_rx1_cssi_data2_lssi_data1_n,
    input   wire  [  7:0]   dio_rx1_cssi_gpio_in,
    output  wire  [  7:0]   dio_rx1_cssi_gpio_out,
    output  wire  [  7:0]   dio_rx1_cssi_gpio_enb,
    input   wire            dio_tx0_cssi_refclk_lssi_refclk_p,
    input   wire            dio_tx0_cssi_nc_lssi_refclk_n,
    output  wire            dio_tx0_cssi_clk_lssi_clk_p,
    output  wire            dio_tx0_cssi_nc_lssi_clk_n,
    output  wire            dio_tx0_cssi_strobe_lssi_strobe_p,
    output  wire            dio_tx0_cssi_nc_lssi_strobe_n,
    output  wire            dio_tx0_cssi_data1_lssi_data0_p,
    output  wire            dio_tx0_cssi_data0_lssi_data0_n,
    output  wire            dio_tx0_cssi_data3_lssi_data1_p,
    output  wire            dio_tx0_cssi_data2_lssi_data1_n,
    input   wire  [  9:0]   dio_tx0_cssi_gpio_in,
    output  wire  [  9:0]   dio_tx0_cssi_gpio_out,
    output  wire  [  9:0]   dio_tx0_cssi_gpio_enb,
    input   wire            dio_tx1_cssi_refclk_lssi_refclk_p,
    input   wire            dio_tx1_cssi_nc_lssi_refclk_n,
    output  wire            dio_tx1_cssi_clk_lssi_clk_p,
    output  wire            dio_tx1_cssi_nc_lssi_clk_n,
    output  wire            dio_tx1_cssi_strobe_lssi_strobe_p,
    output  wire            dio_tx1_cssi_nc_lssi_strobe_n,
    output  wire            dio_tx1_cssi_data1_lssi_data0_p,
    output  wire            dio_tx1_cssi_data0_lssi_data0_n,
    output  wire            dio_tx1_cssi_data3_lssi_data1_p,
    output  wire            dio_tx1_cssi_data2_lssi_data1_n,
    input   wire  [  9:0]   dio_tx1_cssi_gpio_in,
    output  wire  [  9:0]   dio_tx1_cssi_gpio_out,
    output  wire  [  9:0]   dio_tx1_cssi_gpio_enb,
    output  wire            dio_rx0_enable,
    output  wire            dio_rx1_enable,
    output  wire            dio_tx0_enable,
    output  wire            dio_tx1_enable,
    inout   wire  [ 11:0]   dio_dgpio,
    output  wire            dio_mode,
    output  wire            dio_resetb,
    input   wire            dio_gp_int,
    input   wire            dio_dev_clk,

    // multi-chip synchronization interface

    output  wire            gpio_out_clk,
    input   wire            gpio_clk,

    output  wire            dev_out_clk,
    output  wire            mcs_int_out,
    input   wire            dev_clk,
    input   wire            mcs_int_in,

    output  wire            tdd_out_clk,
    output  wire            tdd_out_resetn,
    output  wire            tdd_out_genb,
    output  wire            tdd_out_state,
    output  wire            tdd_out_last,
    output  wire  [ 31:0]   tdd_out_clk_cnt,
    output  wire  [ 31:0]   tdd_out_frm_cnt,
    input   wire            tdd_clk,
    input   wire            tdd_resetn,
    input   wire            tdd_genb,
    input   wire            tdd_state,
    input   wire            tdd_last,
    input   wire  [ 31:0]   tdd_clk_cnt,
    input   wire  [ 31:0]   tdd_frm_cnt,

    output  wire            tx_clk_resetn_out,
    output  wire            tx_phy_resetn_out,
    output  wire            tx_dp_resetn_out,
    output  wire            rx_clk_resetn_out,
    output  wire            rx_phy_resetn_out,
    output  wire            rx_dp_resetn_out,
    input   wire            tx_clk_resetn_in,
    input   wire            tx_phy_resetn_in,
    input   wire            tx_dp_resetn_in,
    input   wire            rx_clk_resetn_in,
    input   wire            rx_phy_resetn_in,
    input   wire            rx_dp_resetn_in,

    output  wire            tx_menb_out,
    output  wire            rx_menb_out,
    output  wire            orx_menb_out,
    input   wire            tx_menb_in,
    input   wire            rx_menb_in,
    input   wire            orx_menb_in,

    // internal receive & observation interface
    // svld - sample valid, sd - sample data

    output  wire            rx0_resetn,
    output  wire            rx0_clk,
    output  wire            rx0_rsenb,
    output  wire            rx0_rstrig,
    output  wire            rx0_rsdsync,
    output  wire            rx0_rsvld,
    output  wire  [ 63:0]   rx0_rsd,
    output  wire            orx0_rsenb,
    output  wire            orx0_rstrig,
    output  wire            orx0_rsdsync,
    output  wire            orx0_rsvld,
    output  wire  [ 63:0]   orx0_rsd,

    output  wire            rx1_resetn,
    output  wire            rx1_clk,
    output  wire            rx1_rsenb,
    output  wire            rx1_rstrig,
    output  wire            rx1_rsdsync,
    output  wire            rx1_rsvld,
    output  wire  [ 63:0]   rx1_rsd,
    output  wire            orx1_rsenb,
    output  wire            orx1_rstrig,
    output  wire            orx1_rsdsync,
    output  wire            orx1_rsvld,
    output  wire  [ 63:0]   orx1_rsd,

    // transmit (valid must follow read)

    output  wire            tx0_resetn,
    output  wire            tx0_clk,
    output  wire            tx0_tsenb,
    output  wire            tx0_tstrig,
    output  wire            tx0_tsdsync,
    output  wire            tx0_tsrd,
    input   wire            tx0_tsav,
    input   wire            tx0_tsvld,
    input   wire  [ 63:0]   tx0_tsd,

    output  wire            tx1_resetn,
    output  wire            tx1_clk,
    output  wire            tx1_tsenb,
    output  wire            tx1_tstrig,
    output  wire            tx1_tsdsync,
    output  wire            tx1_tsrd,
    input   wire            tx1_tsav,
    input   wire            tx1_tsvld,
    input   wire  [ 63:0]   tx1_tsd,

    // gain capture

    output  wire            gpio_resetn,
    output  wire            gpio_gain_rsenb,
    output  wire            gpio_gain_rstrig,
    output  wire            gpio_gain_rsdsync,
    output  wire            gpio_gain_rsvld,
    output  wire  [  7:0]   gpio_gain_rsd,

    // user gpio & triggers

    inout   wire  [  1:0]   trig,
    output  wire  [  3:0]   trig_out,
    output  wire            spi_trig,
    input   wire  [ 31:0]   usr_gpio_in,
    output  wire  [ 31:0]   usr_gpio_out,

    // axi interface

    input   wire            axilite_clk,
    input   wire            axilite_resetn,
    input   wire            axilite_awvalid,
    input   wire  [ 15:0]   axilite_awaddr,
    output  wire            axilite_awready,
    input   wire            axilite_wvalid,
    input   wire  [ 31:0]   axilite_wdata,
    output  wire            axilite_wready,
    output  wire            axilite_bvalid,
    output  wire  [  1:0]   axilite_bresp,
    input   wire            axilite_bready,
    input   wire            axilite_arvalid,
    input   wire  [ 15:0]   axilite_araddr,
    output  wire            axilite_arready,
    output  wire            axilite_rvalid,
    output  wire  [  1:0]   axilite_rresp,
    output  wire  [ 31:0]   axilite_rdata,
    input   wire            axilite_rready,
    output  reg             axilite_intr = 1'd0);

    // local parameters

    localparam    [ 31:0]   AXI_ADRV9001_VERSION      = {8'd0, 8'd8, 8'd1, 8'd0};
    localparam    [  3:0]   AXI_ADRV9001_MAIN_ID      = 4'b0000;
    localparam    [  3:0]   AXI_ADRV9001_GPIO_ID      = 4'b0001;
    localparam    [  3:0]   AXI_ADRV9001_RX0_ID       = 4'b0100;
    localparam    [  3:0]   AXI_ADRV9001_RX1_ID       = 4'b0101;
    localparam    [  3:0]   AXI_ADRV9001_TX0_ID       = 4'b0110;
    localparam    [  3:0]   AXI_ADRV9001_TX1_ID       = 4'b0111;
    localparam    [  3:0]   AXI_ADRV9001_TDD_ID       = 4'b1000;
    localparam    [  3:0]   AXI_ADRV9001_TDD_DEV_ID   = 4'b1001;
    localparam    [  3:0]   AXI_ADRV9001_TDD_DMA_ID   = 4'b1010;

    // internal registers

    reg                     axilite_gpint_in_d = 'd0;
    reg                     axilite_gp_intr = 'd0;

    // internal signals

    wire                    mcs_tx_clk_resetn;
    wire                    mcs_tx_phy_resetn;
    wire                    mcs_tx_dp_resetn;
    wire                    mcs_rx_clk_resetn;
    wire                    mcs_rx_phy_resetn;
    wire                    mcs_rx_dp_resetn;
    wire                    rx0_clk_resetn_out;
    wire                    rx0_phy_resetn_out;
    wire                    rx0_dp_resetn_out;
    wire                    rx0_buf_clk;
    wire          [  7:0]   rx0_gpio_in;
    wire          [  7:0]   rx0_gpio_out;
    wire          [  7:0]   rx0_gpio_enb;
    wire                    rx1_clk_resetn_out;
    wire                    rx1_phy_resetn_out;
    wire                    rx1_dp_resetn_out;
    wire                    rx1_buf_clk;
    wire          [  7:0]   rx1_gpio_in;
    wire          [  7:0]   rx1_gpio_out;
    wire          [  7:0]   rx1_gpio_enb;
    wire                    tx0_clk_resetn_out;
    wire                    tx0_phy_resetn_out;
    wire                    tx0_dp_resetn_out;
    wire          [  9:0]   tx0_gpio_in;
    wire          [  9:0]   tx0_gpio_out;
    wire          [  9:0]   tx0_gpio_enb;
    wire                    tx1_clk_resetn_out;
    wire                    tx1_phy_resetn_out;
    wire                    tx1_dp_resetn_out;
    wire          [  9:0]   tx1_gpio_in;
    wire          [  9:0]   tx1_gpio_out;
    wire          [  9:0]   tx1_gpio_enb;
    wire                    rx0_sync;
    wire                    orx0_sync;
    wire                    tx0_sync;
    wire                    rx1_sync;
    wire                    orx1_sync;
    wire                    tx1_sync;
    wire                    sys_delay_resetn;
    wire                    tdd_orx0_gpio_enable;
    wire                    tdd_orx1_gpio_enable;
    wire                    tdd_tx0_gpio_enable;
    wire                    tdd_tx1_gpio_enable;
    wire                    tdd_ifrm0ctl0_gpio_enable;
    wire                    tdd_ifrm0ctl1_gpio_enable;
    wire                    tdd_ifrm1ctl0_gpio_enable;
    wire                    tdd_ifrm1ctl1_gpio_enable;
    wire                    tdd_trig0_ext_enable;
    wire                    tdd_trig1_ext_enable;
    wire                    gpio_trig;
    wire                    axilite_wrreq;
    wire          [ 15:0]   axilite_wraddr;
    wire          [ 31:0]   axilite_wrdata;
    wire                    axilite_wrack;
    wire                    axilite_rdreq;
    wire          [ 15:0]   axilite_rdaddr;
    wire          [ 31:0]   axilite_rddata;
    wire                    axilite_rdack;
    wire          [  6:0]   axilite_blk_wrack;
    wire          [  6:0]   axilite_blk_rdack;
    wire          [223:0]   axilite_blk_rddata;
    wire          [  1:0]   axilite_resetb;
    wire          [  1:0]   axilite_mode;
    wire                    axilite_gpint_in;
    wire                    axilite_gp_intr_enable;
    wire          [  1:0]   axilite_gp_intr_mode;
    wire                    axilite_mcs_request;
    wire                    axilite_mcs_request_clr;
    wire          [  3:0]   axilite_mcs_width;
    wire          [  3:0]   axilite_mcs_num;
    wire                    axilite_mcs_edge_fall1_rise0;
    wire          [ 31:0]   axilite_mcs_period;
    wire          [  1:0]   axilite_mcs_select;
    wire                    axilite_mcs_trigger;
    wire                    axilite_mcs_trigger_clr;
    wire          [ 15:0]   axilite_mcs_trigger_width;
    wire          [  1:0]   axilite_mcs_trigger_mode;
    wire                    axilite_mcs_tx_clk_resetn;
    wire                    axilite_mcs_tx_phy_resetn;
    wire                    axilite_mcs_tx_dp_resetn;
    wire                    axilite_mcs_rx_clk_resetn;
    wire                    axilite_mcs_rx_phy_resetn;
    wire                    axilite_mcs_rx_dp_resetn;
    wire          [ 31:0]   axilite_mcs_clk_mon_count;
    wire                    axilite_mcs_cdc_state;
    wire                    axilite_mcs_cdc_state_clr;
    wire                    axilite_mcs_swreset;
    wire                    axilite_mmcm_request;
    wire                    axilite_mmcm_ack;
    wire                    axilite_mmcm_rd1_wr0;
    wire          [  6:0]   axilite_mmcm_addr;
    wire          [ 15:0]   axilite_mmcm_wrdata;
    wire          [ 15:0]   axilite_mmcm_rddata;
    wire                    axilite_mmcm_reset;
    wire                    axilite_mmcm_busy;
    wire                    axilite_mmcm_unlocked;
    wire                    axilite_mmcm_ref_clk_sel;
    wire          [ 31:0]   axilite_mmcm_ref_clk_mon_count;
    wire                    axilite_trig0_ext_oe;
    wire                    axilite_trig1_ext_oe;
    wire                    axilite_rx0_intr;
    wire                    axilite_rx1_intr;

    // defaults

    assign dio_resetb = (axilite_resetb[1] == 1'd0) ? axilite_resetb[0] : 1'bz;
    assign dio_mode = (axilite_mode[1] == 1'd0) ? axilite_mode[0] : 1'bz;

    assign rx0_rsdsync = rx0_sync;
    assign tx0_tsdsync = tx0_sync;
    assign orx0_rsdsync = orx0_sync;

    assign rx1_rsdsync = rx1_sync;
    assign tx1_tsdsync = tx1_sync;
    assign orx1_rsdsync = orx1_sync;

    assign gpio_gain_rsenb = 1'd1;
    assign gpio_gain_rstrig = 1'd1;
    assign gpio_gain_rsdsync = 1'd0;

    assign trig_out[1:0] = trig;

    assign trig[0] = (axilite_trig0_ext_oe == 1'b1) ? tdd_trig0_ext_enable : 1'bz;
    assign trig[1] = (axilite_trig1_ext_oe == 1'b1) ? tdd_trig1_ext_enable : 1'bz;

    assign rx_clk_resetn_out = (AXI_ADRV9001_RX_RESET_SEL == 0) ? rx0_clk_resetn_out : rx1_clk_resetn_out;
    assign rx_phy_resetn_out = (AXI_ADRV9001_RX_RESET_SEL == 0) ? rx0_phy_resetn_out : rx1_phy_resetn_out;
    assign rx_dp_resetn_out = (AXI_ADRV9001_RX_RESET_SEL == 0) ? rx0_dp_resetn_out : rx1_dp_resetn_out;
    assign tx_clk_resetn_out = (AXI_ADRV9001_TX_RESET_SEL == 0) ? tx0_clk_resetn_out : tx1_clk_resetn_out;
    assign tx_phy_resetn_out = (AXI_ADRV9001_TX_RESET_SEL == 0) ? tx0_phy_resetn_out : tx1_phy_resetn_out;
    assign tx_dp_resetn_out = (AXI_ADRV9001_TX_RESET_SEL == 0) ? tx0_dp_resetn_out : tx1_dp_resetn_out;

    // interrupt

    always @(negedge axilite_resetn or posedge axilite_clk) begin
        if (axilite_resetn == 1'd0) begin
            axilite_intr <= 1'd0;
            axilite_gpint_in_d <= 1'd0;
            axilite_gp_intr <= 1'd0;
        end else begin
            axilite_intr <= axilite_gp_intr | axilite_rx0_intr | axilite_rx1_intr;
            axilite_gpint_in_d <= axilite_gpint_in;
            case (axilite_gp_intr_mode)
                2'b11: axilite_gp_intr <= axilite_gpint_in_d & ~axilite_gpint_in;
                2'b10: axilite_gp_intr <= ~axilite_gpint_in_d & axilite_gpint_in;
                2'b01: axilite_gp_intr <= ~axilite_gpint_in;
                default: axilite_gp_intr <= axilite_gpint_in;
            endcase
        end
    end

    // instantiations

    generate
    if (AXI_ADRV9001_INSTANCE_ID == 0) begin

    axi_adrv9001_clkgen #(
        .DEVICE_TYPE                      (AXI_ADRV9001_DEVICE_TYPE))
    i_clkgen (
        .sys_ref_clk_p                    (sys_ref_clk_p),
        .sys_ref_clk_n                    (sys_ref_clk_n),
        .dev_ref_clk                      (dio_dev_clk),
        .dev_clk                          (dev_out_clk),
        .gpio_clk                         (gpio_out_clk),
        .tdd_clk                          (tdd_out_clk),
        .axilite_clk                      (axilite_clk),
        .axilite_resetn                   (axilite_resetn),
        .axilite_mmcm_reset               (axilite_mmcm_reset),
        .axilite_mmcm_request             (axilite_mmcm_request),
        .axilite_mmcm_ack                 (axilite_mmcm_ack),
        .axilite_mmcm_rd1_wr0             (axilite_mmcm_rd1_wr0),
        .axilite_mmcm_addr                (axilite_mmcm_addr),
        .axilite_mmcm_wrdata              (axilite_mmcm_wrdata),
        .axilite_mmcm_rddata              (axilite_mmcm_rddata),
        .axilite_mmcm_busy                (axilite_mmcm_busy),
        .axilite_mmcm_unlocked            (axilite_mmcm_unlocked),
        .axilite_mmcm_ref_clk_sel         (axilite_mmcm_ref_clk_sel),
        .axilite_mmcm_ref_clk_mon_count   (axilite_mmcm_ref_clk_mon_count));

    end else begin

    assign dev_out_clk = 1'd0;
    assign gpio_out_clk = 1'd0;
    assign tdd_out_clk = 1'd0;
    assign axilite_mmcm_ack = 1'd0;
    assign axilite_mmcm_rddata = 16'd0;
    assign axilite_mmcm_busy = 1'd0;
    assign axilite_mmcm_unlocked = 1'd1;
    assign axilite_mmcm_ref_clk_mon_count = 32'd0;

    end
    endgenerate

    axi_adrv9001_mcs #(
        .MCS_OUT_CMOS1_LVDS0              (AXI_ADRV9001_MCS_OUT_CMOS1_LVDS0),
        .DEVICE_TYPE                      (AXI_ADRV9001_DEVICE_TYPE),
        .INSTANCE_ID                      (AXI_ADRV9001_INSTANCE_ID))
    i_mcs (
        .dev_clk                          (dev_clk),
        .mcs_in_p                         (sys_mcs_in_p),
        .mcs_in_n                         (sys_mcs_in_n),
        .mcs_out_p                        (sys_mcs_out_p),
        .mcs_out_n                        (sys_mcs_out_n),
        .mcs_int_out                      (mcs_int_out),
        .mcs_int_in                       (mcs_int_in),
        .mcs_trig                         (trig_out[2]),
        .mcs_tx_clk_resetn                (mcs_tx_clk_resetn),
        .mcs_tx_phy_resetn                (mcs_tx_phy_resetn),
        .mcs_tx_dp_resetn                 (mcs_tx_dp_resetn),
        .mcs_rx_clk_resetn                (mcs_rx_clk_resetn),
        .mcs_rx_phy_resetn                (mcs_rx_phy_resetn),
        .mcs_rx_dp_resetn                 (mcs_rx_dp_resetn),
        .axilite_clk                      (axilite_clk),
        .axilite_resetn                   (axilite_resetn),
        .axilite_mcs_request              (axilite_mcs_request),
        .axilite_mcs_request_clr          (axilite_mcs_request_clr),
        .axilite_mcs_width                (axilite_mcs_width),
        .axilite_mcs_num                  (axilite_mcs_num),
        .axilite_mcs_edge_fall1_rise0     (axilite_mcs_edge_fall1_rise0),
        .axilite_mcs_period               (axilite_mcs_period),
        .axilite_mcs_select               (axilite_mcs_select),
        .axilite_mcs_trigger              (axilite_mcs_trigger),
        .axilite_mcs_trigger_clr          (axilite_mcs_trigger_clr),
        .axilite_mcs_trigger_width        (axilite_mcs_trigger_width),
        .axilite_mcs_trigger_mode         (axilite_mcs_trigger_mode),
        .axilite_mcs_tx_clk_resetn        (axilite_mcs_tx_clk_resetn),
        .axilite_mcs_tx_phy_resetn        (axilite_mcs_tx_phy_resetn),
        .axilite_mcs_tx_dp_resetn         (axilite_mcs_tx_dp_resetn),
        .axilite_mcs_rx_clk_resetn        (axilite_mcs_rx_clk_resetn),
        .axilite_mcs_rx_phy_resetn        (axilite_mcs_rx_phy_resetn),
        .axilite_mcs_rx_dp_resetn         (axilite_mcs_rx_dp_resetn),
        .axilite_mcs_cdc_state            (axilite_mcs_cdc_state),
        .axilite_mcs_cdc_state_clr        (axilite_mcs_cdc_state_clr),
        .axilite_mcs_swreset              (axilite_mcs_swreset),
        .axilite_mcs_clk_mon_count        (axilite_mcs_clk_mon_count));

    axi_adrv9001_gpio #(
        .ID                               (AXI_ADRV9001_GPIO_ID),
        .SPI_DISABLE                      (AXI_ADRV9001_GPIO_SPI_DISABLE))
    i_gpio (
        .dgpio                            (dio_dgpio),
        .rx0_gpio_in                      (rx0_gpio_in),
        .rx0_gpio_out                     (rx0_gpio_out),
        .rx0_gpio_enb                     (rx0_gpio_enb),
        .rx1_gpio_in                      (rx1_gpio_in),
        .rx1_gpio_out                     (rx1_gpio_out),
        .rx1_gpio_enb                     (rx1_gpio_enb),
        .tx0_gpio_in                      (tx0_gpio_in),
        .tx0_gpio_out                     (tx0_gpio_out),
        .tx0_gpio_enb                     (tx0_gpio_enb),
        .tx1_gpio_in                      (tx1_gpio_in),
        .tx1_gpio_out                     (tx1_gpio_out),
        .tx1_gpio_enb                     (tx1_gpio_enb),
        .gpio_clk                         (gpio_clk),
        .gpio_resetn                      (gpio_resetn),
        .gpio_trig_out                    (trig_out[3]),
        .gpio_gainindex_valid             (gpio_gain_rsvld),
        .gpio_gainindex                   (gpio_gain_rsd),
        .tdd_clk                          (tdd_clk),
        .tdd_resetn                       (tdd_resetn),
        .tdd_tx0_dev_enable               (dio_tx0_enable),
        .tdd_rx0_dev_enable               (dio_rx0_enable),
        .tdd_tx1_dev_enable               (dio_tx1_enable),
        .tdd_rx1_dev_enable               (dio_rx1_enable),
        .tdd_orx0_gpio_enable             (tdd_orx0_gpio_enable),
        .tdd_orx1_gpio_enable             (tdd_orx1_gpio_enable),
        .tdd_tx0_gpio_enable              (tdd_tx0_gpio_enable),
        .tdd_tx1_gpio_enable              (tdd_tx1_gpio_enable),
        .tdd_ifrm0ctl0_gpio_enable        (tdd_ifrm0ctl0_gpio_enable),
        .tdd_ifrm0ctl1_gpio_enable        (tdd_ifrm0ctl1_gpio_enable),
        .tdd_ifrm1ctl0_gpio_enable        (tdd_ifrm1ctl0_gpio_enable),
        .tdd_ifrm1ctl1_gpio_enable        (tdd_ifrm1ctl1_gpio_enable),
        .trig                             (trig_out),
        .gpio_trig                        (gpio_trig),
        .axilite_clk                      (axilite_clk),
        .axilite_resetn                   (axilite_resetn),
        .axilite_wrreq                    (axilite_wrreq),
        .axilite_wraddr                   (axilite_wraddr),
        .axilite_wrdata                   (axilite_wrdata),
        .axilite_wrack                    (axilite_blk_wrack[6]),
        .axilite_rdreq                    (axilite_rdreq),
        .axilite_rdaddr                   (axilite_rdaddr),
        .axilite_rddata                   (axilite_blk_rddata[((32*6)+31):(32*6)]),
        .axilite_rdack                    (axilite_blk_rdack[6]));

    axi_adrv9001_tdd #(
        .ID                               (AXI_ADRV9001_TDD_ID),
        .INSTANCE_ID                      (AXI_ADRV9001_INSTANCE_ID))
    i_tdd (
        .rx0_resetn                       (rx0_resetn),
        .rx0_clk                          (rx0_clk),
        .rx0_sync                         (rx0_sync),
        .rx0_enable                       (rx0_rsenb),
        .rx0_trig                         (rx0_rstrig),
        .orx0_sync                        (orx0_sync),
        .orx0_enable                      (orx0_rsenb),
        .orx0_trig                        (orx0_rstrig),
        .tx0_resetn                       (tx0_resetn),
        .tx0_clk                          (tx0_clk),
        .tx0_sync                         (tx0_sync),
        .tx0_enable                       (tx0_tsenb),
        .tx0_trig                         (tx0_tstrig),
        .rx1_resetn                       (rx1_resetn),
        .rx1_clk                          (rx1_clk),
        .rx1_sync                         (rx1_sync),
        .rx1_enable                       (rx1_rsenb),
        .rx1_trig                         (rx1_rstrig),
        .orx1_sync                        (orx1_sync),
        .orx1_enable                      (orx1_rsenb),
        .orx1_trig                        (orx1_rstrig),
        .tx1_resetn                       (tx1_resetn),
        .tx1_clk                          (tx1_clk),
        .tx1_sync                         (tx1_sync),
        .tx1_enable                       (tx1_tsenb),
        .tx1_trig                         (tx1_tstrig),
        .spi_trig                         (spi_trig),
        .gpio_trig                        (gpio_trig),
        .tdd_out_resetn                   (tdd_out_resetn),
        .tdd_out_genb                     (tdd_out_genb),
        .tdd_out_state                    (tdd_out_state),
        .tdd_out_last                     (tdd_out_last),
        .tdd_out_clk_cnt                  (tdd_out_clk_cnt),
        .tdd_out_frm_cnt                  (tdd_out_frm_cnt),
        .tdd_clk                          (tdd_clk),
        .tdd_resetn                       (tdd_resetn),
        .tdd_genb                         (tdd_genb),
        .tdd_state                        (tdd_state),
        .tdd_last                         (tdd_last),
        .tdd_clk_cnt                      (tdd_clk_cnt),
        .tdd_frm_cnt                      (tdd_frm_cnt),
        .tdd_rx0_device_enable            (dio_rx0_enable),
        .tdd_tx0_device_enable            (dio_tx0_enable),
        .tdd_rx1_device_enable            (dio_rx1_enable),
        .tdd_tx1_device_enable            (dio_tx1_enable),
        .tdd_orx0_gpio_enable             (tdd_orx0_gpio_enable),
        .tdd_orx1_gpio_enable             (tdd_orx1_gpio_enable),
        .tdd_tx0_gpio_enable              (tdd_tx0_gpio_enable),
        .tdd_tx1_gpio_enable              (tdd_tx1_gpio_enable),
        .tdd_ifrm0ctl0_gpio_enable        (tdd_ifrm0ctl0_gpio_enable),
        .tdd_ifrm0ctl1_gpio_enable        (tdd_ifrm0ctl1_gpio_enable),
        .tdd_ifrm1ctl0_gpio_enable        (tdd_ifrm1ctl0_gpio_enable),
        .tdd_ifrm1ctl1_gpio_enable        (tdd_ifrm1ctl1_gpio_enable),
        .tdd_trig0_ext_enable             (tdd_trig0_ext_enable),
        .tdd_trig1_ext_enable             (tdd_trig1_ext_enable),
        .trig                             (trig_out),
        .axilite_clk                      (axilite_clk),
        .axilite_resetn                   (axilite_resetn),
        .axilite_wrreq                    (axilite_wrreq),
        .axilite_wraddr                   (axilite_wraddr),
        .axilite_wrdata                   (axilite_wrdata),
        .axilite_wrack                    (axilite_blk_wrack[5]),
        .axilite_rdreq                    (axilite_rdreq),
        .axilite_rdaddr                   (axilite_rdaddr),
        .axilite_rddata                   (axilite_blk_rddata[((32*5)+31):(32*5)]),
        .axilite_rdack                    (axilite_blk_rdack[5]));

    axi_adrv9001_tx #(
        .ID                               (AXI_ADRV9001_TX1_ID),
        .GPIO2_CMOS1_LVDS0                (AXI_ADRV9001_TX1_GPIO2_CMOS1_LVDS0),
        .REFCLK_DISABLE                   (AXI_ADRV9001_TX1_REFCLK_DISABLE),
        .DEVICE_TYPE                      (AXI_ADRV9001_DEVICE_TYPE),
        .RESET_PIPE_LENGTH                (AXI_ADRV9001_TX_RESET_PIPE_LENGTH),
        .MATCH_CLOCKING                   (AXI_ADRV9001_TX1_MATCH_CLOCKING),
        .IODELAY_GROUP                    (AXI_ADRV9001_TX1_IODELAY_GROUP),
        .IODELAY_CTRL_ENABLE              (AXI_ADRV9001_TX1_IODELAY_CTRL_ENABLE))
    i_tx1 (
        .tx_cssi_refclk_lssi_refclk_p     (dio_tx1_cssi_refclk_lssi_refclk_p),
        .tx_cssi_nc_lssi_refclk_n         (dio_tx1_cssi_nc_lssi_refclk_n),
        .tx_cssi_clk_lssi_clk_p           (dio_tx1_cssi_clk_lssi_clk_p),
        .tx_cssi_nc_lssi_clk_n            (dio_tx1_cssi_nc_lssi_clk_n),
        .tx_cssi_strobe_lssi_strobe_p     (dio_tx1_cssi_strobe_lssi_strobe_p),
        .tx_cssi_nc_lssi_strobe_n         (dio_tx1_cssi_nc_lssi_strobe_n),
        .tx_cssi_data1_lssi_data0_p       (dio_tx1_cssi_data1_lssi_data0_p),
        .tx_cssi_data0_lssi_data0_n       (dio_tx1_cssi_data0_lssi_data0_n),
        .tx_cssi_data3_lssi_data1_p       (dio_tx1_cssi_data3_lssi_data1_p),
        .tx_cssi_data2_lssi_data1_n       (dio_tx1_cssi_data2_lssi_data1_n),
        .tx_cssi_gpio_in                  (dio_tx1_cssi_gpio_in),
        .tx_cssi_gpio_out                 (dio_tx1_cssi_gpio_out),
        .tx_cssi_gpio_enb                 (dio_tx1_cssi_gpio_enb),
        .rx_buf_clk                       (rx1_buf_clk),
        .rx_clk                           (rx1_clk),
        .rx_resetn                        (rx1_resetn),
        .rx_valid                         (rx1_rsvld),
        .rx_data                          (rx1_rsd),
        .tx_clk                           (tx1_clk),
        .tx_resetn                        (tx1_resetn),
        .tx_read                          (tx1_tsrd),
        .tx_sync                          (tx1_sync),
        .tx_valid                         (tx1_tsvld),
        .tx_data                          (tx1_tsd),
        .tx_enable                        (tx1_tsenb),
        .tx_gpio_in                       (tx1_gpio_in),
        .tx_gpio_out                      (tx1_gpio_out),
        .tx_gpio_enb                      (tx1_gpio_enb),
        .mcs_clk_resetn                   (mcs_tx_clk_resetn),
        .mcs_phy_resetn                   (mcs_tx_phy_resetn),
        .mcs_dp_resetn                    (mcs_tx_dp_resetn),
        .tx_clk_resetn_in                 (tx_clk_resetn_in),
        .tx_phy_resetn_in                 (tx_phy_resetn_in),
        .tx_dp_resetn_in                  (tx_dp_resetn_in),
        .tx_clk_resetn_out                (tx1_clk_resetn_out),
        .tx_phy_resetn_out                (tx1_phy_resetn_out),
        .tx_dp_resetn_out                 (tx1_dp_resetn_out),
        .tx_menable_out                   (),
        .tx_menable_in                    (tx_menb_in),
        .sys_delay_clk                    (sys_delay_clk),
        .sys_delay_resetn                 (sys_delay_resetn),
        .axilite_clk                      (axilite_clk),
        .axilite_resetn                   (axilite_resetn),
        .axilite_wrreq                    (axilite_wrreq),
        .axilite_wraddr                   (axilite_wraddr),
        .axilite_wrdata                   (axilite_wrdata),
        .axilite_wrack                    (axilite_blk_wrack[4]),
        .axilite_rdreq                    (axilite_rdreq),
        .axilite_rdaddr                   (axilite_rdaddr),
        .axilite_rddata                   (axilite_blk_rddata[((32*4)+31):(32*4)]),
        .axilite_rdack                    (axilite_blk_rdack[4]));

    axi_adrv9001_tx #(
        .ID                               (AXI_ADRV9001_TX0_ID),
        .GPIO2_CMOS1_LVDS0                (AXI_ADRV9001_TX0_GPIO2_CMOS1_LVDS0),
        .REFCLK_DISABLE                   (AXI_ADRV9001_TX0_REFCLK_DISABLE),
        .DEVICE_TYPE                      (AXI_ADRV9001_DEVICE_TYPE),
        .RESET_PIPE_LENGTH                (AXI_ADRV9001_TX_RESET_PIPE_LENGTH),
        .MATCH_CLOCKING                   (AXI_ADRV9001_TX0_MATCH_CLOCKING),
        .IODELAY_GROUP                    (AXI_ADRV9001_TX0_IODELAY_GROUP),
        .IODELAY_CTRL_ENABLE              (AXI_ADRV9001_TX0_IODELAY_CTRL_ENABLE))
    i_tx0 (
        .tx_cssi_refclk_lssi_refclk_p     (dio_tx0_cssi_refclk_lssi_refclk_p),
        .tx_cssi_nc_lssi_refclk_n         (dio_tx0_cssi_nc_lssi_refclk_n),
        .tx_cssi_clk_lssi_clk_p           (dio_tx0_cssi_clk_lssi_clk_p),
        .tx_cssi_nc_lssi_clk_n            (dio_tx0_cssi_nc_lssi_clk_n),
        .tx_cssi_strobe_lssi_strobe_p     (dio_tx0_cssi_strobe_lssi_strobe_p),
        .tx_cssi_nc_lssi_strobe_n         (dio_tx0_cssi_nc_lssi_strobe_n),
        .tx_cssi_data1_lssi_data0_p       (dio_tx0_cssi_data1_lssi_data0_p),
        .tx_cssi_data0_lssi_data0_n       (dio_tx0_cssi_data0_lssi_data0_n),
        .tx_cssi_data3_lssi_data1_p       (dio_tx0_cssi_data3_lssi_data1_p),
        .tx_cssi_data2_lssi_data1_n       (dio_tx0_cssi_data2_lssi_data1_n),
        .tx_cssi_gpio_in                  (dio_tx0_cssi_gpio_in),
        .tx_cssi_gpio_out                 (dio_tx0_cssi_gpio_out),
        .tx_cssi_gpio_enb                 (dio_tx0_cssi_gpio_enb),
        .rx_buf_clk                       (rx0_buf_clk),
        .rx_clk                           (rx0_clk),
        .rx_resetn                        (rx0_resetn),
        .rx_valid                         (rx0_rsvld),
        .rx_data                          (rx0_rsd),
        .tx_clk                           (tx0_clk),
        .tx_resetn                        (tx0_resetn),
        .tx_read                          (tx0_tsrd),
        .tx_sync                          (tx0_sync),
        .tx_valid                         (tx0_tsvld),
        .tx_data                          (tx0_tsd),
        .tx_enable                        (tx0_tsenb),
        .tx_gpio_in                       (tx0_gpio_in),
        .tx_gpio_out                      (tx0_gpio_out),
        .tx_gpio_enb                      (tx0_gpio_enb),
        .mcs_clk_resetn                   (mcs_tx_clk_resetn),
        .mcs_phy_resetn                   (mcs_tx_phy_resetn),
        .mcs_dp_resetn                    (mcs_tx_dp_resetn),
        .tx_clk_resetn_in                 (tx_clk_resetn_in),
        .tx_phy_resetn_in                 (tx_phy_resetn_in),
        .tx_dp_resetn_in                  (tx_dp_resetn_in),
        .tx_clk_resetn_out                (tx0_clk_resetn_out),
        .tx_phy_resetn_out                (tx0_phy_resetn_out),
        .tx_dp_resetn_out                 (tx0_dp_resetn_out),
        .tx_menable_out                   (tx_menb_out),
        .tx_menable_in                    (tx_menb_in),
        .sys_delay_clk                    (sys_delay_clk),
        .sys_delay_resetn                 (sys_delay_resetn),
        .axilite_clk                      (axilite_clk),
        .axilite_resetn                   (axilite_resetn),
        .axilite_wrreq                    (axilite_wrreq),
        .axilite_wraddr                   (axilite_wraddr),
        .axilite_wrdata                   (axilite_wrdata),
        .axilite_wrack                    (axilite_blk_wrack[3]),
        .axilite_rdreq                    (axilite_rdreq),
        .axilite_rdaddr                   (axilite_rdaddr),
        .axilite_rddata                   (axilite_blk_rddata[((32*3)+31):(32*3)]),
        .axilite_rdack                    (axilite_blk_rdack[3]));

    axi_adrv9001_rx #(
        .ID                               (AXI_ADRV9001_RX1_ID),
        .DEVICE_TYPE                      (AXI_ADRV9001_DEVICE_TYPE),
        .PN_SWAP                          (AXI_ADRV9001_RX1_PN_SWAP),
        .GPIO2_CMOS1_LVDS0                (AXI_ADRV9001_RX1_GPIO2_CMOS1_LVDS0),
        .RESET_PIPE_LENGTH                (AXI_ADRV9001_RX_RESET_PIPE_LENGTH),
        .MATCH_CLOCKING                   (AXI_ADRV9001_RX1_MATCH_CLOCKING),
        .IODELAY_GROUP                    (AXI_ADRV9001_RX1_IODELAY_GROUP),
        .IODELAY_CTRL_ENABLE              (AXI_ADRV9001_RX1_IODELAY_CTRL_ENABLE))
    i_rx1 (
        .rx_cssi_clk_lssi_clk_p           (dio_rx1_cssi_clk_lssi_clk_p),
        .rx_cssi_nc_lssi_clk_n            (dio_rx1_cssi_nc_lssi_clk_n),
        .rx_cssi_strobe_lssi_strobe_p     (dio_rx1_cssi_strobe_lssi_strobe_p),
        .rx_cssi_nc_lssi_strobe_n         (dio_rx1_cssi_nc_lssi_strobe_n),
        .rx_cssi_data1_lssi_data0_p       (dio_rx1_cssi_data1_lssi_data0_p),
        .rx_cssi_data0_lssi_data0_n       (dio_rx1_cssi_data0_lssi_data0_n),
        .rx_cssi_data3_lssi_data1_p       (dio_rx1_cssi_data3_lssi_data1_p),
        .rx_cssi_data2_lssi_data1_n       (dio_rx1_cssi_data2_lssi_data1_n),
        .rx_cssi_gpio_in                  (dio_rx1_cssi_gpio_in),
        .rx_cssi_gpio_out                 (dio_rx1_cssi_gpio_out),
        .rx_cssi_gpio_enb                 (dio_rx1_cssi_gpio_enb),
        .rx_buf_clk                       (rx1_buf_clk),
        .rx_clk                           (rx1_clk),
        .rx_resetn                        (rx1_resetn),
        .rx_sync                          (rx1_sync),
        .rx_valid                         (rx1_rsvld),
        .rx_data                          (rx1_rsd),
        .rx_enable                        (rx1_rsenb),
        .orx_sync                         (orx1_sync),
        .orx_valid                        (orx1_rsvld),
        .orx_data                         (orx1_rsd),
        .orx_enable                       (orx1_rsenb),
        .rx_gpio_in                       (rx1_gpio_in),
        .rx_gpio_out                      (rx1_gpio_out),
        .rx_gpio_enb                      (rx1_gpio_enb),
        .mcs_clk_resetn                   (mcs_rx_clk_resetn),
        .mcs_phy_resetn                   (mcs_rx_phy_resetn),
        .mcs_dp_resetn                    (mcs_rx_dp_resetn),
        .rx_clk_resetn_in                 (rx_clk_resetn_in),
        .rx_phy_resetn_in                 (rx_phy_resetn_in),
        .rx_dp_resetn_in                  (rx_dp_resetn_in),
        .rx_clk_resetn_out                (rx1_clk_resetn_out),
        .rx_phy_resetn_out                (rx1_phy_resetn_out),
        .rx_dp_resetn_out                 (rx1_dp_resetn_out),
        .rx_menable_out                   (),
        .rx_menable_in                    (rx_menb_in),
        .orx_menable_out                  (),
        .orx_menable_in                   (orx_menb_in),
        .sys_delay_clk                    (sys_delay_clk),
        .sys_delay_resetn                 (sys_delay_resetn),
        .axilite_clk                      (axilite_clk),
        .axilite_resetn                   (axilite_resetn),
        .axilite_wrreq                    (axilite_wrreq),
        .axilite_wraddr                   (axilite_wraddr),
        .axilite_wrdata                   (axilite_wrdata),
        .axilite_wrack                    (axilite_blk_wrack[2]),
        .axilite_rdreq                    (axilite_rdreq),
        .axilite_rdaddr                   (axilite_rdaddr),
        .axilite_rddata                   (axilite_blk_rddata[((32*2)+31):(32*2)]),
        .axilite_rdack                    (axilite_blk_rdack[2]),
        .axilite_intr                     (axilite_rx1_intr));

    axi_adrv9001_rx #(
        .ID                               (AXI_ADRV9001_RX0_ID),
        .DEVICE_TYPE                      (AXI_ADRV9001_DEVICE_TYPE),
        .PN_SWAP                          (AXI_ADRV9001_RX0_PN_SWAP),
        .GPIO2_CMOS1_LVDS0                (AXI_ADRV9001_RX0_GPIO2_CMOS1_LVDS0),
        .RESET_PIPE_LENGTH                (AXI_ADRV9001_RX_RESET_PIPE_LENGTH),
        .MATCH_CLOCKING                   (AXI_ADRV9001_RX0_MATCH_CLOCKING),
        .IODELAY_GROUP                    (AXI_ADRV9001_RX0_IODELAY_GROUP),
        .IODELAY_CTRL_ENABLE              (AXI_ADRV9001_RX0_IODELAY_CTRL_ENABLE))
    i_rx0 (
        .rx_cssi_clk_lssi_clk_p           (dio_rx0_cssi_clk_lssi_clk_p),
        .rx_cssi_nc_lssi_clk_n            (dio_rx0_cssi_nc_lssi_clk_n),
        .rx_cssi_strobe_lssi_strobe_p     (dio_rx0_cssi_strobe_lssi_strobe_p),
        .rx_cssi_nc_lssi_strobe_n         (dio_rx0_cssi_nc_lssi_strobe_n),
        .rx_cssi_data1_lssi_data0_p       (dio_rx0_cssi_data1_lssi_data0_p),
        .rx_cssi_data0_lssi_data0_n       (dio_rx0_cssi_data0_lssi_data0_n),
        .rx_cssi_data3_lssi_data1_p       (dio_rx0_cssi_data3_lssi_data1_p),
        .rx_cssi_data2_lssi_data1_n       (dio_rx0_cssi_data2_lssi_data1_n),
        .rx_cssi_gpio_in                  (dio_rx0_cssi_gpio_in),
        .rx_cssi_gpio_out                 (dio_rx0_cssi_gpio_out),
        .rx_cssi_gpio_enb                 (dio_rx0_cssi_gpio_enb),
        .rx_buf_clk                       (rx0_buf_clk),
        .rx_clk                           (rx0_clk),
        .rx_resetn                        (rx0_resetn),
        .rx_sync                          (rx0_sync),
        .rx_valid                         (rx0_rsvld),
        .rx_data                          (rx0_rsd),
        .rx_enable                        (rx0_rsenb),
        .orx_sync                         (orx0_sync),
        .orx_valid                        (orx0_rsvld),
        .orx_data                         (orx0_rsd),
        .orx_enable                       (orx0_rsenb),
        .rx_gpio_in                       (rx0_gpio_in),
        .rx_gpio_out                      (rx0_gpio_out),
        .rx_gpio_enb                      (rx0_gpio_enb),
        .mcs_clk_resetn                   (mcs_rx_clk_resetn),
        .mcs_phy_resetn                   (mcs_rx_phy_resetn),
        .mcs_dp_resetn                    (mcs_rx_dp_resetn),
        .rx_clk_resetn_in                 (rx_clk_resetn_in),
        .rx_phy_resetn_in                 (rx_phy_resetn_in),
        .rx_dp_resetn_in                  (rx_dp_resetn_in),
        .rx_clk_resetn_out                (rx0_clk_resetn_out),
        .rx_phy_resetn_out                (rx0_phy_resetn_out),
        .rx_dp_resetn_out                 (rx0_dp_resetn_out),
        .rx_menable_out                   (rx_menb_out),
        .rx_menable_in                    (rx_menb_in),
        .orx_menable_out                  (orx_menb_out),
        .orx_menable_in                   (orx_menb_in),
        .sys_delay_clk                    (sys_delay_clk),
        .sys_delay_resetn                 (sys_delay_resetn),
        .axilite_clk                      (axilite_clk),
        .axilite_resetn                   (axilite_resetn),
        .axilite_wrreq                    (axilite_wrreq),
        .axilite_wraddr                   (axilite_wraddr),
        .axilite_wrdata                   (axilite_wrdata),
        .axilite_wrack                    (axilite_blk_wrack[1]),
        .axilite_rdreq                    (axilite_rdreq),
        .axilite_rdaddr                   (axilite_rdaddr),
        .axilite_rddata                   (axilite_blk_rddata[((32*1)+31):(32*1)]),
        .axilite_rdack                    (axilite_blk_rdack[1]),
        .axilite_intr                     (axilite_rx0_intr));

    axi_adrv9001_top_regs #(
        .ID                               (AXI_ADRV9001_MAIN_ID))
    i_main_regs (
        .axilite_version                  (AXI_ADRV9001_VERSION),
        .axilite_instance_id              (AXI_ADRV9001_INSTANCE_ID),
        .axilite_scratch                  (),
        .axilite_timer                    (),
        .axilite_resetb                   (axilite_resetb),
        .axilite_mode                     (axilite_mode),
        .axilite_gp_intr                  (axilite_gp_intr),
        .axilite_intr_gp_intr             (),
        .axilite_gp_intr_enable           (axilite_gp_intr_enable),
        .axilite_gp_intr_mode             (axilite_gp_intr_mode),
        .axilite_usr_gpio_in              (usr_gpio_in),
        .axilite_usr_gpio_out             (usr_gpio_out),
        .axilite_mcs_request              (axilite_mcs_request),
        .axilite_mcs_request_clr          (axilite_mcs_request_clr),
        .axilite_mcs_width                (axilite_mcs_width),
        .axilite_mcs_num                  (axilite_mcs_num),
        .axilite_mcs_edge_fall1_rise0     (axilite_mcs_edge_fall1_rise0),
        .axilite_mcs_period               (axilite_mcs_period),
        .axilite_mcs_select               (axilite_mcs_select),
        .axilite_mcs_trigger              (axilite_mcs_trigger),
        .axilite_mcs_trigger_clr          (axilite_mcs_trigger_clr),
        .axilite_mcs_trigger_width        (axilite_mcs_trigger_width),
        .axilite_mcs_trigger_mode         (axilite_mcs_trigger_mode),
        .axilite_mcs_tx_clk_resetn        (axilite_mcs_tx_clk_resetn),
        .axilite_mcs_tx_phy_resetn        (axilite_mcs_tx_phy_resetn),
        .axilite_mcs_tx_dp_resetn         (axilite_mcs_tx_dp_resetn),
        .axilite_mcs_rx_clk_resetn        (axilite_mcs_rx_clk_resetn),
        .axilite_mcs_rx_phy_resetn        (axilite_mcs_rx_phy_resetn),
        .axilite_mcs_rx_dp_resetn         (axilite_mcs_rx_dp_resetn),
        .axilite_mcs_clk_mon_count        (axilite_mcs_clk_mon_count),
        .axilite_mcs_cdc_state            (axilite_mcs_cdc_state),
        .axilite_mcs_cdc_state_clr        (axilite_mcs_cdc_state_clr),
        .axilite_mcs_timer                (),
        .axilite_mcs_swreset              (axilite_mcs_swreset),
        .axilite_mmcm_request             (axilite_mmcm_request),
        .axilite_mmcm_request_clr         (axilite_mmcm_ack),
        .axilite_mmcm_rd1_wr0             (axilite_mmcm_rd1_wr0),
        .axilite_mmcm_addr                (axilite_mmcm_addr),
        .axilite_mmcm_wrdata              (axilite_mmcm_wrdata),
        .axilite_mmcm_rddata              (axilite_mmcm_rddata),
        .axilite_mmcm_reset               (axilite_mmcm_reset),
        .axilite_mmcm_busy                (axilite_mmcm_busy),
        .axilite_mmcm_unlocked            (axilite_mmcm_unlocked),
        .axilite_mmcm_ref_clk_sel         (axilite_mmcm_ref_clk_sel),
        .axilite_mmcm_ref_clk_mon_count   (axilite_mmcm_ref_clk_mon_count),
        .axilite_trig0_ext_oe             (axilite_trig0_ext_oe),
        .axilite_trig1_ext_oe             (axilite_trig1_ext_oe),
        .axilite_gp_intr_status           (axilite_gp_intr),
        .axilite_rx0_intr_status          (axilite_rx0_intr),
        .axilite_rx1_intr_status          (axilite_rx1_intr),
        .axilite_clk                      (axilite_clk),
        .axilite_resetn                   (axilite_resetn),
        .axilite_wrreq                    (axilite_wrreq),
        .axilite_wraddr                   (axilite_wraddr),
        .axilite_wrdata                   (axilite_wrdata),
        .axilite_wrack                    (axilite_blk_wrack[0]),
        .axilite_rdreq                    (axilite_rdreq),
        .axilite_rdaddr                   (axilite_rdaddr),
        .axilite_rddata                   (axilite_blk_rddata[((32*0)+31):(32*0)]),
        .axilite_rdack                    (axilite_blk_rdack[0]));

    axilite_slave_if #(
        .AXI_ADDRESS_WIDTH                (16))
    i_axilite_slave_if (
        .axilite_clk                      (axilite_clk),
        .axilite_resetn                   (axilite_resetn),
        .axilite_awvalid                  (axilite_awvalid),
        .axilite_awaddr                   (axilite_awaddr),
        .axilite_awready                  (axilite_awready),
        .axilite_wvalid                   (axilite_wvalid),
        .axilite_wdata                    (axilite_wdata),
        .axilite_wready                   (axilite_wready),
        .axilite_bvalid                   (axilite_bvalid),
        .axilite_bresp                    (axilite_bresp),
        .axilite_bready                   (axilite_bready),
        .axilite_arvalid                  (axilite_arvalid),
        .axilite_araddr                   (axilite_araddr),
        .axilite_arready                  (axilite_arready),
        .axilite_rvalid                   (axilite_rvalid),
        .axilite_rresp                    (axilite_rresp),
        .axilite_rdata                    (axilite_rdata),
        .axilite_rready                   (axilite_rready),
        .axilite_wrreq                    (axilite_wrreq),
        .axilite_wraddr                   (axilite_wraddr),
        .axilite_wrdata                   (axilite_wrdata),
        .axilite_wrack                    (axilite_wrack),
        .axilite_rdreq                    (axilite_rdreq),
        .axilite_rdaddr                   (axilite_rdaddr),
        .axilite_rddata                   (axilite_rddata),
        .axilite_rdack                    (axilite_rdack));

    axilite_block_if #(
        .NUM_OF_BLOCKS                    (7))
    i_axilite_block_if (
        .axilite_clk                      (axilite_clk),
        .axilite_resetn                   (axilite_resetn),
        .axilite_intr                     (),
        .axilite_wrack                    (axilite_wrack),
        .axilite_rdack                    (axilite_rdack),
        .axilite_rddata                   (axilite_rddata),
        .axilite_block_intr               (7'd0),
        .axilite_block_wrack              (axilite_blk_wrack),
        .axilite_block_rdack              (axilite_blk_rdack),
        .axilite_block_rddata             (axilite_blk_rddata));

    cdc_resetp i_cdc_resetp_sys_200m (
        .src_clk                          (axilite_clk),
        .src_resetn                       (axilite_resetn),
        .dest_clk                         (sys_delay_clk),
        .dest_resetp                      (sys_delay_resetn));

    cdc #(.DATA_WIDTH(1)) i_cdc_gpint (
        .src_data                         (dio_gp_int),
        .dest_resetn                      (axilite_resetn),
        .dest_clk                         (axilite_clk),
        .dest_data                        (axilite_gpint_in));

endmodule

// **********************************************************************************
// **********************************************************************************
