#!/usr/bin/perl
## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Description:       Vivado Run Handler
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################

use Cwd;

$argcnt = $#ARGV + 1;

if ($argcnt != 3) {
    print "ERROR: unexpected number of arguments ($argcnt), can not continue.\n";
    exit(-1);
}

$log = $ARGV[0];
$device = $ARGV[1];
$target = $ARGV[2];

if (($device ne "generic") && ($device ne "zynq") && ($device ne "zynqmp") &&
    ($device ne "versal") && ($device ne "fabric")) {
    print "ERROR: unknown device ($device), can not continue.\n";
    exit(-1);
}

if (($target ne "run") && ($target ne "clean")) {
    print "ERROR: unknown target ($target), can not continue.\n";
    exit(-1);
}

@words = split(/\./, $log);

if (($#words < 2) || ($#words > 3)) {
    print "ERROR: unexpected format ($log), can not continue.\n";
    exit(-1);
}

$project = $words[0];
$mode = ($#words == 2) ? "default" : $words[1];

## ##################################################################################
## ##################################################################################

$xpr_file = ($mode eq "default") ? "$project" : "$mode/${project}_${mode}";
$bif_file = "$xpr_file.bif";
$bin_file = "$xpr_file.bin";

$xpr_file = ($device eq "generic") ? "${xpr_file}.xpr" : $xpr_file;
$xpr_file = ($device eq "zynqmp") ? "${xpr_file}.bit" : $xpr_file;
$xpr_file = ($device eq "versal") ? "${xpr_file}.pdi" : $xpr_file;
$xpr_file = ($device eq "fabric") ? "${xpr_file}.bin" : $xpr_file;
$xpr_file = ($device eq "zynq") ? "${xpr_file}.bit" : $xpr_file;

$xpr_cmd = ($mode eq "default") ? "vivado" : "vivado -tempDir ./$mode";
$xpr_cmd = "$xpr_cmd -nojournal -nolog -mode batch";
$xpr_cmd = "$xpr_cmd -source ${project}_vivado.tcl";
$xpr_cmd = ($mode eq "default") ? $xpr_cmd : "$xpr_cmd -tclargs $mode";

$xpr_log = ($mode eq "default") ? "${project}" : "${project}_${mode}";
$xpr_log = "${xpr_log}_vivado.log";

## ##################################################################################
## ##################################################################################

system("rm -rf $xpr_file $xpr_log $mode $log");
system("rm -rf $bin_file $bif_file ${xpr_file}.bin");

if ($mode eq "default") {
    system("rm -rf .Xil xgui");
    system("rm -rf *.cache *.rpt *.sysdef *.data *.xpr *.log *.jou *.bif");
    system("rm -rf *.runs *.srcs *.sdk *.hw *.sim *.xml *.ip_user_files");
}

if ($target eq "clean") {
    exit(0);
}

## ##################################################################################
## ##################################################################################

if (system("$xpr_cmd > $xpr_log 2>&1") != 0) {
    print "ERROR: vivado run has failed, can not continue.\n";
    exit(-1);
}

if (!(-e $xpr_file) || !(-f $xpr_file)) {
    print "ERROR: missing file ($xpr_file), can not continue.\n";
    exit(-1);
}

## ##################################################################################
## ##################################################################################

if ($device eq "generic") {
    system("echo generic $xpr_file > $log");
    exit(0);
}

if ($device eq "fabric") {
    system("echo fabric $xpr_file > $log");
    exit(0);
}

if ($device eq "versal") {
    system("echo versal $xpr_file > $log");
    exit(0);
}

if ($device eq "zynq") {

    system("echo > $bif_file");
    system("echo img: >> $bif_file");
    system("echo { >> $bif_file");
    system("echo    $xpr_file >> $bif_file");
    system("echo } >> $bif_file");
    system("echo >> $bif_file");
    
    $xpr_cmd = "bootgen -image $bif_file -arch zynq";
    $xpr_cmd = "$xpr_cmd -process_bitstream bin";
    
    if (system("$xpr_cmd >> $xpr_log 2>&1") != 0) {
        print "ERROR: bootgen run has failed, can not continue.\n";
        exit(-1);
    }
    
    if ((-e "${xpr_file}.bin") && (-f "${xpr_file}.bin"))  {
        system("cp ${xpr_file}.bin $bin_file");
    }
    
    if ((-e $bin_file) && (-f $bin_file))  {
        system("echo zynq $bin_file > $log");
        exit(0);
    }
}

if ($device eq "zynqmp") {

    system("echo > $bif_file");
    system("echo img: >> $bif_file");
    system("echo { >> $bif_file");
    system("echo    [destination_device = pl]$xpr_file >> $bif_file");
    system("echo } >> $bif_file");
    system("echo >> $bif_file");

    $xpr_cmd = "bootgen -image $bif_file -arch zynqmp";
    $xpr_cmd = "$xpr_cmd -o $bin_file";

    if (system("$xpr_cmd >> $xpr_log 2>&1") != 0) {
        print "ERROR: bootgen run has failed, can not continue.\n";
        exit(-1);
    }

    if ((-e $bin_file) && (-f $bin_file))  {
        system("echo zynqmp $bin_file > $log");
        exit(0);
    }
}

print "ERROR: unsupported device ($device), can not continue.\n";
exit(-1);

## ##################################################################################
## ##################################################################################
